<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<%@page contentType="text/html;charset=UTF-8" language="java" %>
<%@ page import="jet.cs.util.*, 
                 jet.server.util.nls.*,
                 jet.server.api.http.*,
                 jet.server.api.*,
                 java.io.*,
                 javax.xml.bind.DatatypeConverter,
                 java.util.*" %>
<!-- 
This jsp page is one of three that show how Single Sign On works.

This one executes the scenario where the applicaiton login code will
set a specific session variable, "authorized_user", on sucess.
This will be used by the custom implementation of ExternalAuthorized 
to recognize that an application  user is logged into the session
and the value of the JReport User ID to use for report requests.

This protocol is the one that is implemented in the CustomHttpExternalAuthenticated class.
This JSP page sets the JReport User Id into the HTTP session variable 
before calling the action page, customViewReport.jsp.

To run this scenario, move this JSP page and customViewReport.jsp 
to the folder "public_html/jinfonet".  
Access it from a browser by way of a bookmark after restarting the browser,
without logging into JReport Server.

   localhost:8888/jinfonet/customSessionAuth.jsp

When you see the page in this way, it is when you are not yet logged
into JReport Server and you are not logged into any application.
This is shown by the current user on the page.

Press the "Run Report" button.  

This leads you to the customViewReport.jsp page, which will not run
the report until you are an authorized JReport Server user.

You should see a pop-up dialog from your browser asking for your
name and password.  This is the HTTP Authentication dialog
to log you in to JReport Server.  This login activity is
being done by JReport Server.  JReport Server does not 
recognize the protocol of passing in a value in the session variable.

This is without Single Sign On in place.

Cancel the login dialog.  This leads to a 404 Error page saying the page
your requested does not exist for you.

To turn on Single Sign On, follow the instructions in the source of
CustomHttpExternalAuthorized.java for compiling it, putting it into 
a jar file, deploy it, and adding a CLASSPATH entry to it in JReport 
start-up script and adding a value to the System properties 
using the -D option. 

Restart JReport Server.  Now, the CustomHttpExternalAuthorized class
will be running within JReport Server, enabling Single Sign On.

Again bring up this JSP page using a bookmark, without logging into JReport Server.

   localhost:8888/jinfonet/customSessionAuth.jsp

When you see the page in this way, it is when you are not yet logged
into JReport Server and you are not logged into any application.
This is shown by the current user on the page.

Press the "Run Report" button. 

This leads you to the customViewReport.jsp page, which will not run
the report until you are an authorized JReport Server user.
Because the Single Sign On is turned on and the implementation
of CustomHttpExternalAuthorized follows the protocol of looking
at the value in the "authorized_user" session variable, which is set, 
this request will run the report.

This demonstrates what happens when a user is identified by the
external authorized class when the Single Sign On system is working.

This demonstrates the Single Sign On framework in action.
-->
<%
    HttpRptServer httpRptServer = null;
    HttpUserSessionManager httpUserSessionManager = null;

    String jrUser = null;  
    String appUser = null;  
    String singleSignOnStatus = "";  
    boolean ssoIsOn = false;
    boolean jrUserIsLoggedIn = false;
    boolean appUserIsLoggedIn = false;
    String scenarioExpectation = "";
    long time = new Date().getTime();

    session = request.getSession(true);

    // emulate the code that an application login would do.
    // register that the application user is logged in,
    // and set the corresponding JReport User ID to use.
    session.setAttribute("authorized_user", "admin");

    if (session.getAttribute("authorized_user") != null) {
        appUser = session.getAttribute("authorized_user").toString();
        appUserIsLoggedIn = true;
    } else {
        appUser = "No Current User";
        appUserIsLoggedIn = false;
    }

    // establish context and handle for JReport API calls.
    httpRptServer = HttpUtil.getHttpRptServer(request);
    if (httpRptServer == null) {
        System.getProperties().put("jreport.context", application);
        HttpUtil.initEnv(System.getProperties());
        httpRptServer = HttpUtil.getHttpRptServer(request);
    }
    if (httpRptServer == null) {
        jrUser = "Unknown";
        jrUserIsLoggedIn = false;
    } else {

        httpUserSessionManager = httpRptServer.getHttpUserSessionManager(); 

            // When there is no current user.  this getUser() returns an empty string.
        jrUser = (String)httpUserSessionManager.getUser(request);
        if (jrUser.equals("")) {
            jrUser = "No Current User";  // establish display value
            jrUserIsLoggedIn = false;
        } else {
            jrUserIsLoggedIn = true;
        }

        HttpExternalAuthorized httpExternalAuthorized = 
                  (HttpExternalAuthorized)httpUserSessionManager.getHttpExternalAuthorized();
        if (httpExternalAuthorized == null) {
            singleSignOnStatus = "Single Sign On is OFF";
            ssoIsOn = false;
        } else {
            //  singleSignOnStatus will be displayed within enclosing bold tags.  Bold tags in extra text for this case work within that context.
            singleSignOnStatus = "Single Sign On is ON.</b>  &nbsp;&nbsp;&nbsp;&nbsp; ExternalAuthorized is by class <b>" + httpExternalAuthorized.getClass().getName();
            ssoIsOn = true;
        }
    }

    if (ssoIsOn) {
        if (appUserIsLoggedIn) {
            if (jrUserIsLoggedIn) {
                scenarioExpectation = "Report will run because JReport Server User is logged in already.  SSO External Authorized will not be called.";
            } else {
                scenarioExpectation = "Report will run because Application User became logged in by this page, "
                     + "which leads to JReport Server User getting logged in."
                     + "<br>JReport Server User will be logged in after a call to SSO External Authorized that returns the Application User ID.";
            }
        } else {
            if (jrUserIsLoggedIn) {
                scenarioExpectation = "Report will run because JReport Server User is logged in already.  SSO External Authorized will not be called";
            } else {
                // NOTE: this scenario can not exist.  This page establishes that appUser is Logged In.
                scenarioExpectation = "Report will run because Application User became logged in by this page, "
                     + "which leads to JReport Server User getting logged in."
                     + "<br>JReport Server User will be logged in after a call to SSO External Authorized that returns the Application User ID.";
            }
        }
    } else {
        if (appUserIsLoggedIn) {
            if (jrUserIsLoggedIn) {
                scenarioExpectation = "Report will run because JReport Server User is logged in already.  SSO External Authorized will not be called.";
            } else {
                scenarioExpectation = "Report will not run because JReport Server User is not logged in already."
                    + "<br>Browser will display HTTP Authentication login dialog to enable running of report."
                    + "<br>(Single Sign On framework is not turned on)";
            }
        } else {
            if (jrUserIsLoggedIn) {
                scenarioExpectation = "Report will run because JReport Server User is logged in already.  SSO External Authorized will not be called.";
            } else {
                scenarioExpectation = "Report will not run because JReport Server User is not logged in already."
                    + "<br>Browser will display HTTP Authentication login dialog to enable running of report."
                    + "<br>(Single Sign On framework is not turned on)";
            }
        }
    }
%>
<html>
<head>
<title>Use Session Variable for Authentication - Single Sign On Demonstration</title>
</head>
<body>
 &nbsp;&nbsp;&nbsp;   <a href="customIndex.jsp?action=<%=String.valueOf(time) %>">Home</a>
<h4>Demonstrate Single Sign On by running a report</h4> 
This case passes in an application user ID to the Single Sign On framework with an HTTP session variable.
<ul>
<li>
The HTTP session will have a variable "authorized_user" holding the value "admin".
</li>
<li>
This emulates the application having a known user already logged in.
</li>
</ul>

<p>
Current application user just set into the session: <b><%=appUser %></b>
<br>
Current JReport Server user in this session: <b><%=jrUser %></b>
<br>
SSO Status: <b><%=singleSignOnStatus %></b>
</p>
<p>
<hr>
<b>Expected result of running report:</b>
<br>
<%=scenarioExpectation %>
<hr>
<hr>
<p>
<form name="form1" action="customViewReport.jsp">
  <table>    
    <tr> <td>
     <b>Scenario:</b>
     <br>
     Application User ID "admin" sent to Single Sign On framework by using HTTP session variable
    </td> </tr>
    <tr> <td>
     <hr>
    </td> </tr>
    <tr> <td>
      <input type="submit" value="Run Report">
    </td> </tr>
  </table>
</form>

</body>
</html

</body>
</html>
