
import jet.server.api.*;
import jet.server.api.http.*;
import jet.cs.util.*; 
import jet.server.api.rmi.*;
import java.util.*;

/**
 * APIDemoDynamicExportTask is an demo that is used to show how to perform customized tasks.
 * It will connect to a running server via RMI or start a new server if one is not running locally.
 * It exports a report to PDF into a local folder.
 */

public class APIDemoDynamicExportTask implements UserTask {

	boolean isStop = false;
	Properties rptProp = null;
	Properties exportProp = null;
	String errorMsg = null;
	boolean hasError = false;

	public void initReportProperties(Properties rptProp) {
		this.rptProp = rptProp;
	}
	
	public void initUserTaskProperties(Properties exportProp) {
		this.exportProp = exportProp;
	}
	
	public void stopExec() {
		Thread t = Thread.currentThread();
		if (t != null) {
			t.interrupt();
			try {
				t.join(1000);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
		hasError = true;
		errorMsg = "cancel the task";
	}

	public void close() {
		hasError = false;
	}

	public boolean hasError() {
		return hasError;
	}

	public String getErrorMsg() {
		return errorMsg;
	}
	
	public void runTask  (RptServer server) throws Exception {
		String uid = "admin" ;
		
			String s = server.runReport(uid, (String)rptProp.get(APIConst.TAG_CATALOG), (String)rptProp.get(APIConst.TAG_REPORT), rptProp);
			System.out.println("The temporary result name : "+s);
			if (exportProp == null) {
				exportProp = new Properties();
			}
			// set export task properties with report properties info
			exportProp.put(APIConst.TAG_REPORT, rptProp.get(APIConst.TAG_REPORT));
			exportProp.put(APIConst.TAG_RPT_VERSION, rptProp.get(APIConst.TAG_RPT_VERSION));
			exportProp.put(APIConst.TAG_CATALOG, rptProp.get(APIConst.TAG_CATALOG));
			exportProp.put(APIConst.TAG_CAT_VERSION, rptProp.get(APIConst.TAG_CAT_VERSION));
			exportProp.put(APIConst.TAG_UID, uid);
			System.out.println("========Before runtask()! exportProp=" + exportProp);
			ExportedFileList fileList = server.exportResult(uid, s, exportProp);
			System.out.println("========Before runtask()! fileList=" + fileList.toHttpQueryString());			

	}	
	
	public void run() {
		if (rptProp == null) {
			System.out.println("========report properties is null!");
			return;
		}
			
		//search the running server using default host and port
		String host = "localhost";
		String port = "1129";
		RptServer server = null;
		// Set reporthome and set the RMI security file location in case we connect remotely
		System.getProperties().put("reporthome","C:\\JReport\\Server");		
		System.getProperties().put("jrs.rmi.auth_file", "C:\\JReport\\Server\\bin\\rmi.auth");
		// Try to connect to a remote server first on the local machine.
		server = RemoteReportServerToolkit.getRemoteWrappedRptServer(host, port);  // Ignore exception in console		
		if (server == null) {
		    // start a new server instance if one is not running with RMI enabled.
		    HttpUtil.initEnv(System.getProperties());
		    server = HttpUtil.getHttpRptServer();
		    System.out.println("Connected to new server="+server);
		    try {
				runTask(server);
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}finally{
				server.shutdown();
				System.out.println("Server "+ server +" shutdown.");
			}
		} else { 
		    System.out.println("Connected to running server using RMI="+server);
		    try {
				runTask(server);
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		} 
		
	}
	
	public static void main (String[] args){
		APIDemoDynamicExportTask aet = new APIDemoDynamicExportTask();
		Properties rptProp = new Properties();
		rptProp.put(APIConst.TAG_REPORT, "/SampleReports/Banded_Link.cls");
		rptProp.put(APIConst.TAG_RPT_VERSION, "-1");
		rptProp.put(APIConst.TAG_CATALOG, "/SampleReports/SampleReports.cat");
		rptProp.put(APIConst.TAG_CAT_VERSION, "-1");
		rptProp.put(APIConst.TAG_PDF, "true");
		aet.initReportProperties(rptProp);
		Properties exportProp = new Properties();
		exportProp.put(APIConst.TAG_PDF, "true");		
		exportProp.put(APIConst.TAG_PDF_DIR, "C:\\JReport\\Server\\temp");
		exportProp.put(APIConst.TAG_TO_DISK,true);
		aet.initUserTaskProperties(exportProp);
		aet.run();
		System.exit(0);
	}
}
