/*
 * Created on Jul 29, 2005
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package jreport.uds.javabean;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintStream;
import java.util.Vector;

import javax.swing.Timer;

/**
 * @author mdaly
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
class DataElementForDataCenter implements ActionListener {
	private String objID;
	private Object owner;
	private Object data;
//	private int	shareNum=0;
	private int maxShareTimes=1;
	private int sharedTimes =0;
	private Vector lockers=new Vector(1);
	private Timer mytimer= null; 
	
	public DataElementForDataCenter(String objID,
			Object owner, 
			Object data,
			int maxShareTimes, 
			int delay ){
		this.objID = objID;
		this.owner = owner;
		this.data =data;
		this.maxShareTimes =maxShareTimes;
		if( delay > 0){
			mytimer = new Timer(delay, this);
			mytimer.start();
		}
	}
	
	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		if( lockers.size()==0){
//			System.out.println("TIMEOUT>>>"+objID);
			mytimer.stop();
			DataCenter.removeData( objID);
		}

	}
	public synchronized boolean lock(Object locker){
		
		boolean ret = false;
		UDSForJavaBeanLogger.debug("DataElementForDataCenter.lock())>>>locker:"+locker);
		synchronized( lockers){
			if (lockers.contains(locker)){
				UDSForJavaBeanLogger.debug("DataElementForDataCenter.lock())>>>Locker has locked the data");
				ret = true;
			}else{
//				int shareNum = lockers.size();
				
//				UDSForJavaBeanLogger.debug("DataElementForDataCenter.lock())>>>locked number:"+shareNum+"Max:"+maxShareTimes);
//				if(shareNum+1 <= maxShareTimes ){
				if(sharedTimes+1 <= maxShareTimes ){
					if(mytimer!=null)
						mytimer.stop();
					
					sharedTimes++;
					lockers.addElement(locker);
					UDSForJavaBeanLogger.debug("DataElementForDataCenter.lock())>>>lock with locker:"+locker);
					
					if(mytimer!=null)
						mytimer.start();
					ret = true;
				}else
					ret = false;
			}
			lockers.notify();
		}
		
		return ret;
	}
	
	public boolean unlock( Object locker){
		
		UDSForJavaBeanLogger.debug("DataElementForDataCenter.unlock())>>>Locker:"+locker);
		synchronized( lockers){
			boolean ret= false;
			if( lockers.contains(locker)){
				if(mytimer!=null)
					mytimer.stop();
				lockers.remove(locker);
				UDSForJavaBeanLogger.debug("DataElementForDataCenter.unlock())>>>Remove the locker"+locker);
				
				int sharedCount = getShareCount();
//				System.out.println("sharedCount="+sharedCount+", sharedTimes="+sharedTimes+",maxShareTimes="+maxShareTimes);
				if( sharedCount==0 && sharedTimes >= maxShareTimes){
					ret= true;
				}
				if(mytimer!=null)
					mytimer.start();
			}
			lockers.notify();
			return ret;
		}
	}
	
	
	public int getShareCount(){
			return (lockers==null?0:lockers.size());
	}
	
	public boolean canBeRemoved(){
		if(mytimer!=null)
			mytimer.stop();
		int sharedCount = getShareCount();
		UDSForJavaBeanLogger.debug("DataElementForDataCenter.canBeRemoved())>>>LockedNum:"+sharedCount
				+"Shared Times:"+sharedTimes+"Max Share Times:"+maxShareTimes);
		
		if( sharedCount==0 && sharedTimes >= maxShareTimes){
			return true;
		}
		if(mytimer!=null)
			mytimer.start();
		return false;
	}
	
	public void removed(){
	    mytimer.stop();
	}
	
	public void dump(PrintStream out){
		out.println("Owner:"+owner+"Data:"+data+"MaxShareTimes:"+maxShareTimes+"SharedTimes:"+sharedTimes+"SharedCount:"+this.getShareCount());
	}
	/**
	 * @return Returns the data.
	 */
	public Object getData() {
		return data;
	}
	/**
	 * @param data The data to set.
	 */
	public void setData(Object data) {
		this.data = data;
	}
	/**
	 * @return Returns the ownder.
	 */
	public Object getOwner() {
		return owner;
	}
	/**
	 * @param ownder The ownder to set.
	 */
	public void setOwner(String owner) {
		this.owner = owner;
	}
	/**
	 * @return Returns the maxShareTimes.
	 */
	public int getMaxShareTimes() {
		return maxShareTimes;
	}
	/**
	 * @param maxShareTimes The maxShareTimes to set.
	 */
	public void setMaxShareTimes(int maxShareTimes) {
		this.maxShareTimes = maxShareTimes;
	}
	/**
	 * @return Returns the sharedTimes.
	 */
	public int getSharedTimes() {
		return sharedTimes;
	}
}
