package jreport.uds.javabean;
import java.io.IOException;
import java.io.StringBufferInputStream;
import java.sql.ResultSet;
import java.util.Properties;

import jet.datasource.JRUserDataSource;
import jet.datasource.JRUserDataSourceException;
import jreport.uds.javabean.exception.JavaBeanDataProviderException;
import jreport.uds.javabean.exception.ResultSetExceptionForJavaBean;
import jreport.uds.javabean.api.JavaBeanDataProvider;
/*
 * Created on Jul 17, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */

/**
 * @author jennyw
 *
 * This Class is used to define the data source which is using Java Bean object(s) as data source.
 * currently it only suitable for one-level Java bean collection.
 */
public class UDSForJavaBean implements JRUserDataSource {
	
	
	private JavaBeanDataProvider dataProvider=null;
	
	/**
	 * This method is called by JReport Engine when it finishes using the result. Usually this method 
	 * is used to clean up opened resource after engine finishes its work on it.
	 * 
	 * In this UDS class, this method will call the DataProvider exit() function, so that
	 * DataProvider can remove clean up accordingly as well.
	 */
	public void releaseResultSet() throws JRUserDataSourceException {
		try {
			dataProvider.exit();
		} catch (JavaBeanDataProviderException e) {
			UDSForJavaBeanLogger.debug(e);
			throw new JRUserDataSourceException(e.getMessage());
		}
	}

	/**
	 * Generate ResultSet object for Java Bean Data Source.
	 * @param : This is formated string. The format of this string is like this:
	 * &<Key>=[value]&<Key>=[value]....
	 * 
	 * For this UDS class, you need to provide two pair of keys and values accordingly:
	 * - <b>JavaBeanDS_DataProvider</b>:The value for this key indicate the Java Class which implements
	 * the interface JavaBeanDataProvider. And that is used to populate the data object 
	 * for the report. Please refer to more information about the interface JavaBeanDataProvider.
	 * 
	 * - <b>JavaBeanDS_RuntimeDataID</b>: This is a string value indicating the key to get populated data from 
	 * DataCenter. So DataProvider could get the data from the DataCenter by the RuntimeDataID.
	 * 
	 */
	public ResultSet getResultSet(String param) throws JRUserDataSourceException {
		
		String strProp = param.replace('&', '\n');
        StringBufferInputStream is = new StringBufferInputStream(strProp);

        Properties properties = new Properties();
        try
        {
            properties.load(is);  // May throw IOException.
            UDSForJavaBeanLogger.debug("List of parameters from Engine>>>>");
            UDSForJavaBeanLogger.debug(properties);
        }
        catch (IOException e){
        	UDSForJavaBeanLogger.debug(e);
            throw new JRUserDataSourceException(e.getMessage());
        }
        
        String strClassNameforDataProvider = (String)properties.get("JavaBeanDS_DataProvider");
        String strRuntimeDataID=(String)properties.get("JavaBeanDS_RuntimeDataID");
        
    	try {
			Class clsDataProvider =  Class.forName(strClassNameforDataProvider);
			
			try {
				dataProvider = (JavaBeanDataProvider)clsDataProvider.newInstance();
				dataProvider.init(strRuntimeDataID, properties);
				return new ResultSetForJavaBean(dataProvider);  
				
			} catch (InstantiationException e2) {
				UDSForJavaBeanLogger.debug(e2);
				throw new JRUserDataSourceException( e2.getMessage());
			} catch (IllegalAccessException e2) {
				UDSForJavaBeanLogger.debug(e2);
				throw new JRUserDataSourceException( e2.getMessage());
			} catch (ResultSetExceptionForJavaBean e) {
				UDSForJavaBeanLogger.debug(e);
				throw new JRUserDataSourceException( e.getMessage());
			}catch(JavaBeanDataProviderException e){
				UDSForJavaBeanLogger.debug(e);
				throw new JRUserDataSourceException(e.getMessage());
			}
		} catch (ClassNotFoundException e1) {
			UDSForJavaBeanLogger.debug(e1);
			throw new JRUserDataSourceException( e1.getMessage());
		}
	}
}
