/*
 * Decompiled with CFR 0.152.
 */
package chart.chart3d;

import chart.ChartDataObject;
import chart.ChartShowValueCondition;
import chart.axis.ChartCategoryAxis;
import chart.chart3d.Chart3DObject;
import chart.chart3d.Chart3DPaper;
import chart.chart3d.Chart3DStrip;
import chart.chart3d.ChartCompass;
import chart.chart3d.ChartMatrix;
import chart.data.Chart1DDataSet;
import chart.data.ChartDataSet;
import chart.data.ChartDataUsedInfo;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartPenStyle;
import chart.properties.ChartNumericAxisProperties;
import chart.util.ChartHintLabel;
import chart.util.ChartMath;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.util.List;
import jet.util.JRInterruptedException;

public class Graph3DLineA
extends Chart3DObject {
    ChartDataSet availableLength;
    int[] availableValue;
    protected Chart3DStrip[][] strip;
    protected ChartFillPattern[] pattern;
    private ChartCompass custommerConstant;
    int draw1;
    int draw2;
    int floatValue;
    protected boolean hasLogY1;
    private boolean get;
    private boolean getAbsoluteValueSumOfCategory;
    private boolean getAxisX1;
    float[] getCategoryName = new float[3];
    int getCategorySize = 2;
    float[] getChartDataSet;
    Color[] getChartDataSetModel;
    boolean[][] getChartLink;
    boolean getChartLinkInfo;
    private ChartPenStyle getChartPlatform;
    float getCompass = 0.6f;
    boolean getCondition = false;

    public Graph3DLineA(ChartDataSet chartDataSet, Chart3DPaper chart3DPaper) {
        super(chartDataSet, chart3DPaper);
        this.availableLength = chartDataSet;
        this.availableValue = chart3DPaper.getIntType();
        this.paper = chart3DPaper;
        this.draw1 = chartDataSet.getCategorySize();
        this.draw2 = chartDataSet.getSeriesSize();
        this.pattern = chart3DPaper.getChartPlatform().getFillPatternByArarry(0);
        this.getCompass = chart3DPaper.getProperties().getGraphProperties().getThresholdFillTransparency();
    }

    @Override
    public void init() {
        int n;
        Number number;
        int n2;
        int n3;
        if (this.draw1 < 2) {
            return;
        }
        this.getCondition = !this.paper.getProperties().isIgnoreNullValue();
        this.setCompass(this.paper.getCompass());
        this.getChartLinkInfo = this.paper.getProperties().getGraphProperties().isContour();
        this.getChartPlatform = this.properties.getGraphProperties().getContourPen();
        this.strip = new Chart3DStrip[this.draw2][this.draw1];
        this.getCategoryName = this.paper.getUnit();
        float f = Math.max(this.paper.getProperties().getGraphProperties().getLineThickness(), 0.0f);
        float f2 = this.getCategoryName[2] / 5.0f;
        if (f2 > this.getCategoryName[2]) {
            f2 = this.getCategoryName[2];
        }
        float f3 = 0.0f;
        float f4 = this.getCategoryName[0];
        float f5 = 0.0f;
        float f6 = this.getCategoryName[2] / 2.0f - f2 / 2.0f;
        float f7 = this.getCategoryName[2];
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        float f11 = 0.0f;
        float[][] fArray = new float[this.draw2][this.draw1];
        this.getChartLink = new boolean[this.draw2][this.draw1 - 1];
        float[] fArray2 = new float[this.draw1];
        if (this.dataset.getChartDataSetModel().isOneGroupForBar()) {
            for (n3 = 0; n3 < this.draw1; ++n3) {
                for (n2 = 0; n2 < this.draw1; ++n2) {
                    fArray2[n3] = fArray2[n3] + (float)((Chart1DDataSet)this.dataset).getAbsoluteValueSumOfCategory(n2);
                }
                fArray2[n3] = fArray2[n3] == 0.0f ? 1.0f : fArray2[n3];
            }
        } else {
            for (n3 = 0; n3 < this.draw1; ++n3) {
                fArray2[n3] = (float)((Chart1DDataSet)this.dataset).getAbsoluteValueSumOfCategory(n3);
            }
        }
        for (n3 = 0; n3 < this.draw2; ++n3) {
            for (n2 = 0; n2 < this.draw1; ++n2) {
                number = ((Chart1DDataSet)this.dataset).getValue(n3, n2);
                fArray[n3][n2] = number == null ? 0.0f : (!((ChartNumericAxisProperties)this.paper.C.getProperties()).getIsShowPercent() ? number.floatValue() : number.floatValue() / fArray2[n2]);
            }
        }
        f3 = this.paper.getOriginY();
        f8 = f5;
        float f12 = f6;
        if (this.paper.getProperties().getGraphProperties().isShowThresholdLine() && this.paper.getProperties().getGraphProperties().isShowThresholdLine2()) {
            this.getCategorySize = 2;
            this.getChartDataSet = new float[this.getCategorySize];
            this.getChartDataSetModel = new Color[this.getCategorySize];
            this.getChartDataSet[0] = (float)this.paper.getProperties().getGraphProperties().getThresholdValue();
            this.getChartDataSet[1] = (float)this.paper.getProperties().getGraphProperties().getThresholdValue2();
            this.getChartDataSetModel[0] = this.paper.getProperties().getGraphProperties().getThresholdLineColor();
            this.getChartDataSetModel[1] = this.paper.getProperties().getGraphProperties().getThresholdLineColor2();
        } else if (this.paper.getProperties().getGraphProperties().isShowThresholdLine()) {
            this.getCategorySize = 1;
            this.getChartDataSet = new float[this.getCategorySize];
            this.getChartDataSetModel = new Color[this.getCategorySize];
            this.getChartDataSet[0] = (float)this.paper.getProperties().getGraphProperties().getThresholdValue();
            this.getChartDataSetModel[0] = this.paper.getProperties().getGraphProperties().getThresholdLineColor();
        } else if (this.paper.getProperties().getGraphProperties().isShowThresholdLine2()) {
            this.getCategorySize = 1;
            this.getChartDataSet = new float[this.getCategorySize];
            this.getChartDataSetModel = new Color[this.getCategorySize];
            this.getChartDataSet[0] = (float)this.paper.getProperties().getGraphProperties().getThresholdValue2();
            this.getChartDataSetModel[0] = this.paper.getProperties().getGraphProperties().getThresholdLineColor2();
        } else {
            this.getCategorySize = 0;
            this.getChartDataSet = new float[this.getCategorySize];
            this.getChartDataSetModel = new Color[this.getCategorySize];
        }
        for (n3 = 0; n3 < this.getCategorySize; ++n3) {
            float f13 = 0.0f;
            for (n = n3; n < this.getCategorySize; ++n) {
                if (!(this.getChartDataSet[n3] > this.getChartDataSet[n])) continue;
                f13 = this.getChartDataSet[n];
                this.getChartDataSet[n] = this.getChartDataSet[n3];
                this.getChartDataSet[n3] = f13;
                Color color = this.getChartDataSetModel[n];
                this.getChartDataSetModel[n] = this.getChartDataSetModel[n3];
                this.getChartDataSetModel[n3] = color;
            }
        }
        float[] fArray3 = new float[this.getCategorySize];
        for (int i = 0; i < this.getCategorySize; ++i) {
            fArray3[i] = this.paper.availableLength(this.getChartDataSet[i] * this.getCategoryName[1]);
            if (!(fArray3[i] < 2.0f) || fArray3[i] == 0.0f) continue;
            fArray3[i] = fArray3[i] + 3.0f;
        }
        ChartCategoryAxis chartCategoryAxis = (ChartCategoryAxis)this.paper.getAxisX1();
        for (int i = 0; i < this.draw2; ++i) {
            float f14 = f12;
            for (n = 0; n < this.draw1 - 1; ++n) {
                float f15;
                Object object;
                float f16;
                Object object2;
                float f17;
                this.strip[i][n] = new Chart3DStrip(this.pattern[i], this.getChartLinkInfo, this.getChartPlatform);
                if (this.getCondition) {
                    f17 = this.paper.availableValue(fArray[i][n]);
                    f9 = f17 * this.getCategoryName[1] + f3;
                    float f18 = this.paper.availableValue(fArray[i][n + 1]);
                    f11 = f18 * this.getCategoryName[1] + f3;
                    f10 = f8 + f4;
                    if (this.paper.getAxisX1().custommerConstant()) {
                        object2 = this.getChartDataSet().getChartDataSetModel().getCategoryName(n);
                        f8 = f16 = chartCategoryAxis.getX(object2, this.getCategoryName[0]);
                        object2 = this.getChartDataSet().getChartDataSetModel().getCategoryName(n + 1);
                        f10 = chartCategoryAxis.getX(object2, this.getCategoryName[0]);
                    }
                } else {
                    int[] nArray;
                    number = ((Chart1DDataSet)this.dataset).getValue(i, n);
                    if (number == null) {
                        if (this.paper.getAxisX1().custommerConstant()) {
                            object2 = this.getChartDataSet().getChartDataSetModel().getCategoryName(n);
                            f8 = f16 = chartCategoryAxis.getX(object2, this.getCategoryName[0]);
                        }
                        object2 = new float[2];
                        float[] fArray4 = new float[2];
                        nArray = ((Chart1DDataSet)this.dataset).getNotNullBeforeAndAfterIndex(i, n);
                        if (nArray[0] != -1) {
                            if (!this.paper.getAxisX1().custommerConstant()) {
                                object2[0] = (float)nArray[0] * f4;
                            } else {
                                object = this.getChartDataSet().getChartDataSetModel().getCategoryName(nArray[0]);
                                object2[0] = chartCategoryAxis.getX(object, this.getCategoryName[0]);
                            }
                            object2[1] = this.paper.availableValue(fArray[i][nArray[0]]) * this.getCategoryName[1] + f3;
                        }
                        if (nArray[1] != -1) {
                            if (!this.paper.getAxisX1().custommerConstant()) {
                                fArray4[0] = (float)nArray[1] * f4;
                            } else {
                                object = this.getChartDataSet().getChartDataSetModel().getCategoryName(nArray[1]);
                                fArray4[0] = chartCategoryAxis.getX(object, this.getCategoryName[0]);
                            }
                            fArray4[1] = this.paper.availableValue(fArray[i][nArray[1]]) * this.getCategoryName[1] + f3;
                        }
                        if (nArray[0] != -1 && nArray[1] != -1) {
                            f9 = ChartMath.getYforUsedStartAndEndPoint(object2, fArray4, f8);
                        } else {
                            f17 = this.paper.availableValue(fArray[i][n]);
                            f9 = f17 * this.getCategoryName[1] + f3;
                        }
                    } else {
                        f17 = this.paper.availableValue(fArray[i][n]);
                        f9 = f17 * this.getCategoryName[1] + f3;
                        if (this.paper.getAxisX1().custommerConstant()) {
                            object2 = this.getChartDataSet().getChartDataSetModel().getCategoryName(n);
                            f8 = f16 = chartCategoryAxis.getX(object2, this.getCategoryName[0]);
                        }
                    }
                    number = ((Chart1DDataSet)this.dataset).getValue(i, n + 1);
                    if (number == null) {
                        if (this.paper.getAxisX1().custommerConstant()) {
                            float f19;
                            object2 = this.getChartDataSet().getChartDataSetModel().getCategoryName(n + 1);
                            f10 = f19 = chartCategoryAxis.getX(object2, this.getCategoryName[0]);
                        } else {
                            f10 = f8 + f4;
                        }
                        object2 = new float[2];
                        float[] fArray5 = new float[2];
                        nArray = ((Chart1DDataSet)this.dataset).getNotNullBeforeAndAfterIndex(i, n + 1);
                        if (nArray[0] != -1) {
                            if (!this.paper.getAxisX1().custommerConstant()) {
                                object2[0] = (float)nArray[0] * f4;
                            } else {
                                object = this.getChartDataSet().getChartDataSetModel().getCategoryName(nArray[0]);
                                object2[0] = chartCategoryAxis.getX(object, this.getCategoryName[0]);
                            }
                            object2[1] = this.paper.availableValue(fArray[i][nArray[0]]) * this.getCategoryName[1] + f3;
                        }
                        if (nArray[1] != -1) {
                            if (!this.paper.getAxisX1().custommerConstant()) {
                                fArray5[0] = (float)nArray[1] * f4;
                            } else {
                                object = this.getChartDataSet().getChartDataSetModel().getCategoryName(nArray[1]);
                                fArray5[0] = chartCategoryAxis.getX(object, this.getCategoryName[0]);
                            }
                            fArray5[1] = this.paper.availableValue(fArray[i][nArray[1]]) * this.getCategoryName[1] + f3;
                        }
                        if (nArray[0] != -1 && nArray[1] != -1) {
                            f11 = ChartMath.getYforUsedStartAndEndPoint(object2, fArray5, f10);
                        } else {
                            f17 = this.paper.availableValue(fArray[i][n + 1]);
                            f11 = f17 * this.getCategoryName[1] + f3;
                        }
                    } else {
                        f17 = this.paper.availableValue(fArray[i][n + 1]);
                        f11 = f17 * this.getCategoryName[1] + f3;
                        if (this.paper.getAxisX1().custommerConstant()) {
                            float f20;
                            object2 = this.getChartDataSet().getChartDataSetModel().getCategoryName(n + 1);
                            f10 = f20 = chartCategoryAxis.getX(object2, this.getCategoryName[0]);
                        } else {
                            f10 = f8 + f4;
                        }
                    }
                }
                object2 = new int[3];
                object2[0] = this.getCategorySize;
                object2[1] = 0.0f;
                object2[2] = 0.0f;
                this.getChartLink[i][n] = false;
                if (f9 > f11) {
                    float f21 = 0.0f;
                    float f22 = 0.0f;
                    f21 = f8;
                    f8 = f10;
                    f10 = f21;
                    f22 = f9;
                    f9 = f11;
                    f11 = f22;
                    this.getChartLink[i][n] = true;
                }
                this.strip[i][n].setLineVertex1(f8, f9, f12, f, f2, 0.0f);
                for (int j = 0; j < this.getCategorySize; ++j) {
                    if (fArray3[j] < f9 && fArray3[j] > f11 || fArray3[j] > f9 && fArray3[j] < f11) {
                        this.strip[i][n].setLineVertex1((fArray3[j] - f9) / (f11 - f9) * (f10 - f8) + f8, fArray3[j], f14, f, f2, 0.0f);
                        object2[1] = object2[1] + true;
                        continue;
                    }
                    if (!(fArray3[j] <= f9) || !(fArray3[j] <= f11)) continue;
                    object2[2] = object2[2] + true;
                }
                this.strip[i][n].setLineVertex1(f10, f11, f14, f, f2, 0.0f);
                if (this.getChartLink[i][n]) {
                    float f23 = 0.0f;
                    f23 = f8;
                    f8 = f10;
                    f10 = f23;
                }
                f16 = 0.0f;
                float f24 = 0.0f;
                if (this.paper.getAxisX1().custommerConstant()) {
                    f24 = 0.0f;
                    f16 = f4;
                    if (n != this.draw1 - 2 && n != 0) {
                        object = this.getChartDataSet().getChartDataSetModel().getCategoryName(n + 1);
                        f15 = chartCategoryAxis.getX(object, this.getCategoryName[0]);
                        f24 = f8;
                        f16 = f15 - f8;
                    } else if (n == 0) {
                        f24 = 0.0f;
                        object = this.getChartDataSet().getChartDataSetModel().getCategoryName(n + 1);
                        f15 = chartCategoryAxis.getX(object, this.getCategoryName[0]);
                        f16 = f15 - f24;
                    } else if (n == this.draw1 - 2) {
                        f24 = f8;
                        object = this.getChartDataSet().getChartDataSetModel().getCategoryName(n + 1);
                        f15 = chartCategoryAxis.getX(object, this.getCategoryName[0]);
                        f16 = this.paper.getLength()[0] - f8;
                    }
                } else {
                    f24 = f8;
                    f16 = this.getCategoryName[0];
                }
                for (int j = 0; j < this.getCategorySize; ++j) {
                    f15 = f12;
                    this.strip[i][n].setLineVertex1(f24, fArray3[j], f15 - this.getCategoryName[2] / 2.0f, 0.0f, this.getCategoryName[2], f16);
                }
                this.strip[i][n].setK((int[])object2);
                this.strip[i][n].setThresholdColor(this.getChartDataSetModel, this.getCompass);
                if (this.paper.getAxisX1().custommerConstant()) continue;
                f8 = f10;
            }
            if (!this.paper.getAxisX1().custommerConstant()) {
                f8 = f5;
            }
            f12 += f7;
        }
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        if (this.draw1 < 2) {
            return;
        }
        for (int i = 0; i < this.draw2; ++i) {
            int n = i;
            if (!this.get) {
                n = this.draw2 - i - 1;
            }
            for (int j = 0; j < this.draw1 - 1; ++j) {
                int n2 = j;
                if (!this.getAbsoluteValueSumOfCategory) {
                    n2 = this.draw1 - j - 1 - 1;
                }
                if (this.strip[n][n2] == null) continue;
                this.floatValue = this.custommerConstant.shownFace(this.strip[n][n2].tVertex, 0);
                if (this.status == 1 && n == this.selectedSeriesIndex) {
                    this.strip[n][n2].setSelectedStatus(true);
                } else {
                    this.strip[n][n2].setSelectedStatus(false);
                }
                if (this.getAxisX1) {
                    this.strip[n][n2].draw1(graphics2D, this.floatValue, this.getChartLinkInfo);
                    continue;
                }
                this.strip[n][n2].draw2(graphics2D, this.floatValue, this.getChartLinkInfo);
            }
        }
    }

    @Override
    public void transform(ChartMatrix chartMatrix) {
        if (this.draw1 < 2) {
            return;
        }
        for (int i = 0; i < this.draw2; ++i) {
            for (int j = 0; j < this.draw1 - 1; ++j) {
                if (this.strip[i][j] == null) continue;
                this.strip[i][j].transform(chartMatrix);
            }
        }
        this.SEDU();
    }

    private void SEDU() {
        if (this.draw1 - 1 != 1) {
            this.availableValue();
        }
        if (this.draw2 != 1) {
            this.availableLength();
        }
        this.custommerConstant();
    }

    private void availableLength() {
        this.get = (this.paper.getShownFace() >> 5 & 1) == 1;
    }

    private void availableValue() {
        this.getAbsoluteValueSumOfCategory = (this.paper.getShownFace() & 1) != 1;
    }

    private void custommerConstant() {
        this.getAxisX1 = (this.paper.getShownFace() >> 3 & 1) == 1;
    }

    public void setCompass(ChartCompass chartCompass) {
        this.custommerConstant = chartCompass;
    }

    @Override
    public String[] search(int n, int n2) {
        this.drilldown = null;
        if (this.draw1 < 1) {
            this.selectedSeriesIndex = -1;
            return null;
        }
        float f = 5.0f;
        String[] stringArray = null;
        block3: for (int i = 0; i < this.draw2; ++i) {
            for (int j = 0; j < this.draw1 - 1; ++j) {
                if (this.strip[i][j] == null) continue;
                try {
                    float f2;
                    float f3;
                    float f4;
                    float f5;
                    if (j == this.draw1 - 2) {
                        if (this.getChartLink[i][j]) {
                            f5 = Math.min(Math.min(this.strip[i][j].tVertex[0][0], this.strip[i][j].tVertex[2][0]), Math.min(this.strip[i][j].tVertex[1][0], this.strip[i][j].tVertex[3][0]));
                            f4 = Math.max(Math.max(this.strip[i][j].tVertex[0][0], this.strip[i][j].tVertex[2][0]), Math.max(this.strip[i][j].tVertex[1][0], this.strip[i][j].tVertex[3][0]));
                            f3 = Math.min(Math.min(this.strip[i][j].tVertex[0][1], this.strip[i][j].tVertex[2][1]), Math.min(this.strip[i][j].tVertex[1][1], this.strip[i][j].tVertex[3][1]));
                            f2 = Math.max(Math.max(this.strip[i][j].tVertex[0][1], this.strip[i][j].tVertex[2][1]), Math.max(this.strip[i][j].tVertex[1][1], this.strip[i][j].tVertex[3][1]));
                        } else {
                            f5 = Math.min(Math.min(this.strip[i][j].tVertex[6 + this.strip[i][j].I[1] * 4][0], this.strip[i][j].tVertex[4 + this.strip[i][j].I[1] * 4][0]), Math.min(this.strip[i][j].tVertex[5 + this.strip[i][j].I[1] * 4][0], this.strip[i][j].tVertex[7 + this.strip[i][j].I[1] * 4][0]));
                            f4 = Math.max(Math.max(this.strip[i][j].tVertex[6 + this.strip[i][j].I[1] * 4][0], this.strip[i][j].tVertex[4 + this.strip[i][j].I[1] * 4][0]), Math.max(this.strip[i][j].tVertex[5 + this.strip[i][j].I[1] * 4][0], this.strip[i][j].tVertex[7 + this.strip[i][j].I[1] * 4][0]));
                            f3 = Math.min(Math.min(this.strip[i][j].tVertex[6 + this.strip[i][j].I[1] * 4][1], this.strip[i][j].tVertex[4 + this.strip[i][j].I[1] * 4][1]), Math.min(this.strip[i][j].tVertex[5 + this.strip[i][j].I[1] * 4][1], this.strip[i][j].tVertex[7 + this.strip[i][j].I[1] * 4][1]));
                            f2 = Math.max(Math.max(this.strip[i][j].tVertex[6 + this.strip[i][j].I[1] * 4][1], this.strip[i][j].tVertex[4 + this.strip[i][j].I[1] * 4][1]), Math.max(this.strip[i][j].tVertex[5 + this.strip[i][j].I[1] * 4][1], this.strip[i][j].tVertex[7 + this.strip[i][j].I[1] * 4][1]));
                        }
                        if ((float)n >= f5 - f && (float)n <= f4 + f && (float)n2 <= f2 + f && (float)n2 >= f3 - f) {
                            if (this.paper.getProperties().isShowCategoryAndSeries()) {
                                stringArray = new String[3];
                                ChartHintLabel chartHintLabel = new ChartHintLabel((ChartDataObject)this, this.dataset, this.paper, 3);
                                stringArray = chartHintLabel.hintLabelShowCategoryAndSeries(i, j + 1);
                            } else {
                                stringArray = new String[]{this.dataset.getFormatedHintValue(((Chart1DDataSet)this.dataset).getValue(i, j + 1))};
                            }
                            this.selectedSeriesIndex = i;
                            this.drilldown = new int[2];
                            this.drilldown[0] = i;
                            this.drilldown[1] = j + 1;
                            return stringArray;
                        }
                    }
                    if (this.getChartLink[i][j]) {
                        f5 = Math.min(Math.min(this.strip[i][j].tVertex[4 + this.strip[i][j].I[1] * 4][0], this.strip[i][j].tVertex[6 + this.strip[i][j].I[1] * 4][0]), Math.min(this.strip[i][j].tVertex[5 + this.strip[i][j].I[1] * 4][0], this.strip[i][j].tVertex[7 + this.strip[i][j].I[1] * 4][0]));
                        f4 = Math.max(Math.max(this.strip[i][j].tVertex[4 + this.strip[i][j].I[1] * 4][0], this.strip[i][j].tVertex[6 + this.strip[i][j].I[1] * 4][0]), Math.max(this.strip[i][j].tVertex[5 + this.strip[i][j].I[1] * 4][0], this.strip[i][j].tVertex[7 + this.strip[i][j].I[1] * 4][0]));
                        f3 = Math.min(Math.min(this.strip[i][j].tVertex[4 + this.strip[i][j].I[1] * 4][1], this.strip[i][j].tVertex[6 + this.strip[i][j].I[1] * 4][1]), Math.min(this.strip[i][j].tVertex[5 + this.strip[i][j].I[1] * 4][1], this.strip[i][j].tVertex[7 + this.strip[i][j].I[1] * 4][1]));
                        f2 = Math.max(Math.max(this.strip[i][j].tVertex[4 + this.strip[i][j].I[1] * 4][1], this.strip[i][j].tVertex[6 + this.strip[i][j].I[1] * 4][1]), Math.max(this.strip[i][j].tVertex[5 + this.strip[i][j].I[1] * 4][1], this.strip[i][j].tVertex[7 + this.strip[i][j].I[1] * 4][1]));
                    } else {
                        f5 = Math.min(Math.min(this.strip[i][j].tVertex[1][0], this.strip[i][j].tVertex[3][0]), Math.min(this.strip[i][j].tVertex[2][0], this.strip[i][j].tVertex[0][0]));
                        f4 = Math.max(Math.max(this.strip[i][j].tVertex[1][0], this.strip[i][j].tVertex[3][0]), Math.max(this.strip[i][j].tVertex[2][0], this.strip[i][j].tVertex[0][0]));
                        f3 = Math.min(Math.min(this.strip[i][j].tVertex[1][1], this.strip[i][j].tVertex[3][1]), Math.min(this.strip[i][j].tVertex[2][1], this.strip[i][j].tVertex[0][1]));
                        f2 = Math.max(Math.max(this.strip[i][j].tVertex[1][1], this.strip[i][j].tVertex[3][1]), Math.max(this.strip[i][j].tVertex[2][1], this.strip[i][j].tVertex[0][1]));
                    }
                    if (!((float)n >= f5 - f) || !((float)n <= f4 + f) || !((float)n2 <= f2 + f) || !((float)n2 >= f3 - f)) continue;
                    if (this.paper.getProperties().isShowCategoryAndSeries()) {
                        stringArray = new String[3];
                        ChartHintLabel chartHintLabel = new ChartHintLabel((ChartDataObject)this, this.dataset, this.paper, 3);
                        stringArray = chartHintLabel.hintLabelShowCategoryAndSeries(i, j);
                    } else {
                        stringArray = new String[]{this.dataset.getFormatedHintValue(((Chart1DDataSet)this.dataset).getValue(i, j))};
                    }
                    this.selectedSeriesIndex = i;
                    this.drilldown = new int[2];
                    this.drilldown[0] = i;
                    this.drilldown[1] = j;
                    return stringArray;
                }
                catch (JRInterruptedException jRInterruptedException) {
                    throw jRInterruptedException;
                }
                catch (Exception exception) {
                    continue block3;
                }
            }
        }
        this.selectedSeriesIndex = -1;
        return null;
    }

    @Override
    public Shape getShapeBySeries(int n) {
        return null;
    }

    @Override
    public Shape getShapeByItem(int n, int n2) {
        return this.strip[n][n2].toHtml();
    }

    @Override
    public Shape[][] getItemShapes(int n) {
        if (this.draw1 < 2) {
            return null;
        }
        float f = 5.0f;
        Shape[][] shapeArray = new Shape[this.draw2][this.draw1];
        for (int i = 0; i < this.draw2; ++i) {
            for (int j = 0; j < this.draw1; ++j) {
                float f2;
                float f3;
                float f4;
                float f5;
                shapeArray[i][j] = new GeneralPath();
                ((GeneralPath)shapeArray[i][j]).reset();
                if (j < this.draw1 - 1) {
                    if (this.strip[i][j] == null) continue;
                    if (this.getChartLink[i][j]) {
                        f5 = Math.min(Math.min(this.strip[i][j].tVertex[4 + this.strip[i][j].I[1] * 4][0], this.strip[i][j].tVertex[6 + this.strip[i][j].I[1] * 4][0]), Math.min(this.strip[i][j].tVertex[5 + this.strip[i][j].I[1] * 4][0], this.strip[i][j].tVertex[7 + this.strip[i][j].I[1] * 4][0]));
                        f4 = Math.max(Math.max(this.strip[i][j].tVertex[4 + this.strip[i][j].I[1] * 4][0], this.strip[i][j].tVertex[6 + this.strip[i][j].I[1] * 4][0]), Math.max(this.strip[i][j].tVertex[5 + this.strip[i][j].I[1] * 4][0], this.strip[i][j].tVertex[7 + this.strip[i][j].I[1] * 4][0]));
                        f3 = Math.min(Math.min(this.strip[i][j].tVertex[4 + this.strip[i][j].I[1] * 4][1], this.strip[i][j].tVertex[6 + this.strip[i][j].I[1] * 4][1]), Math.min(this.strip[i][j].tVertex[5 + this.strip[i][j].I[1] * 4][1], this.strip[i][j].tVertex[7 + this.strip[i][j].I[1] * 4][1]));
                        f2 = Math.max(Math.max(this.strip[i][j].tVertex[4 + this.strip[i][j].I[1] * 4][1], this.strip[i][j].tVertex[6 + this.strip[i][j].I[1] * 4][1]), Math.max(this.strip[i][j].tVertex[5 + this.strip[i][j].I[1] * 4][1], this.strip[i][j].tVertex[7 + this.strip[i][j].I[1] * 4][1]));
                    } else {
                        f5 = Math.min(Math.min(this.strip[i][j].tVertex[1][0], this.strip[i][j].tVertex[3][0]), Math.min(this.strip[i][j].tVertex[2][0], this.strip[i][j].tVertex[0][0]));
                        f4 = Math.max(Math.max(this.strip[i][j].tVertex[1][0], this.strip[i][j].tVertex[3][0]), Math.max(this.strip[i][j].tVertex[2][0], this.strip[i][j].tVertex[0][0]));
                        f3 = Math.min(Math.min(this.strip[i][j].tVertex[1][1], this.strip[i][j].tVertex[3][1]), Math.min(this.strip[i][j].tVertex[2][1], this.strip[i][j].tVertex[0][1]));
                        f2 = Math.max(Math.max(this.strip[i][j].tVertex[1][1], this.strip[i][j].tVertex[3][1]), Math.max(this.strip[i][j].tVertex[2][1], this.strip[i][j].tVertex[0][1]));
                    }
                } else {
                    if (this.strip[i][j - 1] == null) continue;
                    if (this.getChartLink[i][j - 1]) {
                        f5 = Math.min(Math.min(this.strip[i][j - 1].tVertex[0][0], this.strip[i][j - 1].tVertex[2][0]), Math.min(this.strip[i][j - 1].tVertex[1][0], this.strip[i][j - 1].tVertex[3][0]));
                        f4 = Math.max(Math.max(this.strip[i][j - 1].tVertex[0][0], this.strip[i][j - 1].tVertex[2][0]), Math.max(this.strip[i][j - 1].tVertex[1][0], this.strip[i][j - 1].tVertex[3][0]));
                        f3 = Math.min(Math.min(this.strip[i][j - 1].tVertex[0][1], this.strip[i][j - 1].tVertex[2][1]), Math.min(this.strip[i][j - 1].tVertex[1][1], this.strip[i][j - 1].tVertex[3][1]));
                        f2 = Math.max(Math.max(this.strip[i][j - 1].tVertex[0][1], this.strip[i][j - 1].tVertex[2][1]), Math.max(this.strip[i][j - 1].tVertex[1][1], this.strip[i][j - 1].tVertex[3][1]));
                    } else {
                        f5 = Math.min(Math.min(this.strip[i][j - 1].tVertex[6 + this.strip[i][j - 1].I[1] * 4][0], this.strip[i][j - 1].tVertex[4 + this.strip[i][j - 1].I[1] * 4][0]), Math.min(this.strip[i][j - 1].tVertex[5 + this.strip[i][j - 1].I[1] * 4][0], this.strip[i][j - 1].tVertex[7 + this.strip[i][j - 1].I[1] * 4][0]));
                        f4 = Math.max(Math.max(this.strip[i][j - 1].tVertex[6 + this.strip[i][j - 1].I[1] * 4][0], this.strip[i][j - 1].tVertex[4 + this.strip[i][j - 1].I[1] * 4][0]), Math.max(this.strip[i][j - 1].tVertex[5 + this.strip[i][j - 1].I[1] * 4][0], this.strip[i][j - 1].tVertex[7 + this.strip[i][j - 1].I[1] * 4][0]));
                        f3 = Math.min(Math.min(this.strip[i][j - 1].tVertex[6 + this.strip[i][j - 1].I[1] * 4][1], this.strip[i][j - 1].tVertex[4 + this.strip[i][j - 1].I[1] * 4][1]), Math.min(this.strip[i][j - 1].tVertex[5 + this.strip[i][j - 1].I[1] * 4][1], this.strip[i][j - 1].tVertex[7 + this.strip[i][j - 1].I[1] * 4][1]));
                        f2 = Math.max(Math.max(this.strip[i][j - 1].tVertex[6 + this.strip[i][j - 1].I[1] * 4][1], this.strip[i][j - 1].tVertex[4 + this.strip[i][j - 1].I[1] * 4][1]), Math.max(this.strip[i][j - 1].tVertex[5 + this.strip[i][j - 1].I[1] * 4][1], this.strip[i][j - 1].tVertex[7 + this.strip[i][j - 1].I[1] * 4][1]));
                    }
                }
                ((GeneralPath)shapeArray[i][j]).moveTo(f5 - f, f2 + f);
                ((GeneralPath)shapeArray[i][j]).lineTo(f4 + f, f2 + f);
                ((GeneralPath)shapeArray[i][j]).lineTo(f4 + f, f3 - f);
                ((GeneralPath)shapeArray[i][j]).lineTo(f5 - f, f3 - f);
                ((GeneralPath)shapeArray[i][j]).lineTo(f5 - f, f2 + f);
            }
        }
        return shapeArray;
    }

    @Override
    public void locate() {
    }

    public boolean contains(int n, int n2) {
        return false;
    }

    @Override
    public int searchSeries(int n, int n2) {
        return 0;
    }

    @Override
    public int[] searchLinkInfo(int n, int n2) {
        if (this.draw1 < 1) {
            return null;
        }
        float f = 5.0f;
        int[] nArray = null;
        block3: for (int i = 0; i < this.draw2; ++i) {
            for (int j = 0; j < this.draw1 - 1; ++j) {
                if (this.strip[i][j] == null) continue;
                try {
                    float f2;
                    float f3;
                    float f4;
                    float f5;
                    if (j == this.draw1 - 2) {
                        if (this.getChartLink[i][j]) {
                            f5 = Math.min(Math.min(this.strip[i][j].tVertex[0][0], this.strip[i][j].tVertex[2][0]), Math.min(this.strip[i][j].tVertex[1][0], this.strip[i][j].tVertex[3][0]));
                            f4 = Math.max(Math.max(this.strip[i][j].tVertex[0][0], this.strip[i][j].tVertex[2][0]), Math.max(this.strip[i][j].tVertex[1][0], this.strip[i][j].tVertex[3][0]));
                            f3 = Math.min(Math.min(this.strip[i][j].tVertex[0][1], this.strip[i][j].tVertex[2][1]), Math.min(this.strip[i][j].tVertex[1][1], this.strip[i][j].tVertex[3][1]));
                            f2 = Math.max(Math.max(this.strip[i][j].tVertex[0][1], this.strip[i][j].tVertex[2][1]), Math.max(this.strip[i][j].tVertex[1][1], this.strip[i][j].tVertex[3][1]));
                        } else {
                            f5 = Math.min(Math.min(this.strip[i][j].tVertex[6 + this.strip[i][j].I[1] * 4][0], this.strip[i][j].tVertex[4 + this.strip[i][j].I[1] * 4][0]), Math.min(this.strip[i][j].tVertex[5 + this.strip[i][j].I[1] * 4][0], this.strip[i][j].tVertex[7 + this.strip[i][j].I[1] * 4][0]));
                            f4 = Math.max(Math.max(this.strip[i][j].tVertex[6 + this.strip[i][j].I[1] * 4][0], this.strip[i][j].tVertex[4 + this.strip[i][j].I[1] * 4][0]), Math.max(this.strip[i][j].tVertex[5 + this.strip[i][j].I[1] * 4][0], this.strip[i][j].tVertex[7 + this.strip[i][j].I[1] * 4][0]));
                            f3 = Math.min(Math.min(this.strip[i][j].tVertex[6 + this.strip[i][j].I[1] * 4][1], this.strip[i][j].tVertex[4 + this.strip[i][j].I[1] * 4][1]), Math.min(this.strip[i][j].tVertex[5 + this.strip[i][j].I[1] * 4][1], this.strip[i][j].tVertex[7 + this.strip[i][j].I[1] * 4][1]));
                            f2 = Math.max(Math.max(this.strip[i][j].tVertex[6 + this.strip[i][j].I[1] * 4][1], this.strip[i][j].tVertex[4 + this.strip[i][j].I[1] * 4][1]), Math.max(this.strip[i][j].tVertex[5 + this.strip[i][j].I[1] * 4][1], this.strip[i][j].tVertex[7 + this.strip[i][j].I[1] * 4][1]));
                        }
                        if ((float)n >= f5 - f && (float)n <= f4 + f && (float)n2 <= f2 + f && (float)n2 >= f3 - f) {
                            ChartShowValueCondition chartShowValueCondition = this.dataset.getCondition(i, j + 1);
                            if (chartShowValueCondition != null && chartShowValueCondition.getChartLink() != null) {
                                nArray = ((ChartDataUsedInfo)((List)chartShowValueCondition.getChartLink().get(i)).get(j + 1)).getChartLinkInfo();
                            }
                            return nArray;
                        }
                    }
                    if (this.getChartLink[i][j]) {
                        f5 = Math.min(Math.min(this.strip[i][j].tVertex[4 + this.strip[i][j].I[1] * 4][0], this.strip[i][j].tVertex[6 + this.strip[i][j].I[1] * 4][0]), Math.min(this.strip[i][j].tVertex[5 + this.strip[i][j].I[1] * 4][0], this.strip[i][j].tVertex[7 + this.strip[i][j].I[1] * 4][0]));
                        f4 = Math.max(Math.max(this.strip[i][j].tVertex[4 + this.strip[i][j].I[1] * 4][0], this.strip[i][j].tVertex[6 + this.strip[i][j].I[1] * 4][0]), Math.max(this.strip[i][j].tVertex[5 + this.strip[i][j].I[1] * 4][0], this.strip[i][j].tVertex[7 + this.strip[i][j].I[1] * 4][0]));
                        f3 = Math.min(Math.min(this.strip[i][j].tVertex[4 + this.strip[i][j].I[1] * 4][1], this.strip[i][j].tVertex[6 + this.strip[i][j].I[1] * 4][1]), Math.min(this.strip[i][j].tVertex[5 + this.strip[i][j].I[1] * 4][1], this.strip[i][j].tVertex[7 + this.strip[i][j].I[1] * 4][1]));
                        f2 = Math.max(Math.max(this.strip[i][j].tVertex[4 + this.strip[i][j].I[1] * 4][1], this.strip[i][j].tVertex[6 + this.strip[i][j].I[1] * 4][1]), Math.max(this.strip[i][j].tVertex[5 + this.strip[i][j].I[1] * 4][1], this.strip[i][j].tVertex[7 + this.strip[i][j].I[1] * 4][1]));
                    } else {
                        f5 = Math.min(Math.min(this.strip[i][j].tVertex[1][0], this.strip[i][j].tVertex[3][0]), Math.min(this.strip[i][j].tVertex[2][0], this.strip[i][j].tVertex[0][0]));
                        f4 = Math.max(Math.max(this.strip[i][j].tVertex[1][0], this.strip[i][j].tVertex[3][0]), Math.max(this.strip[i][j].tVertex[2][0], this.strip[i][j].tVertex[0][0]));
                        f3 = Math.min(Math.min(this.strip[i][j].tVertex[1][1], this.strip[i][j].tVertex[3][1]), Math.min(this.strip[i][j].tVertex[2][1], this.strip[i][j].tVertex[0][1]));
                        f2 = Math.max(Math.max(this.strip[i][j].tVertex[1][1], this.strip[i][j].tVertex[3][1]), Math.max(this.strip[i][j].tVertex[2][1], this.strip[i][j].tVertex[0][1]));
                    }
                    if (!((float)n >= f5 - f) || !((float)n <= f4 + f) || !((float)n2 <= f2 + f) || !((float)n2 >= f3 - f)) continue;
                    ChartShowValueCondition chartShowValueCondition = this.dataset.getCondition(i, j);
                    if (chartShowValueCondition != null && chartShowValueCondition.getChartLink() != null) {
                        nArray = ((ChartDataUsedInfo)((List)chartShowValueCondition.getChartLink().get(i)).get(j)).getChartLinkInfo();
                    }
                    return nArray;
                }
                catch (JRInterruptedException jRInterruptedException) {
                    throw jRInterruptedException;
                }
                catch (Exception exception) {
                    continue block3;
                }
            }
        }
        return null;
    }
}

