/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.ChartWall;
import chart.GridLine;
import chart.axis.ChartAxis;
import chart.axis.ChartCategoryAxis;
import chart.axis.ChartNumericAxis;
import chart.chart2d.Chart2DMatrix;
import chart.chart2d.Chart2DPaper;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartPenStyle;
import chart.properties.ChartWallProperties;
import chart.util.ChartRenderTools;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Chart2DLayer {
    public static final int AXIS_X_POSITION_YORIGIN = 0;
    public static final int AXIS_X_POSITION_YMIN = 1;
    public static final int AXIS_X_POSITION_YMAX = 2;
    public static final int AXIS_Y_POSITION_XORIGIN = 0;
    public static final int AXIS_Y_POSITION_XMIN = 1;
    public static final int AXIS_Y_POSITION_XMAX = 2;
    protected ChartAxis axisX;
    protected ChartAxis axisY;
    private Rectangle2D.Float SEDU;
    private Rectangle2D.Float append;
    private float availableValue;
    private float bench1;
    protected Chart2DMatrix m2;
    private Chart2DMatrix bench2;
    private float boundFill;
    private float closePath;
    private int contains;
    private int cos;
    private float[][] custommerConstant;
    protected float[][] axisXPos;
    protected float[][] axisYPos;
    private float[][] draw;
    protected float[][] yTickPos;
    private float[][] drawLine;
    private float[][] fill;
    private float[][] formatMinorTickMark;
    protected float[][] tYTickPos;
    private float[][] getAutoOritention;
    private float[][] getAxisPosition;
    private float[][] getBorder;
    private float[][] getGraphProperties;
    private float[][] getGridPen;
    private float getGridXAreaPath;
    private float getGridYAreaPath;
    private float getLabelStartValue;
    private float getLabelTextStyle;
    private float[][] getLabelUnit;
    protected float[][] tYPos;
    private boolean getLabels;
    private int getMax;
    private Chart2DPaper getMin;
    private boolean getMinorTickMarkType;
    private Line2D[] getNumOfTick;
    protected Line2D[] gridYPath;
    protected GeneralPath gridXAreaPath;
    protected GeneralPath gridYAreaPath;
    private boolean getPattern1 = false;
    private int getPattern2;
    float I;
    float Z;
    private boolean getProperties;
    private float[][] getThresholdFillTransparency;
    private float[][] getThresholdLineColor;
    GeneralPath getThresholdLineColor2 = new GeneralPath();
    private int getThresholdLineStyle;
    private boolean getThresholdValue;

    Chart2DLayer(Chart2DPaper chart2DPaper) {
        this.getMin = chart2DPaper;
        this.bench2 = new Chart2DMatrix();
        this.m2 = new Chart2DMatrix();
        this.boundFill = 0.0f;
        this.closePath = 0.0f;
    }

    public void init() {
        this.getLabels = this.getPattern1 && this.getMax > 0;
        this.I = (float)((double)this.getMax * Math.cos(Math.PI / 180 * (double)this.getPattern2));
        this.Z = (float)((double)this.getMax * Math.sin(Math.PI / 180 * (double)this.getPattern2));
        this.I = this.I < 0.0f ? 0.0f : this.I;
        this.Z = this.Z < 0.0f ? 0.0f : this.Z;
        this.getProperties = false;
        this.gridXAreaPath = new GeneralPath();
        this.gridYAreaPath = new GeneralPath();
        this.getGridYAreaPath = (float)((ChartNumericAxis)this.axisY).getMin();
        this.getGridXAreaPath = (float)((ChartNumericAxis)this.axisY).getMax();
        if (this.axisX instanceof ChartNumericAxis) {
            this.getLabelTextStyle = (float)((ChartNumericAxis)this.axisX).getMin();
            this.getLabelStartValue = (float)((ChartNumericAxis)this.axisX).getMax();
        }
    }

    private void SEDU() {
        if (this.axisX != null) {
            this.boundFill = this.axisX.getZeroPosition(this.SEDU.width);
        }
        if (this.axisY != null) {
            this.closePath = this.axisY.getZeroPosition(this.SEDU.height);
        }
    }

    public boolean getAutoOritention(boolean bl) {
        boolean bl2;
        if (bl) {
            boolean bl3;
            int n = this.axisX.getAxisPosition();
            boolean bl4 = bl3 = n != 2 && n != 4;
            if (bl3) {
                float f = this.axisX.getLabelUnit(this.append.width);
                return this.axisX.getAutoOritention(f);
            }
            float f = this.axisX.getLabelUnit(this.append.height);
            return this.axisX.getYAutoOritention(f);
        }
        int n = this.axisY.getAxisPosition();
        boolean bl5 = bl2 = n != 2 && n != 4;
        if (bl2) {
            float f = this.axisY.getLabelUnit(this.append.width);
            return this.axisY.getAutoOritention(f);
        }
        float f = this.axisY.getLabelUnit(this.append.height);
        return this.axisY.getYAutoOritention(f);
    }

    void locate() {
        this.getLabels = this.getPattern1 && this.getMax > 0;
        this.I = (float)((double)this.getMax * Math.cos(Math.PI / 180 * (double)this.getPattern2));
        this.Z = (float)((double)this.getMax * Math.sin(Math.PI / 180 * (double)this.getPattern2));
        this.I = this.I < 0.0f ? 0.0f : this.I;
        float f = this.Z = this.Z < 0.0f ? 0.0f : this.Z;
        if (this.axisX != null && this.axisY != null) {
            this.axisXPos = new float[2][2];
            this.axisYPos = new float[2][2];
            float f2 = this.axisX.getUnit(this.SEDU.width);
            float f3 = this.axisY.getUnit(this.SEDU.height);
            if (!this.getMinorTickMarkType) {
                if (this.axisX.getProperties().isBestEffort() || this.axisX.getProperties().getLabelTextStyle().getWordWrapper()) {
                    this.axisX.setUnitWidth((int)(f2 * this.m2.I));
                }
            } else {
                this.axisX.setUnitWidth(60);
            }
            if (this.axisX instanceof ChartNumericAxis) {
                this.axisXPos[0][0] = this.getLabelTextStyle * f2;
                this.axisXPos[1][0] = this.getLabelStartValue * f2;
            } else {
                this.axisXPos[0][0] = 0.0f;
                this.axisXPos[1][0] = this.SEDU.width;
            }
            float f4 = 0.0f;
            float f5 = 0.0f;
            switch (this.contains) {
                case 0: {
                    if (this.getGridYAreaPath > 0.0f) {
                        f4 = this.getGridYAreaPath * f3;
                        break;
                    }
                    f4 = 0.0f;
                    break;
                }
                case 1: {
                    f4 = this.getGridYAreaPath * f3;
                    break;
                }
                case 2: {
                    f4 = this.getGridXAreaPath * f3;
                }
            }
            this.axisXPos[0][1] = f4;
            this.axisXPos[1][1] = f4;
            this.axisYPos[0][1] = this.getGridYAreaPath * f3;
            this.axisYPos[1][1] = this.getGridXAreaPath * f3;
            switch (this.cos) {
                case 0: {
                    if (this.axisX instanceof ChartNumericAxis && this.getLabelTextStyle > 0.0f) {
                        f5 = this.getLabelTextStyle * f2;
                        break;
                    }
                    f5 = 0.0f;
                    break;
                }
                case 1: {
                    f5 = this.axisXPos[0][0];
                    break;
                }
                case 2: {
                    f5 = this.axisXPos[1][0];
                }
            }
            this.axisYPos[0][0] = f5;
            this.axisYPos[1][0] = f5;
            this.getLabelUnit = new float[this.axisXPos.length][2];
            this.tYPos = new float[this.axisYPos.length][2];
            this.m2.transform(this.axisXPos, this.getLabelUnit);
            this.m2.transform(this.axisYPos, this.tYPos);
            this.setAxisX(f2, f4);
            this.setAxisY(f3, f5);
            this.fill = new float[this.draw.length][2];
            this.formatMinorTickMark = new float[this.drawLine.length][2];
            this.tYTickPos = new float[this.yTickPos.length][2];
            this.m2.transform(this.draw, this.fill);
            this.m2.transform(this.drawLine, this.formatMinorTickMark);
            this.m2.transform(this.yTickPos, this.tYTickPos);
            if (this.getLabels) {
                int n;
                this.getGraphProperties = new float[this.axisXPos.length][2];
                this.getGridPen = new float[this.axisYPos.length][2];
                this.getAutoOritention = new float[this.draw.length][2];
                this.getAxisPosition = new float[this.drawLine.length][2];
                this.getBorder = new float[this.yTickPos.length][2];
                for (n = 0; n < this.getLabelUnit.length; ++n) {
                    this.getGraphProperties[n][0] = this.getLabelUnit[n][0] - this.I;
                    this.getGraphProperties[n][1] = this.getLabelUnit[n][1] + this.Z;
                }
                for (n = 0; n < this.fill.length; ++n) {
                    this.getAutoOritention[n][0] = this.fill[n][0] - this.I;
                    this.getAutoOritention[n][1] = this.fill[n][1] + this.Z;
                }
                for (n = 0; n < this.formatMinorTickMark.length; ++n) {
                    this.getAxisPosition[n][0] = this.formatMinorTickMark[n][0] - this.I;
                    this.getAxisPosition[n][1] = this.formatMinorTickMark[n][1] + this.Z;
                }
                for (n = 0; n < this.tYPos.length; ++n) {
                    this.getGridPen[n][0] = this.tYPos[n][0] - this.I;
                    this.getGridPen[n][1] = this.tYPos[n][1] + this.Z;
                }
                for (n = 0; n < this.tYTickPos.length; ++n) {
                    this.getBorder[n][0] = this.tYTickPos[n][0] - this.I;
                    this.getBorder[n][1] = this.tYTickPos[n][1] + this.Z;
                }
            }
            this.append(this.axisXPos[0][0], this.axisXPos[1][0], this.axisYPos[0][1], this.axisYPos[1][1]);
            this.availableValue();
        }
    }

    public void resetDepthPos(float f, float f2) {
        int n;
        this.getGridPen = new float[this.axisYPos.length][2];
        this.getBorder = new float[this.yTickPos.length][2];
        for (n = 0; n < this.tYPos.length; ++n) {
            this.getGridPen[n][0] = this.tYPos[n][0] - f;
            this.getGridPen[n][1] = this.tYPos[n][1] + f2;
        }
        for (n = 0; n < this.tYTickPos.length; ++n) {
            this.getBorder[n][0] = this.tYTickPos[n][0] - f;
            this.getBorder[n][1] = this.tYTickPos[n][1] + f2;
        }
    }

    public float availableValue(float f) {
        f = f < this.getGridXAreaPath ? f : this.getGridXAreaPath;
        f = f > this.getGridYAreaPath ? f : this.getGridYAreaPath;
        return f;
    }

    public float availableValueX(float f) {
        f = f < this.getLabelStartValue ? f : this.getLabelStartValue;
        f = f > this.getLabelTextStyle ? f : this.getLabelTextStyle;
        return f;
    }

    public float getXLength() {
        return this.SEDU.width;
    }

    public float getYLength() {
        return this.SEDU.height;
    }

    protected float getXUnit(float f) {
        return this.axisX == null ? this.SEDU.width : this.axisX.getUnit(this.SEDU.width);
    }

    float I() {
        return this.axisX == null ? this.SEDU.width : this.axisX.getUnit(this.SEDU.width);
    }

    float Z() {
        return this.axisY == null ? this.SEDU.height : this.axisY.getUnit(this.SEDU.height);
    }

    void I(int n) {
        this.contains = n;
    }

    void Z(int n) {
        this.cos = n;
    }

    void I(Rectangle rectangle, Rectangle rectangle2, float f, float f2) {
        this.SEDU = new Rectangle2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.append = new Rectangle2D.Float(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        this.availableValue = f;
        this.bench1 = f2;
    }

    void I(float[][] fArray2, float[][] fArray3) {
        this.m2.transform(fArray2, fArray3);
    }

    public void transformNormal() {
        float f = this.SEDU.width / 2.0f;
        float f2 = this.SEDU.height / 2.0f;
        float f3 = this.append.width / this.SEDU.width;
        float f4 = this.append.height / this.SEDU.height;
        float f5 = f3 * this.availableValue;
        float f6 = f4 * this.bench1;
        float f7 = this.append.x + this.append.width / 2.0f;
        float f8 = this.append.y + this.append.height / 2.0f;
        this.SEDU();
        this.bench2.unit();
        this.m2.unit();
        this.m2.shift(-f, -f2);
        this.m2.scale(f5, f6);
        this.bench2.xmirror();
        this.bench2.shift(f7, f8);
        this.m2.mul(this.bench2);
        this.m2.shift(this.boundFill * f5, -this.closePath * f6);
        this.getMinorTickMarkType = false;
    }

    public void transformBench0() {
        float f = this.SEDU.width / 2.0f;
        float f2 = this.SEDU.height / 2.0f;
        float f3 = this.append.height / this.SEDU.width;
        float f4 = this.append.width / this.SEDU.height;
        float f5 = f3 * this.bench1;
        float f6 = f4 * this.availableValue;
        float f7 = this.append.x + this.append.width / 2.0f;
        float f8 = this.append.y + this.append.height / 2.0f;
        this.SEDU();
        this.bench2.unit();
        this.m2.unit();
        this.m2.shift(-f, -f2);
        this.m2.scale(f5, f6);
        this.bench2.bench1();
        this.m2.mul(this.bench2);
        this.m2.shift(f7, f8);
        this.m2.shift(this.closePath * f6, this.boundFill * f5);
        this.getMinorTickMarkType = true;
    }

    public void transformBench1() {
        float f = this.SEDU.width / 2.0f;
        float f2 = this.SEDU.height / 2.0f;
        float f3 = this.append.height / this.SEDU.width;
        float f4 = this.append.width / this.SEDU.height;
        float f5 = f3 * this.bench1;
        float f6 = f4 * this.availableValue;
        float f7 = this.append.x + this.append.width / 2.0f;
        float f8 = this.append.y + this.append.height / 2.0f;
        this.SEDU();
        this.bench2.unit();
        this.m2.unit();
        this.m2.shift(-f, -f2);
        this.m2.scale(f5, f6);
        this.bench2.bench1();
        this.m2.mul(this.bench2);
        this.bench2.xmirror();
        this.m2.mul(this.bench2);
        this.m2.shift(f7, f8);
        this.m2.shift(this.closePath * f6, -this.boundFill * f5);
        this.getMinorTickMarkType = true;
    }

    public void transformRadar() {
        float f = this.append.width / 2.0f;
        float f2 = this.append.height / 2.0f;
        float f3 = this.append.x + this.append.width / 2.0f;
        float f4 = this.append.y + this.append.height / 2.0f;
        this.bench2.unit();
        this.m2.unit();
        this.m2.shift(-f, -f2);
        this.m2.scale(this.availableValue, this.bench1);
        this.bench2.xmirror();
        this.bench2.shift(f3, f4);
        this.m2.mul(this.bench2);
        this.m2.shift(this.boundFill * this.availableValue, -this.closePath * this.bench1);
        this.getMinorTickMarkType = false;
    }

    public void transformBench2() {
        float f = this.SEDU.width / 2.0f;
        float f2 = this.SEDU.height / 2.0f;
        float f3 = this.append.height / this.SEDU.width;
        float f4 = this.append.width / this.SEDU.height;
        float f5 = f3 * this.bench1;
        float f6 = f4 * this.availableValue;
        float f7 = this.append.x + this.append.width / 2.0f;
        float f8 = this.append.y + this.append.height / 2.0f;
        this.SEDU();
        this.bench2.unit();
        this.m2.unit();
        this.m2.shift(-f, -f2);
        this.m2.scale(f5, f6);
        this.bench2.bench2();
        this.m2.mul(this.bench2);
        this.bench2.xmirror();
        this.m2.mul(this.bench2);
        this.m2.shift(f7, f8);
        this.m2.shift(-this.closePath * f6, this.boundFill * f5);
        this.getMinorTickMarkType = true;
    }

    public ChartAxis getAxisX() {
        return this.axisX;
    }

    public void setAxisX(ChartAxis chartAxis) {
        this.axisX = chartAxis;
    }

    public ChartAxis getAxisY() {
        return this.axisY;
    }

    public void setAxisY(ChartAxis chartAxis) {
        this.axisY = chartAxis;
    }

    protected void setAxisX(float f, float f2) {
        float f3 = f;
        if (this.axisX instanceof ChartNumericAxis) {
            ChartNumericAxis chartNumericAxis = (ChartNumericAxis)this.axisX;
            String[] stringArray = chartNumericAxis.getLabels();
            this.draw = new float[stringArray.length][2];
            float f4 = (float)chartNumericAxis.getTickPace() * f3;
            float f5 = (float)chartNumericAxis.getLabelStartValue() * f3;
            int n = chartNumericAxis.getNumOfTick();
            float f6 = f5;
            for (int i = 0; i <= n; ++i) {
                this.draw[i][0] = f6;
                this.draw[i][1] = f2;
                f6 += f4;
            }
            this.drawLine = this.draw;
        } else if (this.axisX instanceof ChartCategoryAxis && this.axisX.custommerConstant() && ((ChartCategoryAxis)this.axisX).isScroll()) {
            ChartCategoryAxis chartCategoryAxis = (ChartCategoryAxis)this.axisX;
            double[] dArray = chartCategoryAxis.tickmarkValue;
            if (dArray != null && dArray.length > 0) {
                float f7 = 0.0f;
                this.draw = new float[dArray.length][2];
                for (int i = 0; i < dArray.length; ++i) {
                    this.draw[i][0] = (float)((double)f7 + dArray[i] * (double)f3);
                    this.draw[i][1] = f2;
                }
                this.drawLine = this.draw;
            } else {
                this.draw = new float[1][2];
                this.draw[0][0] = 0.0f;
                this.draw[0][1] = f2;
                this.drawLine = this.draw;
            }
        } else {
            ChartCategoryAxis chartCategoryAxis;
            String[] stringArray;
            int n;
            if (this.axisX.getTickSkipNum() >= 1) {
                f3 *= (float)(this.axisX.getTickSkipNum() + 1);
            }
            int n2 = n = (n = (stringArray = (chartCategoryAxis = (ChartCategoryAxis)this.axisX).getLabels()).length) < 1 ? 1 : n;
            if (chartCategoryAxis.isLineUnit()) {
                this.draw = new float[n][2];
                float f8 = 0.0f;
                for (int i = 0; i < this.draw.length; ++i) {
                    this.draw[i][0] = f8;
                    this.draw[i][1] = f2;
                    f8 += f3;
                }
                this.drawLine = this.draw;
            } else {
                int n3;
                this.draw = ((ChartCategoryAxis)this.axisX).showLastTickmark() ? new float[n + 1][2] : new float[n][2];
                float f9 = 0.0f;
                for (n3 = 0; n3 < this.draw.length; ++n3) {
                    this.draw[n3][0] = f9;
                    this.draw[n3][1] = f2;
                    f9 += f3;
                }
                this.drawLine = new float[n][2];
                f9 = f3 / 2.0f;
                n3 = this.axisX.getTickSkipNum();
                if (n3 >= 1) {
                    f9 /= (float)(n3 + 1);
                }
                for (int i = 0; i < this.drawLine.length; ++i) {
                    this.drawLine[i][0] = f9;
                    this.drawLine[i][1] = f2;
                    f9 += f3;
                }
            }
        }
    }

    protected void setAxisY(float f, float f2) {
        ChartNumericAxis chartNumericAxis = (ChartNumericAxis)this.axisY;
        String[] stringArray = chartNumericAxis.getLabels();
        this.yTickPos = new float[stringArray.length][2];
        float f3 = (float)chartNumericAxis.getTickPace() * f;
        float f4 = (float)chartNumericAxis.getLabelStartValue() * f;
        int n = chartNumericAxis.getNumOfTick();
        float f5 = f4;
        for (int i = 0; i <= n; ++i) {
            this.yTickPos[i][0] = f2;
            this.yTickPos[i][1] = f5;
            f5 += f3;
        }
    }

    private void append(float f, float f2, float f3, float f4) {
        float[][] fArray2 = new float[4][2];
        fArray2[0][0] = f;
        fArray2[0][1] = f3;
        fArray2[1][0] = f2;
        fArray2[1][1] = f3;
        fArray2[2][0] = f2;
        fArray2[2][1] = f4;
        fArray2[3][0] = f;
        fArray2[3][1] = f4;
        this.custommerConstant = new float[4][2];
        this.m2.transform(fArray2, this.custommerConstant);
    }

    private void availableValue() {
        if (this.getMin.getProperties().getGraphProperties().isShowThresholdLine() || this.getMin.getProperties().getGraphProperties().isShowThresholdLine2()) {
            float[][] fArray2 = new float[4][2];
            fArray2[0][0] = 0.0f;
            fArray2[0][1] = this.availableValue((float)this.getMin.getProperties().getGraphProperties().getThresholdValue()) * this.Z();
            fArray2[1][0] = this.SEDU.width;
            fArray2[1][1] = fArray2[0][1];
            fArray2[2][0] = this.SEDU.width;
            fArray2[2][1] = this.axisYPos[1][1];
            fArray2[3][0] = 0.0f;
            fArray2[3][1] = this.axisYPos[1][1];
            float[][] fArray3 = new float[4][2];
            fArray3[0][0] = 0.0f;
            fArray3[0][1] = 0.0f;
            fArray3[1][0] = this.SEDU.width;
            fArray3[1][1] = 0.0f;
            fArray3[2][0] = this.SEDU.width;
            fArray3[2][1] = this.availableValue((float)this.getMin.getProperties().getGraphProperties().getThresholdValue2()) * this.Z();
            fArray3[3][0] = 0.0f;
            fArray3[3][1] = fArray3[2][1];
            this.getThresholdFillTransparency = new float[4][2];
            this.getThresholdLineColor = new float[4][2];
            this.m2.transform(fArray2, this.getThresholdFillTransparency);
            this.m2.transform(fArray3, this.getThresholdLineColor);
        }
    }

    public void paintAxis(Graphics2D graphics2D) {
        if (this.axisX != null && this.axisX.isShow()) {
            if (this.getLabels) {
                this.axisX.setAxisPoint(this.getGraphProperties);
                this.axisX.setMajorTickMarkPoint(this.getAutoOritention);
                if (this.axisX.getProperties().getMinorTickMarkType() != 0) {
                    this.axisX.setMinorTickMarkPoint(ChartRenderTools.formatMinorTickMark(this.getAutoOritention, this.getGraphProperties, this.axisX.getUnit(this.SEDU.width) / 2.0f));
                }
                this.axisX.setLabelPoint(this.getAxisPosition);
            } else {
                this.axisX.setAxisPoint(this.getLabelUnit);
                this.axisX.setMajorTickMarkPoint(this.fill);
                if (this.axisX.getProperties().getMinorTickMarkType() != 0) {
                    this.axisX.setMinorTickMarkPoint(ChartRenderTools.formatMinorTickMark(this.fill, this.getLabelUnit, this.axisX.getUnit(this.SEDU.width) / 2.0f));
                }
                this.axisX.setLabelPoint(this.formatMinorTickMark);
            }
            this.axisX.paint(graphics2D);
        }
        if (this.axisY != null && this.axisY.isShow() && this.tYTickPos != null && this.tYTickPos.length > 0) {
            if (this.getLabels) {
                this.axisY.setAxisPoint(this.getGridPen);
                this.axisY.setMajorTickMarkPoint(this.getBorder);
                this.axisY.setMinorTickMarkPoint(ChartRenderTools.formatMinorTickMark(this.getBorder, this.getGridPen, this.axisY.getUnit(this.SEDU.height) / 2.0f));
                this.axisY.setLabelPoint(this.getBorder);
            } else {
                this.axisY.setAxisPoint(this.tYPos);
                this.axisY.setMajorTickMarkPoint(this.tYTickPos);
                this.axisY.setMinorTickMarkPoint(ChartRenderTools.formatMinorTickMark(this.tYTickPos, this.tYPos, this.axisY.getUnit(this.SEDU.height) / 2.0f));
                this.axisY.setLabelPoint(this.tYTickPos);
            }
            this.axisY.paint(graphics2D);
        }
    }

    public void paintGrid(Graphics2D graphics2D) {
        int n;
        GridLine gridLine = new GridLine();
        float[][] fArray2 = new float[2][2];
        if (this.axisX != null && this.axisX.getProperties().isShowGrid()) {
            gridLine.setPenStyle(this.axisX.getProperties().getGridPen());
            this.getNumOfTick = new Line2D[this.fill.length];
            this.gridXAreaPath.reset();
            for (n = 0; n < this.fill.length; ++n) {
                if (!this.getMinorTickMarkType) {
                    fArray2[0][0] = this.fill[n][0];
                    fArray2[0][1] = this.custommerConstant[0][1];
                    fArray2[1][0] = this.fill[n][0];
                    fArray2[1][1] = this.custommerConstant[2][1];
                } else {
                    fArray2[0][0] = this.custommerConstant[0][0];
                    fArray2[0][1] = this.fill[n][1];
                    fArray2[1][0] = this.custommerConstant[2][0];
                    fArray2[1][1] = this.fill[n][1];
                }
                this.getNumOfTick[n] = new Line2D.Float();
                this.getNumOfTick[n].setLine(fArray2[0][0], fArray2[0][1], fArray2[1][0], fArray2[1][1]);
                gridLine.setLocation(fArray2);
                gridLine.draw(graphics2D);
            }
            if (this.getLabels) {
                for (n = 0; n < this.getAutoOritention.length; ++n) {
                    fArray2[0][0] = this.getAutoOritention[n][0];
                    fArray2[0][1] = this.getAutoOritention[n][1];
                    fArray2[1][0] = this.getAutoOritention[n][0] + this.I;
                    fArray2[1][1] = this.getAutoOritention[n][1] - this.Z;
                    this.getNumOfTick[n].setLine(fArray2[0][0], fArray2[0][1], fArray2[1][0], fArray2[1][1]);
                    gridLine.setLocation(fArray2);
                    gridLine.draw(graphics2D);
                }
            }
            for (n = 0; n < this.getNumOfTick.length; ++n) {
                this.gridXAreaPath.append(this.getNumOfTick[n], false);
            }
        }
        if (this.axisY != null && this.axisY.getProperties().isShowGrid()) {
            gridLine.setPenStyle(this.axisY.getProperties().getGridPen());
            this.gridYAreaPath.reset();
            this.gridYPath = new Line2D[this.tYTickPos.length];
            for (n = 0; n < this.tYTickPos.length; ++n) {
                if (!this.getMinorTickMarkType) {
                    fArray2[0][0] = this.custommerConstant[0][0];
                    fArray2[0][1] = this.tYTickPos[n][1];
                    fArray2[1][0] = this.custommerConstant[1][0];
                    fArray2[1][1] = this.tYTickPos[n][1];
                } else {
                    fArray2[0][0] = this.tYTickPos[n][0];
                    fArray2[0][1] = this.custommerConstant[0][1];
                    fArray2[1][0] = this.tYTickPos[n][0];
                    fArray2[1][1] = this.custommerConstant[2][1];
                }
                this.gridYPath[n] = new Line2D.Float();
                this.gridYPath[n].setLine(fArray2[0][0], fArray2[0][1], fArray2[1][0], fArray2[1][1]);
                gridLine.setLocation(fArray2);
                gridLine.draw(graphics2D);
            }
            if (this.getLabels) {
                if (this.getProperties && this.getMinorTickMarkType) {
                    for (n = 0; n < this.tYTickPos.length; ++n) {
                        fArray2[0][0] = this.tYTickPos[n][0];
                        fArray2[0][1] = this.tYTickPos[n][1];
                        fArray2[1][0] = this.tYTickPos[n][0];
                        fArray2[1][1] = this.tYTickPos[n][1];
                        gridLine.setLocation(fArray2);
                        gridLine.draw(graphics2D);
                    }
                } else {
                    for (n = 0; n < this.tYTickPos.length; ++n) {
                        fArray2[0][0] = this.tYTickPos[n][0];
                        fArray2[0][1] = this.tYTickPos[n][1];
                        fArray2[1][0] = this.tYTickPos[n][0] - this.I;
                        fArray2[1][1] = this.tYTickPos[n][1] + this.Z;
                        gridLine.setLocation(fArray2);
                        gridLine.draw(graphics2D);
                    }
                }
            }
            for (n = 0; n < this.gridYPath.length; ++n) {
                this.gridYAreaPath.append(this.gridYPath[n], false);
            }
        }
    }

    public int getDepth() {
        return this.getMax;
    }

    public void setDepth(int n) {
        this.getMax = n;
    }

    public void setDepthDirection(int n) {
        this.getPattern2 = n;
    }

    public boolean isDepth() {
        return this.getLabels;
    }

    public boolean searchGridX(int n, int n2) {
        if (this.getNumOfTick != null && this.axisX.getProperties().isShowGrid()) {
            return this.getGridXAreaPath().intersects(n - 5, n2 - 5, 10.0, 10.0);
        }
        return false;
    }

    public boolean searchGridY(int n, int n2) {
        if (this.gridYPath != null && this.axisY.getProperties().isShowGrid()) {
            return this.getGridYAreaPath().intersects(n - 5, n2 - 5, 10.0, 10.0);
        }
        return false;
    }

    public String searchAxisXLabel(int n, int n2) {
        return this.axisX.searchAxisLabel(n, n2);
    }

    public String searchAxisYLabel(int n, int n2) {
        return this.axisY.searchAxisLabel(n, n2);
    }

    public boolean IsShowAxisXLabelTips() {
        return this.axisX.isShowLabelTips();
    }

    public boolean IsShowAxisYLabelTips() {
        return this.axisY.isShowLabelTips();
    }

    public boolean searchAxisX(int n, int n2) {
        return this.axisX.searchSelectedAxis(n, n2);
    }

    public boolean searchAxisY(int n, int n2) {
        return this.axisY.searchSelectedAxis(n, n2);
    }

    public Shape getGridXAreaPath() {
        return this.gridXAreaPath;
    }

    public Shape getGridYAreaPath() {
        return this.gridYAreaPath;
    }

    public void paintWall(Graphics2D graphics2D, ChartWall chartWall) {
        boolean bl = this.getMin.properties.isShowWall();
        ChartWallProperties chartWallProperties = chartWall.getProperties();
        GeneralPath generalPath = new GeneralPath();
        ChartFillPattern chartFillPattern = chartWallProperties.getPattern1();
        ChartFillPattern chartFillPattern2 = chartWallProperties.getPattern2();
        ChartPenStyle chartPenStyle = chartWallProperties.getBorder();
        if (bl && this.tYTickPos != null && this.tYTickPos.length > 0) {
            Point2D.Float[] floatArray;
            if (this.custommerConstant != null) {
                floatArray = new Point2D.Float[]{new Point2D.Float(this.custommerConstant[0][0], this.custommerConstant[0][1]), new Point2D.Float(this.custommerConstant[1][0], this.custommerConstant[1][1]), new Point2D.Float(this.custommerConstant[2][0], this.custommerConstant[2][1]), new Point2D.Float(this.custommerConstant[3][0], this.custommerConstant[3][1])};
                chartWall.setPoint(floatArray);
                this.getThresholdLineColor2.moveTo(this.custommerConstant[0][0], this.custommerConstant[0][1]);
                this.getThresholdLineColor2.lineTo(this.custommerConstant[1][0], this.custommerConstant[1][1]);
                this.getThresholdLineColor2.lineTo(this.custommerConstant[2][0], this.custommerConstant[2][1]);
                this.getThresholdLineColor2.lineTo(this.custommerConstant[3][0], this.custommerConstant[3][1]);
                this.getThresholdLineColor2.closePath();
                chartWall.setPattern(chartFillPattern);
                chartWall.setPen(chartPenStyle);
                chartWall.draw(graphics2D);
                if (this.getLabels) {
                    generalPath.reset();
                    if (this.getProperties && this.getMinorTickMarkType) {
                        generalPath.moveTo(this.custommerConstant[1][0], this.custommerConstant[1][1]);
                        generalPath.lineTo(this.custommerConstant[1][0] - this.I, this.custommerConstant[1][1] + this.Z);
                        generalPath.lineTo(this.custommerConstant[2][0] - this.I, this.custommerConstant[2][1] + this.Z);
                        generalPath.lineTo(this.custommerConstant[2][0], this.custommerConstant[2][1]);
                    } else {
                        generalPath.moveTo(this.custommerConstant[0][0], this.custommerConstant[0][1]);
                        generalPath.lineTo(this.custommerConstant[0][0] - this.I, this.custommerConstant[0][1] + this.Z);
                        generalPath.lineTo(this.custommerConstant[3][0] - this.I, this.custommerConstant[3][1] + this.Z);
                        generalPath.lineTo(this.custommerConstant[3][0], this.custommerConstant[3][1]);
                    }
                    generalPath.closePath();
                    if (chartFillPattern != null) {
                        chartFillPattern.fill(graphics2D, generalPath);
                    }
                    chartPenStyle.draw(graphics2D, generalPath);
                    generalPath.reset();
                    generalPath.moveTo(this.custommerConstant[0][0], this.custommerConstant[0][1]);
                    generalPath.lineTo(this.custommerConstant[0][0] - this.I, this.custommerConstant[0][1] + this.Z);
                    generalPath.lineTo(this.custommerConstant[1][0] - this.I, this.custommerConstant[1][1] + this.Z);
                    generalPath.lineTo(this.custommerConstant[1][0], this.custommerConstant[1][1]);
                    generalPath.closePath();
                    if (chartFillPattern != null) {
                        chartFillPattern.fill(graphics2D, generalPath);
                    }
                    chartPenStyle.draw(graphics2D, generalPath);
                }
            }
            if (this.custommerConstant != null) {
                floatArray = (Point2D.Float[])new float[4][2];
                Point2D.Float[][] floatArray2 = new Point2D.Float[this.tYTickPos.length - 1][4];
                for (int i = 0; i < this.tYTickPos.length - 1; ++i) {
                    if (!this.getMinorTickMarkType) {
                        floatArray[0][0] = (Point2D.Float)this.custommerConstant[0][0];
                        floatArray[0][1] = (Point2D.Float)this.tYTickPos[i][1];
                        floatArray[1][0] = (Point2D.Float)this.custommerConstant[1][0];
                        floatArray[1][1] = (Point2D.Float)this.tYTickPos[i][1];
                        floatArray[2][0] = (Point2D.Float)this.custommerConstant[0][0];
                        floatArray[2][1] = (Point2D.Float)((this.tYTickPos[i][1] + this.tYTickPos[i + 1][1]) / 2.0f);
                        floatArray[3][0] = (Point2D.Float)this.custommerConstant[1][0];
                        floatArray[3][1] = (Point2D.Float)((this.tYTickPos[i][1] + this.tYTickPos[i + 1][1]) / 2.0f);
                    } else {
                        floatArray[0][0] = (Point2D.Float)this.tYTickPos[i][0];
                        floatArray[0][1] = (Point2D.Float)this.custommerConstant[0][1];
                        floatArray[1][0] = (Point2D.Float)this.tYTickPos[i][0];
                        floatArray[1][1] = (Point2D.Float)this.custommerConstant[2][1];
                        floatArray[2][0] = (Point2D.Float)((this.tYTickPos[i][0] + this.tYTickPos[i + 1][0]) / 2.0f);
                        floatArray[2][1] = (Point2D.Float)this.custommerConstant[0][1];
                        floatArray[3][0] = (Point2D.Float)((this.tYTickPos[i][0] + this.tYTickPos[i + 1][0]) / 2.0f);
                        floatArray[3][1] = (Point2D.Float)this.custommerConstant[2][1];
                    }
                    floatArray2[i][0] = new Point2D.Float((float)floatArray[0][0], (float)floatArray[0][1]);
                    floatArray2[i][1] = new Point2D.Float((float)floatArray[1][0], (float)floatArray[1][1]);
                    floatArray2[i][2] = new Point2D.Float((float)floatArray[3][0], (float)floatArray[3][1]);
                    floatArray2[i][3] = new Point2D.Float((float)floatArray[2][0], (float)floatArray[2][1]);
                }
                chartWall.setPattern(chartFillPattern2);
                chartWall.setBoundFillPoint(floatArray2);
                chartWall.boundFill(graphics2D);
                if (this.getLabels) {
                    float[][] fArray2 = new float[4][2];
                    for (int i = 0; i < this.tYTickPos.length - 1; ++i) {
                        floatArray[0][0] = (Point2D.Float)this.tYTickPos[i][0];
                        floatArray[0][1] = (Point2D.Float)this.tYTickPos[i][1];
                        floatArray[1][0] = (Point2D.Float)(this.tYTickPos[i][0] - this.I);
                        floatArray[1][1] = (Point2D.Float)(this.tYTickPos[i][1] + this.Z);
                        floatArray[2][0] = (Point2D.Float)this.tYTickPos[i + 1][0];
                        floatArray[2][1] = (Point2D.Float)this.tYTickPos[i + 1][1];
                        floatArray[3][0] = (Point2D.Float)(this.tYTickPos[i + 1][0] - this.I);
                        floatArray[3][1] = (Point2D.Float)(this.tYTickPos[i + 1][1] + this.Z);
                        fArray2[0] = (float[])floatArray[0];
                        fArray2[1] = (float[])floatArray[1];
                        fArray2[2][0] = (float)((floatArray[0][0] + floatArray[2][0]) / 2.0f);
                        fArray2[2][1] = (float)((floatArray[0][1] + floatArray[2][1]) / 2.0f);
                        fArray2[3][0] = (float)((floatArray[1][0] + floatArray[3][0]) / 2.0f);
                        fArray2[3][1] = (float)((floatArray[1][1] + floatArray[3][1]) / 2.0f);
                        floatArray2[i][0] = new Point2D.Float(fArray2[0][0], fArray2[0][1]);
                        floatArray2[i][1] = new Point2D.Float(fArray2[1][0], fArray2[1][1]);
                        floatArray2[i][2] = new Point2D.Float(fArray2[3][0], fArray2[3][1]);
                        floatArray2[i][3] = new Point2D.Float(fArray2[2][0], fArray2[2][1]);
                    }
                    chartWall.setPattern(chartFillPattern2);
                    chartWall.setPen(chartPenStyle);
                    chartWall.setBoundFillPoint(floatArray2);
                    chartWall.boundFill(graphics2D);
                    generalPath.reset();
                    generalPath.moveTo(this.custommerConstant[0][0], this.custommerConstant[0][1]);
                    generalPath.lineTo(this.custommerConstant[0][0] - this.I, this.custommerConstant[0][1] + this.Z);
                    generalPath.lineTo(this.custommerConstant[3][0] - this.I, this.custommerConstant[3][1] + this.Z);
                    generalPath.lineTo(this.custommerConstant[3][0], this.custommerConstant[3][1]);
                    generalPath.closePath();
                    chartPenStyle.draw(graphics2D, generalPath);
                }
            }
        }
    }

    public void paintThresholdLine(Graphics2D graphics2D) {
        GeneralPath generalPath = new GeneralPath();
        switch (this.getMin.getProperties().getGraphProperties().getThresholdLineStyle()) {
            case 0: {
                if (this.getMin.getProperties().getGraphProperties().isShowThresholdLine()) {
                    if (this.isDepth()) {
                        generalPath.reset();
                        generalPath.moveTo(this.getThresholdFillTransparency[0][0] - this.I, this.getThresholdFillTransparency[0][1] + this.Z);
                        generalPath.lineTo(this.getThresholdFillTransparency[1][0] - this.I, this.getThresholdFillTransparency[1][1] + this.Z);
                        generalPath.lineTo(this.getThresholdFillTransparency[2][0] - this.I, this.getThresholdFillTransparency[2][1] + this.Z);
                        generalPath.lineTo(this.getThresholdFillTransparency[3][0] - this.I, this.getThresholdFillTransparency[3][1] + this.Z);
                        generalPath.lineTo(this.getThresholdFillTransparency[0][0] - this.I, this.getThresholdFillTransparency[0][1] + this.Z);
                        generalPath.closePath();
                        graphics2D.setColor(ChartColorPattern.transparent(this.getMin.getProperties().getGraphProperties().getThresholdLineColor(), this.getMin.getProperties().getGraphProperties().getThresholdFillTransparency()));
                        if (this.getMin.getProperties().getGraphProperties().isFillThreshold()) {
                            graphics2D.fill(generalPath);
                        }
                        graphics2D.setColor(this.getMin.getProperties().getGraphProperties().getThresholdLineColor());
                        graphics2D.drawLine((int)(this.getThresholdFillTransparency[0][0] - this.I), (int)(this.getThresholdFillTransparency[0][1] + this.Z), (int)(this.getThresholdFillTransparency[1][0] - this.I), (int)(this.getThresholdFillTransparency[1][1] + this.Z));
                    } else {
                        generalPath.reset();
                        generalPath.moveTo(this.getThresholdFillTransparency[0][0], this.getThresholdFillTransparency[0][1]);
                        generalPath.lineTo(this.getThresholdFillTransparency[1][0], this.getThresholdFillTransparency[1][1]);
                        generalPath.lineTo(this.getThresholdFillTransparency[2][0], this.getThresholdFillTransparency[2][1]);
                        generalPath.lineTo(this.getThresholdFillTransparency[3][0], this.getThresholdFillTransparency[3][1]);
                        generalPath.lineTo(this.getThresholdFillTransparency[0][0], this.getThresholdFillTransparency[0][1]);
                        generalPath.closePath();
                        graphics2D.setColor(ChartColorPattern.transparent(this.getMin.getProperties().getGraphProperties().getThresholdLineColor(), this.getMin.getProperties().getGraphProperties().getThresholdFillTransparency()));
                        if (this.getMin.getProperties().getGraphProperties().isFillThreshold()) {
                            graphics2D.fill(generalPath);
                        }
                        graphics2D.setColor(this.getMin.getProperties().getGraphProperties().getThresholdLineColor());
                        graphics2D.drawLine((int)this.getThresholdFillTransparency[0][0], (int)this.getThresholdFillTransparency[0][1], (int)this.getThresholdFillTransparency[1][0], (int)this.getThresholdFillTransparency[1][1]);
                    }
                }
                if (!this.getMin.getProperties().getGraphProperties().isShowThresholdLine2()) break;
                if (this.isDepth()) {
                    generalPath.reset();
                    generalPath.moveTo(this.getThresholdLineColor[0][0] - this.I, this.getThresholdLineColor[0][1] + this.Z);
                    generalPath.lineTo(this.getThresholdLineColor[1][0] - this.I, this.getThresholdLineColor[1][1] + this.Z);
                    generalPath.lineTo(this.getThresholdLineColor[2][0] - this.I, this.getThresholdLineColor[2][1] + this.Z);
                    generalPath.lineTo(this.getThresholdLineColor[3][0] - this.I, this.getThresholdLineColor[3][1] + this.Z);
                    generalPath.lineTo(this.getThresholdLineColor[0][0] - this.I, this.getThresholdLineColor[0][1] + this.Z);
                    generalPath.closePath();
                    graphics2D.setColor(ChartColorPattern.transparent(this.getMin.getProperties().getGraphProperties().getThresholdLineColor2(), this.getMin.getProperties().getGraphProperties().getThresholdFillTransparency()));
                    if (this.getMin.getProperties().getGraphProperties().isFillThreshold2()) {
                        graphics2D.fill(generalPath);
                    }
                    graphics2D.setColor(this.getMin.getProperties().getGraphProperties().getThresholdLineColor2());
                    graphics2D.drawLine((int)(this.getThresholdLineColor[2][0] - this.I), (int)(this.getThresholdLineColor[2][1] + this.Z), (int)(this.getThresholdLineColor[3][0] - this.I), (int)(this.getThresholdLineColor[3][1] + this.Z));
                    break;
                }
                generalPath.reset();
                generalPath.moveTo(this.getThresholdLineColor[0][0], this.getThresholdLineColor[0][1]);
                generalPath.lineTo(this.getThresholdLineColor[1][0], this.getThresholdLineColor[1][1]);
                generalPath.lineTo(this.getThresholdLineColor[2][0], this.getThresholdLineColor[2][1]);
                generalPath.lineTo(this.getThresholdLineColor[3][0], this.getThresholdLineColor[3][1]);
                generalPath.lineTo(this.getThresholdLineColor[0][0], this.getThresholdLineColor[0][1]);
                generalPath.closePath();
                graphics2D.setColor(ChartColorPattern.transparent(this.getMin.getProperties().getGraphProperties().getThresholdLineColor2(), this.getMin.getProperties().getGraphProperties().getThresholdFillTransparency()));
                if (this.getMin.getProperties().getGraphProperties().isFillThreshold2()) {
                    graphics2D.fill(generalPath);
                }
                graphics2D.setColor(this.getMin.getProperties().getGraphProperties().getThresholdLineColor2());
                graphics2D.drawLine((int)this.getThresholdLineColor[2][0], (int)this.getThresholdLineColor[2][1], (int)this.getThresholdLineColor[3][0], (int)this.getThresholdLineColor[3][1]);
                break;
            }
            case 1: {
                if (!this.getMin.getProperties().getGraphProperties().isShowThresholdLine()) break;
                if (this.isDepth()) {
                    generalPath.reset();
                    generalPath.moveTo(this.getThresholdFillTransparency[0][0] - this.I, this.getThresholdFillTransparency[0][1] + this.Z);
                    generalPath.lineTo(this.getThresholdFillTransparency[1][0] - this.I, this.getThresholdFillTransparency[1][1] + this.Z);
                    generalPath.lineTo(this.getThresholdLineColor[2][0] - this.I, this.getThresholdLineColor[2][1] + this.Z);
                    generalPath.lineTo(this.getThresholdLineColor[3][0] - this.I, this.getThresholdLineColor[3][1] + this.Z);
                    generalPath.lineTo(this.getThresholdFillTransparency[0][0] - this.I, this.getThresholdFillTransparency[0][1] + this.Z);
                    generalPath.closePath();
                    graphics2D.setColor(ChartColorPattern.transparent(this.getMin.getProperties().getGraphProperties().getThresholdLineColor(), this.getMin.getProperties().getGraphProperties().getThresholdFillTransparency()));
                    if (this.getMin.getProperties().getGraphProperties().isFillThreshold()) {
                        graphics2D.fill(generalPath);
                    }
                    graphics2D.setColor(this.getMin.getProperties().getGraphProperties().getThresholdLineColor());
                    graphics2D.drawLine((int)(this.getThresholdFillTransparency[0][0] - this.I), (int)(this.getThresholdFillTransparency[0][1] + this.Z), (int)(this.getThresholdFillTransparency[1][0] - this.I), (int)(this.getThresholdFillTransparency[1][1] + this.Z));
                    graphics2D.drawLine((int)(this.getThresholdLineColor[2][0] - this.I), (int)(this.getThresholdLineColor[2][1] + this.Z), (int)(this.getThresholdLineColor[3][0] - this.I), (int)(this.getThresholdLineColor[3][1] + this.Z));
                    break;
                }
                generalPath.moveTo(this.getThresholdFillTransparency[0][0], this.getThresholdFillTransparency[0][1]);
                generalPath.lineTo(this.getThresholdFillTransparency[1][0], this.getThresholdFillTransparency[1][1]);
                generalPath.lineTo(this.getThresholdLineColor[2][0], this.getThresholdLineColor[2][1]);
                generalPath.lineTo(this.getThresholdLineColor[3][0], this.getThresholdLineColor[3][1]);
                generalPath.lineTo(this.getThresholdFillTransparency[0][0], this.getThresholdFillTransparency[0][1]);
                generalPath.closePath();
                graphics2D.setColor(ChartColorPattern.transparent(this.getMin.getProperties().getGraphProperties().getThresholdLineColor(), this.getMin.getProperties().getGraphProperties().getThresholdFillTransparency()));
                if (this.getMin.getProperties().getGraphProperties().isFillThreshold()) {
                    graphics2D.fill(generalPath);
                }
                graphics2D.setColor(this.getMin.getProperties().getGraphProperties().getThresholdLineColor());
                graphics2D.drawLine((int)this.getThresholdFillTransparency[0][0], (int)this.getThresholdFillTransparency[0][1], (int)this.getThresholdFillTransparency[1][0], (int)this.getThresholdFillTransparency[1][1]);
                graphics2D.drawLine((int)this.getThresholdLineColor[2][0], (int)this.getThresholdLineColor[2][1], (int)this.getThresholdLineColor[3][0], (int)this.getThresholdLineColor[3][1]);
            }
        }
    }

    public float[][] getWallCoordinate() {
        return this.custommerConstant;
    }

    public boolean searchWall(int n, int n2) {
        return this.getWallPath().contains(n, n2);
    }

    public GeneralPath getWallPath() {
        return this.getThresholdLineColor2;
    }

    public Line2D[] getGridXPath() {
        return this.getNumOfTick;
    }

    public Line2D[] getGridYPath() {
        return this.gridYPath;
    }

    public void setUseDepth(boolean bl) {
        this.getPattern1 = bl;
    }

    public boolean isCombo() {
        return this.getProperties;
    }

    public void setCombo(boolean bl) {
        this.getProperties = bl;
    }

    public void setChartCount(int n) {
        this.getThresholdLineStyle = n;
    }

    public int getChartCount() {
        return this.getThresholdLineStyle;
    }

    public boolean isShowCategoryAndSeries() {
        return this.getThresholdValue;
    }

    public void setShowCategoryAndSeries(boolean bl) {
        this.getThresholdValue = bl;
    }

    public boolean useDepth() {
        return this.getPattern1;
    }
}

