/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.ChartLabelBase;
import chart.axis.ChartCategoryAxis;
import chart.chart2d.Chart2DLayer;
import chart.chart2d.Chart2DObject;
import chart.chart2d.Chart2DPaper;
import chart.chart2d.Graph2DLineNode;
import chart.chart2d.Graph2DScatterCurve;
import chart.data.Chart1DDataSet;
import chart.data.ChartDataSet;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartPenStyle;
import chart.graphics.ChartTextStyle;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class Graph2DMeanLine
extends Chart2DObject {
    private GeneralPath F = new GeneralPath();
    private GeneralPath[] append;
    private int clipRect;
    private int clone;
    private float[][] col;
    private float[][] contains;
    private Graph2DLineNode create;
    private Graph2DScatterCurve createStroke = new Graph2DScatterCurve();
    private boolean draw;
    private boolean drawNode;
    private boolean getAbsoluteValueSumOfCategory;
    private double[] v;
    private ChartPenStyle getAxisX = new ChartPenStyle();
    private ChartColorPattern getBorderPen = new ChartColorPattern();
    private String[][] getCategorySize;
    private ChartTextStyle getChartDataSetModel;
    private float getChartPlatform = 0.0f;

    Graph2DMeanLine(ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer, boolean bl, boolean bl2, float f) {
        super(chartDataSet, chart2DPaper, chart2DLayer);
        this.draw = bl;
        this.drawNode = bl2;
        this.clone = chartDataSet.getCategorySize();
        this.clipRect = chartDataSet.getSeriesSize();
        this.getChartPlatform = f;
        this.getChartDataSetModel = chart2DPaper.getProperties().getHintTextStyle();
        this.getChartDataSetModel.setWordWrapper(false);
    }

    @Override
    public void init() {
        boolean bl;
        this.col = new float[this.clone][2];
        this.contains = new float[this.clone][2];
        this.v = ((Chart1DDataSet)this.dataset).getMeanValue();
        this.getCategorySize = new String[this.clone][1];
        float f = this.layer.I();
        float f2 = this.layer.Z();
        this.create = new Graph2DLineNode();
        float f3 = f * this.getChartPlatform;
        this.append = new GeneralPath[this.clone];
        this.getBorderPen.setColor(this.paper.getProperties().getGraphProperties().getMeanLineColor());
        this.getAxisX.setPenColor(this.getBorderPen);
        double d = 0.0;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int[] nArray = this.paper.getChartPlatform().getDataPosition();
        if (nArray != null && nArray.length > 0 && ((n = nArray[0]) < 0 || n >= this.clone)) {
            n = 0;
        }
        f3 = (bl = ((ChartCategoryAxis)this.layer.getAxisX()).isLineUnit()) ? 0.0f : f / 2.0f;
        for (int i = 0; i < this.clone; ++i) {
            this.append[i] = new GeneralPath();
            this.col[i][0] = f3 + (float)i * f;
            if (n == 0) {
                this.col[i][1] = this.getAbsoluteValueSumOfCategory ? (float)((double)f2 * this.v[i] / ((Chart1DDataSet)this.dataset).getAbsoluteValueSumOfCategory(i)) : (float)((double)f2 * this.v[i]);
            } else if (i + n >= 0 && i + n < this.clone) {
                this.col[i][1] = this.getAbsoluteValueSumOfCategory ? (float)((double)f2 * this.v[i + n] / ((Chart1DDataSet)this.dataset).getAbsoluteValueSumOfCategory(i)) : (float)((double)f2 * this.v[i + n]);
            }
            if (this.drawNode) {
                stringBuffer.append("Y1: ");
            } else {
                stringBuffer.append("Y2: ");
            }
            stringBuffer.append(this.v[i]);
            this.getCategorySize[i][0] = stringBuffer.toString();
        }
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        Rectangle rectangle = null;
        Graphics2D graphics2D2 = null;
        int n = this.clone;
        switch (this.paper.getProperties().getGraphProperties().getMeanLineType()) {
            case 0: {
                break;
            }
            case 1: {
                this.F(graphics2D);
                break;
            }
            case 2: {
                graphics2D.setStroke(this.getAxisX.createStroke());
                graphics2D.setColor(this.paper.getProperties().getGraphProperties().getMeanLineColor());
                this.createStroke.isBench = !this.draw;
                this.createStroke.col = this.clone;
                n = this.paper.isScrollChart() ? this.paper.getChartPlatform().showScrollLabelCount() : this.clone;
                this.createStroke.col = n = n > this.clone ? this.clone : n;
                this.createStroke.tpoint1 = this.contains;
                graphics2D2 = (Graphics2D)graphics2D.create();
                rectangle = this.paper.getGraphArea();
                if (rectangle != null) {
                    graphics2D2.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                this.createStroke.paint(graphics2D2, this.paper.getProperties().getGraphProperties().getMeanLineType());
                break;
            }
            case 3: {
                graphics2D.setStroke(this.getAxisX.createStroke());
                graphics2D.setColor(this.paper.getProperties().getGraphProperties().getMeanLineColor());
                n = this.paper.isScrollChart() ? this.paper.getChartPlatform().showScrollLabelCount() : this.clone;
                this.createStroke.col = n = n > this.clone ? this.clone : n;
                this.createStroke.tpoint1 = this.contains;
                graphics2D2 = (Graphics2D)graphics2D.create();
                rectangle = this.paper.getGraphArea();
                if (rectangle != null) {
                    graphics2D2.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                this.createStroke.paint(graphics2D2, this.paper.getProperties().getGraphProperties().getMeanLineType());
                break;
            }
        }
        this.SEDU(graphics2D, this.paper.getProperties().getGraphProperties().getMeanLineNodeStyle());
    }

    @Override
    public Shape getShapeBySeries(int n) {
        return null;
    }

    @Override
    public Shape getShapeByItem(int n, int n2) {
        return this.append[n2];
    }

    private void F(Graphics2D graphics2D) {
        if (this.clone <= 1) {
            return;
        }
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        Rectangle rectangle = this.paper.getGraphArea();
        if (rectangle != null) {
            graphics2D2.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this.F.reset();
        this.F.moveTo(this.contains[0][0], this.contains[0][1]);
        int n = this.paper.isScrollChart() ? this.paper.getChartPlatform().showScrollLabelCount() : this.clone;
        n = n > this.clone ? this.clone : n;
        for (int i = 1; i < n; ++i) {
            this.F.lineTo(this.contains[i][0], this.contains[i][1]);
        }
        this.getAxisX.draw(graphics2D2, this.F);
    }

    private void SEDU(Graphics2D graphics2D, int n) {
        ChartColorPattern chartColorPattern = null;
        chartColorPattern = new ChartColorPattern(this.paper.getProperties().getGraphProperties().getMeanLineColor());
        this.create.getBorderPen().setPenWidth(1.0f);
        this.create.getBorderPen().setPenColor(chartColorPattern);
        this.create.setFillPattern(chartColorPattern);
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        if (this.paper.getGraphArea() != null) {
            Rectangle rectangle = (Rectangle)this.paper.getGraphArea().clone();
            rectangle.width += 2;
            rectangle.height += 2;
            graphics2D2.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        int n2 = this.paper.isScrollChart() ? this.paper.getChartPlatform().showScrollLabelCount() : this.clone;
        n2 = n2 > this.clone ? this.clone : n2;
        for (int i = 0; i < n2; ++i) {
            this.create.drawNode(graphics2D2, (int)this.contains[i][0], (int)this.contains[i][1], n, this.paper.getProperties().getGraphProperties().getLineNodeWidth(), this.paper.getProperties().getGraphProperties().getLineNodeHeight());
        }
    }

    public void drawMeanValueY(Graphics2D graphics2D, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        Rectangle2D.Float float_ = (Rectangle2D.Float)this.paper.getProperties().getHintTextStyle().getDimension(graphics2D, stringBuffer.toString());
        ChartLabelBase chartLabelBase = new ChartLabelBase("");
        for (int i = 0; i < this.clone; ++i) {
            if (!this.append[i].contains(n, n2)) continue;
            stringBuffer.setLength(0);
            if (this.drawNode) {
                stringBuffer.append("Y1: ");
            } else {
                stringBuffer.append("Y2: ");
            }
            stringBuffer.append(this.dataset.getChartDataSetModel().getFormatedHintValue(this.v[i]));
            chartLabelBase.setLabelText(stringBuffer.toString());
            chartLabelBase.locate();
            chartLabelBase.paint(graphics2D, n + 10, n2 - 10);
            return;
        }
    }

    @Override
    public String[] search(int n, int n2) {
        for (int i = 0; i < this.clone; ++i) {
            if (!this.append[i].contains(n, n2)) continue;
            return this.getCategorySize[i];
        }
        return null;
    }

    @Override
    public void locate() {
        int n;
        this.layer.I(this.col, this.contains);
        if (this.layer.isDepth()) {
            for (n = 0; n < this.clone; ++n) {
                float[] fArray2 = this.contains[n];
                fArray2[0] = fArray2[0] - this.layer.I;
                float[] fArray3 = this.contains[n];
                fArray3[1] = fArray3[1] + this.layer.Z;
            }
        }
        n = 5;
        for (int i = 0; i < this.clone; ++i) {
            this.append[i].reset();
            this.append[i].moveTo(this.contains[i][0] - (float)n, this.contains[i][1] + (float)n);
            this.append[i].lineTo(this.contains[i][0] - (float)n, this.contains[i][1] - (float)n);
            this.append[i].lineTo(this.contains[i][0] + (float)n, this.contains[i][1] - (float)n);
            this.append[i].lineTo(this.contains[i][0] + (float)n, this.contains[i][1] + (float)n);
            this.append[i].lineTo(this.contains[i][0] - (float)n, this.contains[i][1] + (float)n);
        }
    }

    @Override
    float[][] getStaticHintLocation() {
        return null;
    }

    @Override
    Shape[][] getItemShapes() {
        return null;
    }

    public boolean contains(int n, int n2) {
        return false;
    }

    @Override
    public int searchSeries(int n, int n2) {
        return 0;
    }

    public void setPercent(boolean bl) {
        this.getAbsoluteValueSumOfCategory = bl;
    }

    @Override
    public int[] searchLinkInfo(int n, int n2) {
        return null;
    }
}

