/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.web.util.json;

import com.jinfonet.web.util.CharArray;
import com.jinfonet.web.util.json.JSON;
import com.jinfonet.web.util.json.JSONArray;
import com.jinfonet.web.util.json.JSONException;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class JSONObject
implements Map,
Cloneable,
Serializable {
    private Map map;
    public static final Null NULL = new Null();
    private static final long serialVersionUID = 1626861352226414051L;

    public JSONObject() {
        this((Map)new LinkedHashMap());
    }

    public JSONObject(String string) throws JSONException {
        this((Map)null);
        if (string == null) {
            throw new JSONException("The JSONObject string can not be null");
        }
        try {
            this.map = (JSONObject)JSON.MapsParser.parse(new CharArray(string));
        }
        catch (ParseException parseException) {
            throw new JSONException(parseException.getMessage() + " " + parseException.getErrorOffset());
        }
    }

    public JSONObject(Map map) {
        this.map = map;
    }

    public JSONObject(HashMap hashMap) {
        this.map = hashMap;
    }

    public Iterator keys() {
        return this.keySet().iterator();
    }

    public CharArray toCharArray() {
        CharArray charArray = new CharArray();
        JSON.MapsConverter.convert(this, charArray);
        return charArray;
    }

    public String toString() {
        return this.toCharArray().getString();
    }

    public String toString(int n) {
        return this.toString();
    }

    public boolean getBoolean(String string) throws JSONException {
        try {
            return JSON.castBoolean(this.get(string));
        }
        catch (JSONException jSONException) {
            throw new JSONException("[\"" + string + "\"] not found or is not a Boolean.", jSONException);
        }
    }

    public int getInt(String string) throws JSONException {
        try {
            return JSON.castInteger(this.get(string));
        }
        catch (JSONException jSONException) {
            throw new JSONException("[\"" + string + "\"] not found or is not a Number.", jSONException);
        }
    }

    public long getLong(String string) throws JSONException {
        try {
            return JSON.castLong(this.get(string));
        }
        catch (JSONException jSONException) {
            throw new JSONException("[\"" + string + "\"] not found or is not a Number.", jSONException);
        }
    }

    public float getFloat(String string) throws JSONException {
        try {
            return JSON.castFloat(this.get(string));
        }
        catch (JSONException jSONException) {
            throw new JSONException("[\"" + string + "\"] not found or is not a Number.", jSONException);
        }
    }

    public double getDouble(String string) throws JSONException {
        try {
            return JSON.castDouble(this.get(string));
        }
        catch (JSONException jSONException) {
            throw new JSONException("[\"" + string + "\"] not found or is not a Number.", jSONException);
        }
    }

    public String getString(String string) throws JSONException {
        try {
            return JSON.castString(this.get(string));
        }
        catch (JSONException jSONException) {
            throw new JSONException("[\"" + string + "\"] not found or is not a String.", jSONException);
        }
    }

    public JSONObject getJSONObject(String string) throws JSONException {
        try {
            return JSON.castJSONObject(this.get(string));
        }
        catch (JSONException jSONException) {
            throw new JSONException("[\"" + string + "\"] not found or is not a JSONObject.", jSONException);
        }
    }

    public JSONArray getJSONArray(String string) throws JSONException {
        try {
            return JSON.castJSONArray(this.get(string));
        }
        catch (JSONException jSONException) {
            throw new JSONException("[\"" + string + "\"] not found or is not a JSONArray.", jSONException);
        }
    }

    public Object opt(String string) {
        return this.get(string);
    }

    public boolean optBoolean(String string) {
        return this.optBoolean(string, false);
    }

    public boolean optBoolean(String string, boolean bl) {
        try {
            return this.getBoolean(string);
        }
        catch (Exception exception) {
            return bl;
        }
    }

    public int optInt(String string) {
        return this.optInt(string, 0);
    }

    public int optInt(String string, int n) {
        try {
            return this.getInt(string);
        }
        catch (Exception exception) {
            return n;
        }
    }

    public long optLong(String string) {
        return this.optLong(string, 0L);
    }

    public long optLong(String string, long l) {
        try {
            return this.getLong(string);
        }
        catch (Exception exception) {
            return l;
        }
    }

    public float optFloat(String string) {
        return this.optFloat(string, 0.0f);
    }

    public float optFloat(String string, float f) {
        try {
            return this.getFloat(string);
        }
        catch (Exception exception) {
            return f;
        }
    }

    public double optDouble(String string) {
        return this.optDouble(string, 0.0);
    }

    public double optDouble(String string, double d) {
        try {
            return this.getDouble(string);
        }
        catch (Exception exception) {
            return d;
        }
    }

    public String optString(String string) {
        return this.optString(string, null);
    }

    public String optString(String string, String string2) {
        String string3 = this.getString(string);
        return string3 == null ? string2 : string3;
    }

    public JSONObject optJSONObject(String string) {
        Object object = this.opt(string);
        return object instanceof JSONObject ? (JSONObject)object : null;
    }

    public JSONArray optJSONArray(String string) {
        Object object = this.opt(string);
        return object instanceof JSONArray ? (JSONArray)object : null;
    }

    public int length() {
        return this.size();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.map.containsValue(object);
    }

    public Set entrySet() {
        return this.map.entrySet();
    }

    public Object get(Object object) {
        Object v = this.map.get(object);
        return v instanceof Null ? null : v;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public Object put(String string, Object object) {
        return this.map.put(string, object);
    }

    public void putAll(Map map) {
        this.map.putAll(map);
    }

    public Object remove(Object object) {
        return this.map.remove(object);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public Collection values() {
        return this.map.values();
    }

    protected Object clone() {
        return new JSONObject((Map)new LinkedHashMap(this.map));
    }

    public static class Null
    implements Serializable {
        private static final long serialVersionUID = 4995764720895272165L;

        protected Object clone() {
            return this;
        }

        public boolean equals(Object object) {
            return object == null || object == this;
        }

        public int hashCode() {
            return "null".hashCode();
        }

        public String toString() {
            return "null";
        }
    }

    public static interface JSONObjectable {
        public Object toJSONObject() throws JSONException;
    }
}

