/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import jet.Env;
import jet.connect.DbArray;
import jet.connect.DbColDesc;
import jet.connect.DbLongColumnBuffer;
import jet.connect.DbLongVariable;
import jet.connect.DbValue;
import jet.log.JRLogger;
import jet.util.RAFile;
import jet.util.TempFile;

public class DbArrayColumnBuffer
extends DbLongColumnBuffer
implements DbLongVariable {
    private static JRLogger I = JRLogger.getLogger(DbArrayColumnBuffer.class.getName());
    private RAFile SEDU;
    private File clearMem;
    private boolean createTempFile = true;
    private Object[] delete;
    TempFile desc = new TempFile(Env.getTemporaryPath(), "array");

    public DbArrayColumnBuffer(DbColDesc dbColDesc, int n) {
        super(dbColDesc, n);
    }

    @Override
    public RAFile createTempFile() throws IOException {
        this.clearMem = this.desc.createTempFile();
        this.SEDU = new RAFile(this.clearMem, "rw");
        return this.SEDU;
    }

    @Override
    public File getFile() {
        return this.clearMem;
    }

    @Override
    public void setBufFile(RAFile rAFile) {
        this.SEDU = rAFile;
    }

    @Override
    public void setCacheToFile(boolean bl) {
        this.createTempFile = bl;
    }

    @Override
    public void updateCell(int n, DbValue dbValue) {
        block26: {
            try {
                if (this.createTempFile) {
                    this.B[n] = this.SEDU.length();
                    this.SEDU.seek(this.B[n]);
                    switch (dbValue.desc.sqlType) {
                        case -7: {
                            boolean[] blArray = (boolean[])((DbArray)dbValue).getValue();
                            this.SEDU.writeInt(blArray.length);
                            for (int i = 0; i < blArray.length; ++i) {
                                this.SEDU.writeBoolean(blArray[i]);
                            }
                            break block26;
                        }
                        case -6: {
                            byte[] byArray = (byte[])((DbArray)dbValue).getValue();
                            this.SEDU.writeInt(byArray.length);
                            for (int i = 0; i < byArray.length; ++i) {
                                this.SEDU.writeByte(byArray[i]);
                            }
                            break block26;
                        }
                        case 5: {
                            short[] sArray = (short[])((DbArray)dbValue).getValue();
                            this.SEDU.writeInt(sArray.length);
                            for (int i = 0; i < sArray.length; ++i) {
                                this.SEDU.writeShort(sArray[i]);
                            }
                            break block26;
                        }
                        case 4: {
                            int[] nArray = (int[])((DbArray)dbValue).getValue();
                            this.SEDU.writeInt(nArray.length);
                            for (int i = 0; i < nArray.length; ++i) {
                                this.SEDU.writeInt(nArray[i]);
                            }
                            break block26;
                        }
                        case -5: 
                        case 91: 
                        case 92: {
                            long[] lArray = (long[])((DbArray)dbValue).getValue();
                            this.SEDU.writeInt(lArray.length);
                            for (int i = 0; i < lArray.length; ++i) {
                                this.SEDU.writeLong(lArray[i]);
                            }
                            break block26;
                        }
                        case 93: {
                            long[] lArray = (long[])((DbArray)dbValue).getValue();
                            int[] nArray = ((DbArray)dbValue).getNanos();
                            this.SEDU.writeInt(lArray.length);
                            for (int i = 0; i < lArray.length; ++i) {
                                this.SEDU.writeLong(lArray[i]);
                                this.SEDU.writeInt(nArray[i]);
                            }
                            break block26;
                        }
                        case 6: 
                        case 7: {
                            float[] fArray2 = (float[])((DbArray)dbValue).getValue();
                            this.SEDU.writeInt(fArray2.length);
                            for (int i = 0; i < fArray2.length; ++i) {
                                this.SEDU.writeFloat(fArray2[i]);
                            }
                            break block26;
                        }
                        case 8: {
                            double[] dArray = (double[])((DbArray)dbValue).getValue();
                            this.SEDU.writeInt(dArray.length);
                            for (int i = 0; i < dArray.length; ++i) {
                                this.SEDU.writeDouble(dArray[i]);
                            }
                            break block26;
                        }
                        case 2: 
                        case 3: {
                            BigDecimal[] bigDecimalArray = (BigDecimal[])((DbArray)dbValue).getValue();
                            this.SEDU.writeInt(bigDecimalArray.length);
                            for (int i = 0; i < bigDecimalArray.length; ++i) {
                                this.SEDU.writeUTF(bigDecimalArray[i].toString());
                            }
                            break block26;
                        }
                        case -1: 
                        case 1: 
                        case 12: {
                            String[] stringArray = (String[])((DbArray)dbValue).getValue();
                            this.SEDU.writeInt(stringArray.length);
                            for (int i = 0; i < stringArray.length; ++i) {
                                if (stringArray[i] == null) {
                                    this.SEDU.writeUTF("");
                                    continue;
                                }
                                this.SEDU.writeUTF(stringArray[i]);
                            }
                            break block26;
                        }
                    }
                    break block26;
                }
                this.delete[n] = ((DbArray)dbValue).getValue();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void refreshFromCell(int n, DbValue dbValue) {
        Object[] objectArray = null;
        int[] nArray = null;
        int n2 = 0;
        try {
            block25: {
                block24: {
                    if (!this.createTempFile) break block24;
                    this.SEDU.seek(this.B[n]);
                    n2 = this.SEDU.readInt();
                    switch (dbValue.desc.sqlType) {
                        case -7: {
                            objectArray = new boolean[n2];
                            for (int i = 0; i < n2; ++i) {
                                ((boolean[])objectArray)[i] = this.SEDU.readBoolean();
                            }
                            break block25;
                        }
                        case -6: {
                            objectArray = new byte[n2];
                            for (int i = 0; i < n2; ++i) {
                                ((byte[])objectArray)[i] = this.SEDU.readByte();
                            }
                            break block25;
                        }
                        case 5: {
                            objectArray = new short[n2];
                            for (int i = 0; i < n2; ++i) {
                                ((short[])objectArray)[i] = this.SEDU.readShort();
                            }
                            break block25;
                        }
                        case 4: {
                            objectArray = new int[n2];
                            for (int i = 0; i < n2; ++i) {
                                ((int[])objectArray)[i] = this.SEDU.readInt();
                            }
                            break block25;
                        }
                        case -5: 
                        case 91: 
                        case 92: {
                            objectArray = new long[n2];
                            for (int i = 0; i < n2; ++i) {
                                ((long[])objectArray)[i] = this.SEDU.readLong();
                            }
                            break block25;
                        }
                        case 93: {
                            objectArray = new long[n2];
                            nArray = new int[n2];
                            for (int i = 0; i < n2; ++i) {
                                ((long[])objectArray)[i] = this.SEDU.readLong();
                                nArray[i] = this.SEDU.readInt();
                            }
                            ((DbArray)dbValue).setNanos(nArray);
                            break;
                        }
                        case 6: 
                        case 7: {
                            objectArray = new float[n2];
                            for (int i = 0; i < n2; ++i) {
                                ((float[])objectArray)[i] = this.SEDU.readFloat();
                            }
                            break block25;
                        }
                        case 8: {
                            objectArray = new double[n2];
                            for (int i = 0; i < n2; ++i) {
                                ((double[])objectArray)[i] = this.SEDU.readDouble();
                            }
                            break block25;
                        }
                        case 2: 
                        case 3: {
                            objectArray = new BigDecimal[n2];
                            for (int i = 0; i < n2; ++i) {
                                ((BigDecimal[])objectArray)[i] = new BigDecimal(this.SEDU.readUTF());
                            }
                            break block25;
                        }
                        case -1: 
                        case 1: 
                        case 12: {
                            objectArray = new String[n2];
                            for (int i = 0; i < n2; ++i) {
                                ((String[])objectArray)[i] = this.SEDU.readUTF();
                            }
                            break block25;
                        }
                    }
                    break block25;
                }
                objectArray = this.delete[n];
                n2 = this.I(objectArray);
            }
            ((DbArray)dbValue).setValue(objectArray, n2);
        }
        catch (IOException iOException) {
            I.error("", iOException);
        }
    }

    private int I(Object object) {
        int n = 0;
        if (object instanceof boolean[]) {
            n = ((boolean[])object).length;
        } else if (object instanceof byte[]) {
            n = ((byte[])object).length;
        } else if (object instanceof short[]) {
            n = ((short[])object).length;
        } else if (object instanceof int[]) {
            n = ((int[])object).length;
        } else if (object instanceof long[]) {
            n = ((long[])object).length;
        } else if (object instanceof float[]) {
            n = ((float[])object).length;
        } else if (object instanceof double[]) {
            n = ((double[])object).length;
        } else if (object instanceof BigDecimal[]) {
            n = ((BigDecimal[])object).length;
        } else if (object instanceof String[]) {
            n = ((String[])object).length;
        }
        return n;
    }

    @Override
    public void setByteRow(byte[] byArray, int n) {
        int n2 = n % this.B.length;
        this.delete[n2] = byArray;
    }

    protected void finalize() {
        if (this.clearMem != null) {
            this.clearMem.delete();
        }
    }

    @Override
    public void clearMem() {
        super.clearMem();
        this.delete = null;
    }
}

