/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import com.jinfonet.util.JRLog;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import jet.connect.DbColDesc;
import jet.connect.DbValue;
import jet.datasource.JRHierarchicalDataset;
import jet.exception.UnsupportedFunctionException;

public class DbBinary
extends DbValue {
    public byte[] value;

    public DbBinary() {
    }

    public DbBinary(DbColDesc dbColDesc) {
        super(dbColDesc);
    }

    public byte[] get() {
        return this.value;
    }

    public InputStream getStream() {
        return new ByteArrayInputStream(this.value);
    }

    public void set(byte[] byArray) {
        this.value = byArray;
        this.bNull = byArray == null;
    }

    @Override
    public void set(ResultSet resultSet, int n) throws SQLException {
        try {
            if (this.desc.sqlType == -4 || this.desc.sqlType == 2004) {
                Object object;
                this.value = null;
                InputStream inputStream = null;
                if (this.desc.sqlType == 2004) {
                    object = resultSet.getBlob(n);
                    if (!resultSet.wasNull()) {
                        inputStream = object != null ? object.getBinaryStream() : resultSet.getBinaryStream(n);
                    }
                } else {
                    inputStream = resultSet.getBinaryStream(n);
                }
                if (inputStream != null) {
                    object = new byte[4096];
                    int n2 = 0;
                    int n3 = -1;
                    do {
                        if ((n3 = inputStream.read((byte[])object)) == -1) continue;
                        if (this.value == null || this.value.length < n2 + n3) {
                            byte[] byArray = new byte[n2 + n3];
                            if (this.value != null && this.value.length > 0) {
                                System.arraycopy(this.value, 0, byArray, 0, this.value.length);
                            }
                            this.value = byArray;
                        }
                        System.arraycopy(object, 0, this.value, n2, n3);
                        n2 += n3;
                    } while (n3 != -1);
                    inputStream.close();
                }
                this.bNull = this.value == null;
            } else {
                this.value = resultSet.getBytes(n);
                this.bNull = resultSet.wasNull();
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            if (JRLog.isError(3)) {
                JRLog.error(3, exception);
            }
            this.bNull = true;
        }
    }

    @Override
    public void set(JRHierarchicalDataset jRHierarchicalDataset, int n) throws SQLException {
        try {
            if (this.desc.sqlType == -4) {
                this.value = null;
                InputStream inputStream = jRHierarchicalDataset.getBinaryStream(n);
                if (inputStream != null) {
                    byte[] byArray = new byte[4096];
                    int n2 = 0;
                    int n3 = -1;
                    do {
                        if ((n3 = inputStream.read(byArray)) == -1) continue;
                        if (this.value == null || this.value.length < n2 + n3) {
                            byte[] byArray2 = new byte[n2 + n3];
                            if (this.value != null && this.value.length > 0) {
                                System.arraycopy(this.value, 0, byArray2, 0, this.value.length);
                            }
                            this.value = byArray2;
                        }
                        System.arraycopy(byArray, 0, this.value, n2, n3);
                        n2 += n3;
                    } while (n3 != -1);
                    inputStream.close();
                }
                this.bNull = this.value == null;
            } else {
                this.value = jRHierarchicalDataset.getBytes(n);
                this.bNull = jRHierarchicalDataset.wasNull();
            }
        }
        catch (Exception exception) {
            this.bNull = jRHierarchicalDataset.wasNull();
        }
        this.bNull = true;
    }

    @Override
    public String toString() {
        if (this.bNull) {
            return "NULL";
        }
        return String.valueOf(this.value);
    }

    @Override
    public Object clone() {
        DbBinary dbBinary = new DbBinary(this.desc);
        dbBinary.bNull = this.bNull;
        dbBinary.value = this.value;
        return dbBinary;
    }

    @Override
    public boolean equals(DbValue dbValue) {
        throw new Error("Can not compare binary.");
    }

    @Override
    public int compareTo(DbValue dbValue) {
        throw new Error("Can not compare binary.");
    }

    @Override
    public void set(DbValue dbValue) {
        if (dbValue == null) {
            this.bNull = true;
            return;
        }
        if (!dbValue.bNull) {
            byte[] byArray = ((DbBinary)dbValue).value;
            this.value = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.value, 0, byArray.length);
        }
        this.bNull = dbValue.bNull;
    }

    @Override
    public void setValue(String string) {
        if (string == null) {
            this.bNull = true;
        } else {
            this.value = string.getBytes();
            this.bNull = false;
        }
    }

    @Override
    public String toStringValue() {
        throw new UnsupportedFunctionException();
    }
}

