/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import com.jinfonet.util.JRLog;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.datastream.DSContainable;
import jet.datastream.DSDataStreamable;
import jet.datastream.DSPage;
import jet.datastream.DSReference;
import jet.datastream.DSSection;
import jet.datastream.DSSubReport;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.util.VersionControlable;

public class DSContainer
extends JRVisiableResult
implements DSContainable {
    Vector Z = new Vector(10);
    Locale addElement;
    TimeZone copyObject;

    @Override
    public void add(JRObjectResult jRObjectResult) {
        if (jRObjectResult == null) {
            return;
        }
        this.Z.addElement(jRObjectResult);
        jRObjectResult.setParent(this);
    }

    @Override
    public void remove(JRObjectResult jRObjectResult) {
        int n = this.Z.indexOf(jRObjectResult);
        if (n >= 0) {
            this.Z.removeElementAt(n);
            jRObjectResult.setParent(null);
        }
    }

    @Override
    public void removeAll() {
        for (int i = this.Z.size() - 1; i >= 0; --i) {
            JRObjectResult jRObjectResult = (JRObjectResult)this.Z.elementAt(i);
            this.Z.removeElementAt(i);
            jRObjectResult.setParent(null);
        }
    }

    @Override
    public Vector getChildren() {
        return this.Z;
    }

    @Override
    protected void readProperties(DataInput dataInput, DSDataStreamable dSDataStreamable) throws IOException, JRStopEngineException {
        super.readProperties(dataInput, dSDataStreamable);
        int n = ((VersionControlable)((Object)dataInput)).getVersion();
        int n2 = n >= 262160 || n == 0 ? dataInput.readInt() : (int)dataInput.readShort();
        for (int i = 0; i < n2; ++i) {
            JRObjectResult jRObjectResult;
            int n3 = n >= 131097 || n == 0 ? dataInput.readInt() : (int)dataInput.readShort();
            if ((n3 & 0x1000) == 0) {
                jRObjectResult = DSPage.createJRObjectResult(n3, this.addElement, this.copyObject);
                jRObjectResult.read(dataInput, dSDataStreamable);
            } else {
                jRObjectResult = DSPage.readUDO(dataInput, dSDataStreamable);
            }
            this.add(jRObjectResult);
        }
    }

    @Override
    protected void writeProperties(DataOutput dataOutput) throws IOException {
        super.writeProperties(dataOutput);
        int n = this.Z.size();
        if (n > Short.MAX_VALUE && JRLog.isTrace(5)) {
            JRLog.trace(5, 5300028, new Object[]{this, n});
        }
        dataOutput.writeInt(n);
        for (int i = 0; i < n; ++i) {
            ((JRObjectResult)this.Z.elementAt(i)).write(dataOutput);
        }
    }

    @Override
    protected int propLength() {
        int n = super.propLength();
        n += 4;
        int n2 = this.Z.size();
        for (int i = 0; i < n2; ++i) {
            n += ((JRObjectResult)this.Z.elementAt(i)).length();
        }
        return n;
    }

    @Override
    public void dump(PrintStream printStream) {
        int n = this.Z.size();
        for (int i = 0; i < n; ++i) {
            ((JRObjectResult)this.Z.elementAt(i)).dump(printStream);
        }
    }

    public void setLocale(Locale locale) {
        this.addElement = locale;
    }

    public Locale getLocale() {
        return this.addElement;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.copyObject = timeZone;
    }

    public TimeZone getTimeZone() {
        return this.copyObject;
    }

    @Override
    public Object copyObject() {
        return this.dup(new DSContainer());
    }

    public DSContainer dup(DSContainer dSContainer) {
        super.dup(dSContainer);
        for (int i = 0; i < this.Z.size(); ++i) {
            dSContainer.add((JRObjectResult)((JRObjectResult)this.Z.elementAt(i)).copyObject());
        }
        dSContainer.addElement = this.addElement;
        dSContainer.copyObject = this.copyObject;
        return dSContainer;
    }

    @Override
    public boolean isDirty() {
        boolean bl = false;
        Enumeration enumeration = this.Z.elements();
        while (enumeration.hasMoreElements()) {
            if (!((JRObjectResult)enumeration.nextElement()).isDirty()) continue;
            return true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics graphics) {
        int n = this.getResolution();
        int n2 = this.Z.size();
        while (--n2 >= 0) {
            JRVisiableResult jRVisiableResult;
            int n3;
            JRVisiableResult jRVisiableResult2;
            int n4 = -1;
            JRObjectResult jRObjectResult = (JRObjectResult)this.Z.elementAt(n2);
            int n5 = 0;
            int n6 = 0;
            boolean bl = true;
            if (jRObjectResult instanceof DSReference) {
                bl = false;
                jRVisiableResult2 = (JRVisiableResult)((DSReference)jRObjectResult).getRefData();
            } else {
                jRVisiableResult2 = (JRVisiableResult)jRObjectResult;
            }
            int n7 = jRVisiableResult2.getY();
            if (jRVisiableResult2.isNeedAd()) {
                if (jRVisiableResult2.getStartYPos() != 0) {
                    JRObjectResult jRObjectResult2;
                    n7 = 0;
                    n3 = 0;
                    if (jRObjectResult instanceof DSSection && (jRObjectResult2 = (JRObjectResult)((Object)((DSSection)jRVisiableResult2).getParent())).getObjectType() == 33 && ((Boolean)((DSSubReport)jRObjectResult2).getPropertyByName("Embedded").getObject()).booleanValue()) {
                        n3 = Math.max(0, ((DSSection)jRVisiableResult2).getY() - ((DSSubReport)jRObjectResult2).getStartYPos());
                    }
                    n7 = (n5 = Math.max(n4, n3)) > 0 ? n5 : 0;
                } else {
                    n7 -= this.getStartYPos();
                }
                if (bl && n5 > 0) {
                    n6 = Math.min(this.getHeight(), jRVisiableResult2.getHeight());
                } else if (bl) {
                    n6 = Math.min(this.getHeight() - n7, jRVisiableResult2.getHeight());
                }
                jRVisiableResult2.setY(n7);
                jRVisiableResult2.setHeight(n6);
                jRVisiableResult2.setAd(false);
            }
            if (!(jRObjectResult instanceof JRVisiableResult) || (n3 = (int)(((Boolean)(jRVisiableResult = (JRVisiableResult)jRObjectResult).getPropertyByName("Invisible").getObject()).booleanValue() ? 1 : 0)) != 0) continue;
            Rectangle rectangle = jRVisiableResult.getBounds();
            Graphics graphics2 = graphics.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            try {
                jRVisiableResult.paint(graphics2);
            }
            finally {
                graphics2.dispose();
            }
        }
    }

    public int getRoundingMode() {
        return 6;
    }

    public void setRoundingMode(int n) {
    }
}

