/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import com.jinfonet.util.JRLog;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jet.JRStopEngineException;
import jet.connect.DbInteger;
import jet.connect.Groupable;
import jet.connect.Record;
import jet.dataengine.api.DSException;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.dataengine.api.group.GroupInfo;
import jet.datastream.Communicator;
import jet.datastream.DSContainer;
import jet.datastream.DSDataStreamable;
import jet.datastream.DSTableObject;
import jet.util.VersionControlable;

public class DSTableRow
extends DSContainer {
    private int SEDU;
    private int dup;
    private GroupInfo[] error = null;

    @Override
    protected void readProperties(DataInput dataInput, DSDataStreamable dSDataStreamable) throws IOException, JRStopEngineException {
        super.readProperties(dataInput, dSDataStreamable);
        this.SEDU = dataInput.readInt();
        if (dataInput instanceof VersionControlable) {
            int n = ((VersionControlable)((Object)dataInput)).getVersion();
            this.dup = n >= 262176 || n == 0 ? (int)dataInput.readByte() : dataInput.readInt();
        }
    }

    @Override
    protected void writeProperties(DataOutput dataOutput) throws IOException {
        super.writeProperties(dataOutput);
        dataOutput.writeInt(this.SEDU);
        dataOutput.writeByte(this.dup);
    }

    public boolean isTableHeader() {
        return this.getObjectType() == 0x1000004;
    }

    @Override
    protected int propLength() {
        int n = super.propLength();
        n += 4;
        return ++n;
    }

    public int getRecordIndex() {
        return this.SEDU;
    }

    public void setRecordIndex(int n) {
        this.SEDU = n;
    }

    public int getGroupTreeIDX() {
        return ((DSTableObject)this.getParent()).getGroupTreeIDX();
    }

    @Override
    public JRecord getRecord() {
        return ((DSTableObject)this.getParent()).getRecord(this);
    }

    @Override
    public JRecord getCalculateRecord() {
        return ((DSTableObject)this.getParent()).getCalculateRecord(this);
    }

    public DSDataStreamable getDataStream() {
        return ((DSTableObject)this.getParent()).getStream();
    }

    @Override
    public Communicator getCommunicator() {
        return this.getDataStream().getCommunicator();
    }

    public int getGroupLevel() {
        return this.dup;
    }

    public void setGroupLevel(int n) {
        this.dup = n;
    }

    @Override
    public Record getSynRecord() {
        return ((DSTableObject)this.getParent()).getSynRecord(this.SEDU);
    }

    @Override
    public Record getSynRecord2() {
        return ((DSTableObject)this.getParent()).getSynRecord2(this.SEDU);
    }

    public GroupInfo[] getGroupInfoChain() {
        block3: {
            if (this.error == null) {
                JRecord jRecord = this.getRecord();
                Groupable groupable = jRecord.getRecordModel().getGroupable();
                try {
                    this.error = groupable.peekGroupInfo(((DbInteger)jRecord.getCell((int)0)).value, this.dup);
                }
                catch (DSException dSException) {
                    if (!JRLog.isError(2)) break block3;
                    JRLog.error(2, dSException);
                }
            }
        }
        return this.error;
    }

    @Override
    public Object copyObject() {
        return this.dup(new DSTableRow());
    }

    public DSTableRow dup(DSTableRow dSTableRow) {
        super.dup(dSTableRow);
        dSTableRow.setRecordIndex(this.SEDU);
        dSTableRow.setGroupLevel(this.dup);
        return dSTableRow;
    }

    public int[][] getGroupPath() {
        try {
            JRecord jRecord = this.getRecord();
            if (jRecord.getRecordModel() == null) {
                return null;
            }
            Groupable groupable = jRecord.getRecordModel().getGroupable();
            int n = this.getObjectType();
            int n2 = this.dup;
            if (n == 0x1000001) {
                --n2;
            }
            if ((n == 0x1000004 || n == 0x1000005) && n2 <= 0) {
                int[][] nArray = new int[2][1];
                nArray[0][0] = -1;
                nArray[1][0] = 0;
                return nArray;
            }
            return groupable.peekGroupLocation(((DbInteger)jRecord.getCell((int)0)).value, n2);
        }
        catch (DSException dSException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, dSException);
            }
            return null;
        }
    }
}

