/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xlsx;

import com.jinfonet.util.JRLog;
import java.util.Vector;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import jet.export.excel.api.CellGradient;
import jet.export.excel.imp.xlsx.CellFillImp;
import jet.export.excel.imp.xlsx.XlsxDocumentException;

public class CellGradientFill
extends CellFillImp
implements CellGradient {
    private byte SEDU = 1;
    private short add = (short)-1;
    private short append = (short)-1;
    private short equals = (short)-1;
    private short get = (short)-1;
    private short isTrace = (short)-1;
    private Vector longValue = new Vector(2);

    @Override
    public void setType(byte by) {
        this.SEDU = by;
    }

    @Override
    public void setLinearDegree(short s) {
        if (s < 0 || s >= 360) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "Xlsx API: Invalid parameter " + s + " (CellGradientFill.setLinearDegree(short))");
            }
            return;
        }
        this.add = s;
    }

    @Override
    public void setPathPosition(short s, short s2, short s3, short s4) {
        if (s < 0 || s > 100 || s2 < 0 || s2 > 100 || s3 < 0 || s3 > 100 || s4 < 0 || s4 > 100) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "Xlsx API: Invalid parameter " + s + ", " + s2 + ", " + s3 + ", " + s4 + " (CellGradientFill.setPathPosition(short, short, short, short))");
            }
            return;
        }
        this.append = s;
        this.equals = s2;
        this.get = s3;
        this.isTrace = s4;
    }

    @Override
    public void addGradientStop(int n, short s) {
        if (s < 0 || s > 100) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "Xlsx API: Invalid parameter " + s + " (CellGradientFill.addGradientStop(int, short))");
            }
            return;
        }
        this.longValue.add(new Long((long)(n &= 0xFFFFFF) << 32 | (long)s));
    }

    public boolean equals(Object object) {
        if (!(object instanceof CellGradientFill)) {
            return false;
        }
        CellGradientFill cellGradientFill = (CellGradientFill)object;
        if (cellGradientFill.SEDU != this.SEDU) {
            return false;
        }
        if (cellGradientFill.add != this.add) {
            return false;
        }
        if (cellGradientFill.append != this.append) {
            return false;
        }
        if (cellGradientFill.equals != this.equals) {
            return false;
        }
        if (cellGradientFill.get != this.get) {
            return false;
        }
        if (cellGradientFill.isTrace != this.isTrace) {
            return false;
        }
        return cellGradientFill.longValue.equals(this.longValue);
    }

    public int hashCode() {
        int n = this.SEDU + this.add + this.append + this.equals + this.get + this.isTrace;
        for (int i = 0; i < this.longValue.size(); ++i) {
            n = (int)((long)n + (Long)this.longValue.get(i));
        }
        return n;
    }

    @Override
    void write(XMLStreamWriter xMLStreamWriter) throws XlsxDocumentException {
        try {
            xMLStreamWriter.writeStartElement("fill");
            xMLStreamWriter.writeStartElement("gradientFill");
            if (this.SEDU == 2) {
                xMLStreamWriter.writeAttribute("type", "path");
            }
            if (this.add != -1) {
                xMLStreamWriter.writeAttribute("degree", String.valueOf(this.add));
            }
            if (this.append != -1) {
                xMLStreamWriter.writeAttribute("top", String.valueOf((double)this.append * 1.0 / 100.0));
            }
            if (this.equals != -1) {
                xMLStreamWriter.writeAttribute("left", String.valueOf((double)this.equals * 1.0 / 100.0));
            }
            if (this.get != -1) {
                xMLStreamWriter.writeAttribute("right", String.valueOf((double)this.get * 1.0 / 100.0));
            }
            if (this.isTrace != -1) {
                xMLStreamWriter.writeAttribute("bottom", String.valueOf((double)this.isTrace * 1.0 / 100.0));
            }
            for (int i = 0; i < this.longValue.size(); ++i) {
                long l = (Long)this.longValue.get(i);
                int n = (int)l;
                int n2 = (int)(l >> 32);
                this.SEDU(xMLStreamWriter, n, n2);
            }
            if (this.longValue.size() == 0) {
                this.SEDU(xMLStreamWriter, 0, -1);
                this.SEDU(xMLStreamWriter, 100, -16777216);
            } else if (this.longValue.size() == 1) {
                this.SEDU(xMLStreamWriter, 100, -16777216);
            }
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XlsxDocumentException(xMLStreamException);
        }
    }

    private void SEDU(XMLStreamWriter xMLStreamWriter, int n, int n2) throws XMLStreamException {
        xMLStreamWriter.writeStartElement("stop");
        xMLStreamWriter.writeAttribute("position", String.valueOf((double)n * 1.0 / 100.0));
        xMLStreamWriter.writeEmptyElement("color");
        xMLStreamWriter.writeAttribute("rgb", Integer.toHexString(n2));
        xMLStreamWriter.writeEndElement();
    }
}

