/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xlsx;

import com.jinfonet.util.JRLog;
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import jet.export.excel.api.ExcelCell;
import jet.export.excel.api.ExcelImageInfo;
import jet.export.excel.api.ExcelShapeInfo;
import jet.export.excel.api.ExcelWorkSheet;
import jet.export.excel.api.LocInfo;
import jet.export.excel.api.PageInfoSetup;
import jet.export.excel.api.SparklineGroup;
import jet.export.excel.api.WindowsOptions;
import jet.export.excel.api.chart.ChartInfo;
import jet.export.excel.imp.xlsx.BlankCellImp;
import jet.export.excel.imp.xlsx.Cell;
import jet.export.excel.imp.xlsx.CellsBlockManager;
import jet.export.excel.imp.xlsx.LabelCellImp;
import jet.export.excel.imp.xlsx.Links;
import jet.export.excel.imp.xlsx.Merges;
import jet.export.excel.imp.xlsx.NoneRelsPart;
import jet.export.excel.imp.xlsx.OPCPackage;
import jet.export.excel.imp.xlsx.PageInfoSetupImp;
import jet.export.excel.imp.xlsx.PictureShape;
import jet.export.excel.imp.xlsx.SharedStringsPart;
import jet.export.excel.imp.xlsx.SimpleShape;
import jet.export.excel.imp.xlsx.SparklineGroupImp;
import jet.export.excel.imp.xlsx.StylePart;
import jet.export.excel.imp.xlsx.URLs;
import jet.export.excel.imp.xlsx.WindowsOptionsImp;
import jet.export.excel.imp.xlsx.WorksheetDrawingPart;
import jet.export.excel.imp.xlsx.XlsxDocumentException;
import jet.export.excel.imp.xlsx.chart.ChartArea;
import jet.export.excel.imp.xlsx.shapeprops.TwoCellAnchor;

public class Worksheet
extends NoneRelsPart
implements ExcelWorkSheet {
    private String SEDU;
    private int add;
    private Hashtable addNoneRelsPart = new Hashtable();
    private WorksheetDrawingPart addStyle;
    private String append;
    private SharedStringsPart close;
    private StylePart currentTimeMillis;
    private CellsBlockManager get;
    private PageInfoSetupImp getColNum;
    private WindowsOptionsImp getColSpan;
    private Vector getCount = new Vector();

    Worksheet(OPCPackage oPCPackage, int n) {
        super(oPCPackage, "sheet" + n + ".xml");
        this.add = n;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "Xlsx API: A worksheet is created. This worksheet's id is " + n);
        }
    }

    public void setSharedStringsPart(SharedStringsPart sharedStringsPart) {
        this.close = sharedStringsPart;
    }

    public void setStylePart(StylePart stylePart) {
        this.currentTimeMillis = stylePart;
    }

    public void setCellsBlockManager(CellsBlockManager cellsBlockManager) {
        this.get = cellsBlockManager;
    }

    @Override
    public void setColWidth(short s, double d) {
        this.addNoneRelsPart.put(new Short(s), new Double(d / 5.25));
    }

    @Override
    public void setRowHeight(int n, double d) throws XlsxDocumentException {
        try {
            this.get.I(n, d, this.add);
        }
        catch (IOException iOException) {
            throw new XlsxDocumentException(iOException);
        }
    }

    @Override
    public void setSheetName(String string) {
        this.SEDU = string;
    }

    @Override
    public String getSheetName() {
        return this.SEDU;
    }

    int Z() {
        return this.add;
    }

    @Override
    public void addCell(ExcelCell excelCell) throws XlsxDocumentException {
        Cell cell = (Cell)excelCell;
        try {
            LabelCellImp labelCellImp;
            Object object;
            if (cell instanceof LabelCellImp && (object = (labelCellImp = (LabelCellImp)cell).B()) != null) {
                labelCellImp.Z(this.close.I(object));
            }
            int n = -1;
            if (cell.getStyle() != null) {
                n = this.currentTimeMillis.addStyle(cell.getStyle());
                cell.I(n);
            }
            this.get.I(cell, this.add);
            if (n != -1 && (cell.getRowSpan() > 1 || cell.getColSpan() > 1)) {
                int n2 = cell.getRowNum();
                short s = cell.getColNum();
                int n3 = cell.getRowSpan();
                int n4 = cell.getColSpan();
                for (int i = 0; i < n3; ++i) {
                    for (int j = 0; j < n4; ++j) {
                        if (i == 0 && j == 0) continue;
                        BlankCellImp blankCellImp = new BlankCellImp(n2 + i, (short)(s + j));
                        blankCellImp.I(n);
                        this.get.I(blankCellImp, this.add);
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new XlsxDocumentException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void write() throws XlsxDocumentException {
        long l = 0L;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "Xlsx API: Start writing the worksheet whose id is " + this.add);
            l = System.currentTimeMillis();
        }
        try {
            XMLStreamWriter xMLStreamWriter = this.pack.C();
            try {
                Object[] objectArray;
                xMLStreamWriter.writeStartDocument(this.pack.getEncoding(), "1.0");
                xMLStreamWriter.setDefaultNamespace("http://schemas.openxmlformats.org/spreadsheetml/2006/main");
                xMLStreamWriter.setPrefix("r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships");
                xMLStreamWriter.writeStartElement("worksheet");
                xMLStreamWriter.writeDefaultNamespace("http://schemas.openxmlformats.org/spreadsheetml/2006/main");
                xMLStreamWriter.writeNamespace("r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships");
                if (this.getColNum != null) {
                    this.getColNum.I(xMLStreamWriter);
                }
                if (this.getColSpan != null) {
                    this.getColSpan.write(xMLStreamWriter);
                }
                if (this.addNoneRelsPart.size() > 0) {
                    xMLStreamWriter.writeStartElement("cols");
                    objectArray = this.addNoneRelsPart.keySet().toArray();
                    Arrays.sort(objectArray);
                    for (Object object : objectArray) {
                        Double d = (Double)this.addNoneRelsPart.get(object);
                        xMLStreamWriter.writeEmptyElement("col");
                        short s = (Short)object;
                        xMLStreamWriter.writeAttribute("min", String.valueOf(s + 1));
                        xMLStreamWriter.writeAttribute("max", String.valueOf(s + 1));
                        xMLStreamWriter.writeAttribute("width", d.toString());
                        xMLStreamWriter.writeAttribute("customWidth", "1");
                    }
                    xMLStreamWriter.writeEndElement();
                }
                objectArray = new URLs();
                Links links = new Links(this.pack.getMergeLinkTempFile(), this.pack.getPerformanceConfig().getMaxLinksInMem(), (URLs)objectArray);
                Merges merges = new Merges(this.pack.getMergeLinkTempFile(), this.pack.getPerformanceConfig().getMaxMergesInMem());
                long l2 = System.currentTimeMillis();
                xMLStreamWriter.writeStartElement("sheetData");
                this.get.I(xMLStreamWriter, links, merges, this.add);
                xMLStreamWriter.writeEndElement();
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "Xlsx API: Writing cells of the worksheet whose id is " + this.add + " spends " + (System.currentTimeMillis() - l2) + " ms.");
                    l2 = System.currentTimeMillis();
                }
                merges.write(xMLStreamWriter);
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "Xlsx API: Writing merges of the worksheet whose id is " + this.add + " spends " + (System.currentTimeMillis() - l2) + " ms.");
                    l2 = System.currentTimeMillis();
                }
                links.write(xMLStreamWriter);
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "Xlsx API: Writing links of the worksheet whose id is " + this.add + " spends " + (System.currentTimeMillis() - l2) + " ms.");
                }
                if (objectArray.getCount() > 0) {
                    this.getRelsPart(true).setURLs((URLs)objectArray);
                }
                if (this.getColNum != null) {
                    this.getColNum.Z(xMLStreamWriter);
                }
                if (this.append != null) {
                    xMLStreamWriter.writeEmptyElement("drawing");
                    xMLStreamWriter.writeAttribute("r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships", "id", this.append);
                }
                if (this.getCount.size() > 0) {
                    xMLStreamWriter.writeStartElement("extLst");
                    xMLStreamWriter.setPrefix("x14", "http://schemas.microsoft.com/office/spreadsheetml/2009/9/main");
                    xMLStreamWriter.writeStartElement("ext");
                    xMLStreamWriter.writeNamespace("x14", "http://schemas.microsoft.com/office/spreadsheetml/2009/9/main");
                    xMLStreamWriter.writeAttribute("uri", "{05C60535-1F16-4fd2-B633-F4F36F0B64E0}");
                    xMLStreamWriter.setPrefix("xm", "http://schemas.microsoft.com/office/excel/2006/main");
                    xMLStreamWriter.writeStartElement("x14", "sparklineGroups", "http://schemas.microsoft.com/office/spreadsheetml/2009/9/main");
                    xMLStreamWriter.writeNamespace("xm", "http://schemas.microsoft.com/office/excel/2006/main");
                    for (int i = 0; i < this.getCount.size(); ++i) {
                        SparklineGroupImp sparklineGroupImp = (SparklineGroupImp)this.getCount.get(i);
                        sparklineGroupImp.write(xMLStreamWriter);
                    }
                    xMLStreamWriter.writeEndElement();
                    xMLStreamWriter.writeEndElement();
                    xMLStreamWriter.writeEndElement();
                }
                xMLStreamWriter.writeEndElement();
                xMLStreamWriter.writeEndDocument();
            }
            finally {
                xMLStreamWriter.close();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XlsxDocumentException(xMLStreamException);
        }
        catch (IOException iOException) {
            throw new XlsxDocumentException(iOException);
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "Xlsx API: Finish writing the worksheet whose id is " + this.add + ". The time spent is " + (System.currentTimeMillis() - l) + " ms.");
        }
    }

    @Override
    public void addImage(ExcelImageInfo excelImageInfo, LocInfo locInfo) throws XlsxDocumentException {
        try {
            this.SEDU().I((PictureShape)excelImageInfo, (TwoCellAnchor)locInfo);
        }
        catch (IOException iOException) {
            throw new XlsxDocumentException(iOException);
        }
    }

    @Override
    public void addShape(ExcelShapeInfo excelShapeInfo, LocInfo locInfo) throws XlsxDocumentException {
        try {
            this.SEDU().I((SimpleShape)excelShapeInfo, (TwoCellAnchor)locInfo);
        }
        catch (IOException iOException) {
            throw new XlsxDocumentException(iOException);
        }
    }

    @Override
    public void addChart(ChartInfo chartInfo, LocInfo locInfo) throws XlsxDocumentException {
        WorksheetDrawingPart worksheetDrawingPart = this.SEDU();
        try {
            worksheetDrawingPart.I((ChartArea)chartInfo, (TwoCellAnchor)locInfo);
        }
        catch (IOException iOException) {
            throw new XlsxDocumentException(iOException);
        }
    }

    WorksheetDrawingPart SEDU() {
        if (this.addStyle == null) {
            int n = this.pack.getDrawingCount() + 1;
            this.pack.setDrawingCount(n);
            this.addStyle = new WorksheetDrawingPart(this.pack, n);
            this.append = this.getRelsPart(true).addNoneRelsPart(this.addStyle);
        }
        return this.addStyle;
    }

    @Override
    public String getTargetName() {
        return "worksheets/" + this.partNameSuffix;
    }

    @Override
    public String getTargetType() {
        return "http://schemas.openxmlformats.org/officeDocument/2006/relationships/worksheet";
    }

    @Override
    String getPartName() {
        return "/xl/worksheets/" + this.partNameSuffix;
    }

    @Override
    String getZipItemName() {
        return "xl/worksheets/" + this.partNameSuffix;
    }

    @Override
    String getExtension() {
        return "xml";
    }

    @Override
    String getContentType() {
        return "application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml";
    }

    @Override
    public boolean isExternal() {
        return false;
    }

    @Override
    public void setPageInfo(PageInfoSetup pageInfoSetup) {
        this.getColNum = (PageInfoSetupImp)pageInfoSetup;
    }

    @Override
    public void setWindowsOption(WindowsOptions windowsOptions) {
        this.getColSpan = (WindowsOptionsImp)windowsOptions;
    }

    @Override
    public void addSparklineGroup(SparklineGroup sparklineGroup) {
        this.getCount.add((SparklineGroupImp)sparklineGroup);
    }
}

