/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xlsx.chart;

import com.jinfonet.util.JRLog;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import jet.export.excel.api.chart.BarColumn3DType;
import jet.export.excel.api.chart.Series1VInfo;
import jet.export.excel.imp.xlsx.NoneRelsPart;
import jet.export.excel.imp.xlsx.XlsxDocumentException;
import jet.export.excel.imp.xlsx.chart.BarSeries;
import jet.export.excel.imp.xlsx.chart.Common3DChartType;

public class Bar3DChartType
extends Common3DChartType
implements BarColumn3DType {
    private byte SEDU = 0;
    private byte add = (byte)2;
    private short append = (short)-1;
    private short getSeriesByIndex = (short)-1;
    private byte isTrace = (byte)-1;

    public Bar3DChartType() {
        super("bar3DChart");
    }

    public void setBarDirection(byte by) {
        this.add = by;
    }

    public void setShape(byte by) {
        this.isTrace = by;
    }

    @Override
    public boolean supportsXCategoryAxis() {
        return true;
    }

    @Override
    public boolean supportsXValueAxis() {
        return false;
    }

    @Override
    public boolean supportsYValueAxis() {
        return true;
    }

    @Override
    public boolean supportsZSeriesAxis() {
        return this.SEDU == 0;
    }

    @Override
    void write1stSpecificProps(XMLStreamWriter xMLStreamWriter, NoneRelsPart noneRelsPart) throws XlsxDocumentException {
        try {
            xMLStreamWriter.writeEmptyElement("c", "barDir", "http://schemas.openxmlformats.org/drawingml/2006/chart");
            if (this.add == 1) {
                xMLStreamWriter.writeAttribute("val", "bar");
            } else {
                xMLStreamWriter.writeAttribute("val", "col");
            }
            xMLStreamWriter.writeEmptyElement("c", "grouping", "http://schemas.openxmlformats.org/drawingml/2006/chart");
            switch (this.SEDU) {
                case 7: {
                    xMLStreamWriter.writeAttribute("val", "clustered");
                    break;
                }
                case 6: {
                    xMLStreamWriter.writeAttribute("val", "percentStacked");
                    break;
                }
                case 2: {
                    xMLStreamWriter.writeAttribute("val", "stacked");
                    break;
                }
                case 0: {
                    xMLStreamWriter.writeAttribute("val", "standard");
                    break;
                }
                default: {
                    xMLStreamWriter.writeAttribute("val", "standard");
                    break;
                }
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XlsxDocumentException(xMLStreamException);
        }
    }

    @Override
    void write2ndSpecificProps(XMLStreamWriter xMLStreamWriter, NoneRelsPart noneRelsPart) throws XlsxDocumentException {
        try {
            if (this.getSeriesByIndex != -1) {
                xMLStreamWriter.writeEmptyElement("c", "gapWidth", "http://schemas.openxmlformats.org/drawingml/2006/chart");
                xMLStreamWriter.writeAttribute("val", String.valueOf(this.getSeriesByIndex));
            }
            if (this.append != -1) {
                xMLStreamWriter.writeEmptyElement("c", "gapDepth", "http://schemas.openxmlformats.org/drawingml/2006/chart");
                xMLStreamWriter.writeAttribute("val", String.valueOf(this.append));
            }
            if (this.isTrace != -1) {
                xMLStreamWriter.writeEmptyElement("c", "shape", "http://schemas.openxmlformats.org/drawingml/2006/chart");
                switch (this.isTrace) {
                    case 1: {
                        xMLStreamWriter.writeAttribute("val", "box");
                        break;
                    }
                    case 5: {
                        xMLStreamWriter.writeAttribute("val", "cone");
                        break;
                    }
                    case 6: {
                        xMLStreamWriter.writeAttribute("val", "coneToMax");
                        break;
                    }
                    case 4: {
                        xMLStreamWriter.writeAttribute("val", "cylinder");
                        break;
                    }
                    case 2: {
                        xMLStreamWriter.writeAttribute("val", "pyramid");
                        break;
                    }
                    case 3: {
                        xMLStreamWriter.writeAttribute("val", "pyramidToMax");
                        break;
                    }
                }
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XlsxDocumentException(xMLStreamException);
        }
    }

    @Override
    public void setGapWidth(int n) {
        if (n < 0 || n > 500) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "Xlsx API: Invalid parameter " + n + " (Bar3DChartType.setGapWidth(int))");
            }
            return;
        }
        this.getSeriesByIndex = (short)n;
    }

    @Override
    public void setSubType(byte by) {
        this.SEDU = by;
    }

    @Override
    public byte getType() {
        return 6;
    }

    @Override
    public boolean is1VSeriesChartType() {
        return true;
    }

    @Override
    public boolean is2VSeriesChartType() {
        return false;
    }

    @Override
    public boolean is3VSeriesChartType() {
        return false;
    }

    @Override
    public void addSeries(Series1VInfo series1VInfo) {
        if (series1VInfo instanceof BarSeries) {
            this.seriesContainer.add((BarSeries)series1VInfo);
        }
    }

    @Override
    public Series1VInfo getSeries(int n) {
        return (BarSeries)this.getSeriesByIndex(n);
    }

    @Override
    public void setGap(short s) {
        if (s < 0 || s > 500) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "Xlsx API: Invalid parameter " + s + " (Bar3DChartType.setGap(short))");
            }
            return;
        }
        this.append = s;
    }

    @Override
    public boolean isBar() {
        return this.add == 1;
    }

    @Override
    void prepareWriting() {
    }

    @Override
    public boolean supportsXDateAxis() {
        return true;
    }
}

