/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xlsx.util;

import com.jinfonet.resstore.OutOfSpaceException;
import com.jinfonet.util.JRLog;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import jet.export.excel.imp.xlsx.XlsxDocumentException;
import jet.export.excel.imp.xlsx.util.RandomAccessFileWrapper;
import jet.export.util.Cache;

public class TempFilesManager {
    private Vector SEDU = new Vector();
    private Vector add = new Vector();
    private Cache append;

    public TempFilesManager(Cache cache) throws XlsxDocumentException {
        this.append = cache;
        if (JRLog.isTrace(6)) {
            try {
                JRLog.trace(6, "Xlsx API: The path to store temporary files in is " + cache.getTemporaryPath().getAbsolutePath() + ".");
            }
            catch (OutOfSpaceException outOfSpaceException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, outOfSpaceException);
                }
                throw new XlsxDocumentException(outOfSpaceException);
            }
            catch (IOException iOException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, iOException);
                }
                throw new XlsxDocumentException(iOException);
            }
        }
    }

    public File createTempFile() throws XlsxDocumentException {
        try {
            File file = this.append.getNextTemporaryFile();
            this.SEDU.add(file);
            return file;
        }
        catch (OutOfSpaceException outOfSpaceException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, outOfSpaceException);
            }
            throw new XlsxDocumentException(outOfSpaceException);
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, iOException);
            }
            throw new XlsxDocumentException(iOException);
        }
    }

    public Cache getCache() {
        return this.append;
    }

    public RandomAccessFileWrapper createTempRAF() throws XlsxDocumentException {
        try {
            RandomAccessFileWrapper randomAccessFileWrapper = new RandomAccessFileWrapper(this.createTempFile(), "rw");
            this.add.add(randomAccessFileWrapper);
            return randomAccessFileWrapper;
        }
        catch (IOException iOException) {
            throw new XlsxDocumentException(iOException);
        }
    }

    public void deleteAllTempFiles() throws XlsxDocumentException {
        try {
            for (Object object : this.add) {
                ((RandomAccessFileWrapper)object).getRaFile().close();
            }
            this.add.removeAllElements();
            for (Object object : this.SEDU) {
                if (!((File)object).exists()) continue;
                this.append.delete((File)object);
            }
            this.SEDU.removeAllElements();
        }
        catch (IOException iOException) {
            throw new XlsxDocumentException(iOException);
        }
    }
}

