/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.type1;

import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import java.util.Vector;
import jet.datastream.CTGridInfo;
import jet.datastream.DSBody;
import jet.datastream.DSCTField;
import jet.datastream.DSContainer;
import jet.datastream.DSCrossTab;
import jet.datastream.DSField;
import jet.datastream.DSParagraph;
import jet.datastream.DSParagraphText;
import jet.datastream.DSParameterForm;
import jet.datastream.DSSection;
import jet.datastream.DSSubReport;
import jet.datastream.DSTableRow;
import jet.datastream.DSTemplatible;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.datastream.render.RenderText;
import jet.export.ExportAuxInfo;
import jet.export.excel.ExcelCache;
import jet.export.excel.ExcelFontInfo;
import jet.export.excel.ExcelToolkit;
import jet.export.excel.api.CellPattern;
import jet.export.excel.api.CellStyle;
import jet.export.excel.api.ExcelFactory;
import jet.export.excel.api.ExcelFont;
import jet.export.excel.type1.CellStyleInfo;
import jet.export.util.CCUtil;
import jet.export.util.FontInfo;
import jet.udos.JHyperLinkRslt;
import jet.util.Containable;
import jet.util.image.ImageResource;
import jet.util.nls.INLSMap;

class ReportFormatCache
extends ExcelCache {
    private Hashtable BLACK = new Hashtable();
    private Hashtable SEDU = new Hashtable();
    private int addChangedByProps = 0;

    public ReportFormatCache(boolean bl, ExportAuxInfo exportAuxInfo, boolean bl2, int n) {
        super(bl, exportAuxInfo, "MatchLayout", bl2);
        this.addChangedByProps = n;
    }

    public int getExtendedTextWidth(JRVisiableResult jRVisiableResult) {
        int n;
        int n2;
        Object object;
        Object object2;
        int n3 = jRVisiableResult.getWidth();
        String string = null;
        if (jRVisiableResult instanceof DSParagraphText) {
            string = ((DSParagraphText)jRVisiableResult).getText();
        } else if (jRVisiableResult instanceof DSField && jRVisiableResult.getParent() instanceof DSParagraph && (object2 = ((DSField)jRVisiableResult).getRender()) instanceof RenderText && (object = ((RenderText)object2).getVLines()) != null) {
            string = (String)((Vector)object).get(0);
        }
        object2 = this.getFontInfo(jRVisiableResult);
        object = ((FontInfo)object2).getFontName();
        boolean bl = CCUtil.getBooleanPropertyByName(jRVisiableResult, "Bold");
        boolean bl2 = CCUtil.getBooleanPropertyByName(jRVisiableResult, "Italic");
        ExcelFontInfo excelFontInfo = this.getExcelFontInfo((String)object, bl, bl2);
        double d = this.BORDERLINENAME(((FontInfo)object2).getFontSize());
        int n4 = 0;
        if (excelFontInfo.isBold()) {
            n4 |= 1;
        }
        if (excelFontInfo.isItalic()) {
            n4 |= 2;
        }
        if ((n2 = CCUtil.getIntPropertyByName(jRVisiableResult, "SupersubScript")) == 1) {
            return n3;
        }
        if (n2 == 2) {
            return n3;
        }
        Font font = new Font(excelFontInfo.getFontFamily(), n4, (int)Math.round(d));
        FontMetrics fontMetrics = ReportFormatCache.BLACK(font);
        double d2 = 0.0;
        int n5 = 0;
        if (string != null) {
            d2 = fontMetrics.stringWidth(string);
            n5 = string.length();
        }
        return n3 > (n = this.SEDU(d2 += (double)fontMetrics.charWidth('1') * ((double)(n5 + 11) * 0.052))) ? n3 : n;
    }

    private static FontMetrics BLACK(Font font) {
        BufferedImage bufferedImage = new BufferedImage(1, 1, 3);
        Graphics graphics = bufferedImage.getGraphics();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.dispose();
        bufferedImage = null;
        return fontMetrics;
    }

    private double BORDERLINENAME(int n) {
        return Unit.convertUnitToInch(n) * 72.0;
    }

    private int SEDU(double d) {
        return Unit.convertInchToUnit(d / 72.0);
    }

    public void registerForNLS(JRVisiableResult jRVisiableResult) {
        DSTemplatible dSTemplatible = jRVisiableResult.getTemplate();
        INLSMap iNLSMap = this.getCurrentINLSMap();
        if (iNLSMap != null) {
            this.BLACK.put(dSTemplatible, iNLSMap);
        }
    }

    @Override
    public FontInfo getFontInfo(DSField dSField) {
        this.setCurrentINLSMap((INLSMap)this.BLACK.get(dSField.getTemplate()));
        return super.getFontInfo(dSField);
    }

    @Override
    public FontInfo getFontInfo(DSParagraph dSParagraph) {
        this.setCurrentINLSMap((INLSMap)this.BLACK.get(dSParagraph.getTemplate()));
        return super.getFontInfo(dSParagraph);
    }

    @Override
    public FontInfo getFontInfo(DSParagraphText dSParagraphText) {
        this.setCurrentINLSMap((INLSMap)this.BLACK.get(dSParagraphText.getTemplate()));
        return super.getFontInfo(dSParagraphText);
    }

    @Override
    public FontInfo getUdoFontInfo(JRVisiableResult jRVisiableResult) {
        this.setCurrentINLSMap((INLSMap)this.BLACK.get(jRVisiableResult.getTemplate()));
        return super.getUdoFontInfo(jRVisiableResult);
    }

    @Override
    public FontInfo getFontInfo(DSParameterForm dSParameterForm) {
        this.setCurrentINLSMap((INLSMap)this.BLACK.get(dSParameterForm.getTemplate()));
        return super.getUdoFontInfo(dSParameterForm);
    }

    @Override
    public FontInfo getFontInfo(JRVisiableResult jRVisiableResult) {
        this.setCurrentINLSMap((INLSMap)this.BLACK.get(jRVisiableResult.getTemplate()));
        return super.getFontInfo(jRVisiableResult);
    }

    public CellStyle createCellStyle(JRVisiableResult jRVisiableResult, ExcelFactory excelFactory) {
        Object object;
        DSTemplatible dSTemplatible = jRVisiableResult.getTemplate();
        CellStyleInfo cellStyleInfo = (CellStyleInfo)this.SEDU.get(dSTemplatible);
        if (cellStyleInfo != null) {
            object = cellStyleInfo.getChangedByProps();
            if (object != null) {
                cellStyleInfo = cellStyleInfo.copy();
                block11: for (int i = 0; i < object.size(); ++i) {
                    int n = (Integer)object.get(i);
                    switch (n) {
                        case 1: {
                            this.blue(cellStyleInfo, jRVisiableResult, false);
                            continue block11;
                        }
                        case 2: {
                            this.booleanValue(cellStyleInfo, jRVisiableResult, false);
                            continue block11;
                        }
                        case 3: {
                            this.charWidth(cellStyleInfo, jRVisiableResult, false);
                            continue block11;
                        }
                        case 4: {
                            this.convertInchToUnit(cellStyleInfo, jRVisiableResult, false);
                            continue block11;
                        }
                        case 5: {
                            this.convertUnitToInch(cellStyleInfo, jRVisiableResult, false);
                            continue block11;
                        }
                        case 6: {
                            this.createCellPattern(cellStyleInfo, jRVisiableResult, false);
                            continue block11;
                        }
                        case 7: {
                            this.createCellStyle(cellStyleInfo, jRVisiableResult, false);
                            continue block11;
                        }
                        case 8: {
                            this.createFont(cellStyleInfo, jRVisiableResult, false);
                            continue block11;
                        }
                        case 9: {
                            this.get(cellStyleInfo, jRVisiableResult, this.addChangedByProps, false);
                        }
                    }
                }
            }
        } else {
            cellStyleInfo = new CellStyleInfo();
            this.addChangedByProps(cellStyleInfo, jRVisiableResult, true);
            this.black(cellStyleInfo, jRVisiableResult, true);
            this.blue(cellStyleInfo, jRVisiableResult, true);
            this.booleanValue(cellStyleInfo, jRVisiableResult, true);
            this.charWidth(cellStyleInfo, jRVisiableResult, true);
            this.convertInchToUnit(cellStyleInfo, jRVisiableResult, true);
            this.convertUnitToInch(cellStyleInfo, jRVisiableResult, true);
            this.copy(cellStyleInfo, jRVisiableResult, true);
            this.createCellPattern(cellStyleInfo, jRVisiableResult, true);
            this.createCellStyle(cellStyleInfo, jRVisiableResult, true);
            this.createFont(cellStyleInfo, jRVisiableResult, true);
            this.get(cellStyleInfo, jRVisiableResult, this.addChangedByProps, true);
            this.SEDU.put(dSTemplatible, cellStyleInfo);
        }
        object = excelFactory.createCellStyle();
        object.setHAlignment(cellStyleInfo.getHAlign());
        object.setVAlignment(cellStyleInfo.getVAlign());
        CellPattern cellPattern = excelFactory.createCellPattern(cellStyleInfo.getFillStyle(), cellStyleInfo.getPatternColor(), cellStyleInfo.getBackColor());
        object.setFill(cellPattern);
        ExcelFont excelFont = excelFactory.createFont(cellStyleInfo.getFontFamily(), cellStyleInfo.getFontSize());
        excelFont.setFontColor(cellStyleInfo.getFontColor());
        excelFont.setIsBold(cellStyleInfo.getIsBold());
        excelFont.setIsItalic(cellStyleInfo.getIsItalic());
        if (cellStyleInfo.getShadowIsSet()) {
            excelFont.setIsShadow(cellStyleInfo.getShadow());
        }
        if (cellStyleInfo.getStrickoutIsSet()) {
            excelFont.setIsStruckout(cellStyleInfo.getStrickout());
        }
        if (cellStyleInfo.getUnderlineIsSet()) {
            excelFont.setUnderline(cellStyleInfo.getUnderline());
        }
        object.setFont(excelFont);
        if (cellStyleInfo.getWordWrapIsSet()) {
            object.setIsWordWrap(cellStyleInfo.getWordWrap());
        }
        object.setBorderColorTop(cellStyleInfo.getBorderTopColor());
        object.setBorderColorLeft(cellStyleInfo.getBorderLeftColor());
        object.setBorderColorBottom(cellStyleInfo.getBorderBottomColor());
        object.setBorderColorRight(cellStyleInfo.getBorderRightColor());
        if (cellStyleInfo.getBorderStyleIsSet()) {
            object.setBorderTop(cellStyleInfo.getBorderTop());
            object.setBorderLeft(cellStyleInfo.getBorderLeft());
            object.setBorderBottom(cellStyleInfo.getBorderBottom());
            object.setBorderRight(cellStyleInfo.getBorderRight());
        }
        return object;
    }

    private void addChangedByProps(CellStyleInfo cellStyleInfo, JRVisiableResult jRVisiableResult, boolean bl) {
        int n = CCUtil.getIntPropertyByName(jRVisiableResult, "HorizontalAlignment");
        int n2 = 1;
        switch (n) {
            default: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 5;
            }
        }
        cellStyleInfo.setHAlign(n2);
    }

    private void black(CellStyleInfo cellStyleInfo, JRVisiableResult jRVisiableResult, boolean bl) {
        int n = 65487;
        if (!(jRVisiableResult instanceof DSParagraphText)) {
            DSParagraph dSParagraph;
            Boolean bl2;
            int n2 = CCUtil.getIntPropertyByName(jRVisiableResult, "VerticalAlignment");
            switch (n2) {
                case 2: {
                    n = 32;
                    break;
                }
                case 0: {
                    n = 16;
                    break;
                }
                default: {
                    n = 65487;
                }
            }
            if (jRVisiableResult.getParent() instanceof DSParagraph && !(bl2 = (Boolean)(dSParagraph = (DSParagraph)jRVisiableResult.getParent()).getTemplate().getPropertyByName("Spacing_type").getObject()).booleanValue()) {
                n = 32;
            }
        } else if (jRVisiableResult instanceof DSParagraphText) {
            DSParagraph dSParagraph = (DSParagraph)jRVisiableResult.getParent();
            Boolean bl3 = (Boolean)dSParagraph.getTemplate().getPropertyByName("Spacing_type").getObject();
            n = bl3 != false ? 65487 : 32;
        }
        cellStyleInfo.setVAlign(n);
    }

    private void blue(CellStyleInfo cellStyleInfo, JRVisiableResult jRVisiableResult, boolean bl) {
        Color color = null;
        if (jRVisiableResult instanceof DSField) {
            color = CCUtil.getColorPropertyByName(jRVisiableResult, "Foreground");
            if (color == null) {
                color = Color.black;
            }
            if (bl && CCUtil.isChangeByFormularProperty(jRVisiableResult, "Foreground")) {
                cellStyleInfo.addChangedByProps(1);
            }
        } else if (jRVisiableResult instanceof DSParagraphText) {
            color = (Color)jRVisiableResult.getPropertyByName("Foreground").getObject();
        } else if (jRVisiableResult instanceof JHyperLinkRslt) {
            ImageResource imageResource = jRVisiableResult.getImgResourceByPropertyName("displayImage");
            if (imageResource == null || imageResource.getImage() == null) {
                color = (Color)jRVisiableResult.getPropertyByName("foreground").getObject();
                if (bl && CCUtil.isChangeByFormularProperty(jRVisiableResult, "foreground")) {
                    cellStyleInfo.addChangedByProps(1);
                }
            }
            if (bl && CCUtil.isChangeByFormularProperty(jRVisiableResult, "displayImage")) {
                cellStyleInfo.addChangedByProps(1);
            }
        }
        cellStyleInfo.setFontColor(color);
    }

    private void booleanValue(CellStyleInfo cellStyleInfo, JRVisiableResult jRVisiableResult, boolean bl) {
        Color color = null;
        if (jRVisiableResult instanceof DSField) {
            color = CCUtil.getColorPropertyByName(jRVisiableResult, "PatternColor");
            if (bl && CCUtil.isChangeByFormularProperty(jRVisiableResult, "PatternColor")) {
                cellStyleInfo.addChangedByProps(2);
            }
        }
        cellStyleInfo.setPatternColor(color);
    }

    private void charWidth(CellStyleInfo cellStyleInfo, JRVisiableResult jRVisiableResult, boolean bl) {
        if (jRVisiableResult instanceof DSField) {
            Color color = CCUtil.getColorPropertyByName(jRVisiableResult, "Background");
            if (bl && CCUtil.isChangeByFormularProperty(jRVisiableResult, "Background")) {
                cellStyleInfo.addChangedByProps(3);
            }
            if (jRVisiableResult instanceof DSCTField) {
                Object object;
                if (color == null && (object = ((DSCTField)jRVisiableResult).getParentGridInfo()) != null) {
                    if (((CTGridInfo)object).fillColor != null) {
                        color = ((CTGridInfo)object).fillColor;
                    }
                    if (bl) {
                        cellStyleInfo.addChangedByProps(3);
                    }
                }
                if (color == null && jRVisiableResult.getParent() != null && (object = jRVisiableResult.getParent()) instanceof DSContainer) {
                    Color color2 = CCUtil.getColorPropertyByName((DSContainer)object, "Background");
                    if (bl && CCUtil.isChangeByFormularProperty((DSContainer)object, "Background")) {
                        cellStyleInfo.addChangedByProps(3);
                    }
                    if (color2 != null) {
                        color = color2;
                    }
                }
            } else if (color == null) {
                color = ReportFormatCache.clear(cellStyleInfo, color, jRVisiableResult, 0, bl);
            }
            cellStyleInfo.setBackColor(color);
        } else if (jRVisiableResult instanceof DSParagraphText) {
            cellStyleInfo.setBackColor((Color)jRVisiableResult.getPropertyByName("Background").getObject());
        } else {
            if (jRVisiableResult instanceof JHyperLinkRslt) {
                ImageResource imageResource = jRVisiableResult.getImgResourceByPropertyName("displayImage");
                if (bl && CCUtil.isChangeByFormularProperty(jRVisiableResult, "displayImage")) {
                    cellStyleInfo.addChangedByProps(3);
                }
                if (imageResource == null || imageResource.getImage() == null) {
                    cellStyleInfo.setBackColor((Color)jRVisiableResult.getPropertyByName("background").getObject());
                    if (bl && CCUtil.isChangeByFormularProperty(jRVisiableResult, "background")) {
                        cellStyleInfo.addChangedByProps(3);
                    }
                    return;
                }
            }
            cellStyleInfo.setBackColor(Color.blue);
        }
    }

    private static Color clear(CellStyleInfo cellStyleInfo, Color color, JRVisiableResult jRVisiableResult, int n, boolean bl) {
        ++n;
        Containable containable = jRVisiableResult.getParent();
        if (containable != null && containable instanceof DSContainer) {
            int n2;
            if ((containable instanceof DSSection || containable instanceof DSTableRow || containable instanceof DSBody) && (n2 = CCUtil.getIntPropertyByName((JRObjectResult)((Object)containable), "BackgroundType")) != 0) {
                return color;
            }
            color = CCUtil.getColorPropertyByName((DSContainer)containable, "Background");
            if (bl && (containable instanceof DSSubReport || CCUtil.isChangeByFormularProperty((JRObjectResult)((Object)containable), "Background"))) {
                cellStyleInfo.addChangedByProps(3);
            }
            if (color == null && n <= 4) {
                color = ReportFormatCache.clear(cellStyleInfo, color, (DSContainer)containable, n, bl);
            }
        }
        return color;
    }

    private void convertInchToUnit(CellStyleInfo cellStyleInfo, JRVisiableResult jRVisiableResult, boolean bl) {
        Color color = null;
        if (jRVisiableResult instanceof DSField) {
            color = CCUtil.getColorPropertyByName(jRVisiableResult, "BorderColor");
            if (bl && CCUtil.isChangeByFormularProperty(jRVisiableResult, "BorderColor")) {
                cellStyleInfo.addChangedByProps(4);
            }
        }
        if (color == null) {
            color = Color.BLACK;
        }
        Color[] colorArray = new Color[4];
        if (!(jRVisiableResult instanceof JHyperLinkRslt)) {
            Object object;
            short s = (short)(Unit.convertUnitToInch(CCUtil.getIntPropertyByName(jRVisiableResult, "BorderWidth")) * 1440.0);
            Color color2 = null;
            boolean bl2 = false;
            short[] sArray = null;
            if (jRVisiableResult instanceof DSCTField) {
                object = (DSCrossTab)jRVisiableResult.getParent();
                bl2 = CCUtil.getBooleanPropertyByName((JRObjectResult)object, "Hasborder");
                if (bl && CCUtil.isChangeByFormularProperty((JRObjectResult)object, "Hasborder")) {
                    cellStyleInfo.addChangedByProps(4);
                }
            }
            object = new int[4];
            for (int i = 0; i < 4; ++i) {
                object[i] = CCUtil.getIntPropertyByName(jRVisiableResult, BORDERLINENAME[i]);
            }
            short[] sArray2 = new short[4];
            for (int i = 0; i < 4; ++i) {
                sArray2[i] = this.getExcelBorderStyle(s, object[i]);
                colorArray[i] = color;
                if (!(jRVisiableResult instanceof DSCTField) || sArray2[i] != 0 || !bl2) continue;
                if (color2 == null) {
                    DSCrossTab dSCrossTab = (DSCrossTab)jRVisiableResult.getParent();
                    color2 = CCUtil.getColorPropertyByName(dSCrossTab, "BorderColor");
                    if (bl && CCUtil.isChangeByFormularProperty(dSCrossTab, "BorderColor")) {
                        cellStyleInfo.addChangedByProps(4);
                    }
                    if (color2 == null) {
                        color2 = Color.BLACK;
                    }
                }
                if (sArray == null) {
                    sArray = ReportFormatCache.fillColor((DSCTField)jRVisiableResult);
                }
                colorArray[i] = color2;
                sArray2[i] = sArray[i];
            }
            cellStyleInfo.setBorderStyle(sArray2[0], sArray2[2], sArray2[1], sArray2[3]);
        } else {
            for (int i = 0; i < 4; ++i) {
                colorArray[i] = color;
            }
        }
        cellStyleInfo.setBorderColor(colorArray[0], colorArray[2], colorArray[1], colorArray[3]);
    }

    private void convertUnitToInch(CellStyleInfo cellStyleInfo, JRVisiableResult jRVisiableResult, boolean bl) {
        FontInfo fontInfo = null;
        fontInfo = jRVisiableResult instanceof DSField ? this.getFontInfo((DSField)jRVisiableResult) : (jRVisiableResult instanceof DSParagraphText ? this.getFontInfo((DSParagraphText)jRVisiableResult) : this.getUdoFontInfo(jRVisiableResult));
        String string = fontInfo.getFontName();
        int n = fontInfo.getFontSize();
        if (bl && !fontInfo.isCanBeCache()) {
            cellStyleInfo.addChangedByProps(5);
        }
        String string2 = ExcelToolkit.getFontBoldPropertyNamebyObject(jRVisiableResult);
        boolean bl2 = jRVisiableResult instanceof JHyperLinkRslt ? (Boolean)((JHyperLinkRslt)jRVisiableResult).getPropertyByName(string2).getObject() : CCUtil.getBooleanPropertyByName(jRVisiableResult, string2);
        if (bl && CCUtil.isChangeByFormularProperty(jRVisiableResult, string2)) {
            cellStyleInfo.addChangedByProps(5);
        }
        string2 = ExcelToolkit.getFontItalicPropertyNamebyObject(jRVisiableResult);
        boolean bl3 = jRVisiableResult instanceof JHyperLinkRslt ? (Boolean)((JHyperLinkRslt)jRVisiableResult).getPropertyByName(string2).getObject() : CCUtil.getBooleanPropertyByName(jRVisiableResult, string2);
        if (bl && CCUtil.isChangeByFormularProperty(jRVisiableResult, string2)) {
            cellStyleInfo.addChangedByProps(5);
        }
        ExcelFontInfo excelFontInfo = this.getExcelFontInfo(string, bl2, bl3);
        cellStyleInfo.setFontFamily(excelFontInfo.getFontFamily());
        cellStyleInfo.setFontSize(this.BORDERLINENAME(n));
        cellStyleInfo.setIsBold(excelFontInfo.isBold());
        cellStyleInfo.setIsItalic(excelFontInfo.isItalic());
    }

    private void copy(CellStyleInfo cellStyleInfo, JRVisiableResult jRVisiableResult, boolean bl) {
        int n = 1;
        if (jRVisiableResult instanceof DSField) {
            n = this.dispose(CCUtil.getIntPropertyByName(jRVisiableResult, "PatternStyle"));
        }
        cellStyleInfo.setFillStyle(n);
    }

    private void createCellPattern(CellStyleInfo cellStyleInfo, JRVisiableResult jRVisiableResult, boolean bl) {
        if (!(jRVisiableResult instanceof JHyperLinkRslt)) {
            boolean bl2 = CCUtil.getBooleanPropertyByName(jRVisiableResult, "StrikeOut");
            if (bl && CCUtil.isChangeByFormularProperty(jRVisiableResult, "StrikeOut")) {
                cellStyleInfo.addChangedByProps(6);
            }
            cellStyleInfo.setStrickout(bl2);
        }
    }

    private void createCellStyle(CellStyleInfo cellStyleInfo, JRVisiableResult jRVisiableResult, boolean bl) {
        if (!(jRVisiableResult instanceof JHyperLinkRslt)) {
            boolean bl2 = CCUtil.getBooleanPropertyByName(jRVisiableResult, "Underline");
            if (bl && CCUtil.isChangeByFormularProperty(jRVisiableResult, "Underline")) {
                cellStyleInfo.addChangedByProps(7);
            }
            if (bl2) {
                cellStyleInfo.setUnderline((byte)1);
            } else {
                cellStyleInfo.resetUnderline();
            }
        } else {
            boolean bl3 = CCUtil.getBooleanPropertyByName(jRVisiableResult, "EnableHyperlinkOnExcel");
            if (bl && CCUtil.isChangeByFormularProperty(jRVisiableResult, "EnableHyperlinkOnExcel")) {
                cellStyleInfo.addChangedByProps(7);
            }
            if (bl3) {
                cellStyleInfo.setUnderline((byte)1);
            } else {
                cellStyleInfo.resetUnderline();
            }
        }
    }

    private void createFont(CellStyleInfo cellStyleInfo, JRVisiableResult jRVisiableResult, boolean bl) {
        if (!(jRVisiableResult instanceof JHyperLinkRslt)) {
            boolean bl2 = CCUtil.getBooleanPropertyByName(jRVisiableResult, "Shadow");
            if (bl && CCUtil.isChangeByFormularProperty(jRVisiableResult, "Shadow")) {
                cellStyleInfo.addChangedByProps(8);
            }
            cellStyleInfo.setShadow(bl2);
        }
    }

    private int dispose(int n) {
        int n2 = 1;
        switch (n) {
            case 1: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 8;
                break;
            }
            case 2: {
                n2 = 5;
                break;
            }
            case 3: {
                n2 = 6;
                break;
            }
            case 4: {
                n2 = 15;
            }
        }
        return n2;
    }

    private static short[] fillColor(DSCTField dSCTField) {
        short[] sArray = new short[]{1, 1, 1, 1};
        CTGridInfo cTGridInfo = dSCTField.getParentGridInfo();
        Vector vector = cTGridInfo.getChildren();
        if (vector.size() > 1) {
            int n = dSCTField.getX();
            int n2 = dSCTField.getY();
            int n3 = dSCTField.getX() + dSCTField.getWidth();
            int n4 = dSCTField.getY() + dSCTField.getHeight();
            for (int i = 0; i < vector.size(); ++i) {
                DSCTField dSCTField2 = (DSCTField)vector.get(i);
                if (dSCTField2 == dSCTField) continue;
                if (dSCTField2.getY() < n2) {
                    sArray[0] = 0;
                }
                if (dSCTField2.getX() < n) {
                    sArray[1] = 0;
                }
                if (dSCTField2.getY() + dSCTField2.getHeight() > n4) {
                    sArray[2] = 0;
                }
                if (dSCTField2.getX() + dSCTField2.getWidth() <= n3) continue;
                sArray[3] = 0;
            }
        }
        return sArray;
    }

    private void get(CellStyleInfo cellStyleInfo, JRVisiableResult jRVisiableResult, int n, boolean bl) {
        boolean bl2 = false;
        if (n == 0) {
            if (!(jRVisiableResult instanceof JHyperLinkRslt)) {
                bl2 = CCUtil.getBooleanPropertyByName(jRVisiableResult, "WordWrap");
                if (bl && CCUtil.isChangeByFormularProperty(jRVisiableResult, "WordWrap")) {
                    cellStyleInfo.addChangedByProps(9);
                }
            } else {
                bl2 = CCUtil.getBooleanPropertyByName(jRVisiableResult, "wordWrap");
                if (bl && CCUtil.isChangeByFormularProperty(jRVisiableResult, "wordWrap")) {
                    cellStyleInfo.addChangedByProps(9);
                }
            }
        } else if (n == 1) {
            bl2 = false;
        } else if (n == 2) {
            bl2 = true;
        }
        if (bl2) {
            cellStyleInfo.setWordWrap(bl2);
        } else {
            cellStyleInfo.resetWordWrap();
        }
    }

    @Override
    public void reInitial() {
        super.reInitial();
        this.BLACK = new Hashtable();
        this.SEDU = new Hashtable();
    }

    @Override
    public void clear() {
        super.clear();
        this.BLACK.clear();
        this.SEDU.clear();
    }
}

