/*
 * Decompiled with CFR 0.152.
 */
package jet.export.util;

import chart.graphics.ChartColorPattern;
import chart.graphics.ChartCustomizedPattern;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartGradientPattern;
import chart.graphics.ChartTexturePattern;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jet.datastream.JRObjectResult;
import jet.export.util.CCUtil;
import jet.export.util.ExportUtil;
import jet.export.util.FillPatternProperties;
import jet.util.image.ImageResource;

public class FillPatternAdapter {
    private FillPatternProperties ConvertProperties;

    public FillPatternAdapter(JRObjectResult jRObjectResult) {
        this.ConvertProperties = FillPatternAdapter.ConvertProperties(jRObjectResult);
    }

    public FillPatternAdapter(FillPatternProperties fillPatternProperties) {
        this.ConvertProperties = fillPatternProperties;
    }

    public static FillPatternProperties ConvertProperties(JRObjectResult jRObjectResult) {
        FillPatternProperties fillPatternProperties = new FillPatternProperties();
        int n = CCUtil.getIntPropertyByName(jRObjectResult, "BackgroundType");
        fillPatternProperties.setFillPatternType(n);
        fillPatternProperties.setTransparency(CCUtil.getIntPropertyByName(jRObjectResult, "BGTransparency"));
        switch (n) {
            case 0: {
                fillPatternProperties.setBackgroundColor(CCUtil.getColorPropertyByName(jRObjectResult, "Background"));
                break;
            }
            case 2: {
                int n2 = CCUtil.getIntPropertyByName(jRObjectResult, "BGGradientStyle");
                Color color = CCUtil.getColorPropertyByName(jRObjectResult, "BGGradientStartColor");
                Color color2 = CCUtil.getColorPropertyByName(jRObjectResult, "BGGradientEndColor");
                int n3 = CCUtil.getIntPropertyByName(jRObjectResult, "BGGradientStartX");
                int n4 = CCUtil.getIntPropertyByName(jRObjectResult, "BGGradientStartY");
                int n5 = CCUtil.getIntPropertyByName(jRObjectResult, "BGGradientEndX");
                int n6 = CCUtil.getIntPropertyByName(jRObjectResult, "BGGradientEndY");
                fillPatternProperties.setGradientProperties(n2, color, color2, n3, n4, n5, n6);
                break;
            }
            case 1: {
                int n7 = CCUtil.getIntPropertyByName(jRObjectResult, "BGTextureStyle");
                Color color = CCUtil.getColorPropertyByName(jRObjectResult, "BGTextureBackground");
                Color color3 = CCUtil.getColorPropertyByName(jRObjectResult, "BGTextureForeground");
                fillPatternProperties.setTextureProperties(n7, color3, color);
                break;
            }
            case 3: {
                ImageResource imageResource = CCUtil.getImagePropertyByName(jRObjectResult, "BGImgSrc");
                Image image = imageResource == null ? null : imageResource.getImage();
                ExportUtil.waitImage(image);
                int n8 = CCUtil.getIntPropertyByName(jRObjectResult, "BGImgLayout");
                int n9 = CCUtil.getIntPropertyByName(jRObjectResult, "BGImgSecX");
                int n10 = CCUtil.getIntPropertyByName(jRObjectResult, "BGImgSecY");
                int n11 = CCUtil.getIntPropertyByName(jRObjectResult, "BGImgSecW");
                int n12 = CCUtil.getIntPropertyByName(jRObjectResult, "BGImgSecH");
                fillPatternProperties.setImageProperties(image, n8, n9, n10, n11, n12);
            }
        }
        return fillPatternProperties;
    }

    public void fillPattern(Graphics graphics, Shape shape) {
        if (this.ConvertProperties != null) {
            if (graphics instanceof Graphics2D) {
                this.ConvertProperties((Graphics2D)graphics, shape);
            } else if (this.ConvertProperties.getFillPatternType() == FillPatternProperties.FILL_COLOR && this.ConvertProperties.getBackgroundColor() != null) {
                Rectangle rectangle = shape.getBounds();
                graphics.setColor(this.ConvertProperties.getBackgroundColor());
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    private void ConvertProperties(Graphics2D graphics2D, Shape shape) {
        ChartFillPattern chartFillPattern = null;
        switch (this.ConvertProperties.getFillPatternType()) {
            case 0: {
                chartFillPattern = new ChartColorPattern(this.ConvertProperties.getBackgroundColor());
                chartFillPattern.setAlpha((float)this.ConvertProperties.getTransparency() / 100.0f);
                break;
            }
            case 1: {
                chartFillPattern = new ChartTexturePattern(this.I(this.ConvertProperties.getTextureStyle()), new ChartColorPattern(this.ConvertProperties.getTextureForeColor()), new ChartColorPattern(this.ConvertProperties.getTextureBackColor()));
                chartFillPattern.setAlpha((float)this.ConvertProperties.getTransparency() / 100.0f);
                break;
            }
            case 2: {
                chartFillPattern = new ChartGradientPattern(this.SEDU(this.ConvertProperties.getGradientStyle()));
                ((ChartGradientPattern)chartFillPattern).setStartColor(new ChartColorPattern(this.ConvertProperties.getGradientStartColor()));
                ((ChartGradientPattern)chartFillPattern).setEndColor(new ChartColorPattern(this.ConvertProperties.getGradientEndColor()));
                ((ChartGradientPattern)chartFillPattern).setStartPoint(new Point2D.Float((float)this.ConvertProperties.getGradientStartX() / 100.0f, 1.0f - (float)this.ConvertProperties.getGradientStartY() / 100.0f));
                ((ChartGradientPattern)chartFillPattern).setEndPoint(new Point2D.Float((float)this.ConvertProperties.getGradientEndX() / 100.0f, 1.0f - (float)this.ConvertProperties.getGradientEndY() / 100.0f));
                ((ChartGradientPattern)chartFillPattern).setAlpha((float)this.ConvertProperties.getTransparency() / 100.0f);
                break;
            }
            case 3: {
                if (this.ConvertProperties.getImage() == null) break;
                float f = (float)this.ConvertProperties.getImageX() / 100.0f;
                float f2 = 1.0f - (float)this.ConvertProperties.getImageY() / 100.0f;
                float f3 = (float)this.ConvertProperties.getImageWidth() / 100.0f;
                float f4 = (float)this.ConvertProperties.getImageHeight() / 100.0f;
                f3 = f + f3 > 1.0f ? 1.0f - f : f3;
                f4 = f2 + f4 > 1.0f ? 1.0f - f2 : f4;
                Rectangle2D.Float float_ = new Rectangle2D.Float(f, f2, f3, f4);
                int n = this.FILL_COLOR(this.ConvertProperties.getImageLayout());
                float f5 = (float)this.ConvertProperties.getTransparency() / 100.0f;
                chartFillPattern = new ChartCustomizedPattern(this.ConvertProperties.getImage(), float_, n, f5);
            }
        }
        if (chartFillPattern != null) {
            chartFillPattern.fill(graphics2D, shape);
        }
    }

    private int FILL_COLOR(int n) {
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
            }
        }
        return n2;
    }

    private int I(int n) {
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = ChartTexturePattern.getBuiltinTexture("Small Dot");
                break;
            }
            case 1: {
                n2 = ChartTexturePattern.getBuiltinTexture("Big Dot");
                break;
            }
            case 2: {
                n2 = ChartTexturePattern.getBuiltinTexture("Horizontal Line");
                break;
            }
            case 3: {
                n2 = ChartTexturePattern.getBuiltinTexture("Vertical Line");
                break;
            }
            case 4: {
                n2 = ChartTexturePattern.getBuiltinTexture("Grid");
                break;
            }
            case 5: {
                n2 = ChartTexturePattern.getBuiltinTexture("Diagonal Up");
                break;
            }
            case 6: {
                n2 = ChartTexturePattern.getBuiltinTexture("Diagonal Down");
                break;
            }
            case 7: {
                n2 = ChartTexturePattern.getBuiltinTexture("Diamond Grid");
                break;
            }
            case 8: {
                n2 = ChartTexturePattern.getBuiltinTexture("Triangle");
                break;
            }
            case 9: {
                n2 = ChartTexturePattern.getBuiltinTexture("Raised Rectangle");
                break;
            }
            case 10: {
                n2 = ChartTexturePattern.getBuiltinTexture("Blurred Diamond");
            }
        }
        return n2;
    }

    private int SEDU(int n) {
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = ChartGradientPattern.getBuiltinGradient("Linear");
                break;
            }
            case 1: {
                n2 = ChartGradientPattern.getBuiltinGradient("Cyclic Linear");
                break;
            }
            case 2: {
                n2 = ChartGradientPattern.getBuiltinGradient("Square Radial");
                break;
            }
            case 3: {
                n2 = ChartGradientPattern.getBuiltinGradient("Round Radial");
            }
        }
        return n2;
    }
}

