/*
 * Decompiled with CFR 0.152.
 */
package jet.ie.io;

import com.jinfonet.resstore.DiskStore;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.UTFDataFormatException;
import jet.util.RAFile;
import jet.util.RandomByteArrayInputOutput;
import jet.util.RandomInputOutputable;
import jet.util.RandomInputable;

public class RAStreamInput
implements RandomInputable {
    protected RandomInputOutputable impl;
    protected InputStream in;
    File SEDU;
    private long available;
    private DiskStore close;

    public RAStreamInput(InputStream inputStream, long l, DiskStore diskStore) throws IOException {
        this.in = inputStream;
        this.available = l;
        this.close = diskStore;
        try {
            this.SEDU = diskStore.createTempFile("raf", ".temp");
            this.impl = new RAFile(this.SEDU, "rw");
        }
        catch (Throwable throwable) {
            this.impl = new RandomByteArrayInputOutput();
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        this.SEDU(n);
        return this.impl.skipBytes(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.in.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.impl.close();
        }
        catch (Exception exception) {
        }
        finally {
            this.close.delete(this.SEDU);
        }
    }

    @Override
    public int read() throws IOException {
        this.SEDU(1L);
        return this.impl.read();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.SEDU(n2);
        return this.impl.read(byArray, n, n2);
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        this.SEDU(byArray.length);
        return this.impl.read(byArray);
    }

    @Override
    public void saveTo(String string) throws IOException {
        this.impl.saveTo(string);
    }

    @Override
    public void readFully(byte[] byArray) throws IOException {
        this.SEDU(byArray.length);
        this.impl.readFully(byArray);
    }

    @Override
    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.SEDU(n2);
        this.impl.readFully(byArray, n, n2);
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.SEDU(10L);
        return this.impl.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        this.SEDU(1L);
        return this.impl.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        this.SEDU(2L);
        return this.impl.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        this.SEDU(2L);
        return this.impl.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        this.SEDU(2L);
        return this.impl.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        this.SEDU(2L);
        return this.impl.readChar();
    }

    @Override
    public int readInt() throws IOException {
        this.SEDU(4L);
        return this.impl.readInt();
    }

    @Override
    public long readLong() throws IOException {
        this.SEDU(8L);
        return this.impl.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        this.SEDU(8L);
        return this.impl.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        this.SEDU(10L);
        return this.impl.readDouble();
    }

    @Override
    public String readLine() throws IOException {
        int n;
        InputStream inputStream = this.in;
        char[] cArray = new char[128];
        int n2 = cArray.length;
        int n3 = 0;
        block4: while (true) {
            n = inputStream.read();
            switch (n) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    int n4 = inputStream.read();
                    if (n4 == 10 || n4 == -1) break block4;
                    if (!(inputStream instanceof PushbackInputStream)) {
                        inputStream = this.in = new PushbackInputStream(inputStream);
                    }
                    ((PushbackInputStream)inputStream).unread(n4);
                    break block4;
                }
                default: {
                    if (--n2 < 0) {
                        cArray = new char[n3 + 128];
                        n2 = cArray.length - n3 - 1;
                    }
                    cArray[n3++] = (char)n;
                    continue block4;
                }
            }
            break;
        }
        if (n == -1 && n3 == 0) {
            return null;
        }
        return String.copyValueOf(cArray, 0, n3);
    }

    @Override
    public String readUTF() throws IOException {
        int n = this.readUnsignedShort();
        char[] cArray = new char[n];
        int n2 = 0;
        int n3 = 0;
        block5: while (n2 < n) {
            int n4 = this.readUnsignedByte();
            switch (n4 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n2;
                    cArray[n3++] = (char)n4;
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((n2 += 2) > n) {
                        throw new UTFDataFormatException();
                    }
                    int n5 = this.readUnsignedByte();
                    if ((n5 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    cArray[n3++] = (char)((n4 & 0x1F) << 6 | n5 & 0x3F);
                    continue block5;
                }
                case 14: {
                    if ((n2 += 3) > n) {
                        throw new UTFDataFormatException();
                    }
                    int n5 = this.readUnsignedByte();
                    int n6 = this.readUnsignedByte();
                    if ((n5 & 0xC0) != 128 || (n6 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    cArray[n3++] = (char)((n4 & 0xF) << 12 | (n5 & 0x3F) << 6 | (n6 & 0x3F) << 0);
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
        return new String(cArray, 0, n3);
    }

    public void write(int n) throws IOException {
        this.impl.write(n);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.impl.write(byArray, n, n2);
    }

    public void write(byte[] byArray) throws IOException {
        this.impl.write(byArray);
    }

    @Override
    public void seek(long l) throws IOException {
        if (l > this.impl.getPosition()) {
            this.SEDU(l - this.impl.getPosition());
        }
        this.impl.seek(l);
    }

    @Override
    public long getPosition() throws IOException {
        return this.impl.getPosition();
    }

    @Override
    public long length() throws IOException {
        if (this.available == 0L) {
            this.available = this.in.available();
        }
        return this.available;
    }

    private final void SEDU(long l) throws IOException {
        int n;
        long l2 = this.impl.length();
        if (l2 == this.available) {
            return;
        }
        long l3 = this.impl.getPosition();
        byte[] byArray = new byte[1024];
        this.impl.seek(l2);
        for (int i = (int)(l - (l2 - l3)); i > 0; i -= n) {
            n = this.in.read(byArray, 0, i > 1024 ? 1024 : i);
            if (n == -1) {
                this.impl.seek(l3);
                throw new IOException("End of file");
            }
            this.impl.write(byArray, 0, n);
        }
        this.impl.seek(l3);
    }
}

