/*
 * Decompiled with CFR 0.152.
 */
package jet.thinviewer;

import com.jinfonet.util.JRLog;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.List;
import javax.swing.JComponent;
import jet.connect.Record;
import jet.datastream.DSContainer;
import jet.datastream.DSGroup;
import jet.datastream.DSReference;
import jet.datastream.DSSection;
import jet.datastream.DSSubReport;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.export.ExportAuxInfo;
import jet.export.util.CCUtil;
import jet.export.util.ExportingInfo;
import jet.thinviewer.JReportChartPlatform;
import jet.thinviewer.JReportContainerable;
import jet.thinviewer.JReportObjectRender;
import jet.thinviewer.JReportParagraph;
import jet.thinviewer.JReportParagraphText;
import jet.thinviewer.JReportViewer;
import jet.thinviewer.ViewerTools;
import jet.udo.JRObjectRender;
import jet.util.JRInterruptedException;
import jet.util.PropertySetable;
import jet.util.image.ImageResource;

public class JReportAreaComponent
extends JComponent
implements JReportObjectRender,
JReportContainerable {
    private static final long serialVersionUID = 1L;
    Shape I = null;
    protected int startY = 0;
    protected int resolution = 96;
    int Z = 0;
    protected ExportAuxInfo auxinfo;
    protected boolean islcView;
    private ExportingInfo contains;

    @Override
    public boolean contains(Point point) {
        return this.I.contains(point);
    }

    @Override
    public boolean contains(int n, int n2) {
        return this.I.contains(n, n2);
    }

    @Override
    public void setProperty(PropertySetable propertySetable) {
        Color color = this.getColorPropertyByName((JRObjectResult)propertySetable, "Background");
        if (color != null) {
            this.setBackground(color);
        }
        this.resolution = ((JRObjectResult)propertySetable).getResolution();
        this.startY = Unit.convertUnitToPixel(((DSContainer)propertySetable).getStartYPos(), this.resolution);
    }

    @Override
    public void createChildren(DSContainer dSContainer) {
        this.removeAll();
        List list = dSContainer.getChildren();
        list = ViewerTools.I(list);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            JRObjectResult jRObjectResult = (JRObjectResult)list.get(i);
            JRObjectRender jRObjectRender = null;
            try {
                jRObjectRender = this.createComponent(jRObjectResult);
            }
            catch (JRInterruptedException jRInterruptedException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, "JRInterruptedException", (Throwable)jRInterruptedException);
                }
                throw jRInterruptedException;
            }
            catch (Exception exception) {
                ViewerTools.I(2401503, exception);
            }
            if (jRObjectRender == null) continue;
            this.add((Component)((Object)jRObjectRender));
        }
    }

    protected JRObjectRender createComponent(JRObjectResult jRObjectResult) {
        boolean bl = true;
        while (jRObjectResult instanceof DSReference) {
            bl = false;
            jRObjectResult = ((DSReference)jRObjectResult).getRefData();
        }
        if (this.contains.isExport(jRObjectResult)) {
            return null;
        }
        JReportObjectRender jReportObjectRender = JReportViewer.I(jRObjectResult);
        if (jReportObjectRender != null) {
            JRVisiableResult jRVisiableResult = (JRVisiableResult)jRObjectResult;
            jReportObjectRender.setProperty(jRVisiableResult);
            Rectangle rectangle = jRVisiableResult.getBounds();
            int n = 0;
            if (jRVisiableResult.getStartYPos() != 0) {
                JRObjectResult jRObjectResult2;
                int n2 = 0;
                if (jRVisiableResult instanceof DSSection && ((jRObjectResult2 = (JRObjectResult)((Object)((DSSection)jRVisiableResult).getParent())).getObjectType() == 45 || jRObjectResult2.getObjectType() == 33 && CCUtil.getBooleanPropertyByName(jRVisiableResult, "Embedded"))) {
                    n2 = Math.max(0, ((DSSection)jRVisiableResult).getY() - ((DSSubReport)jRObjectResult2).getStartYPos());
                }
                rectangle.y = (n = n2) > 0 ? Unit.convertUnitToPixel(n, this.resolution) : 0;
            } else {
                rectangle.y -= this.startY;
            }
            if (bl && n > 0) {
                rectangle.height = Math.min(this.getBounds().height, rectangle.height);
            } else if (bl) {
                rectangle.height = Math.min(this.getBounds().height - rectangle.y, rectangle.height);
            }
            if (jReportObjectRender instanceof JReportParagraph) {
                ((JReportParagraph)jReportObjectRender).setActualSize(rectangle);
            } else if (jReportObjectRender instanceof JReportParagraphText) {
                ((Component)((Object)jReportObjectRender)).setBounds(rectangle);
            } else if (!(jReportObjectRender instanceof JReportChartPlatform)) {
                ((Component)((Object)jReportObjectRender)).setBounds(rectangle);
            }
            if (jRVisiableResult instanceof DSContainer) {
                ((JReportContainerable)((Object)jReportObjectRender)).createChildren((DSContainer)jRVisiableResult);
            }
            if (jReportObjectRender instanceof JReportChartPlatform) {
                ((Component)((Object)jReportObjectRender)).setBounds(rectangle);
            }
        } else if (!(jRObjectResult instanceof DSGroup) && JRLog.isError(2)) {
            JRLog.error(2, 2401518, jRObjectResult);
        }
        return jReportObjectRender;
    }

    public void setProperty(PropertySetable propertySetable, Record record) {
    }

    protected Color getColorPropertyByName(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getColorPropertyByName(jRObjectResult, string);
    }

    protected boolean getBooleanPropertyByName(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getBooleanPropertyByName(jRObjectResult, string);
    }

    protected int getIntPropertyByName(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getIntPropertyByName(jRObjectResult, string);
    }

    protected Image getImagePropertyByName(JRObjectResult jRObjectResult, String string) {
        ImageResource imageResource = CCUtil.getImagePropertyByName(jRObjectResult, string);
        if (imageResource == null) {
            return null;
        }
        return imageResource.getImage();
    }

    protected String getStringPropertyByName(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getStringPropertyByName(jRObjectResult, string);
    }

    @Override
    public void getAuxinfo() {
    }

    @Override
    public void setauxinfo(ExportAuxInfo exportAuxInfo) {
        this.auxinfo = exportAuxInfo;
    }

    @Override
    public void setLcView(boolean bl) {
        this.islcView = bl;
    }

    @Override
    public void setExportInfo(ExportingInfo exportingInfo) {
        this.contains = exportingInfo;
    }
}

