import java.security.acl.Permission;
import jet.cs.util.APIConst;
import jet.server.api.Permissions;
import jet.server.api.custom.security.AuthorizationProvider;

/**
 * In this demonstration program, there are only 4 users: admin, guest, user1, and user2.
 * User "admin" has full permissions and privileges, while every other user has "visible" and 
 * "read" permissions on resource path "/". User "guest" has "visible" and "read"
 * permissions on all nodes, but does not have any privileges. User "user1" has all permissions except "grant"
 * on all nodes, and has privilege APIConst.PRIVILEGE_DEPLOY_REPORT. User "user2" has all permissions on
 * node "/SampleReports", but does not have any other permissions or privileges. Realm name is the default realm of the server.
 * 
 * To apply this demonstration program on JReport Server, follow these steps:
 * 1. Compile DemoAuthorizationProvider.java and put DemoAuthorizationProvider.class into the
 * CLASSPATH used for launching JReport Server (JRServer.bat/sh). 
 * 2. Edit file <install_root>/bin/server.properties, add a name/value pair, the name is  
 * custom.security.AuthorizationProvider and the value is DemoAuthorizationProvider;
 * or specify it using a -D parameter of the JVM, the name is com.jinfonet.AuthorizationProvider and 
 * the value is DemoAuthorizationProvider.
 * 4. Restart JReport Server and the customized user authorization will be used instead of the built in one.
 */
public class DemoAuthorizationProvider implements AuthorizationProvider {

    public boolean isPermissionOk(String realmName, String userName, String resourcePath, int versionNumber,
            Permission permission) {
		
        System.out.println("isPermissionsOk(), userName=" + userName 
                + ", resourcePath=" + resourcePath 
                + ", verNumber=" + versionNumber 
                + ", permission=" + permission);
        if (userName.equals("admin")) {
			
			// User "admin" has all permissions.
            return true;
        } else if (resourcePath.equals("/")
                && permission.equals(Permissions.P_VISIBLE) || permission.equals(Permissions.P_READ)) {

			// All other users have permissions "visible" and "read" on node "/".
            return true;
        } else if (userName.equals("guest") 
                && permission.equals(Permissions.P_VISIBLE) || permission.equals(Permissions.P_READ)) {

			// User "guest" only has permissions "visible" and "read" on all nodes.
            return true;
        } else if (userName.equals("user1")) {

			// User "user1" has all permissions except "grant" on all nodes.
            if (permission.equals(Permissions.P_VISIBLE)
                    || permission.equals(Permissions.P_READ)
                    || permission.equals(Permissions.P_WRITE)
                    || permission.equals(Permissions.P_DELETE)
                    || permission.equals(Permissions.P_EXECUTE)
                    || permission.equals(Permissions.P_SCHEDULE)) {
                return true;
            }
        } else if (userName.equals("user2")) {

			// User "user2" has all permissions on node "/SampleReports".
            if (resourcePath.startsWith("/SampleReports")) {
                return true;
            }
        }
        return false;
    }

    public boolean checkPrivilege(String realm, String userName, String privilege) {

        System.out.println("checkPrivilege(), userName=" + userName + ", privilege=" + privilege);
        if (userName.equals("admin")) {

			// user "admin" has all privileges
            return true;
        } else if (userName.equals("user1")) {

			// user "user1" only has privilege APIConst.PRIVILEGE_PUBLISH_REPORT
            if (privilege.equals(APIConst.PRIVILEGE_PUBLISH_REPORT)) {
                return true;
            }            
        }
        
        // other users do not have any privileges.
        return false;
    }
}
