import java.io.File;
import java.text.DateFormat;
import java.util.*;

import jet.cs.util.*;
import jet.server.api.*;
import jet.server.api.http.HttpUtil;

/**
 * This demo is created to demonstrate the usage of JReport Server API methods to run a report 
 * to PDF and HTML and find the result files located in the JReport temp folder without exporting it.
 * 
 * The sample assumes JReport Server is installed on Windows in the default location
 * SampleReports/SampleReports.cat and SampleReports/CustomerAnalysis.cls are deployed under Public Reports
 * That the C:/JReport/Server/temp directory exists.
 * 
 */ 

public class APIDemoRunReport
{

    public static void main(String[] args)
	{
    	RptServer server = null;
		try {
			//set report home
			System.getProperties().put("reporthome", "C:\\JReport\\Server");
			
			//creates instance of RptServer (JReport Server must not be already running)
			HttpUtil.initEnv(System.getProperties());
			server = HttpUtil.getHttpRptServer();
			System.out.println("========server="+server);

			String catalog = "/SampleReports/SampleReports.cat";
			String rptName = "CustomerAnalysis.cls";

			//set report properties
			Properties props = new Properties();
			
			props.put(APIConst.TAG_REPORT_LANGUAGE, "en_US");
			String today = DateFormat.getDateInstance(DateFormat.LONG, new Locale("en", "US")).format(new Date());
			//set value of parameter "p_StartDate" & "p_EndDate".
			props.put(APIConst.TAG_PARAM_PREFIX + "p_StartDate", "January 1, 2006");
			props.put(APIConst.TAG_PARAM_PREFIX + "p_EndDate", today);
			
			//set result type as .pdf format.
			props.put(APIConst.TAG_RESULT_TYPE, String.valueOf(APIConst.PDF));

			System.out.println("\n========to pdf="+props);

			//The pdf result can be accessed by the url 
			//"http://host:port/sendfileservlet_path/result/temp_result_filename".
			//For example: If tempResult is "c:\JReport\Server\temp\6323848938.pdf", 
			//then the url is:
			//"http://localhost:8888/sendfile/result/6323848938.pdf".
			String tempResult = server.runReport("admin", catalog, rptName, props);
			System.out.println("========tempResult="+tempResult);

			//register the result owner to pass security check
			//for accessing by the url 
			//"http://localhost:8888/sendfile/result/6323848938.pdf".
			server.getTempResultOwnerManager().registerOwner("admin", HttpUtil.getTempResultKey(new File(tempResult).getName()));

			//can delete tempResult.* files here.

			props = new Properties();

			props.put(APIConst.TAG_REPORT_LANGUAGE, "en_US");
			//set value of parameter "p_StartDate" & "p_EndDate".
			props.put(APIConst.TAG_PARAM_PREFIX + "p_StartDate", "January 1, 2006");
			props.put(APIConst.TAG_PARAM_PREFIX + "p_EndDate", today);

			//set result type as html format.
			//html result filenames is 
			//"temp_name*.*".
			//html result files include temp_name.css, temp_name_*.html etc.
			props.put(APIConst.TAG_RESULT_TYPE, String.valueOf(APIConst.HTML));

			System.out.println("\n========to html="+props);

			//The html result can be accessed by the url 
			//"http://host:port/sendfileservlet_path/result/temp_result_filename".
			//For example: If tempResult is "c:\JReport\Server\temp\6323848938_1.html", 
			//then the url is:
			//"http://localhost:8888/sendfile/result/6323848938_1.html".
			tempResult = server.runReport("admin", catalog, rptName, props);
			//the tempResult is the first html page. If want to get all html files, 
			//please see APIDemoRunAndExportReport.java.
			System.out.println("========tempResult="+tempResult);
			
			//register the result owner to pass security check
			//for accessing by the url 
			//"http://localhost:8888/sendfile/result/6323848938_1.html".
			server.getTempResultOwnerManager().registerOwner("admin", HttpUtil.getTempResultKey(new File(tempResult).getName()));

			
		
		}catch (Throwable t){
			t.printStackTrace();
		}
		finally{
			// Make sure server is shutdown or there will be a 2 minute wait to start again
			server.shutdown();
			System.out.println("Server "+ server +" shutdown.");
		}
		System.exit(0);
    }
}


