package jet.formula.javaformula;

import jet.connect.*;
import jet.formula.*;
import java.awt.*;
import java.io.*;
import java.util.*;
/**
 * MyFunctions class creates a set of I/O utilities that are useful in JReport for logging and other I/O from a report.
 * Requires that the formula belong in package jet.formula.javaformula for it to be found and recognized by JReport.
 * 
 */
public class MyFunctions
{
	Bulletin bulletin;

	Vector filetable = new Vector();
//	Hashtable handletable = new Hashtable();

	public MyFunctions()
	{
		bulletin = new Bulletin();
	}

	public DbBigInt OpenFile(DbChar txtfile, DbBit read)
	{
		FileInputStream fin;
		FileOutputStream fout;

		DbBigInt filehandle = new DbBigInt();

		if (!txtfile.bNull && !read.bNull)
		{
			try {
                int idx = filetable.size();
				if (read.value)
				{
					fin = new FileInputStream(new File(txtfile.value));
                    filetable.addElement(fin);
				}
                else
                {
					fout = new FileOutputStream(new File(txtfile.value));
                    filetable.addElement(fout);
                }
				filehandle.bNull = false;
				filehandle.value = idx;
			}
			catch (IOException e)
			{
                e.printStackTrace();
			}
		}
		return filehandle;
	}

	public DbBit CloseFile(DbBigInt filehandle)
    {
        DbBit ret = new DbBit(false);
        if (!filehandle.bNull && filehandle.value>=0 && filehandle.value<filetable.size())
        {
            try {
            Object o = filetable.elementAt((int)filehandle.value);
            if (o instanceof FileInputStream)
                ((FileInputStream)o).close();
            else
                ((FileOutputStream)o).close();
            filetable.setElementAt(null, (int)filehandle.value);
            ret.value = true;
            }
            catch (IOException e)
            {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public DbBigInt Write(DbBigInt filehandle, DbChar txt)
    {
        DbBigInt cnt = new DbBigInt();
        if (!filehandle.bNull && filehandle.value>=0 && filehandle.value<filetable.size())
        {
            Object o = filetable.elementAt((int)filehandle.value);
            if (o instanceof FileOutputStream)
            {
                try {
					byte[] foo = txt.toString().getBytes();
                    ((FileOutputStream)o).write(foo);
                    cnt.bNull = false;
                    cnt.value = foo.length;
                }
                catch (IOException e)
                {
                    e.printStackTrace();
                }
            }
        }
        return cnt;
    }

    public DbBigInt Read(DbBigInt filehandle)
    {
        DbBigInt cnt = new DbBigInt();
        if (!filehandle.bNull && filehandle.value>=0 && filehandle.value<filetable.size())
        {
            Object o = filetable.elementAt((int)filehandle.value);
            if (o instanceof FileInputStream)
            {
				try {
                    int len; 
					byte[] foo = new byte[16];
					len = ((FileInputStream)o).read(foo);
					if ( len != -1 )
					{
						cnt.bNull = false;
						cnt.value = Integer.parseInt(new String(foo, 0, len));
					}
                }
                catch (IOException e)
                {
                    e.printStackTrace();
                }
            }
        }
        return cnt;
    }

	public fText loadText(DbChar txtfile)
	{
		fText ret = new fText();
		if (!txtfile.bNull)
		{
			try
			{
				File txtf = new File(txtfile.value);
				int len = (int)txtf.length();
				byte[] b = new byte[len];
				FileInputStream txtstream = new FileInputStream(txtf);
				txtstream.read(b);
				txtstream.close();
				ret.value = new String(b);
				ret.bNull = false;
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}
		}
		return ret;
	}

	public fImage LoadPicture(DbChar picname)
	{
		fImage ret = new fImage();

		if (!picname.bNull)
		{
			try {
				File imgfile = new File(picname.value);
				int filelen = (int)imgfile.length();
				ret.value = new byte[filelen];
				FileInputStream imgstream = new FileInputStream(imgfile);
				imgstream.read(ret.value);
				imgstream.close();
				ret.bNull = false;
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}
		}

		return ret;
	}

	public DbChar Debug(DbChar prompt)
	{
		//new Exception("----------------------").printStackTrace();
		if (!bulletin.isVisible())
			bulletin.setVisible(true);
		bulletin.println(prompt.toString());
		return new DbChar();
	}

	public static void main(String[] args)
	{
		MyFunctions myfunc = new MyFunctions();
		myfunc.bulletin.println("Running user-defined Formula functions....");
	}
}

class Bulletin extends Frame
{
	TextArea ta = new TextArea();
	
	public Bulletin()
	{
		super();
		setSize(500, 400);

		add(ta, "Center");

		setVisible(false);
	}

	public void println(String str)
	{
		ta.append(str);
		ta.append("\n");
	}
}