/**
 * 
 */

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;

import jet.datasource.JRUserDataSourceException;

/**
 * @author jiwu.ma
 * the unionsampleResult implement java.sql.resultSet,the javadoc please
 * see java.sql.resultSet document
 */
public class UnionSampleResult implements ResultSet {



	private Vector resultContain = new Vector();

    int columnCount = 0;

    ResultSetMetaData metaData;
    
    /**
     * Constructs an unionsampleResult instance use list
     * @param list contains all resultSet instance 
     * @throws JRUserDataSourceException
     */
    public UnionSampleResult(Vector list) throws JRUserDataSourceException {
        if (list == null) {
            throw new JRUserDataSourceException("resultset contian is null");
        }
        try {
            ResultSetMetaData metadata1 = ((ResultSet) list.get(0))
                    .getMetaData();
            for (int i = 1; i < list.size(); i++) {
                this.metaDataEqual(metadata1, ((ResultSet) list.get(i))
                        .getMetaData());
            }
        } catch (SQLException e) {
            throw new JRUserDataSourceException(e.getMessage());
        }
        this.resultContain = list;

    }
    /**
     * compare metadata 
     * @param metadata1 source metadata
     * @param metadata2 target metadata
     * @return false if not equal otherwist true
     * @throws JRUserDataSourceException
     */
    private boolean metaDataEqual(ResultSetMetaData metadata1,
            ResultSetMetaData metadata2) throws JRUserDataSourceException {
        int count1;
        int count2;
        try {
            count1 = metadata1.getColumnCount();
            count2 = metadata2.getColumnCount();
            if (count1 != count2) {
                throw new JRUserDataSourceException(
                        "DataBase structure is not equal!");
            }
//            for (int i = 1; i <= count1; i++) {
//                if (metadata1.getColumnType(i) != metadata2.getColumnType(i)) {
//                    throw new JRUserDataSourceException(
//                            "MetaData type is not equal");
//                }
//            }

        } catch (SQLException e) {
            throw new JRUserDataSourceException(e.getMessage());
        }
        return true;
    }


    public Vector getResultContian() {
        return this.resultContain;
    }

    int len = 0;

    boolean isA = true;

    public boolean next() throws JRUserDataSourceException {
        if (this.resultContain == null) {
            throw new JRUserDataSourceException("the result contain is null");
        }

        try {
            if (!((ResultSet) this.resultContain.get(len)).next()) {
                len++;
                if(len < this.resultContain.size())
                if (!((ResultSet) this.resultContain.get(len)).next())
                    len++;
            }
        } catch (SQLException e) {
            throw new JRUserDataSourceException(e.getMessage());
        }
        if (len >= this.resultContain.size())
            isA = false;
        // isR1 = false;

        return isA;
    }
    void setLen(int len) {
        this.len = len;
    }
    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#close()
     */
    public void close() throws SQLException {
        if(len >= this.resultContain.size())return ;
        ((ResultSet) this.resultContain.get(len)).close();

    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#wasNull()
     */
    public boolean wasNull() throws SQLException {
        return ((ResultSet) this.resultContain.get(len)).wasNull();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getString(int)
     */
    public String getString(int columnIndex) throws SQLException {
        // this.check(columnIndex);
        return ((ResultSet) this.resultContain.get(len)).getString(columnIndex);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getBoolean(int)
     */
    public boolean getBoolean(int columnIndex) throws SQLException {
        // this.check(columnIndex);
        return ((ResultSet) this.resultContain.get(len))
                .getBoolean(columnIndex);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getByte(int)
     */
    public byte getByte(int columnIndex) throws SQLException {
        // this.check(columnIndex);
        return ((ResultSet) this.resultContain.get(len)).getByte(columnIndex);
    }

 
    public short getShort(int columnIndex) throws SQLException {
        // this.check(columnIndex);
        return ((ResultSet) this.resultContain.get(len)).getShort(columnIndex);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getInt(int)
     */
    public int getInt(int columnIndex) throws SQLException {
        // this.check(columnIndex);
        return ((ResultSet) this.resultContain.get(len)).getInt(columnIndex);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getLong(int)
     */
    public long getLong(int columnIndex) throws SQLException {
        // this.check(columnIndex);
        return ((ResultSet) this.resultContain.get(len)).getLong(columnIndex);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getFloat(int)
     */
    public float getFloat(int columnIndex) throws SQLException {
        // this.check(columnIndex);
        return ((ResultSet) this.resultContain.get(len)).getFloat(columnIndex);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getDouble(int)
     */
    public double getDouble(int columnIndex) throws SQLException {
        // this.check(columnIndex);
        return ((ResultSet) this.resultContain.get(len)).getDouble(columnIndex);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getBigDecimal(int, int)
     */
    public BigDecimal getBigDecimal(int columnIndex, int scale)
            throws SQLException {
        // this.check(columnIndex);
        return ((ResultSet) this.resultContain.get(len))
                .getBigDecimal(columnIndex);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getBytes(int)
     */
    public byte[] getBytes(int columnIndex) throws SQLException {
        // this.check(columnIndex);
        return ((ResultSet) this.resultContain.get(len)).getBytes(columnIndex);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getDate(int)
     */
    public Date getDate(int columnIndex) throws SQLException {
        // this.check(columnIndex);
        return ((ResultSet) this.resultContain.get(len)).getDate(columnIndex);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getTime(int)
     */
    public Time getTime(int columnIndex) throws SQLException {
        // this.check(columnIndex);
        return ((ResultSet) this.resultContain.get(len)).getTime(columnIndex);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getTimestamp(int)
     */
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        // this.check(columnIndex);
        return ((ResultSet) this.resultContain.get(len))
                .getTimestamp(columnIndex);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getAsciiStream(int)
     */
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        // this.check(columnIndex);
        return ((ResultSet) this.resultContain.get(len))
                .getAsciiStream(columnIndex);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getUnicodeStream(int)
     */
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        // this.check(columnIndex);
        return ((ResultSet) this.resultContain.get(len))
                .getUnicodeStream(columnIndex);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getBinaryStream(int)
     */
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        // this.check(columnIndex);
        return ((ResultSet) this.resultContain.get(len))
                .getBinaryStream(columnIndex);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getString(java.lang.String)
     */
    public String getString(String columnName) throws SQLException {
        // this.check(columnName);
        return ((ResultSet) this.resultContain.get(len)).getString(columnName);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getBoolean(java.lang.String)
     */
    public boolean getBoolean(String columnName) throws SQLException {
        return ((ResultSet) this.resultContain.get(len)).getBoolean(columnName);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getByte(java.lang.String)
     */
    public byte getByte(String columnName) throws SQLException {
        return ((ResultSet) this.resultContain.get(len)).getByte(columnName);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getShort(java.lang.String)
     */
    public short getShort(String columnName) throws SQLException {
        return ((ResultSet) this.resultContain.get(len)).getShort(columnName);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getInt(java.lang.String)
     */
    public int getInt(String columnName) throws SQLException {
        return ((ResultSet) this.resultContain.get(len)).getInt(columnName);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getLong(java.lang.String)
     */
    public long getLong(String columnName) throws SQLException {
        return ((ResultSet) this.resultContain.get(len)).getLong(columnName);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getFloat(java.lang.String)
     */
    public float getFloat(String columnName) throws SQLException {
        return ((ResultSet) this.resultContain.get(len)).getFloat(columnName);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getDouble(java.lang.String)
     */
    public double getDouble(String columnName) throws SQLException {
        return ((ResultSet) this.resultContain.get(len)).getDouble(columnName);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getBigDecimal(java.lang.String, int)
     */
    public BigDecimal getBigDecimal(String columnName, int scale)
            throws SQLException {
        return ((ResultSet) this.resultContain.get(len)).getBigDecimal(
                columnName, scale);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getBytes(java.lang.String)
     */
    public byte[] getBytes(String columnName) throws SQLException {
        return ((ResultSet) this.resultContain.get(len)).getBytes(columnName);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getDate(java.lang.String)
     */
    public Date getDate(String columnName) throws SQLException {
        return ((ResultSet) this.resultContain.get(len)).getDate(columnName);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getTime(java.lang.String)
     */
    public Time getTime(String columnName) throws SQLException {
        return ((ResultSet) this.resultContain.get(len)).getTime(columnName);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getTimestamp(java.lang.String)
     */
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return ((ResultSet) this.resultContain.get(len))
                .getTimestamp(columnName);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getAsciiStream(java.lang.String)
     */
    public InputStream getAsciiStream(String columnName) throws SQLException {
        return ((ResultSet) this.resultContain.get(len))
                .getAsciiStream(columnName);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getUnicodeStream(java.lang.String)
     */
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return ((ResultSet) this.resultContain.get(len))
                .getUnicodeStream(columnName);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getBinaryStream(java.lang.String)
     */
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return ((ResultSet) this.resultContain.get(len))
                .getBinaryStream(columnName);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getWarnings()
     */
    public SQLWarning getWarnings() throws SQLException {
        return ((ResultSet) this.resultContain.get(len)).getWarnings();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#clearWarnings()
     */
    public void clearWarnings() throws SQLException {
        ((ResultSet) this.resultContain.get(len)).clearWarnings();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getCursorName()
     */
    public String getCursorName() throws SQLException {
        return ((ResultSet) this.resultContain.get(len)).getCursorName();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getMetaData()
     */
    public ResultSetMetaData getMetaData() throws JRUserDataSourceException {
        if (this.resultContain == null) {
            throw new JRUserDataSourceException("the result contian is null");
        }
        ResultSetMetaData metaData;
        try {
            metaData = ((ResultSet) this.resultContain.get(0)).getMetaData();
            this.columnCount = metaData.getColumnCount();
        } catch (SQLException e) {
            throw new JRUserDataSourceException("the result contian is null");
        }
        return metaData;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getObject(int)
     */
    public Object getObject(int columnIndex) throws SQLException {
        return ((ResultSet) this.resultContain.get(len)).getObject(columnIndex);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getObject(java.lang.String)
     */
    public Object getObject(String columnName) throws SQLException {
        return ((ResultSet) this.resultContain.get(len)).getObject(columnName);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#findColumn(java.lang.String)
     */
    public int findColumn(String columnName) throws SQLException {
        return ((ResultSet) this.resultContain.get(len)).findColumn(columnName);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getCharacterStream(int)
     */
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return ((ResultSet) this.resultContain.get(len))
                .getCharacterStream(columnIndex);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getCharacterStream(java.lang.String)
     */
    public Reader getCharacterStream(String columnName) throws SQLException {
        return ((ResultSet) this.resultContain.get(len))
                .getCharacterStream(columnName);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getBigDecimal(int)
     */
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return ((ResultSet) this.resultContain.get(len))
                .getBigDecimal(columnIndex);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getBigDecimal(java.lang.String)
     */
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return ((ResultSet) this.resultContain.get(len))
                .getBigDecimal(columnName);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#isBeforeFirst()
     */
    public boolean isBeforeFirst() throws SQLException {
        return ((ResultSet) this.resultContain.get(len)).isBeforeFirst();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#isAfterLast()
     */
    public boolean isAfterLast() throws SQLException {
        return ((ResultSet) this.resultContain.get(len)).isAfterLast();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#isFirst()
     */
    public boolean isFirst() throws SQLException {
        return ((ResultSet) this.resultContain.get(len)).isFirst();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#isLast()
     */
    public boolean isLast() throws SQLException {
        return ((ResultSet) this.resultContain.get(len)).isLast();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#beforeFirst()
     */
    public void beforeFirst() throws SQLException {
        ((ResultSet) this.resultContain.get(len)).beforeFirst();

    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#afterLast()
     */
    public void afterLast() throws SQLException {
        ((ResultSet) this.resultContain.get(len)).afterLast();

    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#first()
     */
    public boolean first() throws SQLException {
        return ((ResultSet) this.resultContain.get(len)).first();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#last()
     */
    public boolean last() throws SQLException {
        return ((ResultSet) this.resultContain.get(len)).last();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getRow()
     */
    public int getRow() throws SQLException {
        return ((ResultSet) this.resultContain.get(len)).getRow();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#absolute(int)
     */
    public boolean absolute(int row) throws SQLException {
        return ((ResultSet) this.resultContain.get(len)).absolute(row);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#relative(int)
     */
    public boolean relative(int rows) throws SQLException {
        return ((ResultSet) this.resultContain.get(len)).relative(rows);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#previous()
     */
    public boolean previous() throws SQLException {
        return ((ResultSet) this.resultContain.get(len)).previous();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#setFetchDirection(int)
     */
    public void setFetchDirection(int direction) throws SQLException {
        ((ResultSet) this.resultContain.get(len)).setFetchDirection(direction);

    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getFetchDirection()
     */
    public int getFetchDirection() throws SQLException {
        return ((ResultSet) this.resultContain.get(len)).getFetchDirection();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#setFetchSize(int)
     */
    public void setFetchSize(int rows) throws SQLException {
        ((ResultSet) this.resultContain.get(len)).setFetchSize(rows);

    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getFetchSize()
     */
    public int getFetchSize() throws SQLException {
        return ((ResultSet) this.resultContain.get(len)).getFetchSize();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getType()
     */
    public int getType() throws SQLException {
        return ((ResultSet) this.resultContain.get(len)).getType();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getConcurrency()
     */
    public int getConcurrency() throws SQLException {
        return ((ResultSet) this.resultContain.get(len)).getConcurrency();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#rowUpdated()
     */
    public boolean rowUpdated() throws SQLException {
        return ((ResultSet) this.resultContain.get(len)).rowUpdated();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#rowInserted()
     */
    public boolean rowInserted() throws SQLException {
        return ((ResultSet) this.resultContain.get(len)).rowInserted();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#rowDeleted()
     */
    public boolean rowDeleted() throws SQLException {
        return ((ResultSet) this.resultContain.get(len)).rowDeleted();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateNull(int)
     */
    public void updateNull(int columnIndex) throws SQLException {
        ((ResultSet) this.resultContain.get(len)).updateNull(columnIndex);

    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateBoolean(int, boolean)
     */
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        ((ResultSet) this.resultContain.get(len)).updateBoolean(columnIndex, x);

    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateByte(int, byte)
     */
    public void updateByte(int columnIndex, byte x) throws SQLException {
        ((ResultSet) this.resultContain.get(len)).updateByte(columnIndex, x);

    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateShort(int, short)
     */
    public void updateShort(int columnIndex, short x) throws SQLException {
        ((ResultSet) this.resultContain.get(len)).updateShort(columnIndex, x);

    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateInt(int, int)
     */
    public void updateInt(int columnIndex, int x) throws SQLException {
        ((ResultSet) this.resultContain.get(len)).updateInt(columnIndex, x);

    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateLong(int, long)
     */
    public void updateLong(int columnIndex, long x) throws SQLException {
        ((ResultSet) this.resultContain.get(len)).updateLong(columnIndex, x);

    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateFloat(int, float)
     */
    public void updateFloat(int columnIndex, float x) throws SQLException {
        ((ResultSet) this.resultContain.get(len)).updateFloat(columnIndex, x);

    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateDouble(int, double)
     */
    public void updateDouble(int columnIndex, double x) throws SQLException {
        ((ResultSet) this.resultContain.get(len)).updateDouble(columnIndex, x);

    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateBigDecimal(int, java.math.BigDecimal)
     */
    public void updateBigDecimal(int columnIndex, BigDecimal x)
            throws SQLException {
        ((ResultSet) this.resultContain.get(len)).updateBigDecimal(columnIndex,
                x);

    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateString(int, java.lang.String)
     */
    public void updateString(int columnIndex, String x) throws SQLException {
        ((ResultSet) this.resultContain.get(len)).updateString(columnIndex, x);

    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateBytes(int, byte[])
     */
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        ((ResultSet) this.resultContain.get(len)).updateBytes(columnIndex, x);

    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateDate(int, java.sql.Date)
     */
    public void updateDate(int columnIndex, Date x) throws SQLException {
        ((ResultSet) this.resultContain.get(len)).updateDate(columnIndex, x);

    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateTime(int, java.sql.Time)
     */
    public void updateTime(int columnIndex, Time x) throws SQLException {
        // TODO Auto-generated method stub
        ((ResultSet) this.resultContain.get(len)).updateTime(columnIndex, x);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateTimestamp(int, java.sql.Timestamp)
     */
    public void updateTimestamp(int columnIndex, Timestamp x)
            throws SQLException {
        // TODO Auto-generated method stub
        ((ResultSet) this.resultContain.get(len)).updateTimestamp(columnIndex,
                x);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateAsciiStream(int, java.io.InputStream, int)
     */
    public void updateAsciiStream(int columnIndex, InputStream x, int length)
            throws SQLException {
        // TODO Auto-generated method stub
        ((ResultSet) this.resultContain.get(len)).updateAsciiStream(
                columnIndex, x, length);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateBinaryStream(int, java.io.InputStream, int)
     */
    public void updateBinaryStream(int columnIndex, InputStream x, int length)
            throws SQLException {
        // TODO Auto-generated method stub
        ((ResultSet) this.resultContain.get(len)).updateBinaryStream(
                columnIndex, x, length);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateCharacterStream(int, java.io.Reader, int)
     */
    public void updateCharacterStream(int columnIndex, Reader x, int length)
            throws SQLException {
        // TODO Auto-generated method stub
        ((ResultSet) this.resultContain.get(len)).updateCharacterStream(
                columnIndex, x, length);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateObject(int, java.lang.Object, int)
     */
    public void updateObject(int columnIndex, Object x, int scale)
            throws SQLException {
        // TODO Auto-generated method stub
        ((ResultSet) this.resultContain.get(len)).updateObject(columnIndex, x,
                scale);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateObject(int, java.lang.Object)
     */
    public void updateObject(int columnIndex, Object x) throws SQLException {
        // TODO Auto-generated method stub
        ((ResultSet) this.resultContain.get(len)).updateObject(columnIndex, x);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateNull(java.lang.String)
     */
    public void updateNull(String columnName) throws SQLException {
        // TODO Auto-generated method stub
        ((ResultSet) this.resultContain.get(len)).updateNull(columnName);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateBoolean(java.lang.String, boolean)
     */
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        // TODO Auto-generated method stub
        ((ResultSet) this.resultContain.get(len)).updateBoolean(columnName, x);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateByte(java.lang.String, byte)
     */
    public void updateByte(String columnName, byte x) throws SQLException {
        // TODO Auto-generated method stub
        ((ResultSet) this.resultContain.get(len)).updateByte(columnName, x);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateShort(java.lang.String, short)
     */
    public void updateShort(String columnName, short x) throws SQLException {
        // TODO Auto-generated method stub
        ((ResultSet) this.resultContain.get(len)).updateShort(columnName, x);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateInt(java.lang.String, int)
     */
    public void updateInt(String columnName, int x) throws SQLException {
        // TODO Auto-generated method stub
        ((ResultSet) this.resultContain.get(len)).updateInt(columnName, x);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateLong(java.lang.String, long)
     */
    public void updateLong(String columnName, long x) throws SQLException {
        // TODO Auto-generated method stub
        ((ResultSet) this.resultContain.get(len)).updateLong(columnName, x);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateFloat(java.lang.String, float)
     */
    public void updateFloat(String columnName, float x) throws SQLException {
        // TODO Auto-generated method stub
        ((ResultSet) this.resultContain.get(len)).updateFloat(columnName, x);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateDouble(java.lang.String, double)
     */
    public void updateDouble(String columnName, double x) throws SQLException {
        // TODO Auto-generated method stub
        ((ResultSet) this.resultContain.get(len)).updateDouble(columnName, x);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateBigDecimal(java.lang.String,
     *      java.math.BigDecimal)
     */
    public void updateBigDecimal(String columnName, BigDecimal x)
            throws SQLException {
        // TODO Auto-gcenerated method stub
        ((ResultSet) this.resultContain.get(len)).updateBigDecimal(columnName,
                x);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateString(java.lang.String, java.lang.String)
     */
    public void updateString(String columnName, String x) throws SQLException {
        // TODO Auto-generated method stub
        ((ResultSet) this.resultContain.get(len)).updateString(columnName, x);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateBytes(java.lang.String, byte[])
     */
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        // TODO Auto-generated method stub
        ((ResultSet) this.resultContain.get(len)).updateBytes(columnName, x);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateDate(java.lang.String, java.sql.Date)
     */
    public void updateDate(String columnName, Date x) throws SQLException {
        // TODO Auto-generated method stub
        ((ResultSet) this.resultContain.get(len)).updateDate(columnName, x);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateTime(java.lang.String, java.sql.Time)
     */
    public void updateTime(String columnName, Time x) throws SQLException {
        // TODO Auto-generated method stub
        ((ResultSet) this.resultContain.get(len)).updateTime(columnName, x);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateTimestamp(java.lang.String,
     *      java.sql.Timestamp)
     */
    public void updateTimestamp(String columnName, Timestamp x)
            throws SQLException {
        // TODO Auto-generated method stub
        ((ResultSet) this.resultContain.get(len))
                .updateTimestamp(columnName, x);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateAsciiStream(java.lang.String,
     *      java.io.InputStream, int)
     */
    public void updateAsciiStream(String columnName, InputStream x, int length)
            throws SQLException {
        // TODO Auto-generated method stub
        ((ResultSet) this.resultContain.get(len)).updateAsciiStream(columnName,
                x, length);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateBinaryStream(java.lang.String,
     *      java.io.InputStream, int)
     */
    public void updateBinaryStream(String columnName, InputStream x, int length)
            throws SQLException {
        // TODO Auto-generated method stub
        ((ResultSet) this.resultContain.get(len)).updateBinaryStream(
                columnName, x, length);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateCharacterStream(java.lang.String,
     *      java.io.Reader, int)
     */
    public void updateCharacterStream(String columnName, Reader reader,
            int length) throws SQLException {
        // TODO Auto-generated method stub
        ((ResultSet) this.resultContain.get(len)).updateCharacterStream(
                columnName, reader, length);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateObject(java.lang.String, java.lang.Object,
     *      int)
     */
    public void updateObject(String columnName, Object x, int scale)
            throws SQLException {
        // TODO Auto-generated method stub
        ((ResultSet) this.resultContain.get(len)).updateObject(columnName, x,
                scale);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateObject(java.lang.String, java.lang.Object)
     */
    public void updateObject(String columnName, Object x) throws SQLException {
        // TODO Auto-generated method stub
        ((ResultSet) this.resultContain.get(len)).updateObject(columnName, x);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#insertRow()
     */
    public void insertRow() throws SQLException {
        // TODO Auto-generated method stub
        ((ResultSet) this.resultContain.get(len)).insertRow();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateRow()
     */
    public void updateRow() throws SQLException {
        // TODO Auto-generated method stub
        ((ResultSet) this.resultContain.get(len)).updateRow();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#deleteRow()
     */
    public void deleteRow() throws SQLException {
        // TODO Auto-generated method stub
        ((ResultSet) this.resultContain.get(len)).deleteRow();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#refreshRow()
     */
    public void refreshRow() throws SQLException {
        // TODO Auto-generated method stub
        ((ResultSet) this.resultContain.get(len)).refreshRow();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#cancelRowUpdates()
     */
    public void cancelRowUpdates() throws SQLException {
        // TODO Auto-generated method stub
        ((ResultSet) this.resultContain.get(len)).cancelRowUpdates();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#moveToInsertRow()
     */
    public void moveToInsertRow() throws SQLException {
        // TODO Auto-generated method stub
        ((ResultSet) this.resultContain.get(len)).moveToCurrentRow();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#moveToCurrentRow()
     */
    public void moveToCurrentRow() throws SQLException {
        // TODO Auto-generated method stub
        ((ResultSet) this.resultContain.get(len)).moveToCurrentRow();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getStatement()
     */
    public Statement getStatement() throws SQLException {
        // TODO Auto-generated method stub
        return ((ResultSet) this.resultContain.get(len)).getStatement();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getObject(int, java.util.Map)
     */
    public Object getObject(int arg0, Map arg1) throws SQLException {
        return ((ResultSet) this.resultContain.get(len)).getObject(arg0, arg1);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getRef(int)
     */
    public Ref getRef(int i) throws SQLException {
        return ((ResultSet) this.resultContain.get(len)).getRef(i);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getBlob(int)
     */
    public Blob getBlob(int i) throws SQLException {
        // TODO Auto-generated method stub
        return ((ResultSet) this.resultContain.get(len)).getBlob(i);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getClob(int)
     */
    public Clob getClob(int i) throws SQLException {
        // TODO Auto-generated method stub
        return ((ResultSet) this.resultContain.get(len)).getClob(i);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getArray(int)
     */
    public Array getArray(int i) throws SQLException {
        // TODO Auto-generated method stub
        return ((ResultSet) this.resultContain.get(len)).getArray(i);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getObject(java.lang.String, java.util.Map)
     */
    public Object getObject(String arg0, Map arg1) throws SQLException {
        // TODO Auto-generated method stub
        return ((ResultSet) this.resultContain.get(len)).getObject(arg0, arg1);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getRef(java.lang.String)
     */
    public Ref getRef(String colName) throws SQLException {
        // TODO Auto-generated method stub
        return ((ResultSet) this.resultContain.get(len)).getRef(colName);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getBlob(java.lang.String)
     */
    public Blob getBlob(String colName) throws SQLException {
        // TODO Auto-genera((ResultSet)this.resultContain.get(len))
        return ((ResultSet) this.resultContain.get(len)).getBlob(colName);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getClob(java.lang.String)
     */
    public Clob getClob(String colName) throws SQLException {
        // TODO Auto-generated method stub
        return ((ResultSet) this.resultContain.get(len)).getClob(colName);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getArray(java.lang.String)
     */
    public Array getArray(String colName) throws SQLException {
        // TODO Auto-generated method stub
        return ((ResultSet) this.resultContain.get(len)).getArray(colName);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getDate(int, java.util.Calendar)
     */
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        // TODO Auto-generated method stub
        return ((ResultSet) this.resultContain.get(len)).getDate(columnIndex,
                cal);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getDate(java.lang.String, java.util.Calendar)
     */
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        // TODO Auto-generated method stub
        return ((ResultSet) this.resultContain.get(len)).getDate(columnName,
                cal);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getTime(int, java.util.Calendar)
     */
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        // TODO Auto-generated method stub
        return ((ResultSet) this.resultContain.get(len)).getTime(columnIndex,
                cal);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getTime(java.lang.String, java.util.Calendar)
     */
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        // TODO Auto-generated method stub
        return ((ResultSet) this.resultContain.get(len)).getTime(columnName,
                cal);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getTimestamp(int, java.util.Calendar)
     */
    public Timestamp getTimestamp(int columnIndex, Calendar cal)
            throws SQLException {
        // TODO Auto-generated method stub
        return ((ResultSet) this.resultContain.get(len)).getTimestamp(
                columnIndex, cal);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getTimestamp(java.lang.String,
     *      java.util.Calendar)
     */
    public Timestamp getTimestamp(String columnName, Calendar cal)
            throws SQLException {
        // TODO Auto-generated method stub
        return ((ResultSet) this.resultContain.get(len)).getTimestamp(
                columnName, cal);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getURL(int)
     */
    public URL getURL(int columnIndex) throws SQLException {
        // TODO Auto-generated method stub
        return ((ResultSet) this.resultContain.get(len)).getURL(columnIndex);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#getURL(java.lang.String)
     */
    public URL getURL(String columnName) throws SQLException {
        // TODO Auto-generated method stub
        return ((ResultSet) this.resultContain.get(len)).getURL(columnName);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateRef(int, java.sql.Ref)
     */
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        // TODO Auto-generated method stub
        ((ResultSet) this.resultContain.get(len)).updateRef(columnIndex, x);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateRef(java.lang.String, java.sql.Ref)
     */
    public void updateRef(String columnName, Ref x) throws SQLException {
        // TODO Auto-generated method stub
        ((ResultSet) this.resultContain.get(len)).updateRef(columnName, x);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateBlob(int, java.sql.Blob)
     */
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        // TODO Auto-generated method stub
        ((ResultSet) this.resultContain.get(len)).updateBlob(columnIndex, x);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateBlob(java.lang.String, java.sql.Blob)
     */
    public void updateBlob(String columnName, Blob x) throws SQLException {
        // TODO Auto-generated method stub
        ((ResultSet) this.resultContain.get(len)).updateBlob(columnName, x);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateClob(int, java.sql.Clob)
     */
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        // TODO Auto-generated method stub
        ((ResultSet) this.resultContain.get(len)).updateClob(columnIndex, x);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateClob(java.lang.String, java.sql.Clob)
     */
    public void updateClob(String columnName, Clob x) throws SQLException {
        // TODO Auto-generated method stub
        ((ResultSet) this.resultContain.get(len)).updateClob(columnName, x);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateArray(int, java.sql.Array)
     */
    public void updateArray(int columnIndex, Array x) throws SQLException {
        // TODO Auto-generated method stub
        ((ResultSet) this.resultContain.get(len)).updateArray(columnIndex, x);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.sql.ResultSet#updateArray(java.lang.String, java.sql.Array)
     */
    public void updateArray(String columnName, Array x) throws SQLException {
        // TODO Auto-generated method stub
        ((ResultSet) this.resultContain.get(len)).updateArray(columnName, x);
    }
	public int getHoldability() throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}
	public Reader getNCharacterStream(int columnIndex) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}
	public Reader getNCharacterStream(String columnLabel) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}
	public NClob getNClob(int columnIndex) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}
	public NClob getNClob(String columnLabel) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}
	public String getNString(int columnIndex) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}
	public String getNString(String columnLabel) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}
	public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}
	public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}
	public RowId getRowId(int columnIndex) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}
	public RowId getRowId(String columnLabel) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}
	public SQLXML getSQLXML(int columnIndex) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}
	public SQLXML getSQLXML(String columnLabel) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}
	public boolean isClosed() throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}
	public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateClob(int columnIndex, Reader reader) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateClob(String columnLabel, Reader reader) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateNClob(int columnIndex, Reader reader) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateNClob(String columnLabel, Reader reader) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateNString(int columnIndex, String nString) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateNString(String columnLabel, String nString) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateRowId(int columnIndex, RowId x) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateRowId(String columnLabel, RowId x) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public boolean isWrapperFor(Class<?> iface) throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}
	public <T> T unwrap(Class<T> iface) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

}
