/*
 * Decompiled with CFR 0.152.
 */
package barcode.linearBarcode;

import barcode.BarcodeTable;
import barcode.BarcodeUtil;
import barcode.linearBarcode.BarcodeConstraints;
import barcode.linearBarcode.LinearBarcode;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public class Barcode39
extends LinearBarcode {
    public int centreX;
    public int centreY;
    String Code39Tran;

    public Barcode39(BarcodeConstraints barcodeConstraints) {
        this.paper = barcodeConstraints;
    }

    @Override
    public void init() {
        this.Code39Tran = this.paper.getBarMessage();
        this.centreX = this.paper.getCenterX();
        this.centreY = this.paper.getCenterY();
        this.foreColor = this.paper.getForeground();
        this.barHeight = this.paper.getBarHeight();
        this.showBottomText = this.paper.getBarHRDisplay();
        this.narrowWidth = this.paper.getBarNarrowWidth();
        this.enableCheckDigit = this.paper.getBarCheckEnable();
        this.scaleMode = this.paper.getBarScaleMode();
        this.bottomLabelFont = this.paper.getBarHRFont();
        this.startingQuietZone = this.paper.getBarQuietZone();
        this.wideToNarrowRatio = (int)this.paper.getBarRatio();
        this.unit = this.paper.getUnit();
        this.backColor = this.paper.getBackground();
        this.isExPDF = this.paper.getIsExportToPDF();
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        if (this.isOK(this.Code39Tran)) {
            this.printCode39(graphics2D, this.Code39Tran);
        }
    }

    @Override
    public void calculateWidth() {
        if (this.isOK(this.Code39Tran)) {
            this.calculateCode39Width(this.Code39Tran);
        }
    }

    protected void calculateCode39Width(String string) {
        int n;
        int n2;
        float f = 50.0f;
        float f2 = 50.0f;
        float f3 = 50.0f;
        float f4 = 20.0f;
        float f5 = BarcodeUtil.getUserDimFromMils(this.narrowWidth, this.scaleMode);
        float f6 = BarcodeUtil.getUserDimFromMils(this.startingQuietZone, this.scaleMode);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.enableCheckDigit;
        if (string.length() == 0) {
            return;
        }
        if (bl) {
            n2 = BarcodeUtil.checkCode2(string);
            stringBuffer = this.Code39Tran(string + String.valueOf((char)n2));
        } else {
            stringBuffer = this.Code39Tran(string);
        }
        f3 = BarcodeUtil.getUserDimFromMils(this.barHeight, this.scaleMode);
        f3 *= this.unit;
        float f7 = f5 *= this.unit;
        f6 *= this.unit;
        n2 = 0;
        for (n = 0; n < stringBuffer.length(); ++n) {
            if (n == stringBuffer.length() - 1 || stringBuffer.charAt(n) != stringBuffer.charAt(n + 1) || this.wideToNarrowRatio != 3) continue;
            ++n2;
        }
        f = f2 = (float)this.centreX - ((float)stringBuffer.length() * f5 + f5 * (float)n2) / 2.0f;
        f4 = (float)this.centreY - f3 / 2.0f;
        for (n = 0; n < stringBuffer.length(); ++n) {
            f7 = n != stringBuffer.length() - 1 && stringBuffer.charAt(n) == stringBuffer.charAt(n + 1) ? (this.wideToNarrowRatio == 3 ? f5 * 2.0f : f5) : f5;
            f += f7;
        }
        Rectangle2D rectangle2D = BarcodeUtil.getBounds("" + string.charAt(0), this.bottomLabelFont);
        int n3 = (int)rectangle2D.getWidth();
        int n4 = (int)rectangle2D.getHeight();
        this.barD.setSize((int)(f6 * 2.0f + f - f2 + (float)(n3 * 2)), (int)(f3 + (float)(n4 * 2)));
        this.paper.setBarDimension(this.barD);
    }

    @Override
    public void calculateWidth(Graphics2D graphics2D) {
        if (this.isOK(this.Code39Tran)) {
            this.calculateCode39Width(graphics2D, this.Code39Tran);
        }
    }

    protected void calculateCode39Width(Graphics2D graphics2D, String string) {
        int n;
        int n2;
        float f = 50.0f;
        float f2 = 50.0f;
        float f3 = 50.0f;
        float f4 = 20.0f;
        float f5 = BarcodeUtil.getUserDimFromMils(this.narrowWidth, this.scaleMode);
        float f6 = BarcodeUtil.getUserDimFromMils(this.startingQuietZone, this.scaleMode);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.enableCheckDigit;
        if (string.length() == 0) {
            return;
        }
        if (bl) {
            n2 = BarcodeUtil.checkCode2(string);
            stringBuffer = this.Code39Tran(string + String.valueOf((char)n2));
        } else {
            stringBuffer = this.Code39Tran(string);
        }
        f3 = BarcodeUtil.getUserDimFromMils(this.barHeight, this.scaleMode);
        f3 *= this.unit;
        float f7 = f5 *= this.unit;
        f6 *= this.unit;
        n2 = 0;
        for (n = 0; n < stringBuffer.length(); ++n) {
            if (n == stringBuffer.length() - 1 || stringBuffer.charAt(n) != stringBuffer.charAt(n + 1) || this.wideToNarrowRatio != 3) continue;
            ++n2;
        }
        f = f2 = (float)this.centreX - ((float)stringBuffer.length() * f5 + f5 * (float)n2) / 2.0f;
        f4 = (float)this.centreY - f3 / 2.0f;
        for (n = 0; n < stringBuffer.length(); ++n) {
            f7 = n != stringBuffer.length() - 1 && stringBuffer.charAt(n) == stringBuffer.charAt(n + 1) ? (this.wideToNarrowRatio == 3 ? f5 * 2.0f : f5) : f5;
            f += f7;
        }
        if (this.showBottomText) {
            graphics2D.setFont(this.bottomLabelFont);
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n3 = fontMetrics.stringWidth("" + string.charAt(0));
        int n4 = (int)fontMetrics.getStringBounds("" + string.charAt(0), graphics2D).getHeight();
        this.barD.setSize((int)(f6 * 2.0f + f - f2 + (float)(n3 * 2)), (int)(f3 + (float)(n4 * 2)));
        this.paper.setBarDimension(this.barD);
    }

    public StringBuffer Code39Tran(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        if (n > 0 && string.charAt(0) != '*') {
            stringBuffer.append(BarcodeTable.code39STranslate[7]);
            stringBuffer.append("0");
        }
        for (int i = 0; i < n; ++i) {
            int n2;
            if (string.charAt(i) >= '0' && string.charAt(i) <= '9') {
                for (n2 = 0; n2 < 10; ++n2) {
                    if (string.charAt(i) != BarcodeTable.code39N[n2]) continue;
                    stringBuffer.append(BarcodeTable.code39NTranslate[n2]);
                }
            } else if (string.charAt(i) >= 'A' && string.charAt(i) <= 'Z') {
                for (n2 = 0; n2 < 26; ++n2) {
                    if (string.charAt(i) != BarcodeTable.code39C[n2]) continue;
                    stringBuffer.append(BarcodeTable.code39CTranslate[n2]);
                }
            } else {
                for (n2 = 0; n2 < 8; ++n2) {
                    if (string.charAt(i) != BarcodeTable.code39S[n2]) continue;
                    stringBuffer.append(BarcodeTable.code39STranslate[n2]);
                }
            }
            stringBuffer.append("0");
        }
        if (string.charAt(n - 1) != '*') {
            stringBuffer.append(BarcodeTable.code39STranslate[7]);
        }
        return stringBuffer;
    }

    public void printCode39(Graphics2D graphics2D, String string) {
        int n;
        int n2;
        float f = 50.0f;
        float f2 = 50.0f;
        float f3 = 50.0f;
        float f4 = 20.0f;
        float f5 = BarcodeUtil.getUserDimFromMils(this.narrowWidth, this.scaleMode);
        float f6 = BarcodeUtil.getUserDimFromMils(this.startingQuietZone, this.scaleMode);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.enableCheckDigit;
        if (string.length() == 0) {
            return;
        }
        if (bl) {
            n2 = BarcodeUtil.checkCode2(string);
            stringBuffer = this.Code39Tran(string + String.valueOf((char)n2));
        } else {
            stringBuffer = this.Code39Tran(string);
        }
        f3 = BarcodeUtil.getUserDimFromMils(this.barHeight, this.scaleMode);
        f3 *= this.unit;
        float f7 = f5 *= this.unit;
        f6 *= this.unit;
        n2 = 0;
        for (n = 0; n < stringBuffer.length(); ++n) {
            if (n == stringBuffer.length() - 1 || stringBuffer.charAt(n) != stringBuffer.charAt(n + 1) || this.wideToNarrowRatio != 3) continue;
            ++n2;
        }
        f = f2 = (float)this.centreX - ((float)stringBuffer.length() * f5 + f5 * (float)n2) / 2.0f;
        f4 = (float)this.centreY - f3 / 2.0f;
        for (n = 0; n < stringBuffer.length(); ++n) {
            f7 = n != stringBuffer.length() - 1 && stringBuffer.charAt(n) == stringBuffer.charAt(n + 1) ? (this.wideToNarrowRatio == 3 ? f5 * 2.0f : f5) : f5;
            if (stringBuffer.charAt(n) == '1') {
                if (this.foreColor != null) {
                    graphics2D.setColor(this.foreColor);
                } else {
                    graphics2D.setColor(Color.black);
                }
                BarcodeUtil.drawbar(graphics2D, f, f4, f7, f3);
            } else if (this.isExPDF) {
                if (this.backColor != null) {
                    graphics2D.setColor(this.backColor);
                } else {
                    graphics2D.setColor(Color.white);
                }
                BarcodeUtil.drawbar(graphics2D, f, f4, f7, f3);
            }
            f += f7;
        }
        if (this.showBottomText) {
            graphics2D.setColor(this.foreColor);
            graphics2D.setFont(this.bottomLabelFont);
            BarcodeUtil.printBarcodeDataM(string, graphics2D, (int)(f / 2.0f + f2 / 2.0f), (int)(f3 + f4), (int)(f - f2));
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n3 = fontMetrics.stringWidth("" + string.charAt(0));
        int n4 = (int)fontMetrics.getStringBounds("" + string.charAt(0), graphics2D).getHeight();
        this.barD.setSize((int)(f6 * 2.0f + f - f2 + (float)(n3 * 2)), (int)(f3 + (float)(n4 * 2)));
        this.paper.setBarDimension(this.barD);
    }

    protected boolean isOK(String string) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            int n2;
            boolean bl = false;
            if (string.charAt(i) >= '0' && string.charAt(i) <= '9') {
                for (n2 = 0; n2 < 10; ++n2) {
                    if (string.charAt(i) != BarcodeTable.code39N[n2]) continue;
                    bl = true;
                }
            } else if (string.charAt(i) >= 'A' && string.charAt(i) <= 'Z') {
                for (n2 = 0; n2 < 26; ++n2) {
                    if (string.charAt(i) != BarcodeTable.code39C[n2]) continue;
                    bl = true;
                }
            } else {
                for (n2 = 0; n2 < 8; ++n2) {
                    if (string.charAt(i) != BarcodeTable.code39S[n2]) continue;
                    bl = true;
                }
            }
            if (bl) continue;
            return false;
        }
        return true;
    }
}

