/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.ChartCoordinatePaper;
import chart.ChartLabelBase;
import chart.axis.ChartAxis;
import chart.axis.ChartCategoryAxis;
import chart.chart2d.Chart2DLayer;
import chart.chart2d.Chart2DObject;
import chart.chart2d.Chart2DPaper;
import chart.chart2d.Chart2DSimplePaper;
import chart.data.ChartDataFilter;
import chart.data.ChartDataSet;
import chart.graphics.ChartBackground;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartGradientPattern;
import chart.graphics.ChartPenStyle;
import chart.graphics.ChartTextStyle;
import chart.properties.ChartLabelProperties;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import javax.swing.plaf.basic.BasicArrowButton;

public class Chart2DScrollbar
extends Chart2DObject {
    protected float[][] vertex;
    protected float[][] tVertex;
    protected float unitX;
    protected float unitY;
    protected Rectangle rec = null;
    protected float[][] scrollVertex;
    protected GeneralPath scrollPath = new GeneralPath();
    protected float[][] lScrollVertex;
    protected float[][] rScrollVertex;
    protected Rectangle lScrollPath = null;
    protected Rectangle rScrollPath = null;
    float abs;
    float black;
    boolean clone = false;
    boolean closePath = false;
    ChartBackground contains;
    ChartBackground create;
    ChartBackground custommerConstant;
    boolean draw;
    int filter = 7;
    int format = 20;
    protected float[][] leftMoveIcon;
    protected float[][] rightMoveIcon;
    protected GeneralPath leftMoveIconP = new GeneralPath();
    protected GeneralPath rightMoveIconP = new GeneralPath();
    protected static final int MOVEICONTYPE_TRIANGLE = 0;
    protected static final int MOVEICONTYPE_RECTANGLE = 1;
    protected ChartLabelBase startLbl;
    protected ChartLabelBase endLbl;
    protected float[] startLblPos;
    protected float[] endLblPos;
    protected Rectangle lRect;
    protected Rectangle rRect;
    protected int mouseX = -1;
    protected int mouseY = -1;
    protected ChartGradientPattern iconFill;
    protected ChartDataFilter labelFilter = null;
    protected ChartColorPattern spareLineC = null;
    protected ChartTextStyle textSty = null;
    private boolean getAxisX1 = false;
    float[] getAxisX2 = null;

    public Chart2DScrollbar(ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer) {
        super(chartDataSet, chart2DPaper, chart2DLayer);
    }

    @Override
    public void init() {
        if (!this.clone) {
            this.vertex = new float[4][2];
            this.tVertex = new float[4][2];
            this.scrollVertex = new float[4][2];
            this.lScrollVertex = new float[4][2];
            this.rScrollVertex = new float[4][2];
            this.SEDU();
            this.contains = new ChartBackground();
            this.create = new ChartBackground();
            this.contains.setPattern(this.iconFill);
            this.create.setPattern(this.iconFill);
            ChartColorPattern chartColorPattern = new ChartColorPattern(new Color(90, 90, 90));
            chartColorPattern.setAlpha(0.3f);
            this.contains.setBorderColor(chartColorPattern);
            this.contains.setBorderStyle(1);
            this.create.setBorderStyle(1);
            this.custommerConstant = new ChartBackground(null);
            this.create.setBorderColor(chartColorPattern);
            this.custommerConstant.setBorderStyle(2);
            this.leftMoveIcon = new float[3][2];
            this.rightMoveIcon = new float[3][2];
            this.clone = true;
            this.abs();
            this.startLblPos = new float[2];
            this.endLblPos = new float[2];
            this.lRect = new Rectangle();
            this.rRect = new Rectangle();
            this.lScrollPath = new Rectangle();
            this.rScrollPath = new Rectangle();
            this.spareLineC = new ChartColorPattern(new Color(186, 186, 186));
        }
    }

    void SEDU() {
        if (this.iconFill != null) {
            return;
        }
        if (!this.draw) {
            ChartColorPattern chartColorPattern = new ChartColorPattern(new Color(241, 241, 241));
            ChartColorPattern chartColorPattern2 = new ChartColorPattern(new Color(182, 182, 182));
            Point2D.Float float_ = new Point2D.Float(0.14f, 0.05f);
            Point2D.Float float_2 = new Point2D.Float(0.86f, 0.95f);
            this.iconFill = new ChartGradientPattern(1, true, chartColorPattern, float_, chartColorPattern2, float_2);
        } else {
            ChartColorPattern chartColorPattern = new ChartColorPattern(new Color(241, 241, 241));
            ChartColorPattern chartColorPattern3 = new ChartColorPattern(new Color(182, 182, 182));
            Point2D.Float float_ = new Point2D.Float(0.14f, 0.14f);
            Point2D.Float float_3 = new Point2D.Float(0.86f, 0.86f);
            this.iconFill = new ChartGradientPattern(1, true, chartColorPattern3, float_, chartColorPattern, float_3);
        }
    }

    private void abs() {
        ChartLabelProperties chartLabelProperties = new ChartLabelProperties();
        ChartLabelProperties chartLabelProperties2 = new ChartLabelProperties();
        ChartTextStyle chartTextStyle = new ChartTextStyle();
        ChartTextStyle chartTextStyle2 = new ChartTextStyle();
        chartTextStyle.setFontSize(10);
        chartTextStyle.setFontColor(new ChartColorPattern(new Color(0, 0, 0)));
        chartTextStyle2.setFontSize(10);
        chartTextStyle2.setFontColor(new ChartColorPattern(new Color(0, 0, 0)));
        chartLabelProperties.setTextStyle(chartTextStyle);
        chartLabelProperties2.setTextStyle(chartTextStyle2);
        this.startLbl = new ChartLabelBase("", chartLabelProperties);
        this.endLbl = new ChartLabelBase("", chartLabelProperties2);
    }

    protected void resetLabelTextStyle() {
        if (this.textSty != null && this.startLbl != null && this.endLbl != null) {
            ChartTextStyle chartTextStyle = (ChartTextStyle)this.textSty.clone();
            if (chartTextStyle.getFontName() != null) {
                this.startLbl.getChartTextStyle().setFontName(chartTextStyle.getFontName());
                this.endLbl.getChartTextStyle().setFontName(chartTextStyle.getFontName());
            }
            if (chartTextStyle.getFontColor() != null) {
                this.startLbl.getChartTextStyle().setFontColor(chartTextStyle.getFontColor());
                this.endLbl.getChartTextStyle().setFontColor(chartTextStyle.getFontColor());
            }
        }
    }

    public void setScrollInfo(float[] fArray2) {
        if (fArray2 == null || this.vertex == null) {
            return;
        }
        if (fArray2.length == 2) {
            float f = fArray2[0];
            float f2 = fArray2[1];
            f = f < 0.0f ? 0.0f : f;
            f = f > 1.0f ? 1.0f : f;
            f2 = f2 > 1.0f ? 1.0f : f2;
            float f3 = f2 = f2 < 0.0f ? 0.0f : f2;
            if (f > f2) {
                f += f2;
                f2 = f - f2;
                f -= f2;
            }
            if (this.getAxisX2 == null) {
                this.getAxisX2 = new float[2];
            }
            this.getAxisX2[0] = f;
            this.getAxisX2[1] = f2;
            this.getAxisX1 = true;
        }
    }

    public void setBounds(Rectangle rectangle) {
        if (!this.closePath) {
            this.rec = rectangle;
            this.vertex[0][0] = 0.0f;
            this.vertex[0][1] = 0.0f;
            this.vertex[1][0] = rectangle.width;
            this.vertex[1][1] = 0.0f;
            this.vertex[2][0] = rectangle.width;
            this.vertex[2][1] = rectangle.height;
            this.vertex[3][0] = 0.0f;
            this.vertex[3][1] = rectangle.height;
            float[] fArray2 = this.paper.I.getScrollbarInfo();
            float f = 0.0f;
            if (fArray2 != null) {
                f = fArray2[1] - fArray2[0];
            }
            f = f < 0.0f ? 0.0f : f;
            f = f > 1.0f ? 1.0f : f;
            float f2 = 0.0f;
            float f3 = 1.0f;
            if (!this.draw) {
                int n = (int)((float)rectangle.width * f);
                if (this.paper.getChartPlatform().getScrollbarInfo() != null) {
                    f2 = fArray2[0] * (float)rectangle.width;
                    n = (int)(f * (float)rectangle.width);
                }
                this.scrollVertex[0][0] = 0.0f + f2;
                this.scrollVertex[0][1] = 2.0f;
                this.scrollVertex[1][0] = this.scrollVertex[0][0] + (float)n;
                this.scrollVertex[1][1] = 2.0f;
                this.scrollVertex[2][0] = this.scrollVertex[0][0] + (float)n;
                this.scrollVertex[2][1] = this.vertex[2][1] - 2.0f;
                this.scrollVertex[3][0] = this.scrollVertex[0][0];
                this.scrollVertex[3][1] = this.vertex[2][1] - 2.0f;
            } else {
                int n = (int)((float)rectangle.height * f);
                if (fArray2 != null) {
                    f2 = (1.0f - fArray2[0]) * (float)rectangle.height;
                    n = (int)(f * (float)rectangle.height);
                }
                this.scrollVertex[1][1] = f2;
                this.scrollVertex[1][0] = 0.0f;
                this.scrollVertex[0][1] = this.scrollVertex[1][1] - (float)n;
                this.scrollVertex[0][0] = 0.0f;
                this.scrollVertex[2][1] = f2;
                this.scrollVertex[2][0] = rectangle.width;
                this.scrollVertex[3][1] = this.scrollVertex[2][1] - (float)n;
                this.scrollVertex[3][0] = rectangle.width;
            }
            this.closePath = true;
        }
    }

    public Rectangle2D getBounds() {
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        if (this.scrollVertex != null) {
            if (!this.draw) {
                float_.x = this.scrollVertex[0][0] < this.scrollVertex[2][0] ? this.scrollVertex[0][0] : this.scrollVertex[2][0];
                float_.y = this.scrollVertex[0][1] < this.scrollVertex[2][1] ? this.scrollVertex[0][1] : this.scrollVertex[2][1];
                float_.width = Math.abs(this.scrollVertex[0][0] - this.scrollVertex[2][0]);
                float_.height = Math.abs(this.scrollVertex[0][1] - this.scrollVertex[2][1]);
            } else {
                float_.x = this.scrollVertex[0][0] < this.scrollVertex[2][0] ? this.scrollVertex[0][0] : this.scrollVertex[2][0];
                float_.y = this.scrollVertex[0][1] < this.scrollVertex[2][1] ? this.scrollVertex[0][1] : this.scrollVertex[2][1];
                float_.width = Math.abs(this.scrollVertex[0][0] - this.scrollVertex[2][0]);
                float_.height = Math.abs(this.scrollVertex[0][1] - this.scrollVertex[2][1]);
            }
        }
        return float_;
    }

    @Override
    Shape[][] getItemShapes() {
        return null;
    }

    @Override
    float[][] getStaticHintLocation() {
        return null;
    }

    @Override
    public Shape getShapeByItem(int n, int n2) {
        return null;
    }

    @Override
    public Shape getShapeBySeries(int n) {
        return null;
    }

    @Override
    public String[] search(int n, int n2) {
        return null;
    }

    @Override
    public int searchSeries(int n, int n2) {
        return 0;
    }

    @Override
    public void locate() {
        this.layer.I(this.vertex, this.tVertex);
        this.scrollPath.reset();
        if (this.getAxisX1 && this.getAxisX2 != null) {
            if (!this.draw) {
                this.scrollVertex[0][0] = this.vertex[0][0] + Math.abs(this.vertex[2][0] - this.vertex[0][0]) * this.getAxisX2[0];
                this.scrollVertex[0][1] = this.scrollVertex[0][1];
                this.scrollVertex[1][0] = this.vertex[0][0] + Math.abs(this.vertex[2][0] - this.vertex[0][0]) * this.getAxisX2[1];
                this.scrollVertex[1][1] = this.scrollVertex[1][1];
                this.scrollVertex[2][0] = this.vertex[0][0] + Math.abs(this.vertex[2][0] - this.vertex[0][0]) * this.getAxisX2[1];
                this.scrollVertex[2][1] = this.scrollVertex[2][1];
                this.scrollVertex[3][0] = this.vertex[0][0] + Math.abs(this.vertex[2][0] - this.vertex[0][0]) * this.getAxisX2[0];
                this.scrollVertex[3][1] = this.scrollVertex[3][1];
                this.scrollPath.moveTo(this.scrollVertex[0][0], this.scrollVertex[0][1]);
                this.scrollPath.lineTo(this.scrollVertex[1][0], this.scrollVertex[1][1]);
                this.scrollPath.lineTo(this.scrollVertex[2][0], this.scrollVertex[2][1]);
                this.scrollPath.lineTo(this.scrollVertex[3][0], this.scrollVertex[3][1]);
                this.scrollPath.lineTo(this.scrollVertex[0][0], this.scrollVertex[0][1]);
                this.scrollPath.closePath();
            } else {
                this.scrollVertex[0][1] = this.vertex[2][1] - Math.abs(this.vertex[2][1] - this.vertex[0][1]) * this.getAxisX2[1];
                this.scrollVertex[1][1] = this.vertex[2][1] - Math.abs(this.vertex[2][1] - this.vertex[0][1]) * this.getAxisX2[0];
                this.scrollVertex[2][1] = this.vertex[2][1] - Math.abs(this.vertex[2][1] - this.vertex[0][1]) * this.getAxisX2[0];
                this.scrollVertex[3][1] = this.vertex[2][1] - Math.abs(this.vertex[2][1] - this.vertex[0][1]) * this.getAxisX2[1];
                if (this.scrollVertex[0][1] > this.vertex[2][1]) {
                    this.scrollVertex[0][1] = this.vertex[2][1];
                    this.scrollVertex[3][1] = this.scrollVertex[0][1];
                }
                if (this.scrollVertex[0][1] < this.vertex[0][1]) {
                    this.scrollVertex[0][1] = this.vertex[0][1];
                    this.scrollVertex[3][1] = this.scrollVertex[0][1];
                }
                if (this.scrollVertex[1][1] > this.vertex[2][1]) {
                    this.scrollVertex[1][1] = this.vertex[2][1];
                    this.scrollVertex[2][1] = this.scrollVertex[1][1];
                }
                if (this.scrollVertex[1][1] < this.vertex[0][1]) {
                    this.scrollVertex[1][1] = this.vertex[0][1];
                    this.scrollVertex[2][1] = this.scrollVertex[1][1];
                }
                this.scrollPath.moveTo(this.scrollVertex[0][0], this.scrollVertex[0][1]);
                this.scrollPath.lineTo(this.scrollVertex[1][0], this.scrollVertex[1][1]);
                this.scrollPath.lineTo(this.scrollVertex[2][0], this.scrollVertex[2][1]);
                this.scrollPath.lineTo(this.scrollVertex[3][0], this.scrollVertex[3][1]);
                this.scrollPath.lineTo(this.scrollVertex[0][0], this.scrollVertex[0][1]);
                this.scrollPath.closePath();
            }
            this.getAxisX1 = false;
        } else if (!this.draw) {
            this.scrollVertex[0][0] = this.scrollVertex[0][0] + this.abs < this.vertex[0][0] ? this.vertex[0][0] : this.scrollVertex[0][0] + this.abs;
            this.scrollVertex[0][1] = this.scrollVertex[0][1];
            this.scrollVertex[1][0] = this.scrollVertex[1][0] + this.black;
            this.scrollVertex[1][0] = this.scrollVertex[1][0] > this.vertex[2][0] ? this.vertex[2][0] : this.scrollVertex[1][0];
            this.scrollVertex[1][1] = this.scrollVertex[1][1];
            this.scrollVertex[2][0] = this.scrollVertex[2][0] + this.black;
            this.scrollVertex[2][0] = this.scrollVertex[2][0] > this.vertex[2][0] ? this.vertex[2][0] : this.scrollVertex[2][0];
            this.scrollVertex[2][1] = this.scrollVertex[2][1];
            this.scrollVertex[3][0] = this.scrollVertex[3][0] + this.abs < this.vertex[0][0] ? this.vertex[0][0] : this.scrollVertex[3][0] + this.abs;
            this.scrollVertex[3][1] = this.scrollVertex[3][1];
            this.scrollPath.moveTo(this.scrollVertex[0][0], this.scrollVertex[0][1]);
            this.scrollPath.lineTo(this.scrollVertex[1][0], this.scrollVertex[1][1]);
            this.scrollPath.lineTo(this.scrollVertex[2][0], this.scrollVertex[2][1]);
            this.scrollPath.lineTo(this.scrollVertex[3][0], this.scrollVertex[3][1]);
            this.scrollPath.lineTo(this.scrollVertex[0][0], this.scrollVertex[0][1]);
            this.scrollPath.closePath();
        } else {
            this.scrollVertex[0][1] = this.scrollVertex[0][1] + this.abs < this.vertex[0][1] ? this.vertex[0][1] : this.scrollVertex[0][1] + this.abs;
            this.scrollVertex[0][0] = this.scrollVertex[0][0];
            this.scrollVertex[1][1] = this.scrollVertex[1][1] + this.black;
            this.scrollVertex[1][1] = this.scrollVertex[1][1] > this.vertex[2][1] ? this.vertex[2][1] : this.scrollVertex[1][1];
            this.scrollVertex[1][0] = this.scrollVertex[1][0];
            this.scrollVertex[2][1] = this.scrollVertex[2][1] + this.black;
            this.scrollVertex[2][1] = this.scrollVertex[2][1] > this.vertex[2][1] ? this.vertex[2][1] : this.scrollVertex[2][1];
            this.scrollVertex[2][0] = this.scrollVertex[2][0];
            this.scrollVertex[3][1] = this.scrollVertex[3][1] + this.abs < this.vertex[0][1] ? this.vertex[0][1] : this.scrollVertex[3][1] + this.abs;
            this.scrollVertex[3][0] = this.scrollVertex[3][0];
            this.scrollPath.moveTo(this.scrollVertex[0][0], this.scrollVertex[0][1]);
            this.scrollPath.lineTo(this.scrollVertex[1][0], this.scrollVertex[1][1]);
            this.scrollPath.lineTo(this.scrollVertex[2][0], this.scrollVertex[2][1]);
            this.scrollPath.lineTo(this.scrollVertex[3][0], this.scrollVertex[3][1]);
            this.scrollPath.lineTo(this.scrollVertex[0][0], this.scrollVertex[0][1]);
            this.scrollPath.closePath();
        }
        this.closePath();
        this.black();
        this.endLbl();
    }

    private void black() {
        if (this.lRect == null || this.rRect == null) {
            return;
        }
        this.leftMoveIconP.reset();
        this.rightMoveIconP.reset();
        if (!this.draw) {
            this.leftMoveIconP.moveTo(this.lRect.x + 2, this.lRect.y + this.lRect.height / 2);
            this.leftMoveIconP.lineTo(this.lRect.x + this.lRect.width - 2, this.lRect.y + this.lRect.height / 2 + this.lRect.height / 5);
            this.leftMoveIconP.lineTo(this.lRect.x + this.lRect.width - 2, this.lRect.y + this.lRect.height / 2 - this.lRect.height / 5);
            this.leftMoveIconP.closePath();
            this.rightMoveIconP.moveTo(this.rRect.x + this.rRect.width - 2, this.rRect.y + this.rRect.height / 2);
            this.rightMoveIconP.lineTo(this.rRect.x + 2, this.rRect.y + this.rRect.height / 2 - this.rRect.height / 5);
            this.rightMoveIconP.lineTo(this.rRect.x + 2, this.rRect.y + this.rRect.height / 2 + this.rRect.height / 5);
            this.rightMoveIconP.closePath();
        } else {
            this.leftMoveIconP.moveTo(this.lRect.x + this.lRect.width / 2, this.lRect.y + this.lRect.height - 2);
            this.leftMoveIconP.lineTo(this.lRect.x + this.lRect.width / 2 - this.lRect.width / 5, this.lRect.y + 2);
            this.leftMoveIconP.lineTo(this.lRect.x + this.lRect.width / 2 + this.lRect.width / 5, this.lRect.y + 2);
            this.leftMoveIconP.closePath();
            this.rightMoveIconP.moveTo(this.rRect.x + this.rRect.width / 2, this.rRect.y + 2);
            this.rightMoveIconP.lineTo(this.rRect.x + this.lRect.width / 2 - this.lRect.width / 5, this.rRect.y + this.rRect.height - 2);
            this.rightMoveIconP.lineTo(this.rRect.x + this.lRect.width / 2 + this.lRect.width / 5, this.rRect.y + this.rRect.height - 2);
            this.rightMoveIconP.closePath();
        }
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        this.create(graphics2D);
        this.clone(graphics2D);
        this.endLblPos(graphics2D);
    }

    private void clone(Graphics2D graphics2D) {
        if (this.lRect != null && this.rRect != null) {
            BasicArrowButton basicArrowButton = null;
            BasicArrowButton basicArrowButton2 = null;
            if (!this.draw) {
                basicArrowButton = new BasicArrowButton(7);
                basicArrowButton2 = new BasicArrowButton(3);
            } else {
                basicArrowButton = new BasicArrowButton(5);
                basicArrowButton2 = new BasicArrowButton(1);
            }
            basicArrowButton.setBounds(0, 0, this.lRect.width, this.lRect.height);
            basicArrowButton2.setBounds(0, 0, this.rRect.width, this.rRect.height);
            basicArrowButton.updateUI();
            basicArrowButton2.updateUI();
            try {
                Graphics2D graphics2D2 = (Graphics2D)graphics2D.create(this.lRect.x, this.lRect.y, this.lRect.width + 2, this.lRect.height + 2);
                basicArrowButton.paint(graphics2D2);
                graphics2D2 = (Graphics2D)graphics2D.create(this.rRect.x, this.rRect.y, this.rRect.width + 2, this.rRect.height + 2);
                basicArrowButton2.paint(graphics2D2);
            }
            catch (Exception exception) {
                this.contains.paintBackground(graphics2D, this.lRect);
                this.create.paintBackground(graphics2D, this.rRect);
            }
        }
    }

    private void closePath() {
        if (this.scrollVertex == null) {
            return;
        }
        if (!this.draw) {
            int n = (int)Math.abs(this.scrollVertex[3][1] - this.scrollVertex[0][1]);
            n = (n = (int)((float)(n - 15) * 0.5f)) > this.format ? this.format : n;
            int n2 = (int)((Math.abs(this.scrollVertex[3][1] - this.scrollVertex[0][1]) - 15.0f - (float)n) / 2.0f);
            this.lRect.x = (int)this.scrollVertex[0][0] - this.filter / 2;
            this.lRect.y = (int)this.scrollVertex[0][1] + n2;
            this.lRect.width = this.filter;
            this.lRect.height = n;
            this.rRect.x = (int)this.scrollVertex[1][0] - this.filter / 2;
            this.rRect.y = (int)this.scrollVertex[1][1] + n2;
            this.rRect.width = this.filter;
            this.rRect.height = n;
        } else {
            int n = (int)Math.abs(this.scrollVertex[3][0] - this.scrollVertex[0][0]);
            n = (n = (int)((float)(n - 15) * 0.5f)) > this.format ? this.format : n;
            int n3 = (int)((Math.abs(this.scrollVertex[3][0] - this.scrollVertex[0][0]) - 15.0f - (float)n) / 2.0f);
            this.lRect.x = (int)this.scrollVertex[0][0] + 15 + n3;
            this.lRect.y = (int)this.scrollVertex[1][1] - this.filter / 2;
            this.lRect.width = n;
            this.lRect.height = this.filter;
            this.rRect.x = (int)this.scrollVertex[0][0] + 15 + n3;
            this.rRect.y = (int)this.scrollVertex[0][1] - this.filter / 2;
            this.rRect.width = n;
            this.rRect.height = this.filter;
        }
        this.contains();
    }

    private void contains() {
        if (!this.draw) {
            this.lScrollPath.x = this.lRect.x;
            this.lScrollPath.y = this.lRect.y;
            this.lScrollPath.width = this.lRect.width;
            this.lScrollPath.height = this.lRect.height;
            this.rScrollPath.x = this.rRect.x;
            this.rScrollPath.y = this.rRect.y;
            this.rScrollPath.width = this.rRect.width;
            this.rScrollPath.height = this.rRect.height;
        } else {
            this.lScrollPath.x = this.rRect.x;
            this.lScrollPath.y = this.rRect.y;
            this.lScrollPath.width = this.rRect.width;
            this.lScrollPath.height = this.rRect.height;
            this.rScrollPath.x = this.lRect.x;
            this.rScrollPath.y = this.lRect.y;
            this.rScrollPath.width = this.lRect.width;
            this.rScrollPath.height = this.lRect.height;
        }
    }

    private void create(Graphics2D graphics2D) {
        if (this.scrollVertex != null) {
            ChartColorPattern chartColorPattern = new ChartColorPattern(Color.black);
            chartColorPattern.setAlpha(0.5f);
            ChartPenStyle chartPenStyle = new ChartPenStyle(chartColorPattern);
            chartPenStyle.setPenWidth(1.0f);
            if (!this.draw) {
                chartPenStyle.draw(graphics2D, new Line2D.Float((int)this.scrollVertex[1][0], (int)this.scrollVertex[1][1], (int)this.scrollVertex[2][0], (int)this.scrollVertex[2][1] - 15));
                chartPenStyle.draw(graphics2D, new Line2D.Float((int)this.scrollVertex[0][0], (int)this.scrollVertex[0][1], (int)this.scrollVertex[3][0], (int)this.scrollVertex[3][1] - 15));
            } else {
                chartPenStyle.draw(graphics2D, new Line2D.Float((int)this.scrollVertex[1][0] + 15, (int)this.scrollVertex[1][1], (int)this.scrollVertex[2][0], (int)this.scrollVertex[2][1]));
                chartPenStyle.draw(graphics2D, new Line2D.Float((int)this.scrollVertex[0][0] + 15, (int)this.scrollVertex[0][1], (int)this.scrollVertex[3][0], (int)this.scrollVertex[3][1]));
            }
        }
    }

    public int getPosition(int n, int n2) {
        if (!this.draw) {
            return this.custommerConstant(n, n2);
        }
        return this.draw(n, n2);
    }

    int custommerConstant(int n, int n2) {
        if (this.rScrollPath.contains(n, n2)) {
            return 1;
        }
        if (this.lScrollPath.contains(n, n2)) {
            return 0;
        }
        if (this.scrollPath.contains(n, n2)) {
            return 2;
        }
        return -1;
    }

    int draw(int n, int n2) {
        if (this.lScrollPath.contains(n, n2)) {
            return 0;
        }
        if (this.rScrollPath.contains(n, n2)) {
            return 1;
        }
        if (this.scrollPath.contains(n, n2)) {
            return 2;
        }
        return -1;
    }

    public void setMoveLength(float f, float f2) {
        this.abs = f;
        this.black = f2;
    }

    public float[] getStartAndEndP() {
        float[] fArray2 = new float[2];
        if (!this.draw) {
            fArray2[0] = this.scrollVertex[0][0] / (float)this.rec.width;
            fArray2[1] = this.scrollVertex[1][0] / (float)this.rec.width;
        } else {
            fArray2[1] = ((float)this.rec.height - this.scrollVertex[0][1]) / (float)this.rec.height;
            fArray2[0] = ((float)this.rec.height - this.scrollVertex[1][1]) / (float)this.rec.height;
        }
        return fArray2;
    }

    public void setIsBench(boolean bl) {
        this.draw = bl;
    }

    public void setLocate(boolean bl) {
        this.closePath = bl;
    }

    void endLbl() {
        Object object;
        Object object2;
        Object object3 = null;
        Object object4 = null;
        ChartCoordinatePaper chartCoordinatePaper = this.paper.I.getChartCoordinatePaper();
        ChartAxis chartAxis = chartCoordinatePaper.getAxisX1();
        if (chartAxis == null && chartCoordinatePaper instanceof Chart2DPaper) {
            chartAxis = ((Chart2DPaper)chartCoordinatePaper).getAxisX2();
        }
        if (chartAxis != null && chartAxis instanceof ChartCategoryAxis && chartAxis.custommerConstant()) {
            String string;
            object2 = null;
            if (chartAxis != null && chartAxis instanceof ChartCategoryAxis && chartAxis.custommerConstant()) {
                object2 = chartAxis.getConstantStartEnd();
            }
            object3 = object2 != null ? (Object)object2[0] : null;
            Object object5 = object4 = object2 != null ? (Object)object2[1] : null;
            if (object3 != null) {
                string = null;
                if (this.labelFilter != null) {
                    string = this.labelFilter.filter(object3);
                } else if (object3 instanceof Timestamp && this.labelFilter == null) {
                    object = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss a");
                    string = ((Format)object).format(object3);
                } else if (object3 instanceof Date && this.labelFilter == null) {
                    object = new SimpleDateFormat("yyyy-MM-dd");
                    string = ((Format)object).format(object3);
                } else if (object3 instanceof Time && this.labelFilter == null) {
                    object = new SimpleDateFormat("HH:mm:ss a");
                    string = ((Format)object).format(object3);
                } else if (object3 instanceof Number && this.labelFilter == null) {
                    object = new DecimalFormat("0.00");
                    string = ((Format)object).format(object3);
                } else {
                    string = object3.toString();
                }
                this.startLbl.setLabelText(string);
            }
            if (object4 != null) {
                string = null;
                if (this.labelFilter != null) {
                    string = this.labelFilter.filter(object4);
                } else if (object4 instanceof Timestamp && this.labelFilter == null) {
                    object = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss a");
                    string = ((Format)object).format(object4);
                } else if (object4 instanceof Date && this.labelFilter == null) {
                    object = new SimpleDateFormat("yyyy-MM-dd");
                    string = ((Format)object).format(object4);
                } else if (object4 instanceof Time && this.labelFilter == null) {
                    object = new SimpleDateFormat("HH:mm:ss a");
                    string = ((Format)object).format(object4);
                } else if (object4 instanceof Number && this.labelFilter == null) {
                    object = new DecimalFormat("0.00");
                    string = ((Format)object).format(object4);
                } else {
                    string = object4.toString();
                }
                this.endLbl.setLabelText(string);
            }
        } else {
            object2 = new int[]{this.paper.getChartPlatform().showScrollLabelStart(), this.paper.getChartPlatform().showScrollLabelEnd() - 1};
            int n = this.paper.model.getCategoryCount();
            if (object2[0] < 0) {
                object2[0] = 0;
            }
            if (object2[1] < 0) {
                object2[1] = 0;
            }
            if (object2[0] >= n) {
                object2[0] = n - 1;
            }
            if (object2[1] >= n) {
                object2[1] = n - 1;
            }
            object3 = this.paper.model.getCategoryName(object2[0]);
            object4 = this.paper.model.getCategoryName((int)object2[1]);
            if (object3 != null) {
                object = null;
                object = this.labelFilter != null ? this.labelFilter.filter(object3, ((Chart2DSimplePaper)this.paper).getDatePosition()[0]) : object3.toString();
                this.startLbl.setLabelText((String)object);
            }
            if (object4 != null) {
                object = null;
                object = this.labelFilter != null ? this.labelFilter.filter(object4, ((Chart2DSimplePaper)this.paper).getDatePosition()[1] > 0 ? ((Chart2DSimplePaper)this.paper).getDatePosition()[1] - 1 : 0) : object4.toString();
                this.endLbl.setLabelText((String)object);
            }
        }
        object2 = null;
        object2 = !this.draw ? (Object)this.startLbl.getChartTextStyle() : (Object)this.endLbl.getChartTextStyle();
        if (!this.draw) {
            float f = Math.abs(this.scrollVertex[0][0] - this.scrollVertex[2][0]);
            float f2 = (float)((ChartTextStyle)object2).getDimension(this.startLbl.getLabelText()).getWidth();
            float f3 = (float)((ChartTextStyle)object2).getDimension(this.endLbl.getLabelText()).getWidth();
            f3 += (float)(((ChartTextStyle)object2).getFontSize() / 3);
            float f4 = (float)((double)this.paper.getHeight() - ((ChartTextStyle)object2).getDimension(this.startLbl.getLabelText()).getHeight()) - 6.0f;
            float f5 = Math.abs(this.vertex[0][0] - this.vertex[2][0]);
            float f6 = (float)((ChartTextStyle)object2).getDimension("  ").getWidth();
            this.startLblPos[0] = this.scrollVertex[0][0] - f2 / 2.0f;
            if (f2 / 2.0f > f / 2.0f - f6) {
                this.startLblPos[0] = this.startLblPos[0] - (f2 / 2.0f - (f / 2.0f - f6));
            }
            this.startLblPos[0] = this.startLblPos[0] < 0.0f ? 0.0f : this.startLblPos[0];
            this.endLblPos[0] = this.scrollVertex[2][0] - f3 / 2.0f;
            if (this.endLblPos[0] < this.startLblPos[0] + f2 + f6) {
                this.endLblPos[0] = this.endLblPos[0] + (this.startLblPos[0] + f2 + f6 - this.endLblPos[0]);
            }
            if (this.endLblPos[0] + f3 > f5) {
                this.endLblPos[0] = this.endLblPos[0] - (this.endLblPos[0] + f3 - f5);
                if (this.startLblPos[0] + f2 + f6 > this.endLblPos[0]) {
                    this.startLblPos[0] = this.startLblPos[0] - (this.startLblPos[0] + f2 + f6 - this.endLblPos[0]);
                }
            }
            this.startLblPos[1] = f4;
            this.endLblPos[1] = f4;
        } else {
            this.startLbl.getChartTextStyle().setRotation(1.5707963267948966);
            this.endLbl.getChartTextStyle().setRotation(1.5707963267948966);
            float f = Math.abs(this.scrollVertex[0][1] - this.scrollVertex[2][1]);
            float f7 = 6.0f;
            float f8 = (float)((ChartTextStyle)object2).getDimension(this.startLbl.getLabelText()).getHeight();
            float f9 = (float)((ChartTextStyle)object2).getDimension(this.endLbl.getLabelText()).getHeight();
            float f10 = Math.abs(this.vertex[0][1] - this.vertex[2][1]);
            float f11 = (float)((ChartTextStyle)object2).getDimension("  ").getWidth();
            this.startLblPos[1] = this.scrollVertex[1][1] - (f8 += (float)(((ChartTextStyle)object2).getFontSize() / 3)) / 2.0f;
            if (f8 / 2.0f > f / 2.0f - f11) {
                this.startLblPos[1] = this.startLblPos[1] + (f8 / 2.0f - (f / 2.0f - f11));
            }
            this.startLblPos[1] = this.startLblPos[1] + f8 > f10 ? this.startLblPos[1] - (this.startLblPos[1] + f8 - f10) : this.startLblPos[1];
            this.endLblPos[1] = this.scrollVertex[0][1] - f9 / 2.0f;
            if (this.endLblPos[1] + f9 + f11 > this.startLblPos[1]) {
                this.endLblPos[1] = this.endLblPos[1] - (this.endLblPos[1] + f9 + f11 - this.startLblPos[1]);
            }
            if (this.endLblPos[1] < 0.0f) {
                this.endLblPos[1] = this.endLblPos[1] + (0.0f - this.endLblPos[1]);
                if (this.startLblPos[1] < this.endLblPos[1] + f9) {
                    this.startLblPos[1] = this.endLblPos[1] + f9 + f11;
                }
            }
            this.startLblPos[0] = f7;
            this.endLblPos[0] = f7;
        }
    }

    void endLblPos(Graphics2D graphics2D) {
        this.startLbl.paint(graphics2D, this.startLblPos[0], this.startLblPos[1]);
        this.endLbl.paint(graphics2D, this.endLblPos[0], this.endLblPos[1]);
    }

    public void setMouseLoc(int n, int n2) {
        this.mouseX = n - this.paper.getBounds().x;
        this.mouseY = n2 - this.paper.getBounds().y;
    }

    public boolean isOutBounds(float f, float f2) {
        return !this.draw ? this.scrollVertex[0][0] + f < this.vertex[0][0] || this.scrollVertex[1][0] + f2 > this.vertex[1][0] || this.scrollVertex[1][0] + f2 - (this.scrollVertex[0][0] + f) < 7.0f : this.scrollVertex[0][1] + f < this.vertex[0][1] || this.scrollVertex[1][1] + f2 > this.vertex[2][1] || this.scrollVertex[1][1] + f2 - (this.scrollVertex[0][1] + f) < 7.0f;
    }

    public void setLabelFilter(ChartDataFilter chartDataFilter) {
        this.labelFilter = chartDataFilter;
    }

    public Rectangle getLeftButtonBounds() {
        return this.lRect;
    }

    public Rectangle getRightButtonBounds() {
        return this.rRect;
    }

    public void setLabelTextStyle(ChartTextStyle chartTextStyle) {
        this.textSty = chartTextStyle;
        this.resetLabelTextStyle();
    }

    @Override
    public void relocate() {
        float f;
        if (!this.closePath) {
            return;
        }
        float[] fArray2 = this.paper.I.getScrollbarInfo();
        float f2 = f = !this.draw ? Math.abs(this.vertex[0][0] - this.vertex[2][0]) : Math.abs(this.vertex[0][1] - this.vertex[2][1]);
        if (!this.draw) {
            this.scrollVertex[0][0] = this.vertex[0][0] + fArray2[0] * f;
            this.scrollVertex[1][0] = this.vertex[0][0] + fArray2[1] * f;
            this.scrollVertex[2][0] = this.vertex[0][0] + fArray2[1] * f;
            this.scrollVertex[3][0] = this.vertex[0][0] + fArray2[0] * f;
            if (this.scrollPath == null) {
                this.scrollPath = new GeneralPath();
            }
            this.scrollPath.reset();
            this.scrollPath.moveTo(this.scrollVertex[0][0], this.scrollVertex[0][1]);
            this.scrollPath.lineTo(this.scrollVertex[1][0], this.scrollVertex[1][1]);
            this.scrollPath.lineTo(this.scrollVertex[2][0], this.scrollVertex[2][1]);
            this.scrollPath.lineTo(this.scrollVertex[3][0], this.scrollVertex[3][1]);
            this.scrollPath.lineTo(this.scrollVertex[0][0], this.scrollVertex[0][1]);
            this.scrollPath.closePath();
        } else {
            this.scrollVertex[0][1] = this.vertex[3][1] - fArray2[1] * f;
            this.scrollVertex[1][1] = this.vertex[3][1] - fArray2[0] * f;
            this.scrollVertex[2][1] = this.vertex[3][1] - fArray2[0] * f;
            this.scrollVertex[3][1] = this.vertex[3][1] - fArray2[1] * f;
            if (this.scrollPath == null) {
                this.scrollPath = new GeneralPath();
            }
            this.scrollPath.reset();
            this.scrollPath.moveTo(this.scrollVertex[0][0], this.scrollVertex[0][1]);
            this.scrollPath.lineTo(this.scrollVertex[1][0], this.scrollVertex[1][1]);
            this.scrollPath.lineTo(this.scrollVertex[2][0], this.scrollVertex[2][1]);
            this.scrollPath.lineTo(this.scrollVertex[3][0], this.scrollVertex[3][1]);
            this.scrollPath.lineTo(this.scrollVertex[0][0], this.scrollVertex[0][1]);
            this.scrollPath.closePath();
        }
        this.contains();
        this.closePath();
        this.endLbl();
        this.black();
    }

    @Override
    public int[] searchLinkInfo(int n, int n2) {
        return null;
    }
}

