/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.ChartDataObject;
import chart.ChartShowValueCondition;
import chart.ChartShowValueSubCondition;
import chart.axis.ChartCategoryAxis;
import chart.axis.ChartNumericAxis;
import chart.chart2d.Chart2DLayer;
import chart.chart2d.Chart2DObject;
import chart.chart2d.Chart2DPaper;
import chart.chart2d.Chart2DSimplePaper;
import chart.chart2d.Graph2DBarP;
import chart.chart2d.Graph2DBarSi;
import chart.chart2d.Graph2DBarSt;
import chart.chart2d.Graph2DStaticHint;
import chart.data.Chart1DDataSet;
import chart.data.ChartDataSet;
import chart.data.ChartDataUsedInfo;
import chart.data.ChartTypeInfo;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartGradientPattern;
import chart.graphics.ChartShading;
import chart.properties.ChartNumericAxisProperties;
import chart.util.ChartHintLabel;
import chart.util.ChartRenderTools;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Vector;

public class Graph2DBar
extends Chart2DObject {
    protected float startX;
    protected float startY;
    protected float barWidth;
    protected float barHeight;
    protected float top;
    protected float bottom;
    protected float[][] vertex;
    protected float[][] tVertex;
    protected Shape[][] itemShapes;
    protected Shape[][] topItemShapes;
    protected Shape[][] rightItemShapes;
    Shape[][] HighLightPattern;
    Shape[][] KEY_ANTIALIASING;
    protected float unitX;
    protected float unitY;
    protected float[][] value;
    protected int col;
    protected int row;
    protected float depth;
    private float[][] v;
    private boolean[][] KEY_STROKE_CONTROL;
    private boolean VALUE_ANTIALIAS_ON;
    private float VALUE_STROKE_PURE = 0.0f;
    private float abs = 0.0f;
    protected float startOffsetW = 0.0f;
    protected float startOffsetH = 0.0f;
    protected float offsetW = 0.0f;
    protected float offsetH = 0.0f;
    protected int offsetN = 1;
    protected String[][][] hintLabel;
    private double[] addAll;
    private boolean append;
    protected float percentBarWidth;
    protected float[][][][] cBarPos;
    protected boolean isCircleBar;
    protected boolean labelOnTickmark;
    protected float barWidthN = -1.0f;

    Graph2DBar(ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer) {
        super(chartDataSet, chart2DPaper, chart2DLayer);
    }

    Graph2DBar(ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer, int n) {
        super(chartDataSet, chart2DPaper, chart2DLayer);
        this.offsetN = n;
    }

    @Override
    public void init() {
        int n;
        int n2;
        int n3;
        int n4;
        super.init();
        this.col = this.dataset.getCategorySize();
        this.row = this.dataset.getSeriesSize();
        int n5 = this.I();
        this.value = new float[this.row][n5];
        this.hintLabel = this.layer.isShowCategoryAndSeries() ? new String[this.row][n5][3] : new String[this.row][n5][1];
        boolean bl = this.isCircleBar = this.objectProperties.getBarStyle() != 0;
        if (this.objectProperties.getBarStyle() != 0) {
            this.cBarPos = new float[this.row][n5][6][2];
        }
        this.VALUE_ANTIALIAS_ON = (n4 = ChartTypeInfo.getPrimType(n3 = this.dataset.getChartDataSetInfo().getChartType())) == 1;
        double d = Math.PI / 180 * (double)this.objectProperties.getDepthDirection();
        this.depth = this.objectProperties.getDepth() / (float)this.layer.getChartCount();
        this.startOffsetW = (float)((double)(this.depth * (float)(this.offsetN - 1)) * Math.cos(d));
        this.startOffsetH = (float)((double)(this.depth * (float)(this.offsetN - 1)) * Math.sin(d));
        this.startOffsetW = this.startOffsetW < 0.0f ? 0.0f : this.startOffsetW;
        this.startOffsetH = this.startOffsetH < 0.0f ? 0.0f : this.startOffsetH;
        this.depth *= (float)this.offsetN;
        this.abs = (float)((double)this.depth * Math.cos(d));
        this.VALUE_STROKE_PURE = (float)((double)this.depth * Math.sin(d));
        this.abs = this.abs < 0.0f ? 0.0f : this.abs;
        this.VALUE_STROKE_PURE = this.VALUE_STROKE_PURE < 0.0f ? 0.0f : this.VALUE_STROKE_PURE;
        this.offsetW = this.abs / (float)this.offsetN;
        this.offsetH = this.VALUE_STROKE_PURE / (float)this.offsetN;
        this.cBarPos();
        this.itemShapes = new Shape[this.row][n5];
        if (this.layer.isDepth()) {
            this.topItemShapes = new Shape[this.row][n5];
            this.rightItemShapes = new Shape[this.row][n5];
            for (n2 = 0; n2 < this.row; ++n2) {
                for (n = 0; n < n5; ++n) {
                    this.topItemShapes[n2][n] = new GeneralPath();
                    this.rightItemShapes[n2][n] = new GeneralPath();
                }
            }
            if (this.isCircleBar) {
                this.HighLightPattern = new Shape[this.row][n5];
                this.KEY_ANTIALIASING = new Shape[this.row][n5];
                for (n2 = 0; n2 < this.row; ++n2) {
                    for (n = 0; n < n5; ++n) {
                        this.HighLightPattern[n2][n] = new GeneralPath();
                        this.KEY_ANTIALIASING[n2][n] = new GeneralPath();
                    }
                }
            }
        }
        for (n2 = 0; n2 < this.row; ++n2) {
        }
        for (n2 = 0; n2 < this.row; ++n2) {
            for (n = 0; n < n5; ++n) {
                this.itemShapes[n2][n] = new GeneralPath();
            }
        }
        this.vertex = new float[this.row * n5 * 4][2];
        this.tVertex = new float[this.row * n5 * 4][2];
        this.v = new float[n5 * this.row][2];
        this.unitX = this.layer.I();
        this.unitY = this.layer.Z();
        this.KEY_STROKE_CONTROL = ((Chart1DDataSet)this.dataset).isNullValue();
        this.labelOnTickmark = this.layer.getAxisX().getProperties().getPositionAxis() == 0 && this.paper.isSupportLabelOnTickmark() && !this.layer.useDepth();
        this.labelOnTickmark = this.labelOnTickmark || this.layer.getAxisX().custommerConstant();
    }

    private void HighLightPattern() {
        boolean bl = false;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        double d = 0.0;
        double d2 = 0.0;
        float f4 = 0.0f;
        int n = 16;
        float f5 = 0.0f;
        float f6 = 0.0f;
        int n2 = this.I();
        int[] nArray = this.paper.getFilterConstant();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < this.row; ++j) {
                int n3;
                if (nArray != null && nArray[0] >= 0 && nArray[1] >= 0 && (i < nArray[0] || i > nArray[1])) continue;
                if (!bl) {
                    d2 = -Math.PI / 180 * (double)(this.objectProperties.getDepthDirection() > 70 ? 70 : this.objectProperties.getDepthDirection());
                    f = Math.abs(this.tVertex[j * 4 * n2 + 4 * i + 0][0] - this.tVertex[j * 4 * n2 + 4 * i + 1][0]) / 2.0f;
                    f2 = this.VALUE_STROKE_PURE / 2.0f;
                    f4 = Math.abs(this.tVertex[j * 4 * n2 + 4 * i + 0][1] - this.tVertex[j * 4 * n2 + 4 * i + 3][1]);
                    f4 = this.value[j][i] >= 0.0f ? f4 : -f4;
                    f3 = (float)Math.tan(d2);
                    d = Math.atan(f3 * f2 / f);
                    n = (int)((f + f2) * 2.0f);
                    n = (n *= 2) < 16 ? 16 : n;
                }
                f5 = this.tVertex[j * 4 * n2 + 4 * i + 0][0] + f - this.abs / 2.0f;
                f6 = this.tVertex[j * 4 * n2 + 4 * i + 0][1] + f2;
                float[][] fArray2 = new float[n + 2][2];
                for (n3 = 0; n3 < fArray2.length; ++n3) {
                    double d3 = d + (double)(n3 * 2) * Math.PI / (double)fArray2.length;
                    fArray2[n3][0] = (float)((double)f * Math.cos(d3));
                    fArray2[n3][1] = (float)((double)f2 * Math.sin(d3));
                    float[] fArray3 = fArray2[n3];
                    fArray3[0] = fArray3[0] + (float)((double)fArray2[n3][1] * Math.tan(d2));
                    float[] fArray4 = fArray2[n3];
                    fArray4[0] = fArray4[0] + f5;
                    float[] fArray5 = fArray2[n3];
                    fArray5[1] = fArray5[1] + f6;
                }
                ((GeneralPath)this.rightItemShapes[j][i]).moveTo(fArray2[0][0], fArray2[0][1]);
                ((GeneralPath)this.itemShapes[j][i]).moveTo(fArray2[0][0], fArray2[0][1]);
                ((GeneralPath)this.HighLightPattern[j][i]).moveTo(fArray2[0][0], fArray2[0][1]);
                if (this.value[j][i] >= 0.0f) {
                    this.KEY_STROKE_CONTROL(j, i, false, fArray2);
                }
                for (n3 = 2; n3 < fArray2.length; ++n3) {
                    ((GeneralPath)this.rightItemShapes[j][i]).lineTo(fArray2[n3][0], fArray2[n3][1]);
                    if (n3 > fArray2.length / 2) continue;
                    ((GeneralPath)this.itemShapes[j][i]).lineTo(fArray2[n3][0], fArray2[n3][1]);
                }
                ((GeneralPath)this.rightItemShapes[j][i]).closePath();
                ((GeneralPath)this.KEY_ANTIALIASING[j][i]).moveTo(fArray2[0][0], fArray2[0][1]);
                ((GeneralPath)this.KEY_ANTIALIASING[j][i]).lineTo(fArray2[0][0], fArray2[0][1] - f4);
                ((GeneralPath)this.KEY_ANTIALIASING[j][i]).moveTo(fArray2[fArray2.length / 2][0], fArray2[fArray2.length / 2][1]);
                ((GeneralPath)this.KEY_ANTIALIASING[j][i]).lineTo(fArray2[fArray2.length / 2][0], fArray2[fArray2.length / 2][1] - f4);
                this.cBarPos[j][i][0][0] = fArray2[0][0];
                this.cBarPos[j][i][0][1] = fArray2[0][1];
                this.cBarPos[j][i][1][0] = fArray2[fArray2.length / 4][0];
                this.cBarPos[j][i][1][1] = fArray2[fArray2.length / 4][1];
                this.cBarPos[j][i][2][0] = fArray2[fArray2.length / 2][0];
                this.cBarPos[j][i][2][1] = fArray2[fArray2.length / 2][1];
                for (n3 = 0; n3 < fArray2.length; ++n3) {
                    float[] fArray6 = fArray2[n3];
                    fArray6[1] = fArray6[1] - f4;
                }
                this.cBarPos[j][i][5][0] = fArray2[0][0];
                this.cBarPos[j][i][5][1] = fArray2[0][1];
                this.cBarPos[j][i][4][0] = fArray2[fArray2.length / 4][0];
                this.cBarPos[j][i][4][1] = fArray2[fArray2.length / 4][1];
                this.cBarPos[j][i][3][0] = fArray2[fArray2.length / 2][0];
                this.cBarPos[j][i][3][1] = fArray2[fArray2.length / 2][1];
                ((GeneralPath)this.itemShapes[j][i]).lineTo(fArray2[fArray2.length / 2][0], fArray2[fArray2.length / 2][1]);
                ((GeneralPath)this.topItemShapes[j][i]).moveTo(fArray2[0][0], fArray2[0][1]);
                if (this.value[j][i] < 0.0f) {
                    this.KEY_STROKE_CONTROL(j, i, true, fArray2);
                }
                for (n3 = 1; n3 < fArray2.length; ++n3) {
                    ((GeneralPath)this.topItemShapes[j][i]).lineTo(fArray2[n3][0], fArray2[n3][1]);
                    if (n3 > fArray2.length / 2) continue;
                    ((GeneralPath)this.itemShapes[j][i]).lineTo(fArray2[fArray2.length / 2 - n3][0], fArray2[fArray2.length / 2 - n3][1]);
                }
                ((GeneralPath)this.topItemShapes[j][i]).closePath();
                ((GeneralPath)this.itemShapes[j][i]).closePath();
            }
        }
    }

    private void KEY_ANTIALIASING() {
        boolean bl = false;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        double d = 0.0;
        double d2 = 0.0;
        float f4 = 0.0f;
        int n = 16;
        float f5 = 0.0f;
        float f6 = 0.0f;
        int n2 = this.I();
        int[] nArray = this.paper.getFilterConstant();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < this.row; ++j) {
                int n3;
                if (nArray != null && nArray[0] >= 0 && nArray[1] >= 0 && (i < nArray[0] || i > nArray[1])) continue;
                if (!bl) {
                    d2 = Math.PI / 180 * (double)(this.objectProperties.getDepthDirection() < 30 ? 30 : this.objectProperties.getDepthDirection());
                    d2 = 1.5707963267948966 - d2;
                    f = this.abs / 2.0f;
                    f2 = Math.abs(this.tVertex[j * 4 * n2 + 4 * i + 0][1] - this.tVertex[j * 4 * n2 + 4 * i + 1][1]) / 2.0f;
                    f4 = Math.abs(this.tVertex[j * 4 * n2 + 4 * i + 0][0] - this.tVertex[j * 4 * n2 + 4 * i + 3][0]);
                    f4 = this.value[j][i] >= 0.0f ? f4 : -f4;
                    f3 = 1.0f / (float)Math.tan(d2);
                    d = Math.atan(-f3 * f2 / f);
                    n = (int)((f2 + f) * 2.0f);
                    int n4 = n = (n *= 2) < 16 ? 16 : n;
                }
                if (this.tVertex[j * 4 * n2 + 4 * i + 1][1] > this.tVertex[j * 4 * n2 + 4 * i + 0][1]) {
                    f5 = this.tVertex[j * 4 * n2 + 4 * i + 1][0] - f;
                    f6 = this.tVertex[j * 4 * n2 + 4 * i + 1][1] + this.VALUE_STROKE_PURE / 2.0f - f2 / 2.0f;
                } else {
                    f5 = this.tVertex[j * 4 * n2 + 4 * i + 0][0] - f;
                    f6 = this.tVertex[j * 4 * n2 + 4 * i + 0][1] + this.VALUE_STROKE_PURE / 2.0f - f2;
                }
                float[][] fArray2 = new float[n + 2][2];
                for (n3 = 0; n3 < fArray2.length; ++n3) {
                    double d3 = d + (double)(n3 * 2) * Math.PI / (double)fArray2.length;
                    fArray2[n3][0] = (float)((double)f * Math.cos(d3));
                    fArray2[n3][1] = (float)((double)f2 * Math.sin(d3));
                    float[] fArray3 = fArray2[n3];
                    fArray3[1] = fArray3[1] - (float)((double)fArray2[n3][0] * Math.tan(d2));
                    float[] fArray4 = fArray2[n3];
                    fArray4[0] = fArray4[0] + f5;
                    float[] fArray5 = fArray2[n3];
                    fArray5[1] = fArray5[1] + f6;
                }
                ((GeneralPath)this.rightItemShapes[j][i]).moveTo(fArray2[0][0], fArray2[0][1]);
                ((GeneralPath)this.itemShapes[j][i]).moveTo(fArray2[fArray2.length / 2][0], fArray2[fArray2.length / 2][1]);
                if (this.value[j][i] >= 0.0f) {
                    this.SEDU(j, i, false, fArray2);
                }
                for (n3 = 1; n3 < fArray2.length; ++n3) {
                    ((GeneralPath)this.rightItemShapes[j][i]).lineTo(fArray2[n3][0], fArray2[n3][1]);
                    if (n3 <= fArray2.length / 2) continue;
                    ((GeneralPath)this.itemShapes[j][i]).lineTo(fArray2[n3][0], fArray2[n3][1]);
                }
                ((GeneralPath)this.rightItemShapes[j][i]).closePath();
                ((GeneralPath)this.itemShapes[j][i]).lineTo(fArray2[0][0], fArray2[0][1]);
                ((GeneralPath)this.KEY_ANTIALIASING[j][i]).moveTo(fArray2[0][0], fArray2[0][1]);
                ((GeneralPath)this.KEY_ANTIALIASING[j][i]).lineTo(fArray2[0][0] + f4, fArray2[0][1]);
                ((GeneralPath)this.KEY_ANTIALIASING[j][i]).moveTo(fArray2[fArray2.length / 2][0], fArray2[fArray2.length / 2][1]);
                ((GeneralPath)this.KEY_ANTIALIASING[j][i]).lineTo(fArray2[fArray2.length / 2][0] + f4, fArray2[fArray2.length / 2][1]);
                this.cBarPos[j][i][0][0] = fArray2[0][0];
                this.cBarPos[j][i][0][1] = fArray2[0][1];
                this.cBarPos[j][i][1][0] = fArray2[fArray2.length * 3 / 4][0];
                this.cBarPos[j][i][1][1] = fArray2[fArray2.length * 3 / 4][1];
                this.cBarPos[j][i][2][0] = fArray2[fArray2.length / 2][0];
                this.cBarPos[j][i][2][1] = fArray2[fArray2.length / 2][1];
                for (n3 = 0; n3 < fArray2.length; ++n3) {
                    float[] fArray6 = fArray2[n3];
                    fArray6[0] = fArray6[0] + f4;
                }
                this.cBarPos[j][i][5][0] = fArray2[0][0];
                this.cBarPos[j][i][5][1] = fArray2[0][1];
                this.cBarPos[j][i][4][0] = fArray2[fArray2.length * 3 / 4][0];
                this.cBarPos[j][i][4][1] = fArray2[fArray2.length * 3 / 4][1];
                this.cBarPos[j][i][3][0] = fArray2[fArray2.length / 2][0];
                this.cBarPos[j][i][3][1] = fArray2[fArray2.length / 2][1];
                ((GeneralPath)this.itemShapes[j][i]).lineTo(fArray2[0][0], fArray2[0][1]);
                ((GeneralPath)this.topItemShapes[j][i]).moveTo(fArray2[0][0], fArray2[0][1]);
                if (this.value[j][i] < 0.0f) {
                    this.SEDU(j, i, true, fArray2);
                }
                for (n3 = 1; n3 < fArray2.length; ++n3) {
                    ((GeneralPath)this.topItemShapes[j][i]).lineTo(fArray2[n3][0], fArray2[n3][1]);
                    if (n3 > fArray2.length / 2 || n3 < 1) continue;
                    ((GeneralPath)this.itemShapes[j][i]).lineTo(fArray2[fArray2.length - n3][0], fArray2[fArray2.length - n3][1]);
                }
                ((GeneralPath)this.topItemShapes[j][i]).closePath();
                ((GeneralPath)this.itemShapes[j][i]).closePath();
            }
        }
    }

    private void KEY_STROKE_CONTROL(int n, int n2, boolean bl, float[][] fArray2) {
        if (!bl) {
            ((GeneralPath)this.HighLightPattern[n][n2]).moveTo(fArray2[0][0], fArray2[0][1]);
            for (int i = 1; i <= fArray2.length / 2; ++i) {
                ((GeneralPath)this.HighLightPattern[n][n2]).lineTo(fArray2[i][0], fArray2[i][1]);
            }
        } else {
            ((GeneralPath)this.HighLightPattern[n][n2]).moveTo(fArray2[0][0], fArray2[0][1]);
            for (int i = 1; i <= fArray2.length / 2; ++i) {
                ((GeneralPath)this.HighLightPattern[n][n2]).lineTo(fArray2[i][0], fArray2[i][1]);
            }
        }
    }

    private void SEDU(int n, int n2, boolean bl, float[][] fArray2) {
        if (!bl) {
            ((GeneralPath)this.HighLightPattern[n][n2]).moveTo(fArray2[fArray2.length / 2][0], fArray2[fArray2.length / 2][1]);
            for (int i = fArray2.length / 2 + 1; i < fArray2.length; ++i) {
                ((GeneralPath)this.HighLightPattern[n][n2]).lineTo(fArray2[i][0], fArray2[i][1]);
            }
        } else {
            ((GeneralPath)this.HighLightPattern[n][n2]).moveTo(fArray2[fArray2.length / 2][0], fArray2[fArray2.length / 2][1]);
            for (int i = fArray2.length / 2 + 1; i < fArray2.length; ++i) {
                ((GeneralPath)this.HighLightPattern[n][n2]).lineTo(fArray2[i][0], fArray2[i][1]);
            }
        }
    }

    Shape VALUE_ANTIALIAS_ON(int n) {
        GeneralPath generalPath = new GeneralPath();
        GeneralPath generalPath2 = null;
        for (int i = 0; i < this.I(); ++i) {
            generalPath2 = new GeneralPath();
            generalPath2.moveTo(this.cBarPos[n][i][0][0], this.cBarPos[n][i][0][1]);
            for (int j = 1; j < 6; ++j) {
                generalPath2.lineTo(this.cBarPos[n][i][j][0], this.cBarPos[n][i][j][1]);
            }
            generalPath2.closePath();
            generalPath.append(generalPath2, false);
        }
        return generalPath;
    }

    private void VALUE_STROKE_PURE() {
        int n = this.I();
        int[] nArray = this.paper.getFilterConstant();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this.row; ++j) {
                float f;
                if (nArray != null && nArray[0] >= 0 && nArray[1] >= 0 && (i < nArray[0] || i > nArray[1])) continue;
                if (this.value[j][i] >= 0.0f) {
                    ((GeneralPath)this.topItemShapes[j][i]).moveTo(this.tVertex[j * 4 * n + 4 * i + 3][0] - this.startOffsetW - this.offsetW, this.tVertex[j * 4 * n + 4 * i + 3][1] + this.startOffsetH + this.offsetH);
                    ((GeneralPath)this.topItemShapes[j][i]).lineTo(this.tVertex[j * 4 * n + 4 * i + 2][0] - this.startOffsetW - this.offsetW, this.tVertex[j * 4 * n + 4 * i + 2][1] + this.startOffsetH + this.offsetH);
                    ((GeneralPath)this.topItemShapes[j][i]).lineTo(this.tVertex[j * 4 * n + 4 * i + 2][0] - this.startOffsetW, this.tVertex[j * 4 * n + 4 * i + 2][1] + this.startOffsetH);
                    ((GeneralPath)this.topItemShapes[j][i]).lineTo(this.tVertex[j * 4 * n + 4 * i + 3][0] - this.startOffsetW, this.tVertex[j * 4 * n + 4 * i + 3][1] + this.startOffsetH);
                } else if (!this.isBench()) {
                    f = Math.abs(this.tVertex[j * 4 * n + 4 * i + 0][1] - this.tVertex[j * 4 * n + 4 * i + 3][1]);
                    ((GeneralPath)this.topItemShapes[j][i]).moveTo(this.tVertex[j * 4 * n + 4 * i + 3][0] - this.startOffsetW - this.offsetW, this.tVertex[j * 4 * n + 4 * i + 3][1] + this.startOffsetH + this.offsetH - f);
                    ((GeneralPath)this.topItemShapes[j][i]).lineTo(this.tVertex[j * 4 * n + 4 * i + 2][0] - this.startOffsetW - this.offsetW, this.tVertex[j * 4 * n + 4 * i + 2][1] + this.startOffsetH + this.offsetH - f);
                    ((GeneralPath)this.topItemShapes[j][i]).lineTo(this.tVertex[j * 4 * n + 4 * i + 2][0] - this.startOffsetW, this.tVertex[j * 4 * n + 4 * i + 2][1] + this.startOffsetH - f);
                    ((GeneralPath)this.topItemShapes[j][i]).lineTo(this.tVertex[j * 4 * n + 4 * i + 3][0] - this.startOffsetW, this.tVertex[j * 4 * n + 4 * i + 3][1] + this.startOffsetH - f);
                } else {
                    f = Math.abs(this.tVertex[j * 4 * n + 4 * i + 0][0] - this.tVertex[j * 4 * n + 4 * i + 3][0]);
                    ((GeneralPath)this.topItemShapes[j][i]).moveTo(this.tVertex[j * 4 * n + 4 * i + 3][0] + f - this.startOffsetW - this.offsetW, this.tVertex[j * 4 * n + 4 * i + 3][1] + this.startOffsetH + this.offsetH);
                    ((GeneralPath)this.topItemShapes[j][i]).lineTo(this.tVertex[j * 4 * n + 4 * i + 2][0] + f - this.startOffsetW - this.offsetW, this.tVertex[j * 4 * n + 4 * i + 2][1] + this.startOffsetH + this.offsetH);
                    ((GeneralPath)this.topItemShapes[j][i]).lineTo(this.tVertex[j * 4 * n + 4 * i + 2][0] + f - this.startOffsetW, this.tVertex[j * 4 * n + 4 * i + 2][1] + this.startOffsetH);
                    ((GeneralPath)this.topItemShapes[j][i]).lineTo(this.tVertex[j * 4 * n + 4 * i + 3][0] + f - this.startOffsetW, this.tVertex[j * 4 * n + 4 * i + 3][1] + this.startOffsetH);
                }
                ((GeneralPath)this.topItemShapes[j][i]).closePath();
                ((GeneralPath)this.itemShapes[j][i]).moveTo(this.tVertex[j * 4 * n + 4 * i][0] - this.abs, this.tVertex[j * 4 * n + 4 * i][1] + this.VALUE_STROKE_PURE);
                ((GeneralPath)this.itemShapes[j][i]).lineTo(this.tVertex[j * 4 * n + 4 * i + 1][0] - this.abs, this.tVertex[j * 4 * n + 4 * i + 1][1] + this.VALUE_STROKE_PURE);
                ((GeneralPath)this.itemShapes[j][i]).lineTo(this.tVertex[j * 4 * n + 4 * i + 2][0] - this.abs, this.tVertex[j * 4 * n + 4 * i + 2][1] + this.VALUE_STROKE_PURE);
                ((GeneralPath)this.itemShapes[j][i]).lineTo(this.tVertex[j * 4 * n + 4 * i + 3][0] - this.abs, this.tVertex[j * 4 * n + 4 * i + 3][1] + this.VALUE_STROKE_PURE);
                ((GeneralPath)this.itemShapes[j][i]).closePath();
                if (!this.layer.isCombo()) {
                    ((GeneralPath)this.rightItemShapes[j][i]).moveTo(this.tVertex[j * 4 * n + 4 * i + 1][0] - this.startOffsetW - this.offsetW, this.tVertex[j * 4 * n + 4 * i + 1][1] + this.startOffsetH + this.offsetH);
                    ((GeneralPath)this.rightItemShapes[j][i]).lineTo(this.tVertex[j * 4 * n + 4 * i + 1][0] - this.startOffsetW, this.tVertex[j * 4 * n + 4 * i + 1][1] + this.startOffsetH);
                    ((GeneralPath)this.rightItemShapes[j][i]).lineTo(this.tVertex[j * 4 * n + 4 * i + 2][0] - this.startOffsetW, this.tVertex[j * 4 * n + 4 * i + 2][1] + this.startOffsetH);
                    ((GeneralPath)this.rightItemShapes[j][i]).lineTo(this.tVertex[j * 4 * n + 4 * i + 2][0] - this.startOffsetW - this.offsetW, this.tVertex[j * 4 * n + 4 * i + 2][1] + this.startOffsetH + this.offsetH);
                } else {
                    ((GeneralPath)this.rightItemShapes[j][i]).moveTo(this.tVertex[j * 4 * n + 4 * i][0] - this.startOffsetW - this.offsetW, this.tVertex[j * 4 * n + 4 * i][1] + this.startOffsetH + this.offsetH);
                    ((GeneralPath)this.rightItemShapes[j][i]).lineTo(this.tVertex[j * 4 * n + 4 * i][0] - this.startOffsetW, this.tVertex[j * 4 * n + 4 * i][1] + this.startOffsetH);
                    ((GeneralPath)this.rightItemShapes[j][i]).lineTo(this.tVertex[j * 4 * n + 4 * i + 3][0] - this.startOffsetW, this.tVertex[j * 4 * n + 4 * i + 3][1] + this.startOffsetH);
                    ((GeneralPath)this.rightItemShapes[j][i]).lineTo(this.tVertex[j * 4 * n + 4 * i + 3][0] - this.startOffsetW - this.offsetW, this.tVertex[j * 4 * n + 4 * i + 3][1] + this.startOffsetH + this.offsetH);
                }
                ((GeneralPath)this.rightItemShapes[j][i]).closePath();
            }
        }
    }

    @Override
    public void locate() {
        int n;
        int n2;
        int n3 = this.I();
        if (this.layer.isDepth()) {
            for (n2 = 0; n2 < this.row; ++n2) {
                for (n = 0; n < n3; ++n) {
                    ((GeneralPath)this.topItemShapes[n2][n]).reset();
                    ((GeneralPath)this.rightItemShapes[n2][n]).reset();
                }
            }
        }
        for (n2 = 0; n2 < this.row; ++n2) {
            for (n = 0; n < n3; ++n) {
                ((GeneralPath)this.itemShapes[n2][n]).reset();
            }
        }
        this.abs();
        this.layer.I(this.vertex, this.tVertex);
        if (this.layer.isDepth()) {
            if (this.isCircleBar) {
                if (this.VALUE_ANTIALIAS_ON) {
                    this.KEY_ANTIALIASING();
                } else {
                    this.HighLightPattern();
                }
            } else {
                this.VALUE_STROKE_PURE();
            }
        } else {
            n2 = this.add() ? 1 : 0;
            if (n2 == 0) {
                for (n = 0; n < this.row; ++n) {
                    for (int i = 0; i < n3; ++i) {
                        ((GeneralPath)this.itemShapes[n][i]).moveTo(this.tVertex[n * 4 * n3 + 4 * i][0], this.tVertex[n * 4 * n3 + 4 * i][1]);
                        ((GeneralPath)this.itemShapes[n][i]).lineTo(this.tVertex[n * 4 * n3 + 4 * i + 1][0], this.tVertex[n * 4 * n3 + 4 * i + 1][1]);
                        ((GeneralPath)this.itemShapes[n][i]).lineTo(this.tVertex[n * 4 * n3 + 4 * i + 2][0], this.tVertex[n * 4 * n3 + 4 * i + 2][1]);
                        ((GeneralPath)this.itemShapes[n][i]).lineTo(this.tVertex[n * 4 * n3 + 4 * i + 3][0], this.tVertex[n * 4 * n3 + 4 * i + 3][1]);
                        ((GeneralPath)this.itemShapes[n][i]).closePath();
                    }
                }
            } else {
                for (n = 0; n < this.row; ++n) {
                    for (int i = 0; i < n3; ++i) {
                        ((GeneralPath)this.itemShapes[n][i]).moveTo(this.tVertex[n * 4 * n3 + 4 * i][0], this.tVertex[n * 4 * n3 + 4 * i][1]);
                        ((GeneralPath)this.itemShapes[n][i]).lineTo(this.tVertex[n * 4 * n3 + 4 * i + 1][0], this.tVertex[n * 4 * n3 + 4 * i + 1][1]);
                        ((GeneralPath)this.itemShapes[n][i]).lineTo(this.tVertex[n * 4 * n3 + 4 * i + 2][0], this.tVertex[n * 4 * n3 + 4 * i + 2][1]);
                        ((GeneralPath)this.itemShapes[n][i]).lineTo(this.tVertex[n * 4 * n3 + 4 * i + 3][0], this.tVertex[n * 4 * n3 + 4 * i + 3][1]);
                        ((GeneralPath)this.itemShapes[n][i]).closePath();
                        if (this.col(n, i)) continue;
                    }
                }
            }
        }
        this.drawDepthBar();
    }

    private void abs() {
        if (this.layer.getAxisX().custommerConstant()) {
            return;
        }
        if (this.vertex == null) {
            return;
        }
        if (this.vertex.length <= 0) {
            return;
        }
        if (this.labelOnTickmark) {
            int n = this.I();
            float f = this.unitX / 2.0f;
            int n2 = this.dataset.getChartDataSetInfo().getChartType();
            int n3 = ChartTypeInfo.getSubType(n2);
            for (int i = 0; i < this.vertex.length; ++i) {
                float[] fArray2 = this.vertex[i];
                fArray2[0] = fArray2[0] - f;
            }
            float f2 = this.objectProperties.getBarGap();
            float f3 = this.unitX * this.percentBarWidth;
            float f4 = f3 / ((float)(this.row - 1) * f2 + (float)this.row);
            if (n3 == 0 || n3 == 256) {
                f = f3 / 2.0f;
                if (n == 1) {
                    f = f3 / 2.0f;
                    for (int i = 0; i < this.row; ++i) {
                        int n4 = i * n * 4;
                        float[] fArray3 = this.vertex[n4];
                        fArray3[0] = fArray3[0] + f;
                        float[] fArray4 = this.vertex[n4 + 3];
                        fArray4[0] = fArray4[0] + f;
                    }
                } else {
                    for (int i = 0; i < this.row; ++i) {
                        int n5 = i * 4 * n;
                        float[] fArray5 = this.vertex[n5];
                        fArray5[0] = fArray5[0] + f;
                        float[] fArray6 = this.vertex[n5 + 3];
                        fArray6[0] = fArray6[0] + f;
                        float[] fArray7 = this.vertex[(n5 += (n - 1) * 4) + 1];
                        fArray7[0] = fArray7[0] - f;
                        float[] fArray8 = this.vertex[n5 + 2];
                        fArray8[0] = fArray8[0] - f;
                    }
                }
            } else if (this.row == 1) {
                f = this.unitX * this.percentBarWidth / 2.0f;
                float[] fArray9 = this.vertex[0];
                fArray9[0] = fArray9[0] + f;
                float[] fArray10 = this.vertex[3];
                fArray10[0] = fArray10[0] + f;
                if (this.I() != 1) {
                    float[] fArray11 = this.vertex[this.vertex.length - 2];
                    fArray11[0] = fArray11[0] - f;
                    float[] fArray12 = this.vertex[this.vertex.length - 3];
                    fArray12[0] = fArray12[0] - f;
                }
            } else if (this.row % 2 != 0) {
                f = f4 / 2.0f;
                int n6 = 0;
                int n7 = this.row / 2;
                float[] fArray13 = this.vertex[n7 * 4 * n + 4 * n6 + 0];
                fArray13[0] = fArray13[0] + f;
                float[] fArray14 = this.vertex[n7 * 4 * n + 4 * n6 + 3];
                fArray14[0] = fArray14[0] + f;
                n6 = n - 1;
                n7 = this.row / 2;
                float[] fArray15 = this.vertex[n7 * 4 * n + 4 * n6 + 1];
                fArray15[0] = fArray15[0] - f;
                float[] fArray16 = this.vertex[n7 * 4 * n + 4 * n6 + 2];
                fArray16[0] = fArray16[0] - f;
            }
        } else {
            return;
        }
    }

    private boolean add() {
        boolean bl = false;
        if (this.layer != null && this.layer.getAxisX() != null && this.layer.getAxisX().custommerConstant()) {
            return false;
        }
        int n = this.dataset.getChartDataSetInfo().getChartType();
        int n2 = ChartTypeInfo.getSubType(n);
        if (n2 == 0 || n2 == 256) {
            return false;
        }
        if (!this.labelOnTickmark) {
            return false;
        }
        return this.row != 1;
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        int n;
        int n2;
        int n3;
        if (this.layer.isDepth()) {
            this.drawDepthBar(graphics2D);
        } else {
            n3 = this.add();
            int n4 = this.I();
            if (n3 == 0) {
                for (n2 = 0; n2 < this.row; ++n2) {
                    for (n = 0; n < n4; ++n) {
                        this.atan(graphics2D, n2, n);
                    }
                }
            } else {
                for (n2 = 0; n2 < this.row; ++n2) {
                    for (n = 1; n < n4 - 1; ++n) {
                        this.atan(graphics2D, n2, n);
                    }
                }
                for (n2 = 0; n2 < this.row; ++n2) {
                    this.axisY(graphics2D, n2, 0);
                }
                if (n4 > 1) {
                    for (n2 = 0; n2 < this.row; ++n2) {
                        this.axisY(graphics2D, n2, n4 - 1);
                    }
                }
            }
        }
        if (this.valueLabelPosition != 0) {
            n3 = this.I();
            float[][] fArray2 = new float[this.row][n3];
            for (n2 = 0; n2 < this.row; ++n2) {
                for (n = 0; n < n3; ++n) {
                    if (this.VALUE_ANTIALIAS_ON) {
                        this.v[n3 * n2 + n][0] = this.tVertex[n2 * 4 * n3 + 4 * n + 2][0];
                        this.v[n3 * n2 + n][1] = (this.tVertex[n2 * 4 * n3 + 4 * n + 2][1] + this.tVertex[n2 * 4 * n3 + 4 * n + 3][1]) / 2.0f;
                        fArray2[n2][n] = this.tVertex[n2 * 4 * n3 + 4 * n + 2][0] - this.tVertex[n2 * 4 * n3 + 4 * n + 1][0];
                    } else {
                        this.v[n3 * n2 + n][0] = (this.tVertex[n2 * 4 * n3 + 4 * n + 2][0] + this.tVertex[n2 * 4 * n3 + 4 * n + 3][0]) / 2.0f;
                        this.v[n3 * n2 + n][1] = this.tVertex[n2 * 4 * n3 + 4 * n + 2][1];
                        fArray2[n2][n] = this.tVertex[n2 * 4 * n3 + 4 * n + 1][1] - this.tVertex[n2 * 4 * n3 + 4 * n + 2][1];
                    }
                    if (!this.layer.isDepth()) continue;
                    float[] fArray3 = this.v[n3 * n2 + n];
                    fArray3[0] = fArray3[0] - this.abs;
                    float[] fArray4 = this.v[n3 * n2 + n];
                    fArray4[1] = fArray4[1] + this.VALUE_STROKE_PURE;
                }
            }
            Graph2DStaticHint graph2DStaticHint = new Graph2DStaticHint(this.paper.model, graphics2D, this.dataset, this.paper, this.layer, this.v, this.barWidth, fArray2, 0, this.row, this.valueLabelPosition, this.addAll, this.append);
            if (this.paper.getAxisX1() != null && this.paper.getAxisX1().custommerConstant()) {
                graph2DStaticHint.setFilteredPaintColumn(this.paper.getFilterConstant());
            }
            if (this.valueLabelPosition != 0 && (this.valueLabelPosition == 17 || this.valueLabelPosition == 18 || this.valueLabelPosition == 19) && this.valueLabelSmartPos != 0) {
                float f = this.layer.getAxisX().getUnit(!this.VALUE_ANTIALIAS_ON ? (float)(this.paper.getGraphArea().width - 2) : (float)(this.paper.getGraphArea().height - 2));
                if (!this.layer.getAxisX().custommerConstant()) {
                    if (this.row > 1) {
                        if (this instanceof Graph2DBarSi) {
                            f *= this.objectProperties.getBarWidth();
                            f /= (float)this.row;
                        } else {
                            f *= this.objectProperties.getBarWidth();
                        }
                    } else {
                        f *= this.objectProperties.getBarWidth();
                    }
                } else {
                    f = this.barWidthN;
                }
                graph2DStaticHint.setIsSmartShow(true);
                graph2DStaticHint.setBarWidth(f);
            }
            if (!this.paper.isScrollChart()) {
                graph2DStaticHint.paint();
            } else {
                graph2DStaticHint.setColumnNumber(this.I());
                graph2DStaticHint.paint();
            }
        }
    }

    public void drawDepthBar(Graphics2D graphics2D) {
        Object object = null;
        Object object2 = null;
        if (this.isCircleBar) {
            object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            object2 = graphics2D.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        }
        int n = this.I();
        int n2 = 0;
        n2 = this.paper.isScrollChart() ? this.paper.I.showScrollLabelStart() : 0;
        for (int i = 0; i < n; ++i) {
            int[] nArray = !this.isBench() ? this.barWidth(i) : this.barWidthN(i);
            for (int j = 0; j < this.row; ++j) {
                int n3 = nArray[j];
                if (this.KEY_STROKE_CONTROL[n3][i + n2]) continue;
                if (this.dataset.getChartDataSetModel().isOneGroupForBar() && !this.dataset.getChartDataSetModel().isTurnedXZ()) {
                    if (this.objectProperties.isVaryColorbyValues()) {
                        if (this.seriesPattern[i] != null) {
                            int n4 = i + n2;
                            if (!this.isCircleBar) {
                                this.addAll(graphics2D, n3, i, this.seriesPattern[n4 % this.seriesPattern.length]);
                            } else {
                                this.append(graphics2D, n3, i, this.seriesPattern[n4 % this.seriesPattern.length]);
                            }
                        }
                    } else if (this.seriesPattern[0] != null) {
                        if (!this.isCircleBar) {
                            this.addAll(graphics2D, n3, i, this.seriesPattern[0]);
                        } else {
                            this.append(graphics2D, n3, i, this.seriesPattern[0]);
                        }
                    }
                } else if (this.seriesPattern[n3] != null) {
                    if (!this.isCircleBar) {
                        this.addAll(graphics2D, n3, i, this.seriesPattern[n3]);
                    } else {
                        this.append(graphics2D, n3, i, this.seriesPattern[n3]);
                    }
                }
                if (!this.objectProperties.isContour()) continue;
                if (this.value[n3][i] >= 0.0f || !this.isCircleBar) {
                    this.objectProperties.getContourPen().draw(graphics2D, this.topItemShapes[n3][i]);
                    if (!this.isCircleBar) {
                        this.objectProperties.getContourPen().draw(graphics2D, this.rightItemShapes[n3][i]);
                        this.objectProperties.getContourPen().draw(graphics2D, this.itemShapes[n3][i]);
                        continue;
                    }
                    this.objectProperties.getContourPen().draw(graphics2D, this.HighLightPattern[n3][i]);
                    this.objectProperties.getContourPen().draw(graphics2D, this.KEY_ANTIALIASING[n3][i]);
                    continue;
                }
                this.objectProperties.getContourPen().draw(graphics2D, this.KEY_ANTIALIASING[n3][i]);
                this.objectProperties.getContourPen().draw(graphics2D, this.rightItemShapes[n3][i]);
                this.objectProperties.getContourPen().draw(graphics2D, this.HighLightPattern[n3][i]);
            }
        }
        if (this.isCircleBar && graphics2D != null) {
            if (object != null) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
            }
            if (object2 != null) {
                graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, object2);
            }
        }
    }

    private void addAll(Graphics2D graphics2D, int n, int n2, ChartFillPattern chartFillPattern) {
        boolean bl;
        ChartShowValueCondition chartShowValueCondition = this.dataset.getCondition(n, n2);
        boolean bl2 = bl = chartShowValueCondition != null && chartShowValueCondition.getConditionType() != 0;
        if (bl && !(this instanceof Graph2DBarSi) && chartShowValueCondition.getConditionType() == 2) {
            bl = false;
        }
        if (bl) {
            this.cos(graphics2D, n, n2, this.dataset.getCondition(n, n2));
            return;
        }
        if (chartFillPattern == null) {
            return;
        }
        ChartFillPattern chartFillPattern2 = ChartShading.HighLightPattern(chartFillPattern, -20);
        chartFillPattern2.fill(graphics2D, this.rightItemShapes[n][n2]);
        chartFillPattern.fill(graphics2D, this.itemShapes[n][n2]);
        ChartFillPattern chartFillPattern3 = ChartShading.HighLightPattern(chartFillPattern, 20);
        chartFillPattern3.fill(graphics2D, this.topItemShapes[n][n2]);
    }

    private void append(Graphics2D graphics2D, int n, int n2, ChartFillPattern chartFillPattern) {
        boolean bl;
        ChartShowValueCondition chartShowValueCondition = this.dataset.getCondition(n, n2);
        boolean bl2 = bl = chartShowValueCondition != null && chartShowValueCondition.getConditionType() != 0;
        if (bl && !(this instanceof Graph2DBarSi) && chartShowValueCondition.getConditionType() == 2) {
            bl = false;
        }
        if (bl) {
            this.custommerConstant(graphics2D, n, n2, this.dataset.getCondition(n, n2));
            return;
        }
        if (chartFillPattern == null) {
            return;
        }
        ChartFillPattern chartFillPattern2 = ChartShading.HighLightPattern(chartFillPattern, -20);
        ChartFillPattern chartFillPattern3 = ChartShading.HighLightPattern(chartFillPattern, 30);
        if (this.value[n][n2] >= 0.0f) {
            chartFillPattern2.fill(graphics2D, this.rightItemShapes[n][n2]);
            if (chartFillPattern instanceof ChartColorPattern) {
                ChartGradientPattern chartGradientPattern = null;
                chartGradientPattern = !this.VALUE_ANTIALIAS_ON ? new ChartGradientPattern(1, true, (ChartColorPattern)ChartShading.HighLightPattern(chartFillPattern, 40), new Point2D.Float(0.28f, 0.5f), (ChartColorPattern)ChartShading.HighLightPattern(chartFillPattern, -25), new Point2D.Float(0.98f, 0.5f)) : new ChartGradientPattern(1, true, (ChartColorPattern)ChartShading.HighLightPattern(chartFillPattern, 40), new Point2D.Float(0.5f, 0.72f), (ChartColorPattern)ChartShading.HighLightPattern(chartFillPattern, -25), new Point2D.Float(0.5f, 0.02f));
                chartGradientPattern.fill(graphics2D, this.itemShapes[n][n2]);
            } else {
                chartFillPattern.fill(graphics2D, this.itemShapes[n][n2]);
            }
            graphics2D.draw(this.HighLightPattern[n][n2]);
            graphics2D.draw(this.KEY_ANTIALIASING[n][n2]);
            chartFillPattern3.fill(graphics2D, this.topItemShapes[n][n2]);
            graphics2D.draw(this.topItemShapes[n][n2]);
        } else {
            chartFillPattern2.fill(graphics2D, this.topItemShapes[n][n2]);
            if (chartFillPattern instanceof ChartColorPattern) {
                ChartGradientPattern chartGradientPattern = null;
                chartGradientPattern = !this.VALUE_ANTIALIAS_ON ? new ChartGradientPattern(1, true, (ChartColorPattern)ChartShading.HighLightPattern(chartFillPattern, 50), new Point2D.Float(0.28f, 0.5f), (ChartColorPattern)ChartShading.HighLightPattern(chartFillPattern, -25), new Point2D.Float(0.98f, 0.5f)) : new ChartGradientPattern(1, true, (ChartColorPattern)ChartShading.HighLightPattern(chartFillPattern, 50), new Point2D.Float(0.5f, 0.72f), (ChartColorPattern)ChartShading.HighLightPattern(chartFillPattern, -25), new Point2D.Float(0.5f, 0.02f));
                chartGradientPattern.fill(graphics2D, this.itemShapes[n][n2]);
                chartGradientPattern.fill(graphics2D, this.topItemShapes[n][n2]);
                graphics2D.draw(this.HighLightPattern[n][n2]);
                graphics2D.draw(this.KEY_ANTIALIASING[n][n2]);
                graphics2D.draw(this.topItemShapes[n][n2]);
            } else {
                chartFillPattern.fill(graphics2D, this.itemShapes[n][n2]);
            }
            chartFillPattern3.fill(graphics2D, this.rightItemShapes[n][n2]);
            graphics2D.draw(this.rightItemShapes[n][n2]);
        }
    }

    private void atan(Graphics2D graphics2D, int n, int n2) {
        boolean bl;
        ChartShowValueCondition chartShowValueCondition = this.dataset.getCondition(n, n2);
        boolean bl2 = bl = chartShowValueCondition != null && chartShowValueCondition.getConditionType() != 0;
        if (bl && !(this instanceof Graph2DBarSi) && chartShowValueCondition.getConditionType() == 2) {
            bl = false;
        }
        if (bl) {
            this.contains(graphics2D, n, n2, chartShowValueCondition, this.itemShapes[n][n2]);
            if (this.objectProperties.isContour()) {
                this.objectProperties.getContourPen().draw(graphics2D, this.itemShapes[n][n2]);
            }
            return;
        }
        if (this.dataset.getChartDataSetModel().isOneGroupForBar() && !this.dataset.getChartDataSetModel().isTurnedXZ()) {
            int n3 = 0;
            if (this.paper.isScrollChart()) {
                n3 = this.paper.I.showScrollLabelStart();
            }
            if (this.objectProperties.isVaryColorbyValues()) {
                if (this.seriesPattern[(n2 + n3) % this.seriesPattern.length] != null) {
                    this.seriesPattern[(n2 + n3) % this.seriesPattern.length].fill(graphics2D, this.itemShapes[n][n2]);
                }
            } else if (this.seriesPattern[0] != null) {
                this.seriesPattern[0].fill(graphics2D, this.itemShapes[n][n2]);
            }
        } else if (this.seriesPattern[n] != null) {
            this.seriesPattern[n].fill(graphics2D, this.itemShapes[n][n2]);
        }
        if (this.objectProperties.isContour()) {
            this.objectProperties.getContourPen().draw(graphics2D, this.itemShapes[n][n2]);
        }
    }

    private void axisY(Graphics2D graphics2D, int n, int n2) {
        if (this.col(n, n2)) {
            return;
        }
        this.atan(graphics2D, n, n2);
    }

    @Override
    float[][] getStaticHintLocation() {
        return null;
    }

    @Override
    public Shape getShapeBySeries(int n) {
        GeneralPath[] generalPathArray = this.getSeriesShapes();
        if (this.isCircleBar && this.layer.isDepth()) {
            return this.VALUE_ANTIALIAS_ON(n);
        }
        return generalPathArray[n];
    }

    @Override
    public Shape getShapeByItem(int n, int n2) {
        return this.itemShapes[n][n2];
    }

    @Override
    public String[] search(int n, int n2) {
        this.drilldown = null;
        if (this.layer.isDepth()) {
            for (int i = this.I() - 1; i >= 0; --i) {
                int[] nArray = this.barWidth(i);
                if (nArray == null) continue;
                for (int j = this.row - 1; j >= 0; --j) {
                    int n3 = nArray[j];
                    if (this.itemShapes[n3][i].contains(n, n2)) {
                        this.drilldown = new int[2];
                        this.drilldown[0] = n3;
                        this.drilldown[1] = i;
                        return this.hintLabel[n3][i];
                    }
                    if (this.topItemShapes[n3][i].contains(n, n2)) {
                        this.drilldown = new int[2];
                        this.drilldown[0] = n3;
                        this.drilldown[1] = i;
                        return this.hintLabel[n3][i];
                    }
                    if (!this.rightItemShapes[n3][i].contains(n, n2)) continue;
                    this.drilldown = new int[2];
                    this.drilldown[0] = n3;
                    this.drilldown[1] = i;
                    return this.hintLabel[n3][i];
                }
            }
        } else {
            for (int i = 0; i < this.row; ++i) {
                for (int j = 0; j < this.I(); ++j) {
                    if (!this.itemShapes[i][j].contains(n, n2)) continue;
                    this.drilldown = new int[2];
                    this.drilldown[0] = i;
                    this.drilldown[1] = j;
                    return this.hintLabel[i][j];
                }
            }
        }
        return null;
    }

    private int[] barWidth(int n) {
        if (n < 0 || n >= this.I()) {
            return null;
        }
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Integer> vector2 = new Vector<Integer>();
        for (int i = 0; i < this.row; ++i) {
            if (this.value[i][n] >= 0.0f) {
                vector2.add(new Integer(i));
                continue;
            }
            vector.add(0, new Integer(i));
        }
        vector2.addAll(0, vector);
        int[] nArray = new int[vector2.size()];
        for (int i = 0; i < vector2.size(); ++i) {
            nArray[i] = (Integer)vector2.get(i);
        }
        return nArray;
    }

    private int[] barWidthN(int n) {
        return this.barWidth(n);
    }

    public GeneralPath[] getSeriesShapes() {
        GeneralPath[] generalPathArray = new GeneralPath[this.row];
        if (!this.layer.isDepth()) {
            for (int i = 0; i < generalPathArray.length; ++i) {
                generalPathArray[i] = new GeneralPath();
                if (this.itemShapes == null || this.itemShapes[i] == null) continue;
                Shape[] shapeArray = this.itemShapes[i];
                for (int j = 0; j < shapeArray.length; ++j) {
                    if (shapeArray[j] == null) continue;
                    generalPathArray[i].append(shapeArray[j], false);
                }
            }
        } else if (this.isCircleBar) {
            for (int i = 0; i < generalPathArray.length; ++i) {
                generalPathArray[i] = new GeneralPath();
                if (this.itemShapes == null || this.itemShapes[i] == null) continue;
                Shape[] shapeArray = this.itemShapes[i];
                Shape[] shapeArray2 = this.topItemShapes[i];
                for (int j = 0; j < shapeArray.length; ++j) {
                    if (shapeArray[j] != null) {
                        generalPathArray[i].append(shapeArray[j], false);
                    }
                    if (shapeArray2[j] == null) continue;
                    generalPathArray[i].append(shapeArray[j], false);
                }
            }
        } else {
            for (int i = 0; i < generalPathArray.length; ++i) {
                generalPathArray[i] = new GeneralPath();
                if (this.itemShapes == null || this.itemShapes[i] == null) continue;
                Shape[] shapeArray = this.itemShapes[i];
                Shape[] shapeArray3 = this.rightItemShapes[i];
                for (int j = 0; j < shapeArray.length; ++j) {
                    if (shapeArray[j] != null) {
                        generalPathArray[i].append(shapeArray[j], false);
                    }
                    if (shapeArray3[j] == null) continue;
                    generalPathArray[i].append(shapeArray3[j], false);
                }
            }
        }
        return generalPathArray;
    }

    @Override
    Shape[][] getItemShapes() {
        return this.itemShapes;
    }

    public boolean contains(int n, int n2) {
        return false;
    }

    @Override
    public int searchSeries(int n, int n2) {
        GeneralPath[] generalPathArray = this.getSeriesShapes();
        for (int i = 0; i < generalPathArray.length; ++i) {
            if (!generalPathArray[i].contains(n, n2)) continue;
            return i;
        }
        return -1;
    }

    public boolean isBench() {
        return this.VALUE_ANTIALIAS_ON;
    }

    public void setBarWidth(float f) {
        this.percentBarWidth = f;
    }

    public void initSum() {
        int n = this.I();
        this.addAll = new double[n];
        if (this.dataset.getChartDataSetModel().isOneGroup() && this.row == 1) {
            for (int i = 0; i < this.addAll.length; ++i) {
                this.addAll[i] = ((Chart1DDataSet)this.dataset).getAbsoluteValueSum();
                this.addAll[i] = this.addAll[i] == 0.0 ? 1.0 : this.addAll[i];
            }
        } else if (this.paper.isScrollChart()) {
            int n2 = this.paper.I.showScrollLabelStart();
            for (int i = 0; i < this.addAll.length; ++i) {
                this.addAll[i] = ((Chart1DDataSet)this.dataset).getAbsoluteValueSumOfCategory(i + n2);
            }
        } else {
            for (int i = 0; i < this.addAll.length; ++i) {
                this.addAll[i] = ((Chart1DDataSet)this.dataset).getAbsoluteValueSumOfCategory(i);
            }
        }
    }

    void cBarPos() {
        int n;
        int n2;
        Number number = null;
        int n3 = this.I();
        boolean bl = ((ChartNumericAxisProperties)this.layer.axisY.getProperties()).getIsShowPercent() && !(this instanceof Graph2DBarP);
        float[] fArray2 = null;
        if (bl) {
            n2 = this.dataset.getChartDataSetModel().isOneGroup();
            fArray2 = new float[this.col];
            if (n2 != 0 && this.row == 1) {
                for (n = 0; n < fArray2.length; ++n) {
                    fArray2[n] = (float)((Chart1DDataSet)this.dataset).getAbsoluteValueSum();
                    fArray2[n] = fArray2[n] == 0.0f ? 1.0f : fArray2[n];
                }
            } else {
                for (n = 0; n < fArray2.length; ++n) {
                    fArray2[n] = (float)((Chart1DDataSet)this.dataset).getAbsoluteValueSumOfCategory(n);
                    fArray2[n] = fArray2[n] == 0.0f ? 1.0f : fArray2[n];
                }
            }
        }
        if (!this.paper.isScrollChart()) {
            for (n2 = 0; n2 < this.row; ++n2) {
                for (n = 0; n < this.col; ++n) {
                    number = this instanceof Graph2DBarSt ? (Number)((Chart1DDataSet)this.dataset).getOriginValue(n2, n) : (Number)((Chart1DDataSet)this.dataset).getValue(n2, n);
                    this.value[n2][n] = number == null ? 0.0f : (bl ? number.floatValue() / fArray2[n] : number.floatValue());
                }
            }
        } else {
            n2 = this.paper.I.showScrollLabelStart();
            for (n = 0; n < this.row; ++n) {
                for (int i = 0; i < n3; ++i) {
                    number = this instanceof Graph2DBarSt ? (Number)((Chart1DDataSet)this.dataset).getOriginValue(n, i + n2) : (Number)((Chart1DDataSet)this.dataset).getValue(n, i + n2);
                    this.value[n][i] = number == null ? 0.0f : (bl ? number.floatValue() / fArray2[i + n2] : number.floatValue());
                }
            }
        }
        if (this.paper.getProperties().getGraphProperties().getValueLabelType() != 0 && this.valueLabelPosition != 0) {
            this.initSum();
        }
        this.closePath();
    }

    void closePath() {
        if (this.paper.isScrollChart()) {
            int n = this.paper.I.showScrollLabelStart();
            int n2 = this.I();
            for (int i = 0; i < this.row; ++i) {
                for (int j = 0; j < n2; ++j) {
                    if (((Chart1DDataSet)this.dataset).getValue(i, j + n) == null) continue;
                    if (this.layer.isShowCategoryAndSeries()) {
                        ChartHintLabel chartHintLabel = new ChartHintLabel((ChartDataObject)this, this.dataset, this.paper, 3);
                        this.hintLabel[i][j] = chartHintLabel.hintLabelShowCategoryAndSeriesFor2d(i, j + n);
                        continue;
                    }
                    this.hintLabel[i][j][0] = this.dataset.getFormatedHintValue(((Chart1DDataSet)this.dataset).getOriginValue(i, j + n));
                }
            }
        } else {
            for (int i = 0; i < this.row; ++i) {
                for (int j = 0; j < this.col; ++j) {
                    if (((Chart1DDataSet)this.dataset).getValue(i, j) == null) continue;
                    if (this.layer.isShowCategoryAndSeries()) {
                        ChartHintLabel chartHintLabel = new ChartHintLabel((ChartDataObject)this, this.dataset, this.paper, 3);
                        this.hintLabel[i][j] = chartHintLabel.hintLabelShowCategoryAndSeriesFor2d(i, j);
                        continue;
                    }
                    this.hintLabel[i][j][0] = this.dataset.getFormatedHintValue(((Chart1DDataSet)this.dataset).getOriginValue(i, j));
                }
            }
        }
    }

    int I() {
        if (this.paper.isScrollChart()) {
            return this.getScrollLabelCount();
        }
        return this.col;
    }

    private boolean col(int n, int n2) {
        int n3 = this.I();
        if (n2 == 0 || n2 == n3 - 1) {
            if (n2 == 0) {
                return n < this.row / 2;
            }
            return n >= (this.row + 1) / 2;
        }
        return false;
    }

    void contains(Graphics2D graphics2D, int n, int n2, ChartShowValueCondition chartShowValueCondition, Shape shape) {
        int n3 = n2;
        if (!(this.paper instanceof Chart2DSimplePaper)) {
            n3 += this.paper.I.showScrollLabelStart();
        }
        if (chartShowValueCondition.getConditionType() != 2) {
            ChartShowValueSubCondition chartShowValueSubCondition = this.dataset.getSubCondition(n, n3);
            if (chartShowValueSubCondition != null) {
                if (chartShowValueSubCondition.getFillColor() != null) {
                    chartShowValueSubCondition.getFillColor().fill(graphics2D, shape);
                }
            } else if (chartShowValueCondition.getOtherColor() != null) {
                chartShowValueCondition.getOtherColor().fill(graphics2D, shape);
            }
        } else {
            Vector<Shape> vector = new Vector<Shape>();
            float[][] fArray2 = this.draw(n, n2);
            float[] fArray3 = this.dataset(n, n2);
            for (int i = 0; i < chartShowValueCondition.getSubConditons().size(); ++i) {
                ChartShowValueSubCondition chartShowValueSubCondition = (ChartShowValueSubCondition)chartShowValueCondition.getSubConditons().get(i);
                float[][] fArray4 = this.depth(fArray2, fArray3[0], fArray3[1], chartShowValueSubCondition.getStartValue(), chartShowValueSubCondition.getEndValue());
                if (fArray4 == null) continue;
                Shape shape2 = ChartRenderTools.getNormalBarItemFace(fArray4);
                vector.add(shape2);
                if (chartShowValueSubCondition.getFillColor() == null) continue;
                chartShowValueSubCondition.getFillColor().fill(graphics2D, shape2);
            }
            Area area = new Area(shape);
            for (int i = 0; i < vector.size(); ++i) {
                area.subtract(new Area((Shape)vector.get(i)));
            }
            if (chartShowValueCondition.getOtherColor() != null) {
                chartShowValueCondition.getOtherColor().fill(graphics2D, area);
            }
        }
    }

    void cos(Graphics2D graphics2D, int n, int n2, ChartShowValueCondition chartShowValueCondition) {
        if (chartShowValueCondition.getConditionType() != 2) {
            ChartShowValueSubCondition chartShowValueSubCondition = this.dataset.getSubCondition(n, n2);
            if (chartShowValueSubCondition != null) {
                if (chartShowValueSubCondition.getFillColor() != null && this.itemShapes[n][n2] != null) {
                    chartShowValueSubCondition.getFillColor().fill(graphics2D, this.itemShapes[n][n2]);
                    chartShowValueSubCondition.getFillColor().highLightFill(graphics2D, this.topItemShapes[n][n2], 20);
                    chartShowValueSubCondition.getFillColor().highLightFill(graphics2D, this.rightItemShapes[n][n2], -20);
                }
            } else if (chartShowValueCondition.getOtherColor() != null) {
                chartShowValueCondition.getOtherColor().fill(graphics2D, this.itemShapes[n][n2]);
                chartShowValueCondition.getOtherColor().highLightFill(graphics2D, this.topItemShapes[n][n2], 20);
                chartShowValueCondition.getOtherColor().highLightFill(graphics2D, this.rightItemShapes[n][n2], -20);
            }
        } else {
            ChartFillPattern chartFillPattern;
            Object object;
            Vector<Shape> vector = new Vector<Shape>();
            Vector<Shape> vector2 = new Vector<Shape>();
            float[][] fArray2 = this.draw(n, n2);
            float[] fArray3 = this.dataset(n, n2);
            for (int i = 0; i < chartShowValueCondition.getSubConditons().size(); ++i) {
                object = (ChartShowValueSubCondition)chartShowValueCondition.getSubConditons().get(i);
                float[][] fArray4 = this.depth(fArray2, fArray3[0], fArray3[1], ((ChartShowValueSubCondition)object).getStartValue(), ((ChartShowValueSubCondition)object).getEndValue());
                Shape shape = ChartRenderTools.getDepthBarFontFace(fArray4, this.abs, this.VALUE_STROKE_PURE, this.VALUE_ANTIALIAS_ON);
                Shape shape2 = ChartRenderTools.getDepthBarTopFace(fArray4, this.abs, this.VALUE_STROKE_PURE, this.VALUE_ANTIALIAS_ON, this.value[n][n2] >= 0.0f);
                Shape shape3 = ChartRenderTools.getDepthBarRightFace(fArray4, this.abs, this.VALUE_STROKE_PURE, this.VALUE_ANTIALIAS_ON, this.value[n][n2] >= 0.0f);
                vector.add(shape);
                vector2.add(shape3);
                if (((ChartShowValueSubCondition)object).getFillColor() == null) continue;
                ((ChartShowValueSubCondition)object).getFillColor().fill(graphics2D, shape);
                ((ChartShowValueSubCondition)object).getFillColor().highLightFill(graphics2D, shape3, -20);
            }
            Area area = new Area(this.itemShapes[n][n2]);
            object = new Area(this.rightItemShapes[n][n2]);
            for (int i = 0; i < vector.size(); ++i) {
                area.subtract(new Area((Shape)vector.get(i)));
                ((Area)object).subtract(new Area((Shape)vector2.get(i)));
            }
            if (chartShowValueCondition.getOtherColor() != null) {
                chartShowValueCondition.getOtherColor().fill(graphics2D, area);
                chartShowValueCondition.getOtherColor().highLightFill(graphics2D, (Shape)object, -20);
            }
            if ((chartFillPattern = chartShowValueCondition.getValueConditionFill(this.value[n][n2] < 0.0f ? 0.0f : this.value[n][n2])) != null) {
                chartFillPattern.highLightFill(graphics2D, this.topItemShapes[n][n2], 20);
            }
        }
    }

    void custommerConstant(Graphics2D graphics2D, int n, int n2, ChartShowValueCondition chartShowValueCondition) {
        if (chartShowValueCondition.getConditionType() != 2) {
            ChartShowValueSubCondition chartShowValueSubCondition = this.dataset.getSubCondition(n, n2);
            if (chartShowValueSubCondition != null) {
                if (chartShowValueSubCondition.getFillColor() != null && this.itemShapes[n][n2] != null) {
                    ChartRenderTools.fillCylindarFace(graphics2D, this.VALUE_ANTIALIAS_ON, chartShowValueSubCondition.getFillColor(), this.itemShapes[n][n2]);
                    chartShowValueSubCondition.getFillColor().highLightFill(graphics2D, this.topItemShapes[n][n2], 30);
                }
            } else if (chartShowValueCondition.getOtherColor() != null) {
                ChartRenderTools.fillCylindarFace(graphics2D, this.VALUE_ANTIALIAS_ON, chartShowValueCondition.getOtherColor(), this.itemShapes[n][n2]);
                chartShowValueCondition.getOtherColor().highLightFill(graphics2D, this.topItemShapes[n][n2], 30);
            }
        } else {
            ChartFillPattern chartFillPattern;
            Vector<Shape> vector = new Vector<Shape>();
            float[][] fArray2 = this.draw(n, n2);
            float[] fArray3 = this.dataset(n, n2);
            for (int i = 0; i < chartShowValueCondition.getSubConditons().size(); ++i) {
                ChartShowValueSubCondition chartShowValueSubCondition = (ChartShowValueSubCondition)chartShowValueCondition.getSubConditons().get(i);
                float[][] fArray4 = this.depth(fArray2, fArray3[0], fArray3[1], chartShowValueSubCondition.getStartValue(), chartShowValueSubCondition.getEndValue());
                Shape shape = ChartRenderTools.getCylindarItemFaces(fArray4, (double)this.objectProperties.getDepthDirection() * Math.PI / 180.0, this.abs, this.VALUE_STROKE_PURE, this.VALUE_ANTIALIAS_ON, false);
                vector.add(shape);
                if (chartShowValueSubCondition.getFillColor() == null) continue;
                ChartRenderTools.fillCylindarFace(graphics2D, this.VALUE_ANTIALIAS_ON, chartShowValueSubCondition.getFillColor(), shape);
            }
            Area area = new Area(this.itemShapes[n][n2]);
            for (int i = 0; i < vector.size(); ++i) {
                area.subtract(new Area((Shape)vector.get(i)));
            }
            if (chartShowValueCondition.getOtherColor() != null) {
                ChartRenderTools.fillCylindarFace(graphics2D, this.VALUE_ANTIALIAS_ON, chartShowValueCondition.getOtherColor(), area);
            }
            if ((chartFillPattern = chartShowValueCondition.getValueConditionFill(this.value[n][n2] < 0.0f ? 0.0f : this.value[n][n2])) != null) {
                chartFillPattern.highLightFill(graphics2D, this.topItemShapes[n][n2], 20);
            }
        }
    }

    float[] dataset(int n, int n2) {
        float f;
        float f2;
        float[] fArray2 = new float[2];
        if (this.value[n][n2] > 0.0f) {
            f2 = this.value[n][n2];
            f = 0.0f;
        } else {
            f2 = 0.0f;
            f = this.value[n][n2];
        }
        float f3 = (float)((ChartNumericAxis)this.layer.getAxisY()).getLabelEndValue();
        f2 = f2 > f3 ? f3 : f2;
        float f4 = (float)((ChartNumericAxis)this.layer.getAxisY()).getLabelStartValue();
        fArray2[0] = f = f < f4 ? f4 : f;
        fArray2[1] = f2;
        return fArray2;
    }

    private float[][] depth(float[][] fArray2, float f, float f2, float f3, float f4) {
        float f5;
        float[][] fArray3 = new float[4][2];
        if (!this.VALUE_ANTIALIAS_ON) {
            fArray3[0][0] = fArray2[0][0];
            fArray3[1][0] = fArray2[1][0];
            fArray3[2][0] = fArray2[2][0];
            fArray3[3][0] = fArray2[3][0];
        } else {
            fArray3[0][1] = fArray2[0][1];
            fArray3[1][1] = fArray2[1][1];
            fArray3[2][1] = fArray2[2][1];
            fArray3[3][1] = fArray2[3][1];
        }
        float f6 = 0.0f;
        float f7 = 0.0f;
        f6 = f3;
        f7 = f4;
        if (f2 >= 0.0f && f >= 0.0f) {
            f6 = f > f6 ? f : f6;
            f7 = f2 < f7 ? f2 : f7;
        } else {
            f6 = f6 > 0.0f ? 0.0f : f6;
            f6 = f6 < f ? f : f6;
            f7 = f7 > 0.0f ? 0.0f : f7;
        }
        float f8 = Math.abs(f2 - f);
        f8 = f8 == 0.0f ? 0.01f : f8;
        float f9 = f5 = !this.VALUE_ANTIALIAS_ON ? Math.abs(fArray2[3][1] - fArray2[0][1]) : Math.abs(fArray2[3][0] - fArray2[0][0]);
        if (!this.VALUE_ANTIALIAS_ON) {
            if (f2 >= 0.0f && f >= 0.0f) {
                if (f3 < 0.0f && f4 < 0.0f) {
                    return null;
                }
                if (f3 > f7) {
                    return null;
                }
                fArray3[0][1] = fArray2[0][1] - Math.abs((f6 - f) / f8) * f5;
                fArray3[1][1] = fArray3[0][1];
                fArray3[3][1] = fArray2[0][1] - Math.abs((f7 - f) / f8) * f5;
                fArray3[2][1] = fArray3[3][1];
            } else {
                if (f3 >= 0.0f && f4 >= 0.0f) {
                    return null;
                }
                if (f4 < f) {
                    return null;
                }
                fArray3[0][1] = fArray2[0][1] + Math.abs(f6 / f8) * f5;
                fArray3[1][1] = fArray3[0][1];
                fArray3[3][1] = fArray2[0][1] + Math.abs(f7 / f8) * f5;
                fArray3[2][1] = fArray3[3][1];
            }
        } else {
            boolean bl;
            boolean bl2 = bl = this.layer.getAxisX() != null && this.layer.getAxisX().getAxisPosition() == 4;
            if (f2 >= 0.0f && f >= 0.0f) {
                if (f3 < 0.0f && f4 < 0.0f) {
                    return null;
                }
                if (f3 > f7) {
                    return null;
                }
                if (bl) {
                    fArray3[0][0] = fArray2[0][0] - Math.abs((f6 - f) / f8) * f5;
                    fArray3[1][0] = fArray3[0][0];
                    fArray3[3][0] = fArray2[0][0] - Math.abs((f7 - f) / f8) * f5;
                    fArray3[2][0] = fArray3[3][0];
                } else {
                    fArray3[0][0] = fArray2[0][0] + Math.abs((f6 - f) / f8) * f5;
                    fArray3[1][0] = fArray3[0][0];
                    fArray3[3][0] = fArray2[0][0] + Math.abs((f7 - f) / f8) * f5;
                    fArray3[2][0] = fArray3[3][0];
                }
            } else {
                if (f3 >= 0.0f && f4 >= 0.0f) {
                    return null;
                }
                if (f4 < f) {
                    return null;
                }
                if (bl) {
                    fArray3[0][0] = fArray2[0][0] + Math.abs(f6 / f8) * f5;
                    fArray3[1][0] = fArray3[0][0];
                    fArray3[3][0] = fArray2[0][0] + Math.abs(f7 / f8) * f5;
                    fArray3[2][0] = fArray3[3][0];
                } else {
                    fArray3[0][0] = fArray2[0][0] - Math.abs(f6 / f8) * f5;
                    fArray3[1][0] = fArray3[0][0];
                    fArray3[3][0] = fArray2[0][0] - Math.abs(f7 / f8) * f5;
                    fArray3[2][0] = fArray3[3][0];
                }
            }
        }
        return fArray3;
    }

    float[][] draw(int n, int n2) {
        int n3 = n * 4 * this.I() + n2 * 4;
        float[][] fArray2 = new float[4][2];
        fArray2[0][0] = this.tVertex[n3][0];
        fArray2[0][1] = this.tVertex[n3][1];
        fArray2[1][0] = this.tVertex[n3 + 1][0];
        fArray2[1][1] = this.tVertex[n3 + 1][1];
        fArray2[2][0] = this.tVertex[n3 + 2][0];
        fArray2[2][1] = this.tVertex[n3 + 2][1];
        fArray2[3][0] = this.tVertex[n3 + 3][0];
        fArray2[3][1] = this.tVertex[n3 + 3][1];
        return fArray2;
    }

    void drawDepthBar() {
        if (this.paper instanceof Chart2DSimplePaper) {
            return;
        }
        if (this.paper.I.getChartLabelShowInfo() != null && this.paper.I.getChartLabelRotateInfo() != null && this.valueLabelPosition != 0 && (this.valueLabelPosition == 17 || this.valueLabelPosition == 18 || this.valueLabelPosition == 19) && this.valueLabelSmartPos == 1) {
            Integer n = this.getDataSetIndex();
            if (n < 0 || n >= this.paper.I.getChartLabelShowInfo().size()) {
                return;
            }
            if (this.paper.I.getChartLabelShowInfo() == null) {
                return;
            }
            int n2 = this.I();
            float[][] fArray2 = new float[this.row][n2];
            for (int i = 0; i < this.row; ++i) {
                for (int j = 0; j < n2; ++j) {
                    if (this.VALUE_ANTIALIAS_ON) {
                        this.v[n2 * i + j][0] = this.tVertex[i * 4 * n2 + 4 * j + 2][0];
                        this.v[n2 * i + j][1] = (this.tVertex[i * 4 * n2 + 4 * j + 2][1] + this.tVertex[i * 4 * n2 + 4 * j + 3][1]) / 2.0f;
                        fArray2[i][j] = this.tVertex[i * 4 * n2 + 4 * j + 2][0] - this.tVertex[i * 4 * n2 + 4 * j + 1][0];
                    } else {
                        this.v[n2 * i + j][0] = (this.tVertex[i * 4 * n2 + 4 * j + 2][0] + this.tVertex[i * 4 * n2 + 4 * j + 3][0]) / 2.0f;
                        this.v[n2 * i + j][1] = this.tVertex[i * 4 * n2 + 4 * j + 2][1];
                        fArray2[i][j] = this.tVertex[i * 4 * n2 + 4 * j + 1][1] - this.tVertex[i * 4 * n2 + 4 * j + 2][1];
                    }
                    if (!this.layer.isDepth()) continue;
                    float[] fArray3 = this.v[n2 * i + j];
                    fArray3[0] = fArray3[0] - this.abs;
                    float[] fArray4 = this.v[n2 * i + j];
                    fArray4[1] = fArray4[1] + this.VALUE_STROKE_PURE;
                }
            }
            Graph2DStaticHint graph2DStaticHint = new Graph2DStaticHint(this.paper.model, this.dataset, this.paper, this.layer, this.v, this.barWidth, fArray2, 0, this.row, this.valueLabelPosition, this.addAll, this.append);
            float f = 0.0f;
            f = this.layer.getAxisX().getUnit(!this.VALUE_ANTIALIAS_ON ? (float)(this.paper.getGraphArea().width - 2) : (float)(this.paper.getGraphArea().height - 2));
            if (!this.layer.getAxisX().custommerConstant()) {
                if (this.row > 1) {
                    if (this instanceof Graph2DBarSi) {
                        f *= this.objectProperties.getBarWidth();
                        f /= (float)this.row;
                    } else {
                        f *= this.objectProperties.getBarWidth();
                    }
                } else {
                    f *= this.objectProperties.getBarWidth();
                }
            } else {
                f = ((ChartCategoryAxis)this.layer.getAxisX()).getMinUnit(f);
            }
            graph2DStaticHint.setIsSmartShow(true);
            graph2DStaticHint.setBarWidth(f);
            graph2DStaticHint.setColumnNumber(n2);
            Vector vector = graph2DStaticHint.getSmartLabelShowInfo();
            this.paper.I.getChartLabelRotateInfo().set(n, vector.get(0));
            boolean[][] blArray = (boolean[][])vector.get(1);
            Vector vector2 = new Vector();
            if (blArray != null) {
                for (int i = 0; i < blArray.length; ++i) {
                    Vector<Integer> vector3 = new Vector<Integer>();
                    int n3 = blArray[i].length;
                    for (int j = 0; j < n3; ++j) {
                        if (!blArray[i][j]) continue;
                        vector3.add(new Integer(j));
                    }
                    vector2.add(vector3);
                }
            } else {
                vector2.add(null);
            }
            this.paper.I.getChartLabelShowInfo().set(n, vector2);
        }
    }

    @Override
    public int[] searchLinkInfo(int n, int n2) {
        int[] nArray = null;
        int n3 = this.dataset.getShowValueBeginIndex();
        int n4 = this.dataset.getShowValueEndIndex();
        int n5 = n4 - n3;
        int n6 = this.row / n5;
        if (this.layer.isDepth()) {
            for (int i = this.I() - 1; i >= 0; --i) {
                int[] nArray2 = this.barWidth(i);
                if (nArray2 == null) continue;
                for (int j = this.row - 1; j >= 0; --j) {
                    int n7 = nArray2[j];
                    if (this.itemShapes[n7][i].contains(n, n2)) {
                        ChartShowValueCondition chartShowValueCondition = this.dataset.getCondition(n7, i);
                        int n8 = 0;
                        n8 = n7 + 1 > n6 ? n7 - n7 / n6 * n6 : n7;
                        if (chartShowValueCondition != null && chartShowValueCondition.getChartLink() != null) {
                            nArray = ((ChartDataUsedInfo)((List)chartShowValueCondition.getChartLink().get(n8)).get(i)).getChartLinkInfo();
                        }
                        return nArray;
                    }
                    if (this.topItemShapes[n7][i].contains(n, n2)) {
                        ChartShowValueCondition chartShowValueCondition = this.dataset.getCondition(n7, i);
                        int n9 = 0;
                        n9 = n7 + 1 > n6 ? n7 - n7 / n6 * n6 : n7;
                        if (chartShowValueCondition != null && chartShowValueCondition.getChartLink() != null) {
                            nArray = ((ChartDataUsedInfo)((List)chartShowValueCondition.getChartLink().get(n9)).get(i)).getChartLinkInfo();
                        }
                        return nArray;
                    }
                    if (!this.rightItemShapes[n7][i].contains(n, n2)) continue;
                    ChartShowValueCondition chartShowValueCondition = this.dataset.getCondition(n7, i);
                    int n10 = 0;
                    n10 = n7 + 1 > n6 ? n7 - n7 / n6 * n6 : n7;
                    if (chartShowValueCondition != null && chartShowValueCondition.getChartLink() != null) {
                        nArray = ((ChartDataUsedInfo)((List)chartShowValueCondition.getChartLink().get(n10)).get(i)).getChartLinkInfo();
                    }
                    return nArray;
                }
            }
        } else {
            for (int i = 0; i < this.row; ++i) {
                for (int j = 0; j < this.I(); ++j) {
                    if (!this.itemShapes[i][j].contains(n, n2)) continue;
                    ChartShowValueCondition chartShowValueCondition = this.dataset.getCondition(i, j);
                    if (chartShowValueCondition != null && chartShowValueCondition.getChartLink() != null) {
                        int n11 = 0;
                        n11 = i + 1 > n6 ? i - i / n6 * n6 : i;
                        nArray = ((ChartDataUsedInfo)((List)chartShowValueCondition.getChartLink().get(n11)).get(j)).getChartLinkInfo();
                    }
                    return nArray;
                }
            }
        }
        return null;
    }
}

