/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.chart2d.Chart2DLayer;
import chart.chart2d.Chart2DPaper;
import chart.chart2d.Graph2DStock;
import chart.data.Chart4DDataSet;
import chart.data.ChartDataSet;
import chart.graphics.ChartColorPattern;
import java.awt.Shape;
import java.awt.geom.GeneralPath;

public class Graph2DStockOHLC
extends Graph2DStock {
    private float[][][] F;
    private GeneralPath I;
    private float append;

    Graph2DStockOHLC(ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer) {
        super(chartDataSet, chart2DPaper, chart2DLayer);
    }

    @Override
    public void init() {
        int n;
        int n2;
        this.stockType = 2;
        super.init();
        this.I = new GeneralPath();
        this.stockUpBarPattern = new ChartColorPattern(this.objectProperties.getStockUpBarColor());
        this.stockDownBarPattern = new ChartColorPattern(this.objectProperties.getStockDownBarColor());
        this.stockOItemShapes = new Shape[this.row][this.col];
        this.stockCItemShapes = new Shape[this.row][this.col];
        this.stockHItemShapes = new Shape[this.row][this.col];
        this.stockLItemShapes = new Shape[this.row][this.col];
        this.upShapes = new Shape[this.row];
        this.downShapes = new Shape[this.row];
        this.stockLineShapes = new Shape[this.row];
        for (n2 = 0; n2 < this.row; ++n2) {
            this.upShapes[n2] = new GeneralPath();
            this.downShapes[n2] = new GeneralPath();
            this.stockLineShapes[n2] = new GeneralPath();
            for (n = 0; n < this.col; ++n) {
                this.stockOItemShapes[n2][n] = new GeneralPath();
                this.stockCItemShapes[n2][n] = new GeneralPath();
                this.stockHItemShapes[n2][n] = new GeneralPath();
                this.stockLItemShapes[n2][n] = new GeneralPath();
            }
        }
        this.stockBar = new float[4 * this.row * this.col][2];
        this.tStockBar = new float[4 * this.row * this.col][2];
        this.F = new float[this.row][this.col][4];
        for (n2 = 0; n2 < this.row; ++n2) {
            for (n = 0; n < this.col; ++n) {
                if (((Chart4DDataSet)this.dataset).getV1(n2, n) == null) continue;
                this.F[n2][n][0] = ((Chart4DDataSet)this.dataset).getV1(n2, n).floatValue();
                if (((Chart4DDataSet)this.dataset).getV2(n2, n) == null) continue;
                this.F[n2][n][1] = ((Chart4DDataSet)this.dataset).getV2(n2, n).floatValue();
                if (((Chart4DDataSet)this.dataset).getV3(n2, n) == null) continue;
                this.F[n2][n][2] = ((Chart4DDataSet)this.dataset).getV3(n2, n).floatValue();
                if (((Chart4DDataSet)this.dataset).getV4(n2, n) == null) continue;
                this.F[n2][n][3] = ((Chart4DDataSet)this.dataset).getV4(n2, n).floatValue();
            }
        }
        this.I(this.F);
        this.append = this.unitX / 2.0f - this.unitX * this.objectProperties.getBarWidth() / 5.0f;
        for (n2 = 0; n2 < this.row; ++n2) {
            for (n = 0; n < this.col; ++n) {
                this.stockBar[n2 * 4 * this.col + 4 * n][0] = this.append + (float)n * this.unitX;
                this.stockBar[n2 * 4 * this.col + 4 * n][1] = this.layer.availableValue(this.F[n2][n][0]) * this.unitY;
                this.stockBar[n2 * 4 * this.col + 4 * n + 1][0] = this.stockBar[n2 * 4 * this.col + 4 * n][0] + this.unitX * 2.0f * this.objectProperties.getBarWidth() / 5.0f;
                this.stockBar[n2 * 4 * this.col + 4 * n + 1][1] = this.stockBar[n2 * 4 * this.col + 4 * n][1];
                this.stockBar[n2 * 4 * this.col + 4 * n + 2][0] = this.stockBar[n2 * 4 * this.col + 4 * n + 1][0];
                this.stockBar[n2 * 4 * this.col + 4 * n + 2][1] = this.layer.availableValue(this.F[n2][n][3]) * this.unitY;
                this.stockBar[n2 * 4 * this.col + 4 * n + 3][0] = this.stockBar[n2 * 4 * this.col + 4 * n][0];
                this.stockBar[n2 * 4 * this.col + 4 * n + 3][1] = this.stockBar[n2 * 4 * this.col + 4 * n + 2][1];
            }
        }
        for (n2 = 0; n2 < this.row; ++n2) {
            for (n = 0; n < this.col; ++n) {
                this.stockLine[n2 * 2 * this.col + 2 * n][0] = this.unitX / 2.0f + (float)n * this.unitX;
                this.stockLine[n2 * 2 * this.col + 2 * n + 1][0] = this.stockLine[n2 * 2 * this.col + 2 * n][0];
                this.stockLine[n2 * 2 * this.col + 2 * n][1] = this.unitY * this.layer.availableValue(this.F[n2][n][1]);
                this.stockLine[n2 * 2 * this.col + 2 * n + 1][1] = this.unitY * this.layer.availableValue(this.F[n2][n][2]);
            }
        }
    }

    @Override
    public void locate() {
        int n;
        int n2;
        super.locate();
        this.layer.I(this.stockLine, this.tStockLine);
        this.layer.I(this.stockBar, this.tStockBar);
        for (n2 = 0; n2 < this.row; ++n2) {
            for (n = 0; n < this.I(); ++n) {
                this.I.reset();
                if (((Chart4DDataSet)this.dataset).getV1(n2, n) == null || ((Chart4DDataSet)this.dataset).getV4(n2, n) == null) continue;
                this.I.moveTo(this.tStockBar[n2 * 4 * this.col + 4 * n][0], this.tStockBar[n2 * 4 * this.col + 4 * n][1]);
                this.I.lineTo(this.tStockBar[n2 * 4 * this.col + 4 * n + 1][0], this.tStockBar[n2 * 4 * this.col + 4 * n + 1][1]);
                this.I.lineTo(this.tStockBar[n2 * 4 * this.col + 4 * n + 2][0], this.tStockBar[n2 * 4 * this.col + 4 * n + 2][1]);
                this.I.lineTo(this.tStockBar[n2 * 4 * this.col + 4 * n + 3][0], this.tStockBar[n2 * 4 * this.col + 4 * n + 3][1]);
                this.I.closePath();
                if (this.F[n2][n][0] < this.F[n2][n][3]) {
                    ((GeneralPath)this.upShapes[n2]).append(this.I, false);
                    continue;
                }
                ((GeneralPath)this.downShapes[n2]).append(this.I, false);
            }
        }
        for (n2 = 0; n2 < this.row; ++n2) {
            for (n = 0; n < this.I(); ++n) {
                this.I.reset();
                if (((Chart4DDataSet)this.dataset).getV2(n2, n) == null || ((Chart4DDataSet)this.dataset).getV3(n2, n) == null) continue;
                this.I.moveTo(this.tStockLine[n2 * 2 * this.col + 2 * n][0], this.tStockLine[n2 * 2 * this.col + 2 * n][1]);
                this.I.lineTo(this.tStockLine[n2 * 2 * this.col + 2 * n + 1][0], this.tStockLine[n2 * 2 * this.col + 2 * n + 1][1]);
                ((GeneralPath)this.stockLineShapes[n2]).append(this.I, false);
                ((GeneralPath)this.stockHItemShapes[n2][n]).moveTo(this.tStockLine[n2 * 2 * this.col + 2 * n][0] - 5.0f, this.tStockLine[n2 * 2 * this.col + 2 * n][1] + 5.0f);
                ((GeneralPath)this.stockHItemShapes[n2][n]).lineTo(this.tStockLine[n2 * 2 * this.col + 2 * n][0] + 5.0f, this.tStockLine[n2 * 2 * this.col + 2 * n][1] + 5.0f);
                ((GeneralPath)this.stockHItemShapes[n2][n]).lineTo(this.tStockLine[n2 * 2 * this.col + 2 * n][0] + 5.0f, this.tStockLine[n2 * 2 * this.col + 2 * n][1] - 5.0f);
                ((GeneralPath)this.stockHItemShapes[n2][n]).lineTo(this.tStockLine[n2 * 2 * this.col + 2 * n][0] - 5.0f, this.tStockLine[n2 * 2 * this.col + 2 * n][1] - 5.0f);
                ((GeneralPath)this.stockHItemShapes[n2][n]).closePath();
                ((GeneralPath)this.stockLItemShapes[n2][n]).moveTo(this.tStockLine[n2 * 2 * this.col + 2 * n + 1][0] - 5.0f, this.tStockLine[n2 * 2 * this.col + 2 * n + 1][1] + 5.0f);
                ((GeneralPath)this.stockLItemShapes[n2][n]).lineTo(this.tStockLine[n2 * 2 * this.col + 2 * n + 1][0] + 5.0f, this.tStockLine[n2 * 2 * this.col + 2 * n + 1][1] + 5.0f);
                ((GeneralPath)this.stockLItemShapes[n2][n]).lineTo(this.tStockLine[n2 * 2 * this.col + 2 * n + 1][0] + 5.0f, this.tStockLine[n2 * 2 * this.col + 2 * n + 1][1] - 5.0f);
                ((GeneralPath)this.stockLItemShapes[n2][n]).lineTo(this.tStockLine[n2 * 2 * this.col + 2 * n + 1][0] - 5.0f, this.tStockLine[n2 * 2 * this.col + 2 * n + 1][1] - 5.0f);
                ((GeneralPath)this.stockLItemShapes[n2][n]).closePath();
            }
        }
        for (n2 = 0; n2 < this.row; ++n2) {
            for (n = 0; n < this.I(); ++n) {
                if (((Chart4DDataSet)this.dataset).getV1(n2, n) == null || ((Chart4DDataSet)this.dataset).getV4(n2, n) == null) continue;
                ((GeneralPath)this.stockOItemShapes[n2][n]).moveTo(this.tStockBar[n2 * 4 * this.col + 4 * n][0] + this.unitX / 10.0f - 5.0f, this.tStockBar[n2 * 4 * this.col + 4 * n][1] + 5.0f);
                ((GeneralPath)this.stockOItemShapes[n2][n]).lineTo(this.tStockBar[n2 * 4 * this.col + 4 * n][0] + this.unitX / 10.0f + 5.0f, this.tStockBar[n2 * 4 * this.col + 4 * n][1] + 5.0f);
                ((GeneralPath)this.stockOItemShapes[n2][n]).lineTo(this.tStockBar[n2 * 4 * this.col + 4 * n][0] + this.unitX / 10.0f + 5.0f, this.tStockBar[n2 * 4 * this.col + 4 * n][1] - 5.0f);
                ((GeneralPath)this.stockOItemShapes[n2][n]).lineTo(this.tStockBar[n2 * 4 * this.col + 4 * n][0] + this.unitX / 10.0f - 5.0f, this.tStockBar[n2 * 4 * this.col + 4 * n][1] - 5.0f);
                ((GeneralPath)this.stockOItemShapes[n2][n]).closePath();
                ((GeneralPath)this.stockCItemShapes[n2][n]).moveTo(this.tStockBar[n2 * 4 * this.col + 4 * n + 3][0] + this.unitX / 10.0f - 5.0f, this.tStockBar[n2 * 4 * this.col + 4 * n + 3][1] + 5.0f);
                ((GeneralPath)this.stockCItemShapes[n2][n]).lineTo(this.tStockBar[n2 * 4 * this.col + 4 * n + 3][0] + this.unitX / 10.0f + 5.0f, this.tStockBar[n2 * 4 * this.col + 4 * n + 3][1] + 5.0f);
                ((GeneralPath)this.stockCItemShapes[n2][n]).lineTo(this.tStockBar[n2 * 4 * this.col + 4 * n + 3][0] + this.unitX / 10.0f + 5.0f, this.tStockBar[n2 * 4 * this.col + 4 * n + 3][1] - 5.0f);
                ((GeneralPath)this.stockCItemShapes[n2][n]).lineTo(this.tStockBar[n2 * 4 * this.col + 4 * n + 3][0] + this.unitX / 10.0f - 5.0f, this.tStockBar[n2 * 4 * this.col + 4 * n + 3][1] - 5.0f);
                ((GeneralPath)this.stockCItemShapes[n2][n]).closePath();
            }
        }
    }
}

