/*
 * Decompiled with CFR 0.152.
 */
package chart.graphics;

import chart.graphics.ChartColorPattern;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartGradientPattern;
import chart.graphics.ChartPenStyle;
import chart.graphics.ChartTexturePattern;
import chart.util.ChartRenderTools;
import com.jinfonet.util.JRLog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.imageio.ImageIO;

public class ChartGraphicsUtil {
    public static final ChartPenStyle HighlightPen = new ChartPenStyle(1, new ChartColorPattern("Green"));

    public static Color setTransparency(Color color, float f) {
        float[] fArray2 = color.getRGBColorComponents(null);
        return new Color(fArray2[0], fArray2[1], fArray2[2], f);
    }

    public static Color highlight(Color color, int n) {
        if (color != null) {
            int n2 = color.getRGB();
            int n3 = color.getAlpha();
            int n4 = n2 >> 16 & 0xFF;
            int n5 = n2 >> 8 & 0xFF;
            int n6 = n2 & 0xFF;
            int n7 = n >= 0 ? 1 : 0;
            n = Math.abs(n);
            n4 = (n4 * (100 - n) + n7 * 255 * n) / 100;
            n5 = (n5 * (100 - n) + n7 * 255 * n) / 100;
            n6 = (n6 * (100 - n) + n7 * 255 * n) / 100;
            return new Color(n4, n5, n6, n3);
        }
        return null;
    }

    public static BufferedImage copyImage(String string, Component component) {
        Image image = Toolkit.getDefaultToolkit().getImage(string);
        if (image == null) {
            try {
                image = Toolkit.getDefaultToolkit().getImage(new URL(string));
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        if (image == null) {
            return null;
        }
        MediaTracker mediaTracker = new MediaTracker(component);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
            if (mediaTracker.isErrorAny()) {
                return null;
            }
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        int n = image.getWidth(component);
        int n2 = image.getHeight(component);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, component);
        return bufferedImage;
    }

    public static BufferedImage copyImage(String string) {
        Object var1_1 = null;
        File file = new File(string);
        if (file.exists()) {
            ChartGraphicsUtil.copyImage(file);
        } else {
            try {
                ChartGraphicsUtil.copyImage(new URL(string));
            }
            catch (MalformedURLException malformedURLException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, malformedURLException);
                }
                var1_1 = null;
            }
        }
        return var1_1;
    }

    public static BufferedImage copyImage(File file) {
        BufferedImage bufferedImage;
        try {
            bufferedImage = ImageIO.read(file);
        }
        catch (IOException iOException) {
            bufferedImage = null;
        }
        return bufferedImage;
    }

    public static BufferedImage copyImage(URL uRL) {
        BufferedImage bufferedImage;
        try {
            bufferedImage = ImageIO.read(uRL);
        }
        catch (IOException iOException) {
            bufferedImage = null;
        }
        return bufferedImage;
    }

    public static BufferedImage copyImage(Image image) {
        if (image == null) {
            return null;
        }
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        return bufferedImage;
    }

    public static void drawHighlightBorder(Graphics2D graphics2D, ChartPenStyle chartPenStyle, Rectangle rectangle, boolean bl) {
        Rectangle rectangle2 = new Rectangle(rectangle.x + 2, rectangle.y + 2, rectangle.width - 4, rectangle.height - 4);
        Rectangle rectangle3 = new Rectangle(rectangle.x + 3, rectangle.y + 3, rectangle.width - 6, rectangle.height - 6);
        Color color = graphics2D.getColor();
        graphics2D.setColor(Color.BLACK);
        graphics2D.draw(rectangle2);
        graphics2D.setColor(Color.WHITE);
        graphics2D.draw(rectangle3);
        graphics2D.setColor(color);
        if (bl) {
            ChartGraphicsUtil.HighlightPen(graphics2D, rectangle);
            ChartGraphicsUtil.BLACK(graphics2D, chartPenStyle, rectangle);
        }
    }

    public static void drawHighlightBorder(Graphics2D graphics2D, ChartPenStyle chartPenStyle, Shape shape, boolean bl) {
        Color color = ChartGraphicsUtil.highlight(Color.GRAY, 40);
        chartPenStyle.setPenWidth(4.0f);
        chartPenStyle.setPenColor(new ChartColorPattern(color));
        chartPenStyle.draw(graphics2D, shape);
    }

    private static void BLACK(Graphics2D graphics2D, ChartPenStyle chartPenStyle, Rectangle rectangle) {
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.x + rectangle.width - 5;
        int n4 = rectangle.y + rectangle.height - 5;
        int n5 = (n + n3) / 2;
        int n6 = (n2 + n4) / 2;
        ChartGraphicsUtil.GRAY(graphics2D, n, n2);
        ChartGraphicsUtil.GRAY(graphics2D, n, n4);
        ChartGraphicsUtil.GRAY(graphics2D, n3, n2);
        ChartGraphicsUtil.GRAY(graphics2D, n3, n4);
        ChartGraphicsUtil.GRAY(graphics2D, n5, n2);
        ChartGraphicsUtil.GRAY(graphics2D, n5, n4);
        ChartGraphicsUtil.GRAY(graphics2D, n, n6);
        ChartGraphicsUtil.GRAY(graphics2D, n3, n6);
    }

    private static void GRAY(Graphics2D graphics2D, int n, int n2) {
        Color color = graphics2D.getColor();
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(n, n2, 5, 5);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawRect(n, n2, 5, 5);
    }

    private static void HighlightPen(Graphics2D graphics2D, Rectangle rectangle) {
        ChartPenStyle chartPenStyle = new ChartPenStyle();
        chartPenStyle.setPenColor(new ChartColorPattern(Color.white));
        Rectangle rectangle2 = new Rectangle(rectangle.x - 1, rectangle.y - 1, rectangle.width + 2, rectangle.height + 2);
        ChartGraphicsUtil.I(graphics2D, rectangle2);
    }

    private static void I(Graphics2D graphics2D, Rectangle rectangle) {
        ChartPenStyle chartPenStyle = new ChartPenStyle();
        chartPenStyle.setPenColor(new ChartColorPattern(Color.white));
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = 6;
        int n4 = 6;
        GeneralPath generalPath = new GeneralPath();
        GeneralPath generalPath2 = new GeneralPath();
        generalPath.reset();
        n = rectangle.x;
        n2 = rectangle.y;
        generalPath.moveTo(n + n3 / 2, n2 + n4);
        generalPath.lineTo(n + n3, n2 + n4);
        generalPath.lineTo(n + n3, n2 + n4 / 2);
        generalPath2.append(generalPath, false);
        generalPath.reset();
        n2 = rectangle.y + rectangle.height / 2;
        n = rectangle.x;
        generalPath.moveTo(n + n3 / 2, n2 + n4 / 2);
        generalPath.lineTo(n + n3, n2 + n4 / 2);
        generalPath.lineTo(n + n3, n2 - n4 / 2);
        generalPath.lineTo(n + n3 / 2, n2 - n4 / 2);
        generalPath2.append(generalPath, false);
        generalPath.reset();
        n2 = rectangle.y + rectangle.height;
        n = rectangle.x;
        generalPath.moveTo(n + n3, n2 - n4 / 2);
        generalPath.lineTo(n + n3, n2 - n4);
        generalPath.lineTo(n + n3 / 2, n2 - n4);
        generalPath2.append(generalPath, false);
        generalPath.reset();
        n2 = rectangle.y + rectangle.height;
        n = rectangle.x + rectangle.width / 2;
        generalPath.moveTo(n - n3 / 2, n2 - n4 / 2);
        generalPath.lineTo(n - n3 / 2, n2 - n4);
        generalPath.lineTo(n + n3 / 2, n2 - n4);
        generalPath.lineTo(n + n3 / 2, n2 - n4 / 2);
        generalPath2.append(generalPath, false);
        generalPath.reset();
        n2 = rectangle.y + rectangle.height;
        n = rectangle.x + rectangle.width;
        generalPath.moveTo(n - n3 / 2, n2 - n4);
        generalPath.lineTo(n - n3, n2 - n4);
        generalPath.lineTo(n - n3, n2 - n4 / 2);
        generalPath2.append(generalPath, false);
        generalPath.reset();
        n2 = rectangle.y + rectangle.height / 2;
        n = rectangle.x + rectangle.width;
        generalPath.moveTo(n - n3 / 2, n2 - n4 / 2);
        generalPath.lineTo(n - n3, n2 - n4 / 2);
        generalPath.lineTo(n - n3, n2 + n4 / 2);
        generalPath.lineTo(n - n3 / 2, n2 + n4 / 2);
        generalPath2.append(generalPath, false);
        generalPath.reset();
        n2 = rectangle.y;
        n = rectangle.x + rectangle.width;
        generalPath.moveTo(n - n3, n2 + n4 / 2);
        generalPath.lineTo(n - n3, n2 + n4);
        generalPath.lineTo(n - n3 / 2, n2 + n4);
        generalPath2.append(generalPath, false);
        generalPath.reset();
        n2 = rectangle.y;
        n = rectangle.x + rectangle.width / 2;
        generalPath.moveTo(n - n3 / 2, n2 + n4 / 2);
        generalPath.lineTo(n - n3 / 2, n2 + n4);
        generalPath.lineTo(n + n3 / 2, n2 + n4);
        generalPath.lineTo(n + n3 / 2, n2 + n4 / 2);
        generalPath2.append(generalPath, false);
        chartPenStyle.draw(graphics2D, generalPath2);
    }

    public static Color getComplementaryColor(Color color) {
        int n = Math.abs(-color.getRed() + 128);
        int n2 = Math.abs(-color.getGreen() + 128);
        int n3 = Math.abs(-color.getBlue() + 128);
        Color color2 = new Color(n, n2, n3);
        return color2;
    }

    public static final Color getXORColor(Color color, Color color2) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getGreen();
        int n4 = color2.getRed();
        int n5 = color2.getGreen();
        int n6 = color2.getBlue();
        int n7 = n ^ n4;
        int n8 = n2 ^ n5;
        int n9 = n3 ^ n6;
        if (color.equals(Color.BLACK) || color2.equals(Color.BLACK)) {
            n7 ^= Color.WHITE.getRed();
            n8 ^= Color.WHITE.getGreen();
            n9 ^= Color.WHITE.getBlue();
        }
        Color color3 = new Color(n7, n8, n9);
        return color3;
    }

    public static final Color getSupplementColor(Color color) {
        int n = 255 - color.getRed();
        int n2 = 255 - color.getGreen();
        int n3 = 255 - color.getGreen();
        return new Color(n, n2, n3);
    }

    public static void drawSelectedShape(Graphics2D graphics2D, Shape shape) {
        if (shape instanceof GeneralPath) {
            ChartGraphicsUtil.SEDU(graphics2D, (GeneralPath)shape);
        } else if (shape instanceof Arc2D) {
            ChartGraphicsUtil.WHITE(graphics2D, (Arc2D)shape);
        } else if (shape instanceof Line2D) {
            ChartGraphicsUtil.abs(graphics2D, (Line2D)shape);
        } else if (shape instanceof Rectangle2D) {
            ChartGraphicsUtil.addImage(graphics2D, (Rectangle2D)shape);
        }
    }

    private static void SEDU(Graphics2D graphics2D, GeneralPath generalPath) {
        Vector vector = ChartRenderTools.getCoordFromPath(generalPath);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Point point = (Point)vector.get(i);
            ChartGraphicsUtil.GRAY(graphics2D, point.x - 3, point.y - 3);
        }
    }

    private static void WHITE(Graphics2D graphics2D, Arc2D arc2D) {
        int n = (int)arc2D.getCenterX();
        int n2 = (int)arc2D.getCenterY();
        double d = arc2D.getAngleStart() + arc2D.getAngleExtent() / 2.0;
        Point2D point2D = arc2D.getStartPoint();
        Point2D point2D2 = arc2D.getEndPoint();
        int n3 = (int)((double)n + arc2D.getWidth() / 2.0 * Math.cos(d * Math.PI / 180.0));
        int n4 = (int)((double)n2 - arc2D.getHeight() / 2.0 * Math.sin(d * Math.PI / 180.0));
        ChartGraphicsUtil.GRAY(graphics2D, n - 3, n2 - 3);
        ChartGraphicsUtil.GRAY(graphics2D, (int)point2D.getX() - 3, (int)point2D.getY() - 3);
        ChartGraphicsUtil.GRAY(graphics2D, (int)point2D2.getX() - 3, (int)point2D2.getY() - 3);
        ChartGraphicsUtil.GRAY(graphics2D, n3 - 3, n4 - 3);
    }

    private static void abs(Graphics2D graphics2D, Line2D line2D) {
        int n = (int)line2D.getX1();
        int n2 = (int)line2D.getY1();
        int n3 = (int)line2D.getX2();
        int n4 = (int)line2D.getY2();
        ChartGraphicsUtil.GRAY(graphics2D, n - 3, n2 - 3);
        ChartGraphicsUtil.GRAY(graphics2D, (n + n3) / 2 - 3, (n2 + n4) / 2 - 3);
        ChartGraphicsUtil.GRAY(graphics2D, n3 - 3, n4 - 3);
    }

    private static void addImage(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        int n = (int)rectangle2D.getX();
        int n2 = (int)rectangle2D.getY();
        int n3 = (int)((double)n + rectangle2D.getWidth());
        int n4 = n2;
        int n5 = n3;
        int n6 = (int)((double)n2 + rectangle2D.getHeight());
        int n7 = n;
        int n8 = n6;
        ChartGraphicsUtil.GRAY(graphics2D, n - 3, n2 - 3);
        ChartGraphicsUtil.GRAY(graphics2D, n3 - 3, n4 - 3);
        ChartGraphicsUtil.GRAY(graphics2D, n5 - 3, n6 - 3);
        ChartGraphicsUtil.GRAY(graphics2D, n7 - 3, n8 - 3);
    }

    public static Color cloneColor(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        return new Color(n, n2, n3);
    }

    public static ChartGradientPattern get3DEffectFill(ChartFillPattern chartFillPattern) {
        if (chartFillPattern == null) {
            return null;
        }
        Color color = Color.white;
        Color color2 = Color.black;
        if (chartFillPattern instanceof ChartColorPattern) {
            Color color3 = ((ChartColorPattern)chartFillPattern).getColor();
            color = ChartGraphicsUtil.highlight(color3, 80);
            color2 = ChartGraphicsUtil.highlight(color3, -20);
        } else if (chartFillPattern instanceof ChartGradientPattern) {
            color2 = ChartGraphicsUtil.append(((ChartGradientPattern)chartFillPattern).getEndColor().getColor(), ((ChartGradientPattern)chartFillPattern).getStartColor().getColor());
            color = ChartGraphicsUtil.highlight(color2, 90);
            color2 = ChartGraphicsUtil.highlight(color2, -20);
        } else if (chartFillPattern instanceof ChartTexturePattern) {
            color2 = ChartGraphicsUtil.append(((ChartTexturePattern)chartFillPattern).getBackground().getColor(), ((ChartTexturePattern)chartFillPattern).getForeground().getColor());
            color = ChartGraphicsUtil.highlight(color2, 50);
        }
        ChartColorPattern chartColorPattern = new ChartColorPattern(color);
        ChartColorPattern chartColorPattern2 = new ChartColorPattern(color2);
        Point2D.Float float_ = new Point2D.Float(0.34f, 0.25f);
        Point2D.Float float_2 = new Point2D.Float(0.82f, 0.82f);
        ChartGradientPattern chartGradientPattern = new ChartGradientPattern(3, true, chartColorPattern, float_, chartColorPattern2, float_2);
        return chartGradientPattern;
    }

    static Color append(Color color, Color color2) {
        int n;
        int n2;
        if (color == null) {
            return color2;
        }
        if (color2 == null) {
            return color;
        }
        int n3 = color.getRGB();
        int n4 = (n3 >> 16 & 0xFF) + (n3 >> 8 & 0xFF) + (n3 & 0xFF);
        return n4 > (n2 = ((n = color2.getRGB()) >> 16 & 0xFF) + (n >> 8 & 0xFF) + (n & 0xFF)) ? color2 : color;
    }
}

