/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.awt.font.truetype;

import com.jinfonet.awt.BezierTool;
import com.jinfonet.awt.ExPolygon;
import com.jinfonet.awt.JFont;
import com.jinfonet.awt.JFontEnv;
import com.jinfonet.awt.JFontHeader;
import com.jinfonet.awt.JGraphics;
import com.jinfonet.awt.JShape;
import com.jinfonet.awt.JShape2D;
import com.jinfonet.awt.JShapeble;
import com.jinfonet.awt.font.truetype.IOTool;
import com.jinfonet.awt.font.truetype.NameRecord;
import com.jinfonet.awt.font.truetype.OS2;
import com.jinfonet.awt.font.truetype.TrueTypeFontMetrics;
import com.jinfonet.awt.font.truetype.cmap;
import com.jinfonet.awt.font.truetype.comGlyf;
import com.jinfonet.awt.font.truetype.glyf;
import com.jinfonet.awt.font.truetype.head;
import com.jinfonet.awt.font.truetype.hhea;
import com.jinfonet.awt.font.truetype.hmtx;
import com.jinfonet.awt.font.truetype.loca;
import com.jinfonet.awt.font.truetype.maxp;
import com.jinfonet.awt.font.truetype.name;
import com.jinfonet.awt.font.truetype.post;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.IOException;
import java.util.Locale;
import jet.util.IntKeyHashtable;
import jet.util.RandomInputable;
import jet.util.RandomOutputable;

public class OpenTypeFont
implements JFont {
    protected static final int TAG_CMAP = 1668112752;
    protected static final int TAG_HEAD = 1751474532;
    protected static final int TAG_NAME = 1851878757;
    protected static final int TAG_GLYF = 1735162214;
    protected static final int TAG_MAXP = 1835104368;
    protected static final int TAG_PREP = 1886545264;
    protected static final int TAG_HMTX = 1752003704;
    protected static final int TAG_KERN = 1801810542;
    protected static final int TAG_HDMX = 1751412088;
    protected static final int TAG_LOCA = 1819239265;
    protected static final int TAG_POST = 1886352244;
    protected static final int TAG_OS2 = 1330851634;
    protected static final int TAG_CVT = 1668707360;
    protected static final int TAG_GASP = 1734439792;
    protected static final int TAG_VDMX = 1447316824;
    protected static final int TAG_VMTX = 1986884728;
    protected static final int TAG_VHEA = 1986553185;
    protected static final int TAG_HHEA = 1751672161;
    protected static final int TAG_TYP1 = 1954115633;
    protected static final int TAG_BSLN = 1651731566;
    protected static final int TAG_GSUB = 1196643650;
    protected static final int TAG_DSIG = 1146308935;
    protected static final int TAG_FPGM = 1718642541;
    protected static final int TAG_FVAR = 1719034226;
    protected static final int TAG_GVAR = 1735811442;
    protected static final int TAG_CFF = 1128678944;
    protected static final int TAG_MMSD = 1296913220;
    protected static final int TAG_MMFX = 1296909912;
    protected static final int TAG_BASE = 1111577413;
    protected static final int TAG_GDEF = 1195656518;
    protected static final int TAG_GPOS = 1196445523;
    protected static final int TAG_JSTF = 1246975046;
    protected static final int TAG_EBDT = 0x45424454;
    protected static final int TAG_EBLC = 1161972803;
    protected static final int TAG_EBSC = 1161974595;
    protected static final int TAG_LTSH = 1280594760;
    protected static final int TAG_PCLT = 1346587732;
    protected static final int TAG_ACNT = 1633906292;
    protected static final int TAG_AVAR = 1635148146;
    protected static final int TAG_BDAT = 1650745716;
    protected static final int TAG_BLOC = 1651273571;
    protected static final int TAG_CVAR = 1668702578;
    protected static final int TAG_FEAT = 1717920116;
    protected static final int TAG_FDSC = 1717859171;
    protected static final int TAG_FMTX = 1718449272;
    protected static final int TAG_JUST = 1786082164;
    protected static final int TAG_LCAR = 1818452338;
    protected static final int TAG_MORT = 1836020340;
    protected static final int TAG_OPBD = 1836020340;
    protected static final int TAG_PROP = 1886547824;
    protected static final int TAG_TRAK = 1953653099;
    private RandomInputable S = null;
    IntKeyHashtable I = null;
    cmap[] SEDU;
    head Z;
    hhea C;
    hmtx B;
    maxp D;
    name arraycopy;
    OS2 F;
    post J;
    private glyf[] ceil;
    loca A;
    private boolean charAt = false;
    private IntKeyHashtable close = new IntKeyHashtable();

    public OpenTypeFont(RandomInputable randomInputable) throws IOException {
        this(randomInputable, false);
    }

    public OpenTypeFont(RandomInputable randomInputable, boolean bl) throws IOException {
        this.S = randomInputable;
        this.charAt = bl;
        this.S();
    }

    public String getFontName() {
        String string = "";
        if (this.arraycopy != null) {
            int n = OS2.getPlatform(System.getProperty("os.name"));
            int n2 = OS2.getLauguage(n, Locale.getDefault());
            for (int i = 0; i < this.arraycopy.I; ++i) {
                NameRecord nameRecord = this.arraycopy.Z[i];
                if (nameRecord.B != 1 || nameRecord.I != n || nameRecord.C != n2 && string.length() != 0) continue;
                string = nameRecord.D;
                if (nameRecord.C == n2) break;
            }
        }
        return string;
    }

    public synchronized void outputCondensedForm(RandomOutputable randomOutputable) throws IOException {
        Object[] objectArray;
        int n;
        this.S.seek(0L);
        randomOutputable.writeInt(this.S.readInt());
        boolean bl = this.I.containsKey(1330851634);
        int n2 = bl ? 10 : 9;
        randomOutputable.writeShort(n2);
        randomOutputable.writeShort(128);
        randomOutputable.writeShort(3);
        randomOutputable.writeShort(16 * n2 - 128);
        int[] nArray = null;
        nArray = bl ? new int[]{1751474532, 1751672161, 1752003704, 1835104368, 1851878757, 1886352244, 1330851634, 1668112752, 1735162214, 1819239265} : new int[]{1751474532, 1751672161, 1752003704, 1835104368, 1851878757, 1886352244, 1668112752, 1735162214, 1819239265};
        long l = 12 + 16 * n2;
        for (n = 0; n < n2; ++n) {
            objectArray = (long[])this.I.get(nArray[n]);
            randomOutputable.writeInt(nArray[n]);
            randomOutputable.writeInt((int)(0xFFFFFFFFFFFFFFFFL & objectArray[2]));
            randomOutputable.writeInt((int)(0xFFFFFFFFFFFFFFFFL & l));
            randomOutputable.writeInt((int)(0xFFFFFFFFFFFFFFFFL & objectArray[1]));
            l += objectArray[1];
        }
        n = 1024;
        objectArray = new byte[n];
        for (int i = 0; i < n2; ++i) {
            long[] lArray = (long[])this.I.get(nArray[i]);
            this.S.seek(lArray[0]);
            if (lArray[1] <= (long)n) {
                this.S.readFully((byte[])objectArray, 0, (int)lArray[1]);
                randomOutputable.write((byte[])objectArray, 0, (int)lArray[1]);
                continue;
            }
            long l2 = 0L;
            for (l2 = 0L; l2 < lArray[1] / (long)n; ++l2) {
                this.S.read((byte[])objectArray);
                randomOutputable.write((byte[])objectArray, 0, n);
            }
            int n3 = (int)(lArray[1] - (long)n * l2);
            this.S.read((byte[])objectArray, 0, n3);
            randomOutputable.write((byte[])objectArray, 0, n3);
        }
    }

    private void S() throws IOException {
        this.S.seek(4L);
        int n = IOTool.readUSHORT(this.S);
        int n2 = IOTool.readUSHORT(this.S);
        int n3 = IOTool.readUSHORT(this.S);
        int n4 = IOTool.readUSHORT(this.S);
        boolean bl = false;
        try {
            this.I = new IntKeyHashtable((int)Math.ceil((double)n / 0.75));
            for (int i = 0; i < n; ++i) {
                int n5 = (int)IOTool.readULONG(this.S);
                long l = IOTool.readULONG(this.S);
                long l2 = IOTool.readULONG(this.S);
                long l3 = IOTool.readULONG(this.S);
                this.I.put(n5, new long[]{l2, l3, l});
            }
            if (!this.charAt) {
                this.SEDU = cmap.make((long[])this.I.get(1668112752), this.S);
                this.Z = new head();
                this.Z.read(this, this.S);
                this.C = new hhea();
                this.C.read(this, this.S);
                this.B = new hmtx();
                this.B.read(this, this.S);
                this.D = new maxp();
                this.D.read(this, this.S);
            }
            this.arraycopy = new name();
            this.arraycopy.read(this, this.S);
            if (this.charAt) {
                return;
            }
            this.A = new loca();
            this.A.read(this, this.S);
            this.J = new post();
            this.J.read(this, this.S);
            this.ceil = glyf.make(this, this.S);
            if (this.I.containsKey(1330851634)) {
                this.F = new OS2();
                this.F.read(this, this.S);
            }
        }
        catch (Throwable throwable) {
            bl = true;
        }
        if (bl) {
            throw new IOException("Font file corrupted or bad format.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public glyf getGlyphByIndex(int n) {
        glyf glyf2 = this.ceil[n];
        if (glyf2 == null) {
            OpenTypeFont openTypeFont = this;
            synchronized (openTypeFont) {
                try {
                    glyf2 = glyf.readGlyf(this, n, this.S);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            this.ceil[n] = glyf2;
        }
        return glyf2;
    }

    public JShapeble[] getGlyphs(boolean bl, String string, int n, float f, float f2, float f3) {
        int n2 = string.length();
        JShapeble[] jShapebleArray = null;
        float f4 = this.getScale(n, f);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = this.getGlyphIndex(string.charAt(i));
            JShapeble[] jShapebleArray2 = this.ceil(bl, n4, f2, f3, f4, f4, null);
            jShapebleArray = OpenTypeFont.arraycopy(jShapebleArray, jShapebleArray2, i + n3);
            n3 += jShapebleArray2.length - 1;
            f2 += this.SEDU(n4, f4);
        }
        return jShapebleArray;
    }

    private final float SEDU(int n, float f) {
        float f2 = this.B.Z.length <= n ? (float)this.C.B * f : (float)this.B.I[n] * f;
        return f2;
    }

    public JShapeble[] getGlyphs(boolean bl, int[] nArray, float f, float f2, float f3) {
        JShapeble[] jShapebleArray = null;
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            JShapeble[] jShapebleArray2 = this.ceil(bl, n2, f2, f3, f, f, null);
            jShapebleArray = OpenTypeFont.arraycopy(jShapebleArray, jShapebleArray2, i + n);
            n += jShapebleArray2.length - 1;
            f2 += this.SEDU(n2, f);
        }
        return jShapebleArray;
    }

    private static JShapeble[] arraycopy(JShapeble[] jShapebleArray, JShapeble[] jShapebleArray2, int n) {
        JShapeble[] jShapebleArray3 = new JShapeble[(jShapebleArray != null ? jShapebleArray.length : 0) + jShapebleArray2.length];
        if (jShapebleArray != null) {
            System.arraycopy(jShapebleArray, 0, jShapebleArray3, 0, n);
        }
        System.arraycopy(jShapebleArray2, 0, jShapebleArray3, n, jShapebleArray2.length);
        return jShapebleArray3;
    }

    public final int getGlyphIndex(char c) {
        int n = -1;
        for (int i = 0; i < this.SEDU.length && (n = this.SEDU[i].getGlyphIndex(c)) == 0; ++i) {
        }
        return n;
    }

    public JShapeble[] getGlyph(boolean bl, char c, int n, int n2, float f, float f2) {
        float f3 = this.getScale(n, n2);
        return this.ceil(bl, this.getGlyphIndex(c), f, f2, f3, f3, null);
    }

    public final float getScale(int n, float f) {
        return f * (float)n / (float)(72 * this.Z.I);
    }

    private JShapeble[] ceil(boolean bl, int n, float f, float f2, float f3, float f4, comGlyf comGlyf2) {
        JShapeble[] jShapebleArray = null;
        glyf glyf2 = this.getGlyphByIndex(n);
        if (glyf2.I < 0) {
            if (comGlyf2 != null) {
                f3 *= comGlyf2.getXScale();
                f4 *= comGlyf2.getYScale();
            }
            int n2 = glyf2.J.size();
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                comGlyf comGlyf3 = (comGlyf)glyf2.J.elementAt(i);
                JShapeble[] jShapebleArray2 = this.ceil(bl, comGlyf3.I, f, f2, f3, f4, comGlyf3);
                jShapebleArray = OpenTypeFont.arraycopy(jShapebleArray, jShapebleArray2, i + n3);
                n3 += jShapebleArray2.length - 1;
            }
        } else {
            jShapebleArray = new JShapeble[]{this.charAt(bl, glyf2, f, f2, f3, f4, comGlyf2)};
        }
        return jShapebleArray;
    }

    private JShapeble charAt(boolean bl, glyf glyf2, float f, float f2, float f3, float f4, comGlyf comGlyf2) {
        JShapeble jShapeble = null;
        jShapeble = bl ? new JShape2D() : new JShape();
        int n = 0;
        float[] fArray2 = new float[8];
        for (int i = 0; i < glyf2.I; ++i) {
            int n2 = glyf2.C[i] + 1;
            int n3 = 0;
            int n4 = glyf2.B[n] & 0xFF;
            float f5 = f + (comGlyf2 == null ? (float)glyf2.D[n] * f3 : comGlyf2.getX(f3, glyf2.D[n], glyf2.F[n]));
            float f6 = f2 - (comGlyf2 == null ? (float)glyf2.F[n] * f4 : comGlyf2.getY(f4, glyf2.D[n], glyf2.F[n]));
            jShapeble.moveTo(f5, f6);
            fArray2 = this.containsKey(fArray2, n3, f5, f6);
            ++n3;
            for (int j = n + 1; j < n2 + 1; ++j) {
                if (j == n2) {
                    n4 = glyf2.B[n] & 0xFF;
                    f5 = f + (comGlyf2 == null ? (float)glyf2.D[n] * f3 : comGlyf2.getX(f3, glyf2.D[n], glyf2.F[n]));
                    f6 = f2 - (comGlyf2 == null ? (float)glyf2.F[n] * f4 : comGlyf2.getY(f4, glyf2.D[n], glyf2.F[n]));
                } else {
                    n4 = glyf2.B[j] & 0xFF;
                    f5 = f + (comGlyf2 == null ? (float)glyf2.D[j] * f3 : comGlyf2.getX(f3, glyf2.D[j], glyf2.F[j]));
                    f6 = f2 - (comGlyf2 == null ? (float)glyf2.F[j] * f4 : comGlyf2.getY(f4, glyf2.D[j], glyf2.F[j]));
                }
                if ((n4 & 1) != 0) {
                    if (n3 == 1) {
                        jShapeble.lineTo(f5, f6);
                        n3 = 0;
                    } else if (n3 == 2) {
                        jShapeble.quadTo(fArray2[2], fArray2[3], f5, f6);
                        n3 = 0;
                    } else {
                        int n5;
                        int n6 = n5 * 2;
                        for (n5 = 1; n5 < n3 - 1; ++n5) {
                            n6 = n5 * 2;
                            float[] fArray3 = OpenTypeFont.close(fArray2[n6], fArray2[n6 + 1], fArray2[n6 + 2], fArray2[n6 + 3]);
                            jShapeble.quadTo(fArray2[n6], fArray2[n6 + 1], fArray3[0], fArray3[1]);
                        }
                        jShapeble.quadTo(fArray2[n6 + 2], fArray2[n6 + 3], f5, f6);
                        n3 = 0;
                    }
                }
                fArray2 = this.containsKey(fArray2, n3, f5, f6);
                ++n3;
            }
            n = n2;
        }
        return jShapeble;
    }

    private static float[] close(float f, float f2, float f3, float f4) {
        float f5 = f3 - f;
        float f6 = f4 - f2;
        float[] fArray2 = new float[]{f + f5 / 2.0f, f2 + f6 / 2.0f};
        return fArray2;
    }

    private float[] containsKey(float[] fArray2, int n, float f, float f2) {
        float[] fArray3 = fArray2;
        if (fArray2.length < n * 2 + 2) {
            fArray3 = new float[fArray2.length * 2];
            System.arraycopy(fArray2, 0, fArray3, 0, fArray2.length);
        }
        fArray3[n * 2] = f;
        fArray3[n * 2 + 1] = f2;
        return fArray3;
    }

    @Override
    public void draw(Graphics graphics, String string, float f, float f2) {
        JFontEnv jFontEnv = (JFontEnv)((Object)graphics.getFont());
        boolean bl = JGraphics.is2D(graphics);
        if (!bl) {
            int n = string.length();
            float f3 = f;
            float f4 = this.getScale(jFontEnv.getResolution(), jFontEnv.getPoints());
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                n2 = this.getGlyphIndex(string.charAt(i));
                ExPolygon[] exPolygonArray = (ExPolygon[])this.close.get(n2);
                if (exPolygonArray == null) {
                    JShapeble[] jShapebleArray = this.ceil(false, n2, 0.0f, 0.0f, 1.0f, 1.0f, null);
                    exPolygonArray = new ExPolygon[jShapebleArray.length];
                    for (int j = 0; j < jShapebleArray.length; ++j) {
                        exPolygonArray[j] = BezierTool.getPolygon((JShape)jShapebleArray[j], graphics, 3);
                    }
                    this.close.put(n2, exPolygonArray);
                }
                for (int j = 0; j < exPolygonArray.length; ++j) {
                    ExPolygon exPolygon = exPolygonArray[j].dup();
                    exPolygon.zoom(f4);
                    exPolygon.fill(graphics, f3, f2);
                }
                f3 += this.SEDU(n2, f4);
            }
        }
    }

    @Override
    public FontMetrics getFontMetrics(JFontEnv jFontEnv) {
        return new TrueTypeFontMetrics((Font)((Object)jFontEnv));
    }

    @Override
    public FontMetrics getFontMetrics() {
        throw new Error("Can not access this method");
    }

    @Override
    public JFontHeader getFontHeader() {
        JFontHeader jFontHeader = new JFontHeader(this);
        jFontHeader.setSubType("True Type");
        jFontHeader.setBaseFont(this.arraycopy.getPostName());
        jFontHeader.setFirstChar(this.F.C);
        jFontHeader.setLastChar(255);
        jFontHeader.setEncoding(this.arraycopy.Z[0].Z);
        return jFontHeader;
    }

    @Override
    public void writeTo(RandomOutputable randomOutputable) throws IOException {
        this.outputCondensedForm(randomOutputable);
    }

    @Override
    public int getStyle() {
        int n = 0;
        String string = this.arraycopy.getName(2);
        if (string.indexOf("Italic") != -1) {
            n |= 2;
        }
        if (string.indexOf("Bold") != -1) {
            n |= 1;
        }
        return n;
    }

    @Override
    public int[] getWidths() {
        int[] nArray = new int[256];
        int n = 0;
        boolean bl = this.isAsiaFont();
        for (int i = this.F.C; i < 256; ++i) {
            n = this.getGlyphIndex((char)i);
            nArray[i] = bl || n == 0 || this.B.Z.length <= n ? (int)((double)((float)this.F.I * this.getScale(1, 72.0f)) * 1000.0) : (int)((double)((float)this.B.I[n] * this.getScale(1, 72.0f)) * 1000.0);
        }
        return nArray;
    }

    @Override
    public void setFontEnv(JFontEnv jFontEnv) {
    }

    @Override
    public String getMapFontName() {
        return this.arraycopy.getMapName();
    }

    @Override
    public String getPSName() {
        return this.arraycopy.getPostName();
    }

    @Override
    public boolean isAsiaFont() {
        return this.arraycopy.isAsiaFont();
    }

    @Override
    public String getBaseName() {
        return this.arraycopy.getBasePSName();
    }

    @Override
    public void unload() {
        try {
            this.S.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

