/*
 * Decompiled with CFR 0.152.
 */
package guitools.toolkit;

import guitools.toolkit.TPaintBoard;
import guitools.toolkit.TransparentPeer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;

public class TComponent
extends Component
implements TransparentPeer {
    protected boolean eraser = true;
    protected TPaintBoard tpb;
    private static int SEDU = 0;

    public TComponent() {
        this.setName("TComponent" + SEDU++);
    }

    @Override
    public void addNotify() {
        this.tpb = this.getPaintBoard();
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.tpb = null;
    }

    @Override
    public boolean hasEraser() {
        return this.eraser;
    }

    @Override
    public void setEraser(boolean bl) {
        if (this.eraser != bl) {
            this.eraser = bl;
            this.repaint();
        }
    }

    @Override
    public TPaintBoard getPaintBoard() {
        if (this.tpb == null) {
            Container container;
            for (container = this.getParent(); container != null && !(container instanceof TPaintBoard); container = container.getParent()) {
            }
            this.tpb = (TPaintBoard)container;
        }
        return this.tpb;
    }

    @Override
    public void repaintImage() {
        Dimension dimension = this.getSize();
        this.repaintImage(0, 0, dimension.width, dimension.height);
    }

    @Override
    public void repaintImage(int n, int n2, int n3, int n4) {
        if (this.tpb != null) {
            Rectangle rectangle = this.getBounds();
            rectangle.setLocation(0, 0);
            rectangle = rectangle.intersection(new Rectangle(n, n2, n3, n4));
            this.mapToBoard(rectangle);
            this.tpb.prepareRepaintImage(rectangle);
        }
    }

    @Override
    public boolean isFront() {
        Container container = this.getParent();
        return container == null ? false : container.getComponent(0) == this;
    }

    @Override
    public boolean isBack() {
        Container container = this.getParent();
        return container == null ? false : container.getComponent(container.getComponentCount() - 1) == this;
    }

    @Override
    public void bringToTop() {
        Container container = this.getParent();
        if (container != null) {
            container.add((Component)this, 0);
            if (container instanceof TransparentPeer) {
                ((TransparentPeer)((Object)container)).bringToTop();
            }
        }
    }

    @Override
    public void toZOrderPos(int n) {
        Container container = this.getParent();
        if (container != null) {
            container.add((Component)this, n);
        }
    }

    @Override
    public void toFront() {
        Container container = this.getParent();
        if (container != null && !this.isFront()) {
            container.add((Component)this, 0);
        }
    }

    @Override
    public void toBack() {
        Container container = this.getParent();
        if (container != null && !this.isBack()) {
            container.add(this);
        }
    }

    @Override
    public void forward() {
        Container container = this.getParent();
        if (container != null && !this.isFront()) {
            container.add((Component)this, this.indexOfAtParent() - 1);
        }
    }

    @Override
    public void backward() {
        Container container = this.getParent();
        if (container != null && !this.isBack()) {
            container.add((Component)this, this.indexOfAtParent() + 1);
        }
    }

    protected int indexOfAtParent() {
        Container container = this.getParent();
        if (container != null) {
            for (int i = container.getComponentCount() - 1; i >= 0; --i) {
                if (container.getComponent(i) != this) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public Point mapToBoard(int n, int n2) {
        Point point = new Point(n, n2);
        this.mapToBoard(point);
        return point;
    }

    @Override
    public void mapToBoard(Point point) {
        Point point2 = this.getLocation();
        point.translate(point2.x, point2.y);
        for (Container container = this.getParent(); container != this.tpb; container = container.getParent()) {
            point2 = container.getLocation();
            point.translate(point2.x, point2.y);
        }
    }

    @Override
    public Rectangle mapToBoard(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        this.mapToBoard(rectangle);
        return rectangle;
    }

    @Override
    public void mapToBoard(Rectangle rectangle) {
        Point point = this.mapToBoard(rectangle.x, rectangle.y);
        rectangle.setLocation(point.x, point.y);
    }

    @Override
    public Point mapLocToBoard() {
        return this.mapToBoard(0, 0);
    }

    @Override
    public Rectangle mapBoundsToBoard() {
        Point point = this.mapLocToBoard();
        Dimension dimension = this.getSize();
        Rectangle rectangle = new Rectangle(point.x, point.y, dimension.width, dimension.height);
        return rectangle;
    }

    @Override
    public Point mapToComp(int n, int n2) {
        Point point = new Point(n, n2);
        this.mapToComp(point);
        return point;
    }

    @Override
    public void mapToComp(Point point) {
        Point point2 = this.getLocation();
        point.translate(-point2.x, -point2.y);
        for (Container container = this.getParent(); container != this.tpb; container = container.getParent()) {
            point2 = container.getLocation();
            point.translate(-point2.x, -point2.y);
        }
    }

    @Override
    public Rectangle mapToComp(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        this.mapToComp(rectangle);
        return rectangle;
    }

    @Override
    public void mapToComp(Rectangle rectangle) {
        Point point = this.mapToComp(rectangle.x, rectangle.y);
        rectangle.setLocation(point.x, point.y);
    }
}

