/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jet.connect.DbColDesc;
import jet.connect.DbColumn;
import jet.connect.DbValue;

public abstract class DbColumnBuffer
extends DbColumn {
    static byte getNullable = (byte)2;
    protected byte[] flags;
    int isNull;

    public DbColumnBuffer(DbColDesc dbColDesc, int n) {
        super(dbColDesc);
        this.isNull = n;
        this.flags = new byte[n];
    }

    protected abstract void writeValueToFile(DataOutput var1) throws IOException;

    protected abstract void readValueFromFile(DataInput var1) throws IOException;

    @Override
    public final void updateValue(int n, DbValue dbValue) {
        if (!dbValue.isNull()) {
            int n2 = n;
            this.flags[n2] = (byte)(this.flags[n2] | Z);
            this.updateCell(n, dbValue);
        } else {
            int n3 = n;
            this.flags[n3] = (byte)(this.flags[n3] & ~Z);
        }
        int n4 = n;
        this.flags[n4] = (byte)(this.flags[n4] | getNullable);
    }

    @Override
    public final void refreshValue(int n, DbValue dbValue) {
        if (this.C.getNullable() != 0 && this.isNull(n)) {
            dbValue.setNull();
        } else {
            this.refreshFromCell(n, dbValue);
        }
    }

    @Override
    public final boolean isNull(int n) {
        return (this.flags[n] & Z) != Z;
    }

    public final boolean isReady(int n) {
        return (this.flags[n] & getNullable) == getNullable;
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.flags.length; ++i) {
            this.flags[i] = 0;
        }
    }

    @Override
    public final void writeToFile(DataOutput dataOutput) throws IOException {
        dataOutput.write(this.flags);
        this.writeValueToFile(dataOutput);
    }

    @Override
    public final void readFromFile(DataInput dataInput) throws IOException {
        dataInput.readFully(this.flags);
        this.readValueFromFile(dataInput);
    }

    @Override
    public void clearMem() {
        super.clearMem();
        this.flags = null;
    }
}

