/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import com.jinfonet.dataservice.util.Bits;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import jet.connect.DbColDesc;
import jet.connect.DbNumber;
import jet.datasource.JRHierarchicalDataset;

public class DbDecimal
extends DbNumber {
    public BigDecimal value;

    public DbDecimal() {
    }

    public DbDecimal(DbColDesc dbColDesc) {
        super(dbColDesc);
    }

    public BigDecimal get() {
        return this.value;
    }

    public void set(BigDecimal bigDecimal) {
        if (bigDecimal != null) {
            this.value = this.desc != null ? bigDecimal.setScale(this.desc.getScale(), 4) : bigDecimal;
            this.bNull = false;
        } else {
            this.value = bigDecimal;
            this.bNull = true;
        }
    }

    @Override
    public void set(ResultSet resultSet, int n) throws SQLException {
        BigDecimal bigDecimal = resultSet.getBigDecimal(n);
        this.bNull = resultSet.wasNull();
        if (!this.bNull) {
            this.set(bigDecimal);
        }
    }

    @Override
    public void set(JRHierarchicalDataset jRHierarchicalDataset, int n) throws SQLException {
        BigDecimal bigDecimal = jRHierarchicalDataset.getBigDecimal(n);
        boolean bl = this.bNull = jRHierarchicalDataset.wasNull() || bigDecimal == null;
        if (!this.bNull) {
            this.set(bigDecimal);
        }
    }

    @Override
    public String toString() {
        if (this.bNull || this.value == null) {
            return "NULL";
        }
        return this.get().toString();
    }

    @Override
    public Object clone() {
        DbDecimal dbDecimal = new DbDecimal(this.desc);
        dbDecimal.bNull = this.bNull;
        dbDecimal.value = this.value;
        return dbDecimal;
    }

    @Override
    public boolean equals(DbNumber dbNumber) {
        if (this == dbNumber) {
            return true;
        }
        if (dbNumber == null) {
            return false;
        }
        if (dbNumber.bNull != this.bNull) {
            return false;
        }
        if (this.bNull) {
            return true;
        }
        if (dbNumber instanceof DbDecimal) {
            if (this.value != null) {
                return this.value.equals(((DbDecimal)dbNumber).value);
            }
        } else if (this.value != null) {
            return this.value.equals(new BigDecimal(dbNumber.doubleValue()));
        }
        return false;
    }

    @Override
    protected int compareToWithSameSQLType(DbNumber dbNumber) {
        DbDecimal dbDecimal = (DbDecimal)dbNumber;
        if (dbDecimal.bNull) {
            if (this.bNull) {
                return 0;
            }
            return 1;
        }
        if (this.bNull) {
            if (dbDecimal.bNull) {
                return 0;
            }
            return -1;
        }
        return this.value.compareTo(dbDecimal.value);
    }

    @Override
    public byte byteValue() {
        if (this.value != null) {
            return this.value.byteValue();
        }
        return 0;
    }

    @Override
    public short shortValue() {
        if (this.value != null) {
            return this.value.shortValue();
        }
        return 0;
    }

    @Override
    public int intValue() {
        if (this.value != null) {
            return this.value.intValue();
        }
        return 0;
    }

    @Override
    public long longValue() {
        if (this.value != null) {
            return this.value.longValue();
        }
        return 0L;
    }

    @Override
    public float floatValue() {
        if (this.value != null) {
            return this.value.floatValue();
        }
        return 0.0f;
    }

    @Override
    public double doubleValue() {
        if (this.value != null) {
            return this.value.doubleValue();
        }
        return 0.0;
    }

    @Override
    public void setValue(DbNumber dbNumber) {
        boolean bl = this.bNull = dbNumber == null || dbNumber.bNull;
        if (dbNumber instanceof DbDecimal) {
            this.value = ((DbDecimal)dbNumber).value;
        } else if (!this.bNull) {
            this.value = new BigDecimal(dbNumber.doubleValue());
        }
    }

    @Override
    public void setValue(String string) {
        this.value = new BigDecimal(string);
        this.bNull = false;
    }

    @Override
    public String toStringValue() {
        byte[] byArray = null;
        if (this.isNull()) {
            byArray = new byte[1];
        } else {
            BigInteger bigInteger = this.value.unscaledValue();
            byte[] byArray2 = bigInteger.toByteArray();
            int n = byArray2.length;
            byArray = new byte[n + 4];
            int n2 = this.value.scale();
            Bits.putInt(byArray, 0, n2);
            System.arraycopy(byArray2, 0, byArray, 4, n);
        }
        return Base64.encode(byArray);
    }
}

