/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import com.sun.org.apache.xml.internal.security.utils.Base64;
import java.sql.ResultSet;
import java.sql.SQLException;
import jet.connect.DbColDesc;
import jet.connect.DbNumber;
import jet.datasource.JRHierarchicalDataset;

public class DbInteger
extends DbNumber {
    public int value;

    public DbInteger() {
    }

    public DbInteger(int n) {
        this.value = n;
        this.bNull = false;
    }

    public DbInteger(DbColDesc dbColDesc) {
        super(dbColDesc);
    }

    public int get() {
        return this.value;
    }

    public void set(int n) {
        this.value = n;
        this.bNull = false;
    }

    @Override
    public void set(ResultSet resultSet, int n) throws SQLException {
        this.value = resultSet.getInt(n);
        this.bNull = resultSet.wasNull();
    }

    @Override
    public void set(JRHierarchicalDataset jRHierarchicalDataset, int n) throws SQLException {
        this.value = jRHierarchicalDataset.getInt(n);
        this.bNull = jRHierarchicalDataset.wasNull();
    }

    @Override
    public String toString() {
        if (this.bNull) {
            return "NULL";
        }
        return String.valueOf(this.value);
    }

    @Override
    public Object clone() {
        DbInteger dbInteger = new DbInteger(this.desc);
        dbInteger.bNull = this.bNull;
        dbInteger.value = this.value;
        return dbInteger;
    }

    @Override
    public boolean equals(DbNumber dbNumber) {
        if (this == dbNumber) {
            return true;
        }
        if (dbNumber == null) {
            return false;
        }
        if (dbNumber.bNull != this.bNull) {
            return false;
        }
        if (this.bNull) {
            return true;
        }
        return this.value == dbNumber.intValue();
    }

    @Override
    protected int compareToWithSameSQLType(DbNumber dbNumber) {
        DbInteger dbInteger = (DbInteger)dbNumber;
        if (dbInteger.bNull) {
            if (this.bNull) {
                return 0;
            }
            return 1;
        }
        if (this.bNull) {
            if (dbInteger.bNull) {
                return 0;
            }
            return -1;
        }
        if (this.value == dbInteger.value) {
            return 0;
        }
        if (this.value < dbInteger.value) {
            return -1;
        }
        return 1;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public void setValue(DbNumber dbNumber) {
        boolean bl = this.bNull = dbNumber == null || dbNumber.bNull;
        if (dbNumber instanceof DbInteger) {
            this.value = ((DbInteger)dbNumber).value;
        } else if (!this.bNull) {
            this.value = dbNumber.intValue();
        }
    }

    @Override
    public void setValue(String string) {
        this.value = Integer.parseInt(string);
        this.bNull = false;
    }

    @Override
    public String toStringValue() {
        byte[] byArray = null;
        if (this.isNull()) {
            byArray = new byte[1];
        } else {
            byArray = new byte[5];
            byArray[0] = 1;
            int n = 1;
            byArray[n++] = (byte)this.value;
            byArray[n++] = (byte)(this.value >> 8);
            byArray[n++] = (byte)(this.value >> 16);
            byArray[n++] = (byte)(this.value >> 24);
        }
        return Base64.encode(byArray);
    }
}

