/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import com.jinfonet.util.JRLog;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import jet.JRStopEngineException;
import jet.connect.DbBinary;
import jet.connect.DbColDesc;
import jet.connect.DbValue;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.datastream.DSContainer;
import jet.datastream.DSDataStreamable;
import jet.util.BitmapReader;
import jet.util.VersionControlable;
import jet.util.image.ImageResource;

public class DSMap
extends DSContainer {
    String SEDU = "";
    String UTFLength = "";
    float addImage = 1.0f;
    float booleanValue = 1.0f;
    private DbBinary clone = null;
    private boolean close = false;
    private byte colName;
    private int createImage;
    private boolean desc = false;
    private byte[] drawImage = null;
    private int dup = 0;

    public String getName() {
        return this.SEDU;
    }

    public void setName(String string) {
        this.SEDU = string;
    }

    public float getWZoom() {
        return this.addImage;
    }

    public void setWZoom(float f) {
        this.addImage = f;
    }

    public float getHZoom() {
        return this.booleanValue;
    }

    public void setHZoom(float f) {
        this.booleanValue = f;
    }

    public String getValue() {
        return this.UTFLength;
    }

    public void setValue(String string) {
        this.UTFLength = string;
    }

    @Override
    protected void readProperties(DataInput dataInput, DSDataStreamable dSDataStreamable) throws IOException, JRStopEngineException {
        super.readProperties(dataInput, dSDataStreamable);
        int n = ((VersionControlable)((Object)dataInput)).getVersion();
        this.SEDU = dataInput.readUTF();
        this.UTFLength = dataInput.readUTF();
        if (n >= 262145 || n == 0) {
            this.close = dataInput.readBoolean();
            if (this.close) {
                this.clone = DSMap.UTFLength(dataInput);
            }
        }
        if (n >= 262176 || n == 0) {
            this.colName = dataInput.readByte();
        }
        if (n >= 262416 || n == 0) {
            this.createImage = dataInput.readInt();
            this.desc = dataInput.readBoolean();
            if (this.desc) {
                boolean bl = dataInput.readBoolean();
                if (!bl) {
                    int n2 = dataInput.readInt();
                    byte[] byArray = new byte[n2];
                    dataInput.readFully(byArray, 0, n2);
                    this.setDefaultImageData(byArray);
                } else {
                    this.drawImage = null;
                }
            }
        }
        if (n >= 263168 || n == 0) {
            this.dup = dataInput.readInt();
        }
    }

    @Override
    protected void writeProperties(DataOutput dataOutput) throws IOException {
        super.writeProperties(dataOutput);
        dataOutput.writeUTF(this.SEDU);
        dataOutput.writeUTF(this.UTFLength);
        dataOutput.writeBoolean(this.close);
        if (this.close) {
            DSMap.SEDU(dataOutput, this.clone);
        }
        dataOutput.writeByte(this.colName);
        dataOutput.writeInt(this.createImage);
        dataOutput.writeBoolean(this.desc);
        if (this.desc) {
            boolean bl = false;
            if (this.drawImage != null) {
                dataOutput.writeBoolean(bl);
                int n = this.drawImage.length;
                dataOutput.writeInt(n);
                dataOutput.write(this.drawImage, 0, n);
            } else {
                bl = true;
                dataOutput.writeBoolean(bl);
            }
        }
        dataOutput.writeInt(this.dup);
    }

    @Override
    protected int propLength() {
        int n = super.propLength();
        n += DSMap.UTFLength(this.SEDU) + 2 + (DSMap.UTFLength(this.UTFLength) + 2);
        ++n;
        if (this.close) {
            n += DSMap.addImage(this.clone);
        }
        ++n;
        n += 4;
        ++n;
        if (this.desc) {
            ++n;
            if (this.drawImage != null) {
                n += 4 + 1 * this.getDefaultImageData().length;
            }
        }
        return n += 4;
    }

    @Override
    public Object copyObject() {
        return this.dup(new DSMap());
    }

    public DSMap dup(DSMap dSMap) {
        super.dup(dSMap);
        dSMap.SEDU = this.SEDU;
        dSMap.addImage = this.addImage;
        dSMap.booleanValue = this.booleanValue;
        dSMap.UTFLength = this.UTFLength;
        dSMap.createImage = this.createImage;
        dSMap.desc = this.desc;
        if (this.drawImage != null) {
            dSMap.setDefaultImageData((byte[])this.drawImage.clone());
        } else {
            dSMap.drawImage = null;
        }
        dSMap.dup = this.dup;
        return dSMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void paint(Graphics graphics) {
        Object object;
        boolean bl = (Boolean)this.getPropertyByName("FromDatabase").getObject();
        Image image = null;
        if (bl) {
            object = null;
            object = (String)this.getPropertyByName("ColumnName").getObject();
            JRecord jRecord = this.getRecord();
            DbBinary dbBinary = (DbBinary)jRecord.getCell((String)object);
            if (!dbBinary.isNull()) {
                MediaTracker mediaTracker;
                block20: {
                    byte[] byArray = dbBinary.get();
                    int n = -1;
                    if (byArray != null && byArray.length > 0) {
                        if (byArray[0] == 66 && byArray[1] == 77) {
                            n = 1;
                        } else if (byArray[0] == 71 && byArray[1] == 73 && byArray[2] == 70) {
                            n = 4;
                        } else if (byArray[0] == -1 && byArray[1] == -40 && byArray[2] == -1 && byArray[3] == -32) {
                            n = 0;
                        }
                    }
                    mediaTracker = new MediaTracker(new Container());
                    if (n == 4 || n == 0) {
                        image = Toolkit.getDefaultToolkit().createImage(byArray);
                    } else if (n == 1) {
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                        BitmapReader bitmapReader = BitmapReader.loadFromBMP(dataInputStream);
                        if (bitmapReader != null) {
                            image = Toolkit.getDefaultToolkit().createImage(bitmapReader.getMemImgSrc());
                        }
                        try {
                            byteArrayInputStream.close();
                            dataInputStream.close();
                        }
                        catch (IOException iOException) {
                            if (!JRLog.isError(2)) break block20;
                            JRLog.error(2, iOException);
                        }
                    }
                }
                if (image != null) {
                    mediaTracker.addImage(image, 0);
                    try {
                        mediaTracker.waitForID(0);
                    }
                    catch (InterruptedException interruptedException) {
                        if (JRLog.isError(2)) {
                            JRLog.error(2, interruptedException);
                        }
                    }
                }
            }
        } else {
            object = this.getImgInfo();
            ImageResource imageResource = this.getImgResourceByPropertyName("ImageSource");
            image = imageResource.getImage();
        }
        if (image != null) {
            object = this.getBounds();
            graphics.drawImage(image, 0, 0, ((Rectangle)object).width, ((Rectangle)object).height, null);
        }
        super.paint(graphics);
    }

    public void setHasDataset() {
        this.close = true;
    }

    public void setImageValue(DbBinary dbBinary) {
        if (dbBinary != null) {
            this.clone = dbBinary;
        }
    }

    public DbBinary getImageValue() {
        if (this.close) {
            return this.clone;
        }
        String string = null;
        string = (String)this.getPropertyByName("ColumnName").getObject();
        JRecord jRecord = this.getRecord();
        DbBinary dbBinary = (DbBinary)jRecord.getCell(string);
        return dbBinary;
    }

    static void SEDU(DataOutput dataOutput, DbBinary dbBinary) throws IOException {
        boolean bl = false;
        byte[] byArray = null;
        int n = -2;
        if (dbBinary == null) {
            bl = true;
        } else {
            bl = dbBinary.isNull();
            n = dbBinary.getSqlType();
        }
        dataOutput.writeBoolean(bl);
        dataOutput.writeInt(n);
        if (!bl) {
            String string = dbBinary.desc.colName;
            boolean bl2 = string != null;
            dataOutput.writeBoolean(bl2);
            if (bl2) {
                dataOutput.writeUTF(string);
            }
            byArray = dbBinary.get();
            int n2 = byArray.length;
            dataOutput.writeInt(n2);
            dataOutput.write(byArray, 0, n2);
        }
    }

    static DbBinary UTFLength(DataInput dataInput) throws IOException {
        int n;
        int n2 = ((VersionControlable)((Object)dataInput)).getVersion();
        DbValue dbValue = null;
        boolean bl = dataInput.readBoolean();
        DbColDesc dbColDesc = null;
        if (n2 >= 131084 || n2 == 0 || !bl) {
            n = dataInput.readInt();
            if (!(bl || n2 < 262145 && n2 != 0)) {
                boolean bl2 = dataInput.readBoolean();
                if (bl2) {
                    String string = dataInput.readUTF();
                    dbColDesc = new DbColDesc(string, n, 0, 0, 2);
                } else {
                    dbColDesc = new DbColDesc(null, n, 0, 0, 2);
                }
            } else {
                dbColDesc = new DbColDesc(null, n, 0, 0, 2);
            }
            dbValue = (DbBinary)DbValue.makeDbValue(dbColDesc);
        }
        if (!bl) {
            n = dataInput.readInt();
            byte[] byArray = new byte[n];
            dataInput.readFully(byArray, 0, n);
            if (dbValue != null) {
                ((DbBinary)dbValue).set(byArray);
            }
        } else if (dbValue != null) {
            dbValue.setNull();
        }
        return dbValue;
    }

    static int addImage(DbBinary dbBinary) {
        int n = 0;
        boolean bl = false;
        bl = dbBinary == null ? true : dbBinary.isNull();
        ++n;
        n += 4;
        if (!bl) {
            String string = dbBinary.desc.colName;
            boolean bl2 = string != null;
            ++n;
            if (bl2) {
                n += 2 + DSMap.UTFLength(string);
            }
            n += 4 + dbBinary.get().length * 1;
        }
        return n;
    }

    public int getImageType() {
        return this.colName;
    }

    public void setImageType(int n) {
        this.colName = (byte)n;
    }

    public int getGroupTreeIDX() {
        return this.createImage;
    }

    public void setGroupTreeIDX(int n) {
        this.createImage = n;
    }

    public Image getDefaultImage() {
        if (this.isDefaultImage()) {
            MediaTracker mediaTracker = new MediaTracker(new Container());
            Image image = Toolkit.getDefaultToolkit().createImage(this.drawImage);
            if (image != null) {
                mediaTracker.addImage(image, 0);
                try {
                    mediaTracker.waitForID(0);
                    mediaTracker.removeImage(image, 0);
                }
                catch (InterruptedException interruptedException) {
                    if (JRLog.isError(2)) {
                        JRLog.error(2, interruptedException);
                    }
                    mediaTracker.removeImage(image);
                    image = null;
                }
            }
            return image;
        }
        return null;
    }

    public boolean isDefaultImage() {
        return this.desc;
    }

    public void setDefaultImage(boolean bl) {
        this.desc = bl;
    }

    public byte[] getDefaultImageData() {
        return this.drawImage;
    }

    public void setDefaultImageData(byte[] byArray) {
        this.drawImage = byArray;
    }

    @Override
    public int getRoundingMode() {
        return this.dup;
    }

    @Override
    public void setRoundingMode(int n) {
        this.dup = n;
    }
}

