/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.v7x;

import com.jinfonet.resstore.OutOfSpaceException;
import com.jinfonet.util.JRLog;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import jet.JRStopEngineException;
import jet.bean.ExcelParameter;
import jet.datastream.Communicator;
import jet.datastream.ReportHeaderInfo;
import jet.export.AbstractExporter;
import jet.export.ExpException;
import jet.export.ExportAuxInfo;
import jet.export.excel.api.DocumentException;
import jet.export.excel.api.ExcelFactory;
import jet.export.excel.api.ExcelWorkBook;
import jet.export.excel.api.PerformanceConfig;
import jet.export.excel.v7x.ColumnFormatCache;
import jet.export.excel.v7x.ColumnedXls;
import jet.export.excel.v7x.ExportToXls;
import jet.export.excel.v7x.ExportToXls1;

public class NormalXls
extends AbstractExporter {
    private boolean SEDU;
    private boolean add = true;
    private boolean append = true;
    private String checkOutputStream;
    private ExcelParameter clear;
    private ExportAuxInfo close;

    public NormalXls(Communicator[] communicatorArray, ExcelParameter excelParameter) {
        this._commuList = communicatorArray;
        this.clear = excelParameter;
        this.SEDU = JRLog.isError(2);
    }

    @Override
    public List exportToFile(String string) throws ExpException, JRStopEngineException {
        ArrayList<String> arrayList = new ArrayList<String>();
        OutputStream outputStream = this.SEDU(string);
        try {
            this.close.getDiskStore().createFile(this.checkOutputStream);
            this.exportToStream(outputStream);
            this.append = false;
            this.close.getDiskStore().fileUpdated(new File(this.checkOutputStream));
        }
        catch (OutOfSpaceException outOfSpaceException) {
            throw new ExpException(outOfSpaceException);
        }
        catch (IOException iOException) {
            throw new ExpException(iOException);
        }
        finally {
            File file;
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    this.treatIOException(iOException, this.checkOutputStream, true);
                }
                outputStream = null;
            }
            if (this.append && (file = new File(this.checkOutputStream)).exists()) {
                file.delete();
            }
        }
        arrayList.add(this.checkOutputStream);
        return arrayList;
    }

    private OutputStream SEDU(String string) throws ExpException {
        this.checkOutputStream = this.add ? (this.clear.isXlsFormat() ? (string.endsWith(".xls") ? string : string + ".xls") : (string.endsWith(".xlsx") ? string : string + ".xlsx")) : (string.endsWith(".zip") ? string : string + ".zip");
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.checkOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.treatIOException(fileNotFoundException, this.checkOutputStream, true);
        }
        if (this.add) {
            return fileOutputStream;
        }
        String string2 = this.checkOutputStream.substring(0, this.checkOutputStream.lastIndexOf(".zip"));
        string2 = this.clear.isXlsFormat() ? (string2.endsWith(".xls") ? string2 : string2 + ".xls") : (string2.endsWith(".xlsx") ? string2 : string2 + ".xlsx");
        ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
        ZipEntry zipEntry = new ZipEntry(string2);
        try {
            zipOutputStream.putNextEntry(zipEntry);
        }
        catch (IOException iOException) {
            this.treatIOException(iOException, this.checkOutputStream, true);
        }
        return zipOutputStream;
    }

    @Override
    public void exportToStream(OutputStream outputStream) throws ExpException, JRStopEngineException {
        this.checkOutputStream(outputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        this._commu = this._commuList[0];
        this.waitCommunicator();
        Runtime runtime = Runtime.getRuntime();
        this.showingWaitMessage(true, "Before export to Column format excel");
        long l = 0L;
        boolean bl = JRLog.isTrace(5);
        if (bl) {
            long l2 = runtime.maxMemory();
            long l3 = runtime.totalMemory();
            long l4 = runtime.freeMemory();
            JRLog.trace(5, "Before export to Columned excel memory info: total(" + l3 + ")max(" + l2 + ")free(" + l4 + ")");
            l = System.currentTimeMillis();
            JRLog.indent("Export to JReport v7 Columned excel");
            JRLog.trace(5, 4402301, new Timestamp(l));
        }
        if (this.SEDU) {
            JRLog.indent("To JReport v7 excel Error information");
        }
        ColumnFormatCache columnFormatCache = new ColumnFormatCache(this.clear.isExportShape(), this.close, this.clear.isXlsFormat());
        columnFormatCache.setPJFVersion(this._commu.getHeaderInfo(0).getPJFVersion());
        try {
            ExcelFactory excelFactory;
            Object object;
            if (this.clear.isXlsFormat()) {
                object = this._commu.getHeaderInfo(0);
                int n = ((ReportHeaderInfo)object).getExcelBufSize();
                excelFactory = ExcelFactory.createXlsFactory(columnFormatCache, n);
            } else {
                object = new PerformanceConfig();
                excelFactory = ExcelFactory.createXlsxFactory(columnFormatCache, (PerformanceConfig)object);
            }
            columnFormatCache.setExcelFactory(excelFactory);
            ExcelWorkBook excelWorkBook = excelFactory.getWorkBook();
            for (int i = 0; i < this._commuList.length; ++i) {
                this._commu = this._commuList[i];
                if (this._commu == null) {
                    this.logCommunicatorNullInfo(i);
                    continue;
                }
                this.waitCommunicator();
                ExportToXls1 exportToXls1 = this._commu.getHeaderInfo(0).isPreDefinedCol() ? new ColumnedXls(this._commu, this.clear) : new ExportToXls(this._commu, this.clear);
                exportToXls1.setFactory(excelFactory);
                exportToXls1.setWorkBook(excelWorkBook);
                exportToXls1.setExcelCache(columnFormatCache);
                exportToXls1.publish();
            }
            excelWorkBook.output(bufferedOutputStream);
            bufferedOutputStream.flush();
        }
        catch (IOException iOException) {
            this.treatIOException(iOException, null, false);
        }
        catch (DocumentException documentException) {
            throw new ExpException(documentException);
        }
        catch (OutOfSpaceException outOfSpaceException) {
            throw new ExpException(outOfSpaceException);
        }
        finally {
            columnFormatCache.clear();
        }
        if (this.SEDU) {
            JRLog.deIndent("To JReport v7 excel Error information");
        }
        if (bl) {
            long l5 = System.currentTimeMillis();
            JRLog.trace(5, 4402302, new Timestamp(l5));
            JRLog.deIndent("Export to JReport v7 Columned excel");
        }
        if (JRLog.isAd()) {
            JRLog.print("Successed produce the JReport v7 column format excel");
        }
        this.showingWaitMessage(false, "After export to columned excel");
    }

    @Override
    public void setAuxiliaryInfo(ExportAuxInfo exportAuxInfo) {
        this.close = exportAuxInfo;
    }
}

