/*
 * Decompiled with CFR 0.152.
 */
package jet.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import jet.util.ValueToUnit;
import jet.util.nls.NLSBundle;
import jet.util.nls.NLSFontValue;
import jet.util.nls.NLSFontValueImpl;
import jet.util.nls.NLSValue;
import jet.util.nls.NLSValueImpl;

public class NLSResourceBundle
implements NLSBundle {
    protected static final String LCNLS_FOLDER = "LCNLS";
    protected static final String DEFNLS_FOLDER = "";
    public static String PROPS_FILE_EXTENSION = ".properties";
    public static String FILENAME_CONCAT_CHAR = "_";
    public static String KEY_ENCODING = "encoding";
    protected Properties propResources = new Properties();
    protected String strEncoding = null;
    protected static final String KEY_COPYRIGHT = "copyright";
    protected boolean isNewVersion = false;
    private Locale add = null;
    private NLSResourceBundle append = null;
    private static String charAt = null;
    private static String clear = "#JReport Resources of ";
    private static String clearReplaceMapping = "# ---------------------------------------------------------- #";
    private static String containsKey = "# Note: You must provide correct encoding after 'encoding='. #";
    private static String convertKey = "# ---------------------------------------------------------- #";
    private static String convertPointToUnit = "=";

    protected NLSResourceBundle(Locale locale) {
        this.add = locale;
        this.isNewVersion = true;
    }

    @Override
    public NLSFontValue getFont(String string, double d) {
        int n;
        int n2 = (int)ValueToUnit.convertPointToUnit(Math.round(d));
        String string2 = string + "," + n2;
        String string3 = this.get("FONT_TXT", string2);
        int n3 = n = string3 == null ? -1 : string3.lastIndexOf(",");
        if (n > 0) {
            try {
                String string4 = string3.substring(0, n);
                int n4 = Integer.parseInt(string3.substring(n + 1));
                return new NLSFontValueImpl(string4, ValueToUnit.convertUnitToInch(n4) * 72.0, this.add);
            }
            catch (NumberFormatException numberFormatException) {
                if (this.append != null) {
                    return this.append.getFont(string, d);
                }
                return new NLSFontValueImpl(null, -1.0, this.add);
            }
        }
        if (this.append != null) {
            return this.append.getFont(string, d);
        }
        return new NLSFontValueImpl(null, -1.0, this.add);
    }

    @Override
    public NLSValue getFormat(String string) {
        String string2 = this.get("FMT_TXT", string);
        if (string2 == null && this.append != null) {
            return this.append.getFormat(string);
        }
        return new NLSValueImpl(string2, this.add);
    }

    @Override
    public final Locale getLocale() {
        return this.add;
    }

    @Override
    public NLSValue getText(int n, String string) {
        String string2 = null;
        if (string == null || string.length() == 0) {
            string2 = null;
        } else {
            switch (n) {
                case 1: {
                    string2 = this.get("COL_TXT", string);
                    break;
                }
                case 0: {
                    string2 = this.get("LBL_TXT", string);
                    break;
                }
                case 5: {
                    string2 = this.get("PARAM_PROMPTTXT", string.toUpperCase());
                    break;
                }
                case 6: {
                    string2 = this.get("TOC_TXT", string);
                    break;
                }
                case 7: {
                    string2 = this.get("OBJ_TITLE", string);
                    break;
                }
                case 8: {
                    string2 = this.get("OBJ_DESCRIP", string);
                    break;
                }
                case 10: {
                    string2 = this.get("OBJ_DISP", string);
                    break;
                }
                case 9: {
                    string2 = this.get("UNV_METADATA", string);
                }
            }
            if (string2 == null && this.append != null) {
                return this.append.getText(n, string);
            }
        }
        return new NLSValueImpl(string2, this.add);
    }

    @Override
    public boolean isEmpty() {
        boolean bl;
        int n = this.propResources.size();
        if (this.propResources.containsKey(KEY_ENCODING)) {
            --n;
        }
        if (this.propResources.containsKey(KEY_COPYRIGHT)) {
            --n;
        }
        boolean bl2 = bl = n == 0;
        if (!bl) {
            bl = true;
            for (String string : this.propResources.keySet()) {
                if (!string.startsWith("COL_TXT") && !string.startsWith("FONT_TXT") && !string.startsWith("FMT_TXT") && !string.startsWith("LBL_TXT") && !string.startsWith("PARAM_PROMPTTXT") && !string.startsWith("TOC_TXT") && !string.startsWith("OBJ_TITLE") && !string.startsWith("OBJ_DESCRIP") && !string.startsWith("OBJ_DISP") && !string.startsWith("UNV_METADATA")) continue;
                bl = false;
                break;
            }
        }
        if (bl && this.append != null) {
            bl = this.append.isEmpty();
        }
        return bl;
    }

    @Override
    public void setFont(String string, double d, String string2, double d2) {
        d = Math.round(d);
        d2 = Math.round(d2);
        int n = (int)ValueToUnit.convertPointToUnit(d);
        int n2 = (int)ValueToUnit.convertPointToUnit(d2);
        String string3 = string + "," + n;
        String string4 = string2 + "," + n2;
        this.put("FONT_TXT", string3, string4, true);
    }

    @Override
    public void setFormat(String string, String string2) {
        if (string == null || string2.length() == 0) {
            return;
        }
        this.put("FMT_TXT", string, string2, true);
    }

    @Override
    public void setText(int n, String string, String string2) {
        if (string == null || string.length() == 0) {
            return;
        }
        switch (n) {
            case 1: {
                this.put("COL_TXT", string, string2, true);
                break;
            }
            case 0: {
                this.put("LBL_TXT", string, string2, true);
                break;
            }
            case 5: {
                this.put("PARAM_PROMPTTXT", string.toUpperCase(), string2, true);
                break;
            }
            case 6: {
                this.put("TOC_TXT", string, string2, true);
                break;
            }
            case 7: {
                this.put("OBJ_TITLE", string, string2, true);
                break;
            }
            case 8: {
                this.put("OBJ_DESCRIP", string, string2, true);
                break;
            }
            case 10: {
                this.put("OBJ_DISP", string, string2, true);
                break;
            }
            case 9: {
                this.put("UNV_METADATA", string, string2, true);
            }
        }
    }

    public void setEncoding(String string) {
        this.strEncoding = string;
    }

    public String getEncoding() {
        return this.strEncoding;
    }

    @Override
    public NLSBundle duplicate() {
        NLSResourceBundle nLSResourceBundle = new NLSResourceBundle(this.add);
        nLSResourceBundle.propResources.putAll((Map<?, ?>)this.propResources);
        nLSResourceBundle.isNewVersion = this.isNewVersion;
        nLSResourceBundle.strEncoding = this.strEncoding;
        nLSResourceBundle.append = this.append;
        return nLSResourceBundle;
    }

    public final void mergeWith(NLSResourceBundle nLSResourceBundle, boolean bl) {
        Iterator<Map.Entry<Object, Object>> iterator = nLSResourceBundle.propResources.entrySet().iterator();
        boolean bl2 = false;
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            if (bl) {
                this.propResources.put(entry.getKey(), entry.getValue());
                bl2 = true;
                continue;
            }
            if (this.propResources.containsKey(entry.getKey())) continue;
            this.propResources.put(entry.getKey(), entry.getValue());
            bl2 = true;
        }
        if (bl2) {
            this.fireContentUpdated();
        }
    }

    @Override
    public Map<String, String> getReplaceMapping(int n) {
        switch (n) {
            case 0: {
                return this.getReplaceMapping("LBL_TXT");
            }
            case 6: {
                return this.getReplaceMapping("TOC_TXT");
            }
            case 5: {
                return this.getReplaceMapping("PARAM_PROMPTTXT");
            }
            case 1: {
                return this.getReplaceMapping("COL_TXT");
            }
            case 2: {
                return this.getReplaceMapping("FMT_TXT");
            }
            case 4: {
                return this.getReplaceMapping("FONT_TXT");
            }
            case 8: {
                return this.getReplaceMapping("OBJ_DESCRIP");
            }
            case 10: {
                return this.getReplaceMapping("OBJ_DISP");
            }
            case 7: {
                return this.getReplaceMapping("OBJ_TITLE");
            }
            case 9: {
                return this.getReplaceMapping("UNV_METADATA");
            }
        }
        return new Hashtable<String, String>();
    }

    protected final Map<String, String> getReplaceMapping(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (Map.Entry<Object, Object> entry : this.propResources.entrySet()) {
            String string2 = (String)entry.getKey();
            if (!string2.startsWith(string)) continue;
            String string3 = this.decodeKey(string2.substring(string.length() + 1));
            hashtable.put(string3, this.decodeValue((String)entry.getValue()));
        }
        return hashtable;
    }

    @Override
    public final void setReplaceMapping(int n, Map<String, String> map) {
        this.setReplaceMapping(n, map, true);
    }

    @Override
    public void setReplaceMapping(int n, Map<String, String> map, boolean bl) {
        switch (n) {
            case 0: {
                this.setReplaceMapping("LBL_TXT", map, bl);
                break;
            }
            case 6: {
                this.setReplaceMapping("TOC_TXT", map, bl);
                break;
            }
            case 5: {
                this.setReplaceMapping("PARAM_PROMPTTXT", map, bl);
                break;
            }
            case 1: {
                this.setReplaceMapping("COL_TXT", map, bl);
                break;
            }
            case 2: {
                this.setReplaceMapping("FMT_TXT", map, bl);
                break;
            }
            case 4: {
                this.setReplaceMapping("FONT_TXT", map, bl);
                break;
            }
            case 8: {
                this.setReplaceMapping("OBJ_DESCRIP", map, bl);
                break;
            }
            case 10: {
                this.setReplaceMapping("OBJ_DISP", map, bl);
                break;
            }
            case 7: {
                this.setReplaceMapping("OBJ_TITLE", map, bl);
                break;
            }
            case 9: {
                this.setReplaceMapping("UNV_METADATA", map, bl);
                break;
            }
        }
    }

    @Override
    public void clearReplaceMapping(int n) {
        switch (n) {
            case 0: {
                this.clearReplaceMapping("LBL_TXT");
                break;
            }
            case 6: {
                this.clearReplaceMapping("TOC_TXT");
                break;
            }
            case 5: {
                this.clearReplaceMapping("PARAM_PROMPTTXT");
                break;
            }
            case 1: {
                this.clearReplaceMapping("COL_TXT");
                break;
            }
            case 2: {
                this.clearReplaceMapping("FMT_TXT");
                break;
            }
            case 4: {
                this.clearReplaceMapping("FONT_TXT");
                break;
            }
            case 8: {
                this.clearReplaceMapping("OBJ_DESCRIP");
                break;
            }
            case 10: {
                this.clearReplaceMapping("OBJ_DISP");
                break;
            }
            case 7: {
                this.clearReplaceMapping("OBJ_TITLE");
                break;
            }
            case 9: {
                this.clearReplaceMapping("UNV_METADATA");
                break;
            }
        }
    }

    protected final void setReplaceMapping(String string, Map<String, String> map, boolean bl) {
        if (bl) {
            this.clearReplaceMapping(string);
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.put(string, entry.getKey(), entry.getValue(), bl);
        }
    }

    protected final void put(String string, String string2, String string3, boolean bl) {
        if (string.equals("PARAM_PROMPTTXT")) {
            string2 = string2.toUpperCase();
        }
        String string4 = string + "_" + this.convertKey(string2);
        if (bl) {
            this.propResources.put(string4, string3);
            this.fireContentUpdated(string, string2, string3);
        } else if (!this.propResources.containsKey(string4)) {
            this.propResources.put(string4, string3);
            this.fireContentUpdated(string, string2, string3);
        }
    }

    protected final void clearReplaceMapping(String string) {
        Vector<Object> vector = new Vector<Object>(this.propResources.keySet());
        Vector<String> vector2 = new Vector<String>(vector.size());
        ListIterator listIterator = vector.listIterator();
        while (listIterator.hasNext()) {
            String string2 = (String)listIterator.next();
            if (!string2.startsWith(string)) continue;
            vector2.add(string2);
        }
        listIterator = vector2.listIterator();
        while (listIterator.hasNext()) {
            this.propResources.remove(listIterator.next());
        }
        if (vector2.size() > 0) {
            this.fireContentUpdated();
        }
    }

    protected final void resetParent(NLSResourceBundle nLSResourceBundle) {
        this.append = nLSResourceBundle;
    }

    protected final void resetLocale(Locale locale) {
        this.add = locale;
    }

    protected final void load(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return;
        }
        Properties properties = new Properties();
        properties.load(inputStream);
        this.propResources.clear();
        this.isNewVersion = false;
        this.strEncoding = "8859_1";
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object object = entry.getKey();
            Object object2 = entry.getValue();
            if (!(object instanceof String) || !(object2 instanceof String)) continue;
            String string = (String)object;
            if (string.startsWith("PARAM_PROMPTTXT")) {
                string = this.decodeKey(string.substring("PARAM_PROMPTTXT".length() + 1));
                string = "PARAM_PROMPTTXT_" + this.convertKey(string.toUpperCase());
                this.propResources.put(string, object2);
                continue;
            }
            this.propResources.put(string, object2);
            if (string.equals(KEY_COPYRIGHT)) {
                this.isNewVersion = "Jinfonet Software".equalsIgnoreCase((String)object2);
                continue;
            }
            if (!string.equals(KEY_ENCODING)) continue;
            this.strEncoding = (String)object2;
        }
        properties.clear();
        properties = null;
        this.fireContentUpdated();
    }

    public void store(OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "8859_1");
        PrintWriter printWriter = new PrintWriter((Writer)outputStreamWriter, true);
        if (this.add != null) {
            printWriter.println(clear + this.add);
        }
        this.propResources.store(outputStream, charAt);
        printWriter.println(clearReplaceMapping);
        printWriter.println(containsKey);
        printWriter.println(convertKey);
        printWriter.println(KEY_ENCODING + convertPointToUnit + System.getProperty("file.encoding"));
        if (this.isNewVersion) {
            printWriter.println(KEY_COPYRIGHT + convertPointToUnit + "Jinfonet Software");
        }
    }

    public static String[] parseFontValueTexts(String string) {
        int n = string.indexOf(",");
        String[] stringArray = new String[]{string.substring(0, n), string.substring(n + ",".length())};
        return stringArray;
    }

    public static String buildFontValueText(String string, String string2) {
        return string + "," + string2;
    }

    protected final String decodeValue(String string) {
        if (this.isNewVersion) {
            return string;
        }
        char c = '\u0100';
        if (string != null) {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                if (string.charAt(i) <= c) continue;
                return string;
            }
            try {
                string = new String(string.getBytes("8859_1"), this.strEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return string;
    }

    protected final String convertKey(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '=') {
                stringBuffer.append('_');
                stringBuffer.append('e');
                continue;
            }
            if (c == ':') {
                stringBuffer.append('_');
                stringBuffer.append('c');
                continue;
            }
            if (c == ' ') {
                stringBuffer.append('_');
                stringBuffer.append('s');
                continue;
            }
            if (c == '_') {
                stringBuffer.append('_');
                stringBuffer.append('_');
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    protected final String decodeKey(String string) {
        int n = string.indexOf(95);
        if (n < 0 || n == string.length() - 1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        do {
            stringBuilder.append(string.substring(0, n));
            char c = string.charAt(n + 1);
            if (c == '_') {
                stringBuilder.append('_');
                string = string.substring(n + 2);
                continue;
            }
            if (c == 's') {
                stringBuilder.append(' ');
                string = string.substring(n + 2);
                continue;
            }
            if (c == 'e') {
                stringBuilder.append('=');
                string = string.substring(n + 2);
                continue;
            }
            if (c == 'c') {
                stringBuilder.append(':');
                string = string.substring(n + 2);
                continue;
            }
            stringBuilder.append(string.charAt(n));
            string = string.substring(n + 1);
        } while ((n = string.indexOf(95)) >= 0);
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public void clear() {
        this.propResources.clear();
        if (this.strEncoding != null) {
            this.propResources.put(KEY_ENCODING, this.strEncoding);
        }
        this.propResources.put(KEY_COPYRIGHT, "Jinfonet Software");
        this.fireContentUpdated();
    }

    final String get(String string, String string2) {
        String string3 = this.propResources.getProperty(string + "_" + this.convertKey(string2));
        return this.decodeValue(string3);
    }

    protected final Properties buildAFullContents() {
        Vector<Properties> vector = new Vector<Properties>();
        vector.add(this.propResources);
        NLSResourceBundle nLSResourceBundle = this.append;
        while (nLSResourceBundle != null) {
            vector.add(nLSResourceBundle.propResources);
            nLSResourceBundle = nLSResourceBundle.append;
        }
        int n = vector.size();
        Properties properties = new Properties();
        for (int i = n - 1; i >= 0; --i) {
            properties.putAll((Map<?, ?>)((Map)vector.get(i)));
        }
        return properties;
    }

    protected void fireContentUpdated() {
    }

    protected void fireContentUpdated(String string, String string2, String string3) {
    }

    @Override
    public String searchKeyByValue(String string) {
        throw new UnsupportedOperationException(this + ": " + string);
    }
}

