/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.GridLine;
import chart.axis.ChartNumericAxis;
import chart.axis.ChartNumericRadarAxis;
import chart.chart2d.Chart2DLayer;
import chart.chart2d.Chart2DPaper;
import chart.data.ChartDataSet;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.List;

public class Chart2DRadarLayer
extends Chart2DLayer {
    private int SEDU;
    private Chart2DPaper append;
    private int cos;
    private float[][] draw;
    private float[][] drawRadarCircleGrid;
    private float[][] get;
    private float[][] getCategorySize;
    private float[][] getChartDataSets;
    private Line2D.Float[] getGraphArea;
    private boolean getGraphProperties;

    Chart2DRadarLayer(Chart2DPaper chart2DPaper) {
        super(chart2DPaper);
        this.append = chart2DPaper;
    }

    @Override
    public void init() {
        super.init();
        List list = this.append.model.getChartDataSets();
        ChartDataSet chartDataSet = (ChartDataSet)list.get(0);
        this.SEDU = chartDataSet.getCategorySize();
        this.getCategorySize = new float[this.SEDU][2];
        this.getChartDataSets = new float[this.SEDU][2];
        this.getGraphArea = new Line2D.Float[this.SEDU];
        this.gridYAreaPath = new GeneralPath();
        for (int i = 0; i < this.SEDU; ++i) {
            this.getGraphArea[i] = new Line2D.Float();
        }
    }

    @Override
    public void paintAxis(Graphics2D graphics2D) {
        if (this.axisY != null && this.axisY.isShow()) {
            float[][] fArray = new float[this.SEDU + 1][2];
            fArray[0][0] = this.tYPos[0][0];
            fArray[0][1] = this.tYPos[0][1];
            this.axisY.setLabelPoint(this.tYTickPos);
            for (int i = 0; i < this.SEDU; ++i) {
                fArray[i + 1][0] = this.tYPos[i + 1][0];
                fArray[i + 1][1] = this.tYPos[i + 1][1];
                this.getGraphArea[i].setLine(fArray[0][0], fArray[0][1], fArray[i + 1][0], fArray[i + 1][1]);
            }
            ((ChartNumericRadarAxis)this.axisY).setAxisPoint(fArray);
            ((ChartNumericRadarAxis)this.axisY).setRadarAxisAreaPath(this.getGraphArea);
            ((ChartNumericRadarAxis)this.axisY).setMajorTickMarkPoint(this.tYTickPos);
            ((ChartNumericRadarAxis)this.axisY).paint(graphics2D);
        }
    }

    @Override
    public void locate() {
        int n;
        super.locate();
        int n2 = 25;
        int n3 = this.append.getProperties().getGraphProperties().getRadarArrowStyle();
        if (n3 == 0) {
            n2 = 5;
        }
        double d = Math.PI * 2 / (double)this.SEDU;
        int n4 = this.append.getGraphArea().height;
        int n5 = this.append.getGraphArea().width;
        this.axisYPos = new float[this.SEDU + 1][2];
        this.tYPos = new float[this.SEDU + 1][2];
        this.axisYPos[0][0] = n5 / 2;
        this.axisYPos[0][1] = n4 / 2;
        int n6 = n4 > n5 ? n5 : n4;
        n6 = this.getRadarAxisLength(n6);
        float f = this.axisY.getUnit(n6);
        double d2 = 1.5707963267948966;
        for (int i = 0; i < this.SEDU; ++i) {
            this.axisYPos[i + 1][0] = (float)(n5 / 2) + (float)n6 * (float)Math.cos(d * (double)i + d2);
            this.axisYPos[i + 1][1] = (float)(n4 / 2) + (float)n6 * (float)Math.sin(d * (double)i + d2);
            this.getCategorySize[i][0] = (float)(n5 / 2) + (float)(n6 + n2) * (float)Math.cos(d * (double)i + d2);
            this.getCategorySize[i][1] = (float)(n4 / 2) + (float)(n6 + n2) * (float)Math.sin(d * (double)i + d2);
        }
        this.setAxisY(f, this.axisYPos[0][0]);
        ChartNumericAxis chartNumericAxis = (ChartNumericAxis)this.axisY;
        this.cos = chartNumericAxis.getNumOfTick();
        this.tYTickPos = new float[this.yTickPos.length][2];
        this.drawRadarCircleGrid = new float[this.SEDU * this.cos][2];
        this.get = new float[this.SEDU * this.cos][2];
        this.draw = new float[this.SEDU * this.cos][2];
        this.gridYPath = new Line2D[this.SEDU * this.cos];
        for (n = 0; n < this.SEDU * this.cos; ++n) {
            this.gridYPath[n] = new Line2D.Float();
        }
        for (n = 0; n < this.cos; ++n) {
            for (int i = 0; i < this.SEDU; ++i) {
                this.drawRadarCircleGrid[n * this.SEDU + i][0] = (float)(n5 / 2) + (float)(n + 1) / (float)this.cos * (float)n6 * (float)Math.cos(d * (double)i + d2);
                this.drawRadarCircleGrid[n * this.SEDU + i][1] = (float)(n4 / 2) + (float)(n + 1) / (float)this.cos * (float)n6 * (float)Math.sin(d * (double)i + d2);
            }
        }
        this.m2.transform(this.axisYPos, this.tYPos);
        this.m2.transform(this.yTickPos, this.tYTickPos);
        this.m2.transform(this.drawRadarCircleGrid, this.get);
        this.m2.transform(this.getCategorySize, this.getChartDataSets);
        ((ChartNumericRadarAxis)this.axisY).setRadarColumnNamePosition(this.getChartDataSets);
    }

    @Override
    public void paintGrid(Graphics2D graphics2D) {
        block7: {
            if (this.axisY == null || !this.axisY.getProperties().isShowGrid()) break block7;
            GridLine gridLine = new GridLine();
            gridLine.setPenStyle(this.axisY.getProperties().getGridPen());
            this.gridYAreaPath.reset();
            this.getGraphProperties = true;
            if (this.getGraphProperties) {
                int n;
                for (n = 0; n < this.SEDU * this.cos; ++n) {
                    if ((n + 1) % this.SEDU == 0) {
                        this.draw[0][0] = this.get[n][0];
                        this.draw[0][1] = this.get[n][1];
                        this.draw[1][0] = this.get[n - this.SEDU + 1][0];
                        this.draw[1][1] = this.get[n - this.SEDU + 1][1];
                    } else {
                        this.draw[0][0] = this.get[n][0];
                        this.draw[0][1] = this.get[n][1];
                        this.draw[1][0] = this.get[n + 1][0];
                        this.draw[1][1] = this.get[n + 1][1];
                    }
                    this.gridYPath[n].setLine(this.draw[0][0], this.draw[0][1], this.draw[1][0], this.draw[1][1]);
                    gridLine.setLocation(this.draw);
                    gridLine.draw(graphics2D);
                }
                for (n = 0; n < this.gridYPath.length; ++n) {
                    this.gridYAreaPath.append(this.gridYPath[n], false);
                }
            } else {
                double d = this.tYPos[0][1] - this.get[0][1];
                double d2 = this.tYPos[0][0];
                double d3 = this.tYPos[0][1];
                for (int i = 0; i < this.cos; ++i) {
                    d = (this.tYPos[0][1] - this.get[0][1]) * (float)(i + 1);
                    Arc2D.Double double_ = new Arc2D.Double(d2 - d, d3 - d, d * 2.0, d * 2.0, 0.0, 360.0, 1);
                    gridLine.drawRadarCircleGrid(graphics2D, double_);
                }
            }
        }
    }

    @Override
    protected void setAxisY(float f, float f2) {
        int n;
        ChartNumericAxis chartNumericAxis = (ChartNumericAxis)this.axisY;
        String[] stringArray = chartNumericAxis.getLabels();
        this.yTickPos = new float[stringArray.length][2];
        float f3 = (float)chartNumericAxis.getTickPace() * f;
        this.cos = n = chartNumericAxis.getNumOfTick();
        float f4 = this.append.getGraphArea().height / 2;
        for (int i = 0; i <= n; ++i) {
            this.yTickPos[i][0] = f2;
            this.yTickPos[i][1] = f4;
            f4 += f3;
        }
        chartNumericAxis.setAxisPosition(4);
    }

    public int getRadarAxisLength(int n) {
        int n2 = 15;
        int n3 = 5;
        int n4 = 0;
        boolean bl = this.append.getProperties().getGraphProperties().isRadarIsShowColumnName();
        if (!bl) {
            n4 = n - n2 * 2 < 2 ? 2 : (n - n2 * 2) / 2;
            return n4;
        }
        ChartNumericRadarAxis chartNumericRadarAxis = (ChartNumericRadarAxis)this.axisY;
        Dimension dimension = chartNumericRadarAxis.getMaxDimensionOfCategoryLabels();
        n4 = n / 2 - (n2 + n3);
        if (dimension.width == 0 && dimension.height == 0) {
            return n4;
        }
        n4 = dimension.width > dimension.height ? (n4 -= dimension.width) : (n4 -= dimension.height);
        n4 = n4 < 1 ? 1 : n4;
        return n4;
    }

    public void setRadarIsNormalGrid(boolean bl) {
        this.getGraphProperties = bl;
    }

    public boolean getRadarIsNormalGrid() {
        return this.getGraphProperties;
    }
}

