/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.ChartShowValueCondition;
import chart.axis.ChartNumericAxis;
import chart.chart2d.Chart2DLayer;
import chart.chart2d.Chart2DObject;
import chart.chart2d.Chart2DPaper;
import chart.data.Chart3DDataSet;
import chart.data.ChartDataSet;
import chart.data.ChartDataUsedInfo;
import chart.graphics.ChartGradientPattern;
import chart.graphics.ChartGraphicsUtil;
import chart.graphics.ChartPenStyle;
import chart.util.ChartRenderTools;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.List;

public class Graph2DBubble
extends Chart2DObject {
    private Shape[] D;
    private Shape[][] append;
    private ChartPenStyle availableValue;
    private float availableValueX;
    private float contains;
    private int draw;
    private int drawBubble;
    private float fill;
    private float floatValue;
    private float[][] get;
    private float[][] get3DEffectFill;
    private float[] getAxisX;
    private float[] getBounds2D;
    private float[][] getCategoryName;
    private float getCategoryNames;
    private double getCategoryNmae;
    private String[][][] getCategorySize;
    private boolean getChartLink = true;
    private boolean getChartLinkInfo = false;

    Graph2DBubble(ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer) {
        super(chartDataSet, chart2DPaper, chart2DLayer);
    }

    @Override
    public void init() {
        int n;
        int n2;
        super.init();
        this.availableValue = this.objectProperties.getContourPen();
        this.draw = this.dataset.getSeriesSize();
        this.drawBubble = this.dataset.getCategorySize();
        this.fill = this.layer.I();
        this.floatValue = this.layer.Z();
        this.getAxisX = new float[this.draw * this.drawBubble];
        this.getBounds2D = new float[this.draw * this.drawBubble];
        this.get = new float[this.draw * this.drawBubble][2];
        this.get3DEffectFill = new float[this.draw * this.drawBubble][2];
        this.getCategoryName = new float[this.draw * this.drawBubble][2];
        this.append = new Shape[this.draw][this.drawBubble];
        this.D = new Shape[this.draw];
        this.getCategorySize = new String[this.draw][this.drawBubble][3];
        for (int i = 0; i < this.draw; ++i) {
            for (int j = 0; j < this.drawBubble; ++j) {
                this.append[i][j] = new GeneralPath();
            }
            this.D[i] = new GeneralPath();
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = 0; n2 < this.draw; ++n2) {
            for (n = 0; n < this.drawBubble; ++n) {
                Number number = ((Chart3DDataSet)this.dataset).getX(n2, n);
                if (this.layer.isShowCategoryAndSeries()) {
                    this.getCategorySize[n2][n] = this.hintLabelShowCategoryAndSeries(5, n2, n, number);
                } else {
                    String[] stringArray = ((Chart3DDataSet)this.dataset).getValueNames();
                    if (number != null) {
                        this.getCategoryName[n2 * this.drawBubble + n][0] = number.floatValue();
                        if (stringArray.length % 2 == 0) {
                            stringBuffer.append(this.paper.model.getCategoryNmae());
                            stringBuffer.append(" : ");
                            if (((Chart3DDataSet)this.dataset).isUseCategoryAsX()) {
                                Object e = this.paper.model.getCategoryNames().get(n);
                                if (e != null) {
                                    stringBuffer.append(e.toString());
                                }
                            } else {
                                stringBuffer.append(this.dataset.getFormatedHintValue(number));
                            }
                        } else {
                            stringBuffer.append(stringArray[0]);
                            stringBuffer.append(" : ");
                            stringBuffer.append(this.dataset.getFormatedHintValue(number));
                        }
                        this.getCategorySize[n2][n][0] = stringBuffer.toString();
                        stringBuffer.setLength(0);
                    }
                    if ((number = ((Chart3DDataSet)this.dataset).getY(n2, n)) != null) {
                        this.getCategoryName[n2 * this.drawBubble + n][1] = number.floatValue();
                        int n3 = n2 / this.paper.model.getSeriesCount();
                        n3 = stringArray.length % 2 == 0 ? (n3 *= 2) : n3 * 2 + 1;
                        n3 = n3 < 0 ? 0 : n3;
                        n3 = n3 >= stringArray.length ? stringArray.length - 1 : n3;
                        stringBuffer.append(stringArray[n3]);
                        stringBuffer.append(" : ");
                        stringBuffer.append(this.dataset.getFormatedHintValue(number));
                        this.getCategorySize[n2][n][1] = stringBuffer.toString();
                        stringBuffer.setLength(0);
                    }
                    if ((number = ((Chart3DDataSet)this.dataset).getZ(n2, n)) != null) {
                        this.getAxisX[n2 * this.drawBubble + n] = number.floatValue();
                        int n4 = n2 / this.paper.model.getSeriesCount();
                        n4 = stringArray.length % 2 == 0 ? n4 * 2 + 1 : n4 * 2 + 2;
                        n4 = n4 < 0 ? 0 : n4;
                        n4 = n4 >= stringArray.length ? stringArray.length - 1 : n4;
                        stringBuffer.append(stringArray[n4]);
                        stringBuffer.append(" : ");
                        stringBuffer.append(this.dataset.getFormatedHintValue(number));
                        this.getCategorySize[n2][n][2] = stringBuffer.toString();
                        stringBuffer.setLength(0);
                    }
                }
                this.getCategoryNames = this.getCategoryNames < this.getAxisX[n2 * this.drawBubble + n] ? this.getAxisX[n2 * this.drawBubble + n] : this.getCategoryNames;
            }
        }
        this.getCategoryNames = this.getCategoryNames >= (float)this.paper.getRenderInfo().zMax ? this.getCategoryNames : (float)this.paper.getRenderInfo().zMax;
        n2 = 0;
        if (this.layer.getAxisX() instanceof ChartNumericAxis) {
            this.availableValueX = (float)((ChartNumericAxis)this.layer.getAxisX()).getMax();
            this.contains = (float)((ChartNumericAxis)this.layer.getAxisX()).getMin();
            this.getCategoryNmae = ((ChartNumericAxis)this.layer.getAxisX()).getTickPace();
        } else {
            this.getCategoryNmae = this.layer.getAxisX().getUnit(this.paper.getGraphArea().width);
            n2 = 1;
        }
        this.getChartLink = this.paper.getProperties().getGraphProperties().getCutBubble();
        for (n = 0; n < this.draw; ++n) {
            for (int i = 0; i < this.drawBubble; ++i) {
                this.get[n * this.drawBubble + i][0] = n2 == 0 ? this.fill * this.layer.availableValueX(this.getCategoryName[n * this.drawBubble + i][0]) : this.fill * (float)i;
                this.get[n * this.drawBubble + i][1] = this.floatValue * this.layer.availableValue(this.getCategoryName[n * this.drawBubble + i][1]);
                if (this.getCategoryNames == 0.0f) {
                    this.getCategoryNames = 1.0f;
                }
                this.getBounds2D[n * this.drawBubble + i] = n2 == 0 ? (float)((double)(this.getAxisX[n * this.drawBubble + i] / this.getCategoryNames) * this.getCategoryNmae * (double)this.layer.getAxisX().getUnit(this.paper.getGraphArea().width)) : (float)((double)(this.getAxisX[n * this.drawBubble + i] / this.getCategoryNames) * this.getCategoryNmae);
                if (!(this.getBounds2D[n * this.drawBubble + i] < 6.0f)) continue;
                this.getBounds2D[n * this.drawBubble + i] = 6.0f;
            }
        }
    }

    @Override
    public void locate() {
        int n;
        int n2;
        for (n2 = 0; n2 < this.draw; ++n2) {
            for (n = 0; n < this.drawBubble; ++n) {
                ((GeneralPath)this.append[n2][n]).reset();
            }
            ((GeneralPath)this.D[n2]).reset();
        }
        this.layer.I(this.get, this.get3DEffectFill);
        for (n2 = 0; n2 < this.draw; ++n2) {
            for (n = 0; n < this.drawBubble; ++n) {
                if (((Chart3DDataSet)this.dataset).getX(n2, n) == null || ((Chart3DDataSet)this.dataset).getY(n2, n) == null || ((Chart3DDataSet)this.dataset).getZ(n2, n) == null || this.getBounds2D[n2 * this.drawBubble + n] < 0.0f) continue;
                this.append[n2][n] = new GeneralPath(new Arc2D.Double(this.get3DEffectFill[n2 * this.drawBubble + n][0] - (float)((int)this.getBounds2D[n2 * this.drawBubble + n]) / 2.0f, this.get3DEffectFill[this.drawBubble * n2 + n][1] - this.getBounds2D[n2 * this.drawBubble + n] / 2.0f, this.getBounds2D[n2 * this.drawBubble + n], this.getBounds2D[n2 * this.drawBubble + n], 0.0, 360.0, 0));
                ((GeneralPath)this.D[n2]).append(this.append[n2][n], false);
            }
        }
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        for (int i = 0; i < this.draw; ++i) {
            this.drawBubble(graphics2D, i);
        }
    }

    public void drawBubble(Graphics2D graphics2D, int n) {
        boolean bl = true;
        if (this.seriesPattern[n] != null) {
            for (int i = 0; i < this.drawBubble; ++i) {
                ChartGradientPattern chartGradientPattern;
                if (this.getChartLinkInfo) {
                    if (this.objectProperties.isUse3DEffect()) {
                        chartGradientPattern = ChartGraphicsUtil.get3DEffectFill(ChartRenderTools.highLight(this.seriesPattern[n], -30));
                        chartGradientPattern.fill(graphics2D, !this.getChartLink ? this.append[n][i] : this.D(this.append[n][i]));
                        bl = false;
                        continue;
                    }
                    ChartRenderTools.highLight(this.seriesPattern[n], -20).fill(graphics2D, !this.getChartLink ? this.append[n][i] : this.D(this.append[n][i]));
                    continue;
                }
                if (this.objectProperties.isUse3DEffect()) {
                    chartGradientPattern = ChartGraphicsUtil.get3DEffectFill(this.seriesPattern[n]);
                    chartGradientPattern.fill(graphics2D, !this.getChartLink ? this.append[n][i] : this.D(this.append[n][i]));
                    bl = false;
                    continue;
                }
                this.seriesPattern[n].fill(graphics2D, !this.getChartLink ? this.append[n][i] : this.D(this.append[n][i]));
            }
        }
        if (this.objectProperties.isContour() && bl) {
            this.availableValue.draw(graphics2D, !this.getChartLink ? this.D[n] : this.D(this.D[n]));
        }
    }

    Area D(Shape shape) {
        if (shape == null) {
            return null;
        }
        Area area = new Area(shape);
        area.intersect(new Area(this.paper.getGraphArea()));
        return area;
    }

    @Override
    float[][] getStaticHintLocation() {
        return null;
    }

    @Override
    public Shape getShapeBySeries(int n) {
        return this.D[n];
    }

    @Override
    public Shape getShapeByItem(int n, int n2) {
        return this.append[n][n2];
    }

    @Override
    public Shape[][] getItemShapes() {
        return this.append;
    }

    public Shape[][] getLimitedItemShapes() {
        if (this.append != null && this.append.length > 0 && this.append[0] != null && this.append[0].length > 1 && this.getAxisX != null) {
            int n = 0;
            Shape[][] shapeArray = new GeneralPath[this.append.length][this.append[0].length];
            Area area = new Area();
            for (int i = this.append.length - 1; i >= 0; --i) {
                for (int j = this.append[0].length - 1; j >= 0; --j) {
                    if (this.append[i][j] == null) continue;
                    Rectangle2D rectangle2D = this.append[i][j].getBounds2D();
                    rectangle2D.setRect(rectangle2D.getX() + 1.0, rectangle2D.getY() + 1.0, rectangle2D.getWidth() - 2.0, rectangle2D.getHeight() - 2.0);
                    if (area.contains(rectangle2D)) continue;
                    shapeArray[i][j] = (GeneralPath)this.append[i][j];
                    area.add(new Area(rectangle2D));
                    ++n;
                }
            }
            return shapeArray;
        }
        return this.append;
    }

    @Override
    public String[] search(int n, int n2) {
        this.drilldown = null;
        for (int i = this.draw - 1; i >= 0; --i) {
            for (int j = this.drawBubble - 1; j >= 0; --j) {
                if (!this.append[i][j].contains(n, n2)) continue;
                this.drilldown = new int[2];
                this.drilldown[0] = i;
                this.drilldown[1] = j;
                return this.getCategorySize[i][j];
            }
        }
        return null;
    }

    public boolean contains(int n, int n2) {
        return false;
    }

    @Override
    public int searchSeries(int n, int n2) {
        for (int i = 0; i < this.D.length; ++i) {
            if (!this.D[i].contains(n, n2)) continue;
            return i;
        }
        return -1;
    }

    public String[] hintLabelShowCategoryAndSeries(int n, int n2, int n3, Number number) {
        int n4;
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = new String[n];
        if (this.paper.model.getSeriesN() != null) {
            stringBuffer.append(this.paper.model.getSeriesN() + ": ");
            stringBuffer.append(this.dataset.getFormatedHintSeriesValue(this.paper.model.getSeriesNames().get(n2 % this.paper.model.getSeriesNames().size()), n2 % this.paper.model.getSeriesNames().size()));
            stringArray[0] = stringBuffer.toString();
            stringBuffer.setLength(0);
        } else {
            stringArray[0] = "";
            stringBuffer.setLength(0);
        }
        if (this.paper.model.getCategoryNmae() != null) {
            stringBuffer.append(this.paper.model.getCategoryNmae());
            object = this.paper.model.getCategoryName(n3);
            if (object != null) {
                stringBuffer.append(" : ");
                stringBuffer.append(this.dataset.getFormatedHintCategoryValue(this.paper.model.getCategoryName(n3), n3));
            }
            stringArray[1] = stringBuffer.toString();
            stringBuffer.setLength(0);
        }
        object = ((Chart3DDataSet)this.dataset).getValueNames();
        if (((Chart3DDataSet)this.dataset).isUseCategoryAsX()) {
            Object e = this.paper.model.getCategoryNames().get(n3);
            if (e != null) {
                stringBuffer.append(this.paper.model.getCategoryNmae() == null ? "X" : this.paper.model.getCategoryNmae());
                stringBuffer.append(" : ");
                stringBuffer.append(e.toString());
                stringArray[2] = stringBuffer.toString();
                stringBuffer.setLength(0);
            }
            if (number != null) {
                this.getCategoryName[n2 * this.drawBubble + n3][0] = number.floatValue();
            }
        } else if (number != null) {
            this.getCategoryName[n2 * this.drawBubble + n3][0] = number.floatValue();
            if (((String[])object).length % 2 == 0) {
                Object e = this.paper.model.getCategoryNames().get(n3);
                if (e != null) {
                    stringBuffer.append(this.paper.model.getCategoryNmae() == null ? "X" : this.paper.model.getCategoryNmae());
                    stringBuffer.append(" : ");
                    stringBuffer.append(e.toString());
                }
            } else {
                n4 = 0;
                stringBuffer.append(object[n4]);
                stringBuffer.append(" : ");
                stringBuffer.append(number.toString());
            }
            stringArray[2] = stringBuffer.toString();
            stringBuffer.setLength(0);
        }
        number = ((Chart3DDataSet)this.dataset).getY(n2, n3);
        if (number != null) {
            this.getCategoryName[n2 * this.drawBubble + n3][1] = number.floatValue();
            if (((String[])object).length % 2 == 0) {
                n4 = n2 / this.paper.model.getSeriesCount();
                n4 *= 2;
            } else {
                n4 = n2 / this.paper.model.getSeriesCount();
                n4 = n4 * 2 + 1;
            }
            stringBuffer.append(object[n4]);
            stringBuffer.append(" : ");
            stringBuffer.append(number.toString());
            stringArray[3] = stringBuffer.toString();
            stringBuffer.setLength(0);
        }
        if ((number = ((Chart3DDataSet)this.dataset).getZ(n2, n3)) != null) {
            this.getAxisX[n2 * this.drawBubble + n3] = number.floatValue();
            if (((String[])object).length % 2 == 0) {
                n4 = n2 / this.paper.model.getSeriesCount();
                n4 = n4 * 2 + 1;
            } else {
                n4 = n2 / this.paper.model.getSeriesCount();
                n4 = n4 * 2 + 2;
            }
            stringBuffer.append(object[n4]);
            stringBuffer.append(" : ");
            stringBuffer.append(number.toString());
            stringArray[4] = stringBuffer.toString();
            stringBuffer.setLength(0);
        }
        return stringArray;
    }

    public boolean getIsCutByXYArea() {
        return this.getChartLink;
    }

    public void setIsCutByXYArea(boolean bl) {
        this.getChartLink = bl;
    }

    public void setIsDarkFill(boolean bl) {
    }

    @Override
    public int[] searchLinkInfo(int n, int n2) {
        int[] nArray = null;
        for (int i = this.draw - 1; i >= 0; --i) {
            for (int j = this.drawBubble - 1; j >= 0; --j) {
                if (!this.append[i][j].contains(n, n2)) continue;
                ChartShowValueCondition chartShowValueCondition = this.dataset.getCondition(i, j);
                if (chartShowValueCondition != null && chartShowValueCondition.getChartLink() != null) {
                    nArray = ((ChartDataUsedInfo)((List)chartShowValueCondition.getChartLink().get(i)).get(j)).getChartLinkInfo();
                }
                return nArray;
            }
        }
        return null;
    }
}

