/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.ChartLabelBase;
import chart.axis.ChartAxisArrowStyle;
import chart.axis.ChartNumericAxis;
import chart.chart2d.Graph2DGuageDials;
import chart.data.Chart1DDataSet;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartGradientPattern;
import chart.graphics.ChartPenStyle;
import chart.graphics.ChartTexturePattern;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;

public class Graph2DGuageDial {
    int F = 0;
    Graph2DGuageDials SEDU;
    ChartFillPattern[] dataset = new ChartFillPattern[3];

    Graph2DGuageDial(Graph2DGuageDials graph2DGuageDials, int n) {
        this.SEDU = graph2DGuageDials;
        this.F = n;
    }

    public void paint(Graphics2D graphics2D) {
        if (this.SEDU.objectProperties.isGaugeDialCurveIsFill()) {
            this.getAxisLabelsPos(graphics2D);
        }
        if (this.SEDU.paper.getProperties().isShowAxisY()) {
            this.getAlertArea(graphics2D);
        }
        if (this.SEDU.paper.getProperties().getAxisYProperties().isShowGrid()) {
            this.getArrowPoint(graphics2D);
        }
        this.fill(graphics2D);
        this.SEDU(graphics2D);
        this.draw(graphics2D);
        this.F(graphics2D);
    }

    private void F(Graphics2D graphics2D) {
        if (!this.SEDU.paper.getProperties().getAxisXProperties().isShowTickMarkLabels()) {
            return;
        }
        ChartLabelBase chartLabelBase = this.SEDU.getCategoryLabel(this.F);
        if (chartLabelBase == null) {
            return;
        }
        float f = this.SEDU.getCategoryLabelsX(this.F);
        float f2 = this.SEDU.getCategoryLabelsY(this.F);
        chartLabelBase.locate();
        chartLabelBase.paint(graphics2D, f, f2);
    }

    private void SEDU(Graphics2D graphics2D) {
        ChartFillPattern[] chartFillPatternArray = this.SEDU.seriesPattern;
        int n = this.SEDU.Z;
        float f = (float)((ChartNumericAxis)this.SEDU.layer.getAxisY()).getMax();
        float f2 = (float)((ChartNumericAxis)this.SEDU.layer.getAxisY()).getMin();
        for (int i = 0; i < n; ++i) {
            if (((Chart1DDataSet)this.SEDU.dataset).getValue(i, this.F) == null || this.SEDU.I[i][this.F] > f || this.SEDU.I[i][this.F] < f2) continue;
            Shape shape = this.SEDU.getShapeByItem(i, this.F);
            this.dataset(graphics2D, shape, i, chartFillPatternArray[i]);
        }
    }

    private void dataset(Graphics2D graphics2D, Shape shape, int n, ChartFillPattern chartFillPattern) {
        if (shape == null) {
            return;
        }
        switch (this.SEDU.objectProperties.getGaugeDialLineStyle()) {
            case 0: 
            case 1: {
                if (chartFillPattern == null) break;
                chartFillPattern.fill(graphics2D, shape);
                if (!this.SEDU.objectProperties.isContour()) break;
                this.SEDU.objectProperties.getContourPen().draw(graphics2D, shape);
                break;
            }
            case 2: {
                Color color = null;
                ChartColorPattern chartColorPattern = null;
                if (this.SEDU.seriesPattern[n] == null) break;
                if (this.SEDU.seriesPattern[n] instanceof ChartColorPattern) {
                    chartColorPattern = (ChartColorPattern)this.SEDU.seriesPattern[n];
                    color = ((ChartColorPattern)this.SEDU.seriesPattern[n]).getColor();
                } else if (this.SEDU.seriesPattern[n] instanceof ChartGradientPattern) {
                    chartColorPattern = ((ChartGradientPattern)this.SEDU.seriesPattern[n]).getStartColor();
                    color = ((ChartGradientPattern)this.SEDU.seriesPattern[n]).getStartColor().getColor();
                } else if (this.SEDU.seriesPattern[n] instanceof ChartTexturePattern) {
                    chartColorPattern = ((ChartTexturePattern)this.SEDU.seriesPattern[n]).getForeground();
                    color = ((ChartTexturePattern)this.SEDU.seriesPattern[n]).getForeground().getColor();
                }
                ChartPenStyle chartPenStyle = new ChartPenStyle();
                chartPenStyle.setPenWidth(3.0f);
                chartPenStyle.setPenColor(chartColorPattern);
                if (this.SEDU.getArrowLine(n, this.F) != null) {
                    chartPenStyle.draw(graphics2D, this.SEDU.getArrowLine(n, this.F));
                }
                ChartAxisArrowStyle chartAxisArrowStyle = null;
                graphics2D.setColor(color);
                int n2 = (int)this.SEDU.getArrowPoint(n, this.F)[0];
                int n3 = (int)this.SEDU.getArrowPoint(n, this.F)[1];
                graphics2D.rotate(Math.PI * 2 + this.SEDU.getValueAngle(n, this.F) - 1.5707963267948966, n2, n3);
                switch (this.SEDU.objectProperties.getGaugeDialLineArrowStyle()) {
                    case 1: {
                        chartAxisArrowStyle = new ChartAxisArrowStyle(1);
                        break;
                    }
                    case 2: {
                        chartAxisArrowStyle = new ChartAxisArrowStyle(2);
                        break;
                    }
                    case 3: {
                        chartAxisArrowStyle = new ChartAxisArrowStyle(3);
                        break;
                    }
                    case 0: {
                        chartAxisArrowStyle = new ChartAxisArrowStyle(0);
                        break;
                    }
                }
                if (chartAxisArrowStyle != null) {
                    chartAxisArrowStyle.draw(graphics2D, n2, n3);
                }
                graphics2D.rotate(Math.PI * -2 - this.SEDU.getValueAngle(n, this.F) + 1.5707963267948966, n2, n3);
                break;
            }
        }
    }

    private void draw(Graphics2D graphics2D) {
        float f = this.SEDU.getCenterX(this.F);
        float f2 = this.SEDU.getCenterY(this.F);
        switch (this.SEDU.objectProperties.getGaugeDialLineStyle()) {
            case 0: 
            case 2: {
                Arc2D.Float float_ = new Arc2D.Float(f - this.SEDU.C / 10.0f, f2 - this.SEDU.C / 10.0f, this.SEDU.C / 5.0f, this.SEDU.C / 5.0f, 0.0f, 360.0f, 0);
                ChartGradientPattern chartGradientPattern = new ChartGradientPattern(3);
                chartGradientPattern.setStartColor(new ChartColorPattern(Color.white));
                chartGradientPattern.setEndColor(new ChartColorPattern(Color.gray));
                Point2D.Float float_2 = new Point2D.Float(0.3f, 0.3f);
                Point2D.Float float_3 = new Point2D.Float(1.0f, 1.0f);
                chartGradientPattern.setStartPoint(float_2);
                chartGradientPattern.setEndPoint(float_3);
                chartGradientPattern.fill(graphics2D, float_);
            }
        }
    }

    private void fill(Graphics2D graphics2D) {
        Shape shape = this.SEDU.getCurvePath(this.F);
        if (shape == null) {
            return;
        }
        this.SEDU.paper.getProperties().getAxisYProperties().getAxisPen().draw(graphics2D, shape);
    }

    private void getAlertArea(Graphics2D graphics2D) {
        Shape shape = this.SEDU.getAxisPaths(this.F);
        this.SEDU.paper.getProperties().getAxisYProperties().getAxisPen().draw(graphics2D, shape);
        this.drawTickMark(graphics2D);
        if (this.SEDU.paper.getProperties().getAxisYProperties().isShowTickMarkLabels()) {
            this.getArrowLine(graphics2D);
        }
    }

    private void getArrowLine(Graphics2D graphics2D) {
        ChartLabelBase[] chartLabelBaseArray = this.SEDU.getLabels();
        if (chartLabelBaseArray == null) {
            return;
        }
        float[][] fArray = this.SEDU.getAxisLabelsPos(this.F);
        int n = chartLabelBaseArray.length;
        for (int i = 0; i < n; ++i) {
            chartLabelBaseArray[i].locate();
            chartLabelBaseArray[i].paint(graphics2D, fArray[i][0], fArray[i][1]);
        }
    }

    public void drawTickMark(Graphics2D graphics2D) {
        Shape[] shapeArray = this.SEDU.getTickPath(this.F);
        if (shapeArray == null) {
            return;
        }
        int n = shapeArray.length;
        for (int i = 0; i < n; ++i) {
            this.SEDU.paper.getProperties().getAxisYProperties().getTickMarkPen().draw(graphics2D, shapeArray[i]);
        }
    }

    private void getArrowPoint(Graphics2D graphics2D) {
        Shape[] shapeArray = this.SEDU.getGridPath(this.F);
        if (shapeArray == null) {
            return;
        }
        int n = shapeArray.length;
        for (int i = 0; i < n; ++i) {
            this.SEDU.paper.getProperties().getAxisYProperties().getGridPen().draw(graphics2D, shapeArray[i]);
        }
    }

    private void getAxisLabelsPos(Graphics2D graphics2D) {
        if (this.dataset[0] != null) {
            this.dataset[0].fill(graphics2D, this.SEDU.getNormalArea(this.F));
        }
        if (this.dataset[1] != null) {
            this.dataset[1].fill(graphics2D, this.SEDU.getAlertArea(this.F));
        }
        if (this.dataset[2] != null) {
            this.dataset[2].fill(graphics2D, this.SEDU.getErrorArea(this.F));
        }
    }

    public void setGaugePatterns(ChartFillPattern[] chartFillPatternArray) {
        this.dataset = chartFillPatternArray;
    }
}

