/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.ChartDataObject;
import chart.ChartLabelBase;
import chart.ChartShowValueCondition;
import chart.chart2d.Chart2DLayer;
import chart.chart2d.Chart2DObject;
import chart.chart2d.Chart2DPaper;
import chart.chart2d.Graph2DPieArc;
import chart.chart2d.PieLabelModification;
import chart.data.Chart1DDataSet;
import chart.data.ChartDataFilter;
import chart.data.ChartDataSet;
import chart.data.ChartDataSetModel;
import chart.data.ChartDataUsedInfo;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartPenStyle;
import chart.graphics.ChartTextStyle;
import chart.util.ChartHintLabel;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class Graph2DPie
extends Chart2DObject {
    public static final int LABELTYPE_VLAUE = 0;
    public static final int LABELTYPE_CATEGORYNAME = 1;
    public static final int LABELTYPE_PERCENT = 2;
    public static final int LABELTYPE_VLAUE_PERCENT = 3;
    private Chart2DPaper D;
    private ChartDataSet LabelSide;
    private Graph2DPieArc[][] abs;
    private int addVertex;
    private int adjustLabelLocation;
    private int adjustPieLabel;
    private ChartFillPattern[] append;
    private float[] clear;
    private int contains = -1;
    private float cos;
    private Point2D.Double cutBefLabels;
    private Point2D.Double[] distance;
    private float doubleValue;
    private double draw;
    private double[][] v;
    private double[][][] equals;
    private Shape[][] filter;
    private int floatValue = -1;
    private int floor = -1;
    private Shape[] get;
    private String[][][] getArcCenter;
    private ChartTextStyle getArcExtendAngle;
    private boolean getArcRadius = false;
    private boolean getAxisXProperties;
    private Point2D.Float[] getBefLabelBounds;
    private ChartLabelBase[] getBottomMargin;
    private ChartTextStyle getBounds;
    private Rectangle2D[] getCategoryFilter;
    private float getCategorySize;
    private int getChartDataSetModel = 2;
    private int getChartLink = 1;
    private int getChartLinkInfo = 1;
    private int getChartPlatform;
    private boolean getCondition;

    public Graph2DPie(ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer) {
        super(chartDataSet, chart2DPaper, chart2DLayer);
        this.LabelSide = chartDataSet;
        this.D = chart2DPaper;
    }

    @Override
    public void init() {
        float f;
        int n;
        super.init();
        this.addVertex = this.LabelSide.getCategorySize();
        this.adjustLabelLocation = this.LabelSide.getSeriesSize();
        this.v = new double[this.addVertex][5];
        this.equals = new double[this.adjustLabelLocation][this.addVertex][5];
        this.distance = new Point2D.Double[this.adjustLabelLocation];
        this.getArcCenter = new String[this.adjustLabelLocation][this.addVertex][3];
        this.getArcExtendAngle = this.D.getProperties().getHintTextStyle();
        this.getArcExtendAngle.setWordWrapper(false);
        this.append = this.D.getChartPlatform().getFillPatternByArarry(0);
        this.draw = this.D.getProperties().getGraphProperties().getPieExplodeDistance();
        this.clear = new float[2];
        this.getArcRadius = this.D.properties.getGraphProperties().isContour();
        this.clear[1] = this.D.properties.getGraphProperties().getPieYRotation();
        this.clear[0] = this.D.properties.getGraphProperties().getPieXRotation();
        this.filter = new Shape[this.adjustLabelLocation][this.addVertex];
        this.get = new Shape[this.addVertex];
        Number number = null;
        this.abs = new Graph2DPieArc[this.adjustLabelLocation][this.addVertex];
        float[][] fArray = new float[this.adjustLabelLocation][this.addVertex];
        double[] dArray = new double[this.adjustLabelLocation];
        for (int i = 0; i < this.adjustLabelLocation; ++i) {
            for (int j = 0; j < this.addVertex; ++j) {
                float f2;
                Number number2 = ((Chart1DDataSet)this.LabelSide).getValue(i, j);
                if (number2 == null) {
                    f2 = 0.0f;
                } else {
                    f2 = number2.floatValue();
                    if (this.layer.isShowCategoryAndSeries()) {
                        ChartHintLabel chartHintLabel = new ChartHintLabel((ChartDataObject)this, this.LabelSide, this.D, 3);
                        this.getArcCenter[i][j] = chartHintLabel.hintLabelShowCategoryAndSeriesFor2d(i, j);
                    } else {
                        this.getArcCenter[i][j][0] = this.LabelSide.getFormatedHintValue(number2);
                    }
                }
                fArray[i][j] = f2;
                int n2 = i;
                dArray[n2] = dArray[n2] + (double)Math.abs(f2);
            }
            if (dArray[i] != 0.0) continue;
            dArray[i] = 1.0;
        }
        float f3 = this.D.getBounds().width;
        float f4 = this.D.getBounds().height;
        float f5 = Math.min(f3, f4);
        float f6 = Math.max(f3, f4);
        int n3 = 1;
        int n4 = 1;
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        if (f3 == 0.0f || f4 == 0.0f) {
            return;
        }
        for (int i = 1; i <= this.adjustLabelLocation; ++i) {
            n3 = i;
            for (n = 1; n <= (int)(f6 / (f5 / (float)n3)); ++n) {
                if (n3 * n < this.adjustLabelLocation) continue;
                n4 = n;
                bl = true;
                break;
            }
            if (bl) break;
        }
        if (f3 >= f4) {
            n5 = n3;
            n6 = n4;
        } else {
            n5 = n4;
            n6 = n3;
        }
        this.getAxisXProperties = this.D.getProperties().getGraphProperties().isShowPieName();
        if (this.getAxisXProperties) {
            int n7;
            int n8;
            String[] stringArray;
            this.getBounds = this.D.getProperties().getAxisXProperties().getLabelTextStyle();
            this.getBounds.setRotation(0.0);
            this.getBounds.setShearing(0.0f);
            ArrayList<String> arrayList = null;
            if (this.LabelSide.getChartDataSetModel().isOneGroup()) {
                arrayList = new ArrayList<String>();
                stringArray = this.LabelSide.getChartDataSetModel().getValuesName();
                n8 = stringArray.length;
                for (n7 = 0; n7 < n8; ++n7) {
                    arrayList.add(stringArray[n7]);
                }
            } else {
                ChartDataFilter chartDataFilter;
                stringArray = this.LabelSide.getChartDataSetModel().getSeriesNames();
                n7 = stringArray.size();
                if (this.LabelSide.getChartDataSetModel().isSwapGroup()) {
                    chartDataFilter = this.LabelSide.getChartDataSetModel().getCategoryFilter();
                } else {
                    ChartDataFilter chartDataFilter2 = this.LabelSide.getChartDataSetModel().getCategoryFilter();
                    String string = chartDataFilter2 != null ? chartDataFilter2.getDataMappingFile() : null;
                    chartDataFilter = this.LabelSide.getChartDataSetModel().getSeriesFilter();
                    if (chartDataFilter != null && string != null && !string.equals("")) {
                        chartDataFilter.setDataMappingFile(string);
                    }
                }
                arrayList = new ArrayList();
                for (int i = 0; i < n7; ++i) {
                    if (chartDataFilter != null) {
                        arrayList.add(chartDataFilter.filter(stringArray.get(i)));
                        continue;
                    }
                    arrayList.add((String)stringArray.get(i));
                }
            }
            n = this.adjustLabelLocation;
            this.getBefLabelBounds = new Point2D.Float[n];
            this.getBottomMargin = new ChartLabelBase[n];
            this.getCategoryFilter = new Rectangle2D[n];
            n7 = arrayList.size();
            this.getCategorySize = 0.0f;
            for (n8 = 0; n8 < n; ++n8) {
                this.getBottomMargin[n8] = this.cutBefLabels(String.valueOf(arrayList.get(n8 % n7)), this.getBounds);
                this.getBefLabelBounds[n8] = new Point2D.Float();
                this.getCategoryFilter[n8] = this.getBounds.getDimension(String.valueOf(arrayList.get(n8 % n7)));
                this.getCategorySize = (float)((double)this.getCategorySize > this.getCategoryFilter[n8].getHeight() ? (double)this.getCategorySize : this.getCategoryFilter[n8].getHeight());
            }
        }
        float f7 = 0.0f;
        if (this.adjustLabelLocation > 1) {
            f7 = this.D.properties.getGraphProperties().getPieGap();
            this.getChartPlatform = (int)f7;
        }
        this.getChartLink = n6;
        this.getChartLinkInfo = n5;
        float f8 = f4 / (float)n5 / 2.0f - f7 - this.getCategorySize;
        f8 = f8 < 0.0f ? 0.0f : f8;
        this.cos = Math.min(f8, f3 / (float)n6 / 2.0f);
        float f9 = f = this.cos / 2.0f;
        float f10 = f9 / 4.0f;
        float f11 = 0.0f;
        String string = null;
        int n9 = 8;
        List list = this.LabelSide.getFilterLegendSeriesLabels();
        int n10 = this.D.getProperties().getGraphProperties().getValueLabelType();
        ChartDataSetModel chartDataSetModel = this.D.model;
        boolean bl2 = this.D.getProperties().isShadowContents();
        ChartPenStyle chartPenStyle = this.D.getProperties().getGraphProperties().getContourPen();
        int n11 = this.D.getProperties().getGraphProperties().getDonutWidth();
        for (int i = 0; i < this.adjustLabelLocation; ++i) {
            int n12 = i / n6 + 1;
            int n13 = i - (n12 - 1) * n6 + 1;
            double d = 0.0;
            double d2 = 0.0;
            f11 = (float)(n13 * 2 - 1) * f3 / (float)(n6 * 2) - 3.0f * f9 / 2.0f;
            float f12 = (float)(n12 * 2 - 1) * f4 / (float)(n5 * 2);
            if (this.getAxisXProperties) {
                this.getBefLabelBounds[i].x = (float)((double)(f3 / (float)n6 * (float)n13 - f3 / (float)n6 / 2.0f) - this.getCategoryFilter[i].getWidth() / 2.0);
                this.getBefLabelBounds[i].y = (f12 -= this.getCategorySize / 2.0f) + this.cos - this.D.getProperties().getBottomMargin();
            }
            double d3 = 0.0;
            for (int j = 0; j < this.addVertex; ++j) {
                this.abs[i][j] = new Graph2DPieArc();
                this.abs[i][j].setPattern(this.append[0]);
                this.abs[i][j].setIsDonut(this.getCondition);
                this.abs[i][j].setDonutWidth((float)n11 / 100.0f);
                if (j != 0) {
                    d += d2;
                }
                d2 = Math.abs(fArray[i][j] * 360.0f / (float)dArray[i]);
                for (int k = 0; k < 2; ++k) {
                    this.abs[i][j].addVertex(f11, f12, f9 / 3.0f);
                    this.abs[i][j].addVertex(0.0f, 0.0f, 0.0f);
                    this.abs[i][j].addVertex(0.0f, 0.0f, 0.0f);
                    this.abs[i][j].addVertex(f11, f12 + 2.0f * f10, f9 / 3.0f);
                }
                double d4 = 0.0;
                d4 = ((Chart1DDataSet)this.LabelSide).getValue(i, j) == null ? (double)1.4E-45f : (double)((Chart1DDataSet)this.LabelSide).getValue(i, j).floatValue();
                number = ((Chart1DDataSet)this.LabelSide).getOriginValue(i, j);
                switch (this.D.getProperties().getGraphProperties().getValueLabelType()) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        if (number == null) break;
                        number = new Double(number.doubleValue() / dArray[i]);
                        break;
                    }
                    case 3: {
                        if (number == null) break;
                        string = this.LabelSide.getFormatedHintValue(number);
                        number = new Double(number.doubleValue() / dArray[i]);
                        break;
                    }
                }
                String string2 = this.LabelSide.getFormatedHintValue(number);
                this.abs[i][j].addVertex(f9 * 3.0f, f9 * 3.0f, 0.0f);
                this.abs[i][j].addVertex((float)d, (float)d2, (float)d4);
                this.abs[i][j].setAcrProperties(chartDataSetModel, chartPenStyle, number, String.valueOf(list.get(j)), this.valueLabelPosition, n10, bl2, this.clear[1], this.cos, this.getArcRadius, string2, string, this.getArcExtendAngle, this.D.getProperties().getGraphProperties().isSuppressZeroLabel());
                this.abs[i][j].graphProp = this.D.getProperties().getGraphProperties();
            }
        }
    }

    @Override
    public void locate() {
        int n;
        int n2;
        if (this.clear[1] >= 85.0f) {
            this.clear[1] = 85.0f;
        }
        float f = this.clear[0];
        for (n2 = 0; n2 < this.adjustLabelLocation; ++n2) {
            if (this.abs[n2][0] != null) {
                this.abs[n2][0].vertex[9][0] = f;
                this.abs[n2][0].vertex[8][1] = this.abs[n2][0].vertex[8][0] * (float)Math.cos((double)this.clear[1] * Math.PI / 180.0);
                this.abs[n2][0].vertex[3][1] = this.abs[n2][0].vertex[0][1] + this.abs[n2][0].vertex[0][2] * (float)Math.sin((double)this.clear[1] * Math.PI / 180.0);
            }
            for (n = 1; n < this.addVertex; ++n) {
                if (this.abs[n2][n] == null) continue;
                this.abs[n2][n].vertex[9][0] = this.abs[n2][n - 1].vertex[9][0] + this.abs[n2][n - 1].vertex[9][1];
                this.abs[n2][n].vertex[8][1] = this.abs[n2][n].vertex[8][0] * (float)Math.cos((double)this.clear[1] * Math.PI / 180.0);
                this.abs[n2][n].vertex[3][1] = this.abs[n2][n].vertex[0][1] + this.abs[n2][n].vertex[0][2] * (float)Math.sin((double)this.clear[1] * Math.PI / 180.0);
                float f2 = this.abs[n2][n].vertex[9][0];
                if (f2 > 360.0f) {
                    f2 -= (float)(Math.round(f2 / 360.0f) * 360);
                }
                this.abs[n2][n].vertex[9][0] = f2;
            }
        }
        this.doubleValue = 0.0f;
        for (n2 = 0; n2 < this.adjustLabelLocation; ++n2) {
            for (n = 0; n < this.addVertex; ++n) {
                if (this.abs[n2][n] == null) continue;
                this.doubleValue = (float)this.abs[n2][n].getArcRadius();
                this.distance[n2] = this.abs[n2][n].getArcCenter();
                break;
            }
            if (this.doubleValue > 0.0f) break;
        }
        block4: for (n2 = 0; n2 < this.adjustLabelLocation; ++n2) {
            for (n = 0; n < this.addVertex; ++n) {
                if (this.abs[n2][n] == null) continue;
                this.distance[n2] = this.abs[n2][n].getArcCenter();
                continue block4;
            }
        }
        if (this.abs[0][0] == null) {
            return;
        }
        this.cutBefLabels = this.abs[0][0].getArcCenter();
        this.doubleValue = (float)this.abs[0][0].getArcRadius();
        if (this.adjustLabelLocation == 1) {
            for (n2 = 0; n2 < this.addVertex; ++n2) {
                this.v[n2][0] = this.abs[0][n2].vertex[0][0];
                this.v[n2][1] = this.abs[0][n2].vertex[0][1];
                this.v[n2][2] = this.abs[0][n2].vertex[3][1];
                this.v[n2][3] = this.abs[0][n2].vertex[8][0];
                this.v[n2][4] = this.abs[0][n2].vertex[8][1];
            }
            if (this.draw > 0.0) {
                this.SEDU(this.draw, true);
            }
        } else {
            for (n2 = 0; n2 < this.adjustLabelLocation; ++n2) {
                for (n = 0; n < this.addVertex; ++n) {
                    this.equals[n2][n][0] = this.abs[n2][n].vertex[0][0];
                    this.equals[n2][n][1] = this.abs[n2][n].vertex[0][1];
                    this.equals[n2][n][2] = this.abs[n2][n].vertex[3][1];
                    this.equals[n2][n][3] = this.abs[n2][n].vertex[8][0];
                    this.equals[n2][n][4] = this.abs[n2][n].vertex[8][1];
                }
            }
            if (this.draw > 0.0) {
                this.abs(this.draw, true);
            }
        }
        for (n2 = 0; n2 < this.adjustLabelLocation; ++n2) {
            for (n = 0; n < this.addVertex; ++n) {
                this.abs[n2][n].setPattern(this.append[n]);
                this.abs[n2][n].locate(0);
            }
        }
        this.adjustPieLabel();
        this.cutBefLabels();
        this.clear();
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        int n;
        if (this.addVertex <= 0 || this.adjustLabelLocation <= 0) {
            return;
        }
        for (n = 0; n < this.adjustLabelLocation; ++n) {
            ChartShowValueCondition chartShowValueCondition = this.LabelSide.getCondition(n, 0);
            boolean bl = false;
            if (chartShowValueCondition != null && chartShowValueCondition.getConditionType() != 2 && chartShowValueCondition.getConditionType() != 0) {
                bl = true;
            }
            for (int i = 0; i < this.addVertex; ++i) {
                if (this.abs[n][i] == null) continue;
                this.abs[n][i].setPattern(this.append[i]);
                this.abs[n][i].locate(0);
                if (!bl) continue;
                this.abs[n][i].setIsUseConditionalFill(true);
                this.abs[n][i].setSubCondition(this.LabelSide.getSubCondition(n, i));
                this.abs[n][i].setCondition(this.LabelSide.getCondition(n, i));
            }
        }
        this.adjustPieLabel();
        this.cutBefLabels();
        if (this.clear[1] == 0.0f) {
            this.adjustPieLabel = 0;
            this.D(graphics2D);
        } else if (this.abs[0][0] != null) {
            this.adjustPieLabel = 1;
            while ((float)this.adjustPieLabel < this.abs[0][0].vertex[0][2] * (float)Math.sin((double)this.clear[1] * Math.PI / 180.0)) {
                this.D(graphics2D);
                ++this.adjustPieLabel;
            }
            this.adjustPieLabel = 0;
            this.D(graphics2D);
        }
        this.adjustPieLabel = -1;
        this.D(graphics2D);
        if (this.getAxisXProperties) {
            for (n = 0; n < this.getBottomMargin.length; ++n) {
                this.getBottomMargin[n].locate();
                this.getBottomMargin[n].paint(graphics2D, this.getBefLabelBounds[n].x, this.getBefLabelBounds[n].y);
            }
        }
    }

    private void D(Graphics2D graphics2D) {
        for (int i = 0; i < this.adjustLabelLocation; ++i) {
            for (int j = 0; j < this.addVertex; ++j) {
                if (this.abs[i][j] == null) continue;
                this.abs[i][j].draw(graphics2D, this.adjustPieLabel);
            }
        }
    }

    public double drag(double d, double d2, double d3, double d4) {
        if (this.abs.length == 1) {
            if (this.floor != -1 || this.floatValue != -1) {
                this.LabelSide(d, d2, d3, d4);
            }
        } else if (this.floor != -1 || this.floatValue != -1) {
            double d5 = Math.floor(this.add(this.abs[0][this.floatValue], d, d2, d3, d4)) / 2.0;
            this.abs(d5, false);
            this.clear();
        }
        this.draw = this.draw < 0.0 ? 0.0 : this.draw;
        this.draw = Math.floor(this.draw);
        return this.draw;
    }

    private void LabelSide(double d, double d2, double d3, double d4) {
        double d5 = Math.floor(this.add(this.abs[0][this.floatValue], d, d2, d3, d4)) / 2.0;
        this.SEDU(d5, false);
        this.clear();
    }

    private void SEDU(double d, boolean bl) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = this.doubleValue;
        int n = bl ? 2 : 1;
        for (int i = 0; i < this.abs[0].length; ++i) {
            if (i == 0 && (d4 = d > this.abs[0][i].getArcRadius() - (double)this.doubleValue ? this.abs[0][i].getArcRadius() * (double)this.doubleValue / ((double)this.doubleValue + d) : (double)this.doubleValue) >= (double)this.doubleValue) {
                d4 = this.doubleValue;
            }
            double[] dArray = this.adjustPieLabel(this.abs[0][i]);
            double d5 = (double)this.doubleValue - d4;
            d2 = (d + d5) * dArray[1] + d5 * (double)n;
            d3 = (d + d5) * dArray[0];
            if ((this.v[i][3] - d5 * 2.0) / 2.0 >= (double)this.doubleValue) {
                this.abs[0][i].vertex[0][0] = (float)this.v[i][0];
                this.abs[0][i].vertex[0][1] = (float)this.v[i][1];
                this.abs[0][i].vertex[3][1] = (float)this.v[i][2];
                this.abs[0][i].vertex[8][0] = (float)this.v[i][3];
                this.abs[0][i].vertex[8][1] = (float)this.v[i][4];
                continue;
            }
            this.abs[0][i].vertex[0][0] = (float)(this.v[i][0] + d2);
            this.abs[0][i].vertex[0][1] = (float)(this.v[i][1] + d3);
            this.abs[0][i].vertex[3][1] = (float)(this.v[i][2] + d3);
            this.abs[0][i].vertex[8][0] = (float)(this.v[i][3] - d5 * 2.0 * (double)n);
            this.abs[0][i].vertex[8][1] = (float)(this.v[i][4] - d5 * 2.0 * (double)n);
        }
        this.draw = this.cutBefLabels.distance(this.abs[0][0].getArcCenter()) / 2.0;
    }

    private void abs(double d, boolean bl) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = this.doubleValue;
        int n = bl ? 2 : 1;
        double d5 = 0.0;
        for (int i = 0; i < this.abs.length; ++i) {
            for (int j = 0; j < this.abs[0].length; ++j) {
                double[] dArray;
                if (this.abs[i][j] == null) {
                    // empty if block
                }
                if (j == 0 && (d4 = d > this.abs[i][j].getArcRadius() - (double)this.doubleValue ? this.abs[i][j].getArcRadius() * (double)this.doubleValue / ((double)this.doubleValue + d) : (double)this.doubleValue) >= (double)this.doubleValue) {
                    d4 = this.doubleValue;
                }
                if (this.distance[i] == null) continue;
                if (this.distance[i] != null) {
                    dArray = this.append(this.abs[i][j], this.distance[i]);
                } else {
                    double[] dArray2 = new double[2];
                    dArray2[0] = 0.0;
                    dArray = dArray2;
                    dArray2[1] = 0.0;
                }
                double[] dArray3 = dArray;
                d5 = (double)this.doubleValue - d4;
                d2 = (d + d5) * dArray3[1] + d5 * (double)n;
                d3 = (d + d5) * dArray3[0];
                if ((this.equals[i][j][3] - d5 * 2.0) / 2.0 >= (double)this.doubleValue) {
                    this.abs[i][j].vertex[0][0] = (float)this.equals[i][j][0];
                    this.abs[i][j].vertex[0][1] = (float)this.equals[i][j][1];
                    this.abs[i][j].vertex[3][1] = (float)this.equals[i][j][2];
                    this.abs[i][j].vertex[8][0] = (float)this.equals[i][j][3];
                    this.abs[i][j].vertex[8][1] = (float)this.equals[i][j][4];
                    if (i <= 0) continue;
                    continue;
                }
                this.abs[i][j].vertex[0][0] = (float)(this.equals[i][j][0] + d2);
                this.abs[i][j].vertex[0][1] = (float)(this.equals[i][j][1] + d3);
                this.abs[i][j].vertex[3][1] = (float)(this.equals[i][j][2] + d3);
                this.abs[i][j].vertex[8][0] = (float)(this.equals[i][j][3] - d5 * 2.0 * (double)n);
                this.abs[i][j].vertex[8][1] = (float)(this.equals[i][j][4] - d5 * 2.0 * (double)n);
                if (i <= 0) continue;
            }
        }
        if (this.floatValue >= 0) {
            this.draw = this.cutBefLabels.distance(this.abs[0][0].getArcCenter()) / 2.0;
        }
    }

    private double add(Graph2DPieArc graph2DPieArc, double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        double d7;
        Point2D.Double double_ = this.addVertex(graph2DPieArc);
        if (Math.round(this.cutBefLabels.x - ((Point2D)double_).getX()) == 0L) {
            double d8 = this.cutBefLabels.x;
            d7 = d2;
            double d9 = this.cutBefLabels.x;
            d6 = d4;
            d5 = d4 - d2;
        } else if (Math.round(this.cutBefLabels.y - ((Point2D)double_).getY()) == 0L) {
            double d10 = d;
            d7 = this.cutBefLabels.y;
            double d11 = d3;
            d6 = this.cutBefLabels.y;
            d5 = d3 - d;
        } else {
            double d12 = -(((Point2D)double_).getX() - this.cutBefLabels.x) / (((Point2D)double_).getY() - this.cutBefLabels.y);
            double d13 = d2 - d12 * d;
            double d14 = (this.cutBefLabels.x - d12 * d13 + d12 * this.cutBefLabels.y) / (d12 * d12 + 1.0);
            d7 = d12 * d14 + d13;
            double d15 = d4 - d12 * d3;
            double d16 = (this.cutBefLabels.x - d12 * d15 + d12 * this.cutBefLabels.y) / (d12 * d12 + 1.0);
            d6 = d12 * d16 + d15;
            d5 = Point2D.distance(d14, d7, d16, d6);
        }
        if ((d6 - d7) * (this.cutBefLabels.y - d7) >= 0.0) {
            d5 = -d5;
        }
        return d5;
    }

    private Point2D.Double addVertex(Graph2DPieArc graph2DPieArc) {
        double d = (float)(Math.sin((double)(graph2DPieArc.vertex[9][0] + graph2DPieArc.vertex[9][1] / 2.0f + 90.0f) * Math.PI / 180.0) * (double)graph2DPieArc.vertex[8][0] / 2.0 + (double)graph2DPieArc.vertex[0][0] + (double)(graph2DPieArc.vertex[8][0] / 2.0f));
        double d2 = (float)(Math.cos((double)(graph2DPieArc.vertex[9][0] + graph2DPieArc.vertex[9][1] / 2.0f + 90.0f) * Math.PI / 180.0) * (double)graph2DPieArc.vertex[8][1] / 2.0 + (double)graph2DPieArc.vertex[0][1]);
        Point2D.Double double_ = new Point2D.Double(d, d2);
        return double_;
    }

    private GeneralPath adjustLabelLocation(Graph2DPieArc graph2DPieArc) {
        int n;
        float f = 1.0f;
        double d = graph2DPieArc.getArcExtendAngle();
        int n2 = (int)(d / (double)f);
        n2 = n2 == 0 ? 1 : n2;
        double d2 = d / (double)n2;
        GeneralPath generalPath = new GeneralPath();
        Point2D.Double[] doubleArray = new Point2D.Double[n2 + 2];
        for (n = 0; n < n2 + 2; ++n) {
            doubleArray[n] = new Point2D.Double();
        }
        doubleArray[0] = graph2DPieArc.getArcCenter();
        doubleArray[1] = graph2DPieArc.getStartPoint();
        doubleArray[n2 + 1] = graph2DPieArc.getEndPoint();
        for (n = 0; n < n2 - 1; ++n) {
            doubleArray[n + 2].x = (float)(Math.sin(((double)graph2DPieArc.vertex[9][0] + d2 * (double)(n + 1) + 90.0) * Math.PI / 180.0) * (double)graph2DPieArc.vertex[8][0] / 2.0 + (double)graph2DPieArc.vertex[0][0] + (double)(graph2DPieArc.vertex[8][0] / 2.0f));
            doubleArray[n + 2].y = (float)(Math.cos(((double)graph2DPieArc.vertex[9][0] + d2 * (double)(n + 1) + 90.0) * Math.PI / 180.0) * (double)graph2DPieArc.vertex[8][1] / 2.0 + (double)graph2DPieArc.vertex[0][1]);
        }
        generalPath.moveTo((float)doubleArray[0].x, (float)doubleArray[0].y);
        for (n = 1; n < doubleArray.length; ++n) {
            generalPath.lineTo((float)doubleArray[n].x, (float)doubleArray[n].y);
        }
        generalPath.lineTo((float)doubleArray[0].x, (float)doubleArray[0].y);
        return generalPath;
    }

    private double[] adjustPieLabel(Graph2DPieArc graph2DPieArc) {
        double[] dArray = new double[2];
        Point2D.Double double_ = this.addVertex(graph2DPieArc);
        double d = Math.sqrt(Math.pow(double_.getX() - this.cutBefLabels.x, 2.0) + Math.pow(double_.getY() - this.cutBefLabels.y, 2.0));
        double d2 = (double_.getY() - this.cutBefLabels.y) / d;
        double d3 = (double_.getX() - this.cutBefLabels.x) / d;
        dArray[0] = d2;
        dArray[1] = d3;
        return dArray;
    }

    private double[] append(Graph2DPieArc graph2DPieArc, Point2D.Double double_) {
        double[] dArray = new double[2];
        Point2D.Double double_2 = this.addVertex(graph2DPieArc);
        double d = Math.sqrt(Math.pow(double_2.getX() - double_.x, 2.0) + Math.pow(double_2.getY() - double_.y, 2.0));
        double d2 = (double_2.getY() - double_.y) / d;
        double d3 = (double_2.getX() - double_.x) / d;
        dArray[0] = d2;
        dArray[1] = d3;
        return dArray;
    }

    @Override
    public String[] search(int n, int n2) {
        this.drilldown = null;
        for (int i = 0; i < this.adjustLabelLocation; ++i) {
            for (int j = 0; j < this.addVertex; ++j) {
                if (!this.filter[i][j].contains(n, n2)) continue;
                this.drilldown = new int[2];
                this.drilldown[0] = i;
                this.drilldown[1] = j;
                return this.getArcCenter[i][j];
            }
        }
        return null;
    }

    private void clear() {
        this.contains();
        this.cos();
    }

    private void contains() {
        for (int i = 0; i < this.adjustLabelLocation; ++i) {
            for (int j = 0; j < this.addVertex; ++j) {
                this.filter[i][j] = this.adjustLabelLocation(this.abs[i][j]);
            }
        }
    }

    @Override
    public Shape getShapeBySeries(int n) {
        return this.get[n];
    }

    @Override
    public Shape getShapeByItem(int n, int n2) {
        return this.filter[n][n2];
    }

    public Shape[][] getItemShapes(int n) {
        return this.filter;
    }

    public boolean contains(int n, int n2) {
        return this.contains != -1;
    }

    @Override
    public int searchSeries(int n, int n2) {
        for (int i = 0; i < this.addVertex; ++i) {
            if (!this.get[i].contains(n, n2)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public float[][] getStaticHintLocation() {
        return null;
    }

    @Override
    Shape[][] getItemShapes() {
        return this.filter;
    }

    Shape[][] I() {
        Shape[][] shapeArray = new Shape[this.adjustLabelLocation][this.addVertex];
        for (int i = 0; i < this.adjustLabelLocation; ++i) {
            for (int j = 0; j < this.addVertex; ++j) {
                shapeArray[i][j] = this.abs[i][j].vertex[9][1] >= 360.0f ? new Arc2D.Double(this.abs[i][j].vertex[0][0], this.abs[i][j].vertex[0][1] - this.abs[i][j].vertex[8][1] / 2.0f, this.abs[i][j].vertex[8][0], this.abs[i][j].vertex[8][1], this.abs[i][j].vertex[9][0], this.abs[i][j].vertex[9][1], 0) : new Arc2D.Double(this.abs[i][j].vertex[0][0], this.abs[i][j].vertex[0][1] - this.abs[i][j].vertex[8][1] / 2.0f, this.abs[i][j].vertex[8][0], this.abs[i][j].vertex[8][1], this.abs[i][j].vertex[9][0], this.abs[i][j].vertex[9][1], 2);
            }
        }
        return shapeArray;
    }

    public void setSelectedSeriesIndex(int n) {
        this.floatValue = n;
    }

    public void setSelectedObjectIndex(int n) {
        this.floor = n;
    }

    private void cos() {
        int n;
        for (n = 0; n < this.addVertex; ++n) {
            this.get[n] = new GeneralPath();
        }
        for (n = 0; n < this.adjustLabelLocation; ++n) {
            for (int i = 0; i < this.addVertex; ++i) {
                ((GeneralPath)this.get[i]).append(this.filter[n][i], false);
            }
        }
    }

    public Point2D.Double getPieCenter() {
        return this.cutBefLabels;
    }

    private ChartLabelBase cutBefLabels(String string, ChartTextStyle chartTextStyle) {
        ChartLabelBase chartLabelBase;
        if (string != null) {
            chartLabelBase = new ChartLabelBase(string);
            chartLabelBase.setChartTextStyle(chartTextStyle);
        } else {
            chartLabelBase = null;
        }
        return chartLabelBase;
    }

    public void cutBefLabels() {
        if (this.valueLabelPosition != 50) {
            return;
        }
        Line2D.Double[] doubleArray = null;
        Line2D.Double[] doubleArray2 = null;
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < this.adjustLabelLocation; ++i) {
            int n3;
            int n4;
            int n5;
            int n6;
            for (n6 = 0; n6 < this.addVertex; ++n6) {
                if (this.abs[i][n6] == null || this.abs[i][n6].getValueLabel() == null || this.abs[i][n6].getLabelPosition() == null) continue;
                if (n == -1) {
                    n = n6;
                    n2 = n6;
                    continue;
                }
                doubleArray = this.abs[i][n].getBefLabelBounds(this.abs[i][n6].I + 2.0, this.abs[i][n6].Z);
                doubleArray2 = this.abs[i][n6].getBefLabelBounds(this.abs[i][n6].I + 2.0, this.abs[i][n6].Z);
                if (doubleArray2 == null) continue;
                if (doubleArray == null) {
                    n = n6;
                    continue;
                }
                if (doubleArray == null) {
                    doubleArray = this.abs[i][n].getBefLabelBounds(this.abs[i][n6].I + 2.0, this.abs[i][n6].Z);
                }
                n5 = 0;
                for (n4 = 0; n4 < doubleArray.length; ++n4) {
                    for (n3 = 0; n3 < doubleArray2.length; ++n3) {
                        if (doubleArray[n4].intersectsLine(doubleArray2[n3])) {
                            n5 = 1;
                        }
                        if (n5 == 0) continue;
                    }
                }
                if (n5 == 0) {
                    n = n6;
                    continue;
                }
                this.abs[i][n6].setLabelPosition(null);
            }
            if (n2 == -1 || n <= 0) continue;
            doubleArray = this.abs[i][n2].getBefLabelBounds(this.abs[i][n2].I + 2.0, this.abs[i][n2].Z);
            doubleArray2 = this.abs[i][n].getBefLabelBounds(this.abs[i][n].I + 2.0, this.abs[i][n].Z);
            n6 = 0;
            n5 = 0;
            if (doubleArray != null) {
                n6 = doubleArray.length;
            }
            if (doubleArray2 != null) {
                n5 = doubleArray2.length;
            }
            block4: for (n4 = 0; n4 < n6; ++n4) {
                for (n3 = 0; n3 < n5; ++n3) {
                    if (!doubleArray[n4].intersectsLine(doubleArray2[n3])) continue;
                    this.abs[i][n].setLabelPosition(null);
                    continue block4;
                }
            }
        }
    }

    public void adjustPieLabel() {
        int n;
        int n2;
        if (this.valueLabelPosition == 50) {
            return;
        }
        boolean bl = true;
        ArrayList<Graph2DPieArc> arrayList = new ArrayList<Graph2DPieArc>();
        Rectangle rectangle = new Rectangle(this.D.getBounds());
        double d = -1.0;
        double d2 = -1.0;
        double d3 = 0.0;
        double d4 = 0.0;
        Point2D.Double double_ = null;
        int n3 = rectangle.width - this.getChartPlatform > 0 ? (rectangle.width - (this.getChartLink - 1) * this.getChartPlatform) / this.getChartLink : 0;
        int n4 = n2 = rectangle.height - this.getChartPlatform > 0 ? (rectangle.height - (this.getChartLinkInfo - 1) * this.getChartPlatform) / this.getChartLinkInfo : 0;
        if (n3 == 0 || n2 == 0) {
            return;
        }
        for (n = 0; n < this.addVertex; ++n) {
            if (this.abs[0][n] == null) continue;
            d = this.abs[0][n].getArcCenter().x;
            d2 = this.abs[0][n].getArcCenter().y;
            n = this.addVertex;
            break;
        }
        if (d < 0.0 && d2 < 0.0) {
            d = n3 / 2;
            d2 = n2 / 2;
        }
        for (n = 0; n < this.adjustLabelLocation; ++n) {
            int n5;
            bl = true;
            for (n5 = 0; n5 < this.addVertex; ++n5) {
                if (this.abs[n][n5] == null) continue;
                arrayList.add(this.abs[n][n5]);
                bl = false;
            }
            if (!bl) {
                int n6;
                double_ = new Point2D.Double();
                for (n5 = 0; n5 < this.addVertex; ++n5) {
                    if (this.abs[n][n5] == null) continue;
                    d3 = this.abs[n][n5].getArcCenter().x;
                    d4 = this.abs[n][n5].getArcCenter().y;
                    double_ = this.abs[n][n5].getArcCenter();
                    n5 = this.addVertex;
                }
                Rectangle rectangle2 = new Rectangle((int)(d3 -= d), (int)(d4 -= d2), n3, n2);
                PieLabelModification pieLabelModification = new PieLabelModification(arrayList, this.getChartDataSetModel, rectangle2, this.doubleValue, double_, n, this.getChartLinkInfo, this.getChartLink);
                if (this.valueLabelPosition == 49) {
                    boolean bl2 = pieLabelModification.islabelovrlap();
                    if (bl2) {
                        ArrayList arrayList2 = pieLabelModification.setLabelsLocation();
                        for (int i = 0; i < this.addVertex; ++i) {
                            if (arrayList2.get(i) != null) {
                                Point2D.Double double_2 = (Point2D.Double)arrayList2.get(i);
                                this.abs[n][i].getLabelPosition().y = double_2.y;
                                this.abs[n][i].setOverlaped();
                                continue;
                            }
                            this.abs[n][i].setLabelPosition(null);
                        }
                    }
                    for (n6 = 0; n6 < this.addVertex; ++n6) {
                        if (this.abs[n][n6] == null || this.abs[n][n6].getLabelPosition() == null || this.abs[n][n6].getStartPoint() == null || this.abs[n][n6].getValueLabel() == null) continue;
                        if (!bl2) {
                            pieLabelModification.moveSlimLegLabel(rectangle2, this.abs[n][n6], this.abs[n][n6].getLabelPosition(), this.abs[n][n6].getValueLabel().getLabelBaseDimension().width, this.abs[n][n6].LabelSide());
                            continue;
                        }
                        pieLabelModification.moveSlimLegLabel(rectangle2, this.abs[n][n6], this.abs[n][n6].getLabelPosition(), this.abs[n][n6].getValueLabel().getLabelBaseDimension().width, this.abs[n][n6].LabelSide(), true);
                    }
                } else {
                    ArrayList arrayList3 = pieLabelModification.adjustLabelLocation();
                    for (n6 = 0; n6 < this.addVertex; ++n6) {
                        Point2D.Double double_3 = (Point2D.Double)arrayList3.get(n6);
                        if (this.abs[n][n6] == null || this.abs[n][n6].isLabelInSlice()) continue;
                        this.abs[n][n6].setLabelPosition(double_3);
                    }
                }
            }
            arrayList.clear();
        }
    }

    public void setIsDonut(boolean bl) {
        this.getCondition = bl;
    }

    public boolean isDonut() {
        return this.getCondition;
    }

    @Override
    public int[] searchLinkInfo(int n, int n2) {
        int[] nArray = null;
        int n3 = this.LabelSide.getShowValueBeginIndex();
        int n4 = this.LabelSide.getShowValueEndIndex();
        int n5 = n4 - n3;
        int n6 = this.adjustLabelLocation / n5;
        for (int i = 0; i < this.adjustLabelLocation; ++i) {
            for (int j = 0; j < this.addVertex; ++j) {
                if (!this.filter[i][j].contains(n, n2)) continue;
                ChartShowValueCondition chartShowValueCondition = this.LabelSide.getCondition(i, j);
                int n7 = 0;
                n7 = i + 1 > n6 ? i - i / n6 * n6 : i;
                if (chartShowValueCondition != null && chartShowValueCondition.getChartLink() != null) {
                    nArray = ((ChartDataUsedInfo)((List)chartShowValueCondition.getChartLink().get(n7)).get(j)).getChartLinkInfo();
                }
                return nArray;
            }
        }
        return null;
    }
}

