/*
 * Decompiled with CFR 0.152.
 */
package chart.chart3d;

import chart.ChartDataObject;
import chart.ChartShowValueCondition;
import chart.axis.ChartCategoryAxis;
import chart.chart3d.Chart3DObject;
import chart.chart3d.Chart3DPaper;
import chart.chart3d.Chart3DStrip;
import chart.chart3d.ChartCompass;
import chart.chart3d.ChartMatrix;
import chart.data.Chart1DDataSet;
import chart.data.ChartDataSet;
import chart.data.ChartDataUsedInfo;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartPenStyle;
import chart.properties.ChartNumericAxisProperties;
import chart.util.ChartHintLabel;
import chart.util.ChartMath;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.util.List;

public class Graph3DAreaA
extends Chart3DObject {
    int[] appendCover;
    boolean[][] areaSurface;
    protected Chart3DStrip[][] strip;
    protected Chart3DStrip[][] bottom;
    protected Chart3DStrip[][][][] areas;
    protected ChartFillPattern[] pattern;
    protected ChartCompass compass;
    int availableLength;
    int availableOriginY;
    boolean availableValue;
    private ChartPenStyle bottomCover;
    GeneralPath closePath;
    protected boolean outerAscending;
    protected boolean innerAscending;
    protected boolean toUpAscending;
    float[] contains;
    Rectangle custommerConstant = new Rectangle();
    float[][] draw;
    int drawArea = 2;
    float[] drawAreaSurface;
    int[][][][] drawSelectedOutLine;
    Color[] fill;
    float floatValue;
    private ChartShowValueCondition get = null;
    protected Chart3DStrip[][] sideArea;
    private boolean getAbsoluteValueSumOfCategory = true;

    Graph3DAreaA(ChartDataSet chartDataSet, Chart3DPaper chart3DPaper) {
        super(chartDataSet, chart3DPaper);
        this.dataset = chartDataSet;
        this.appendCover = chart3DPaper.getIntType();
        this.paper = chart3DPaper;
        this.availableLength = chartDataSet.getCategorySize();
        this.availableOriginY = chartDataSet.getSeriesSize();
        this.pattern = chart3DPaper.getChartPlatform().getFillPatternByArarry(0);
        this.floatValue = chart3DPaper.getProperties().getGraphProperties().getThresholdFillTransparency();
    }

    @Override
    public void locate() {
    }

    @Override
    void transform(ChartMatrix chartMatrix) {
        int n;
        int n2;
        if (this.availableLength < 2) {
            return;
        }
        for (n2 = 0; n2 < this.availableOriginY; ++n2) {
            if (this.strip[n2] == null) continue;
            for (n = 0; n < this.strip[n2].length; ++n) {
                this.strip[n2][n].transform(chartMatrix);
                this.bottom[n2][n].transform(chartMatrix);
                for (int i = 0; i < this.drawArea; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        this.areas[n2][n][i][j].transform(chartMatrix);
                    }
                }
            }
        }
        if (this.sideArea != null && this.sideArea.length > 0) {
            for (n2 = 0; n2 < this.drawArea; ++n2) {
                for (n = 0; n < this.sideArea[n2].length; ++n) {
                    this.sideArea[n2][n].transform(chartMatrix);
                }
            }
        }
        this.SEDU();
    }

    @Override
    public void init() {
        float f;
        float f2;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        this.closePath = new GeneralPath();
        this.availableValue = this.paper.getProperties().getGraphProperties().isContour();
        this.bottomCover = this.properties.getGraphProperties().getContourPen();
        boolean bl = this.getAbsoluteValueSumOfCategory = !this.paper.getProperties().isIgnoreNullValue();
        if (this.availableLength < 2) {
            return;
        }
        this.setCompass(this.paper.getCompass());
        this.strip = new Chart3DStrip[this.availableOriginY][];
        this.bottom = new Chart3DStrip[this.availableOriginY][];
        this.areas = new Chart3DStrip[this.availableOriginY][][][];
        this.drawSelectedOutLine = new int[this.availableOriginY][][][];
        this.contains = this.paper.getUnit();
        float f3 = 20.0f;
        if (f3 > this.contains[2]) {
            f3 = this.contains[2];
        }
        float f4 = 0.0f;
        f4 = this.paper.availableOriginY(this.paper.getOriginY());
        float f5 = this.contains[0];
        float f6 = 0.0f;
        float f7 = this.contains[2] / 2.0f - f3 / 2.0f;
        float f8 = this.contains[2];
        this.draw = new float[this.availableOriginY][this.availableLength];
        this.areaSurface = new boolean[this.availableOriginY][];
        float[] fArray = new float[this.availableLength];
        if (this.dataset.getChartDataSetModel().isOneGroupForBar()) {
            for (n5 = 0; n5 < this.availableLength; ++n5) {
                for (int i = 0; i < this.availableLength; ++i) {
                    fArray[n5] = fArray[n5] + (float)((Chart1DDataSet)this.dataset).getAbsoluteValueSumOfCategory(i);
                }
                fArray[n5] = fArray[n5] == 0.0f ? 1.0f : fArray[n5];
            }
        } else {
            for (n5 = 0; n5 < this.availableLength; ++n5) {
                fArray[n5] = (float)((Chart1DDataSet)this.dataset).getAbsoluteValueSumOfCategory(n5);
            }
        }
        int[] nArray = new int[this.availableOriginY];
        for (n4 = 0; n4 < this.availableOriginY; ++n4) {
            for (n3 = 0; n3 < this.availableLength - 1; ++n3) {
                Number number = ((Chart1DDataSet)this.dataset).getValue(n4, n3);
                Number number2 = ((Chart1DDataSet)this.dataset).getValue(n4, n3 + 1);
                float f9 = number == null ? 0.0f : number.floatValue();
                float f10 = number2 == null ? 0.0f : number2.floatValue();
                if (f9 > 0.0f && f10 < 0.0f || f9 < 0.0f && f10 > 0.0f) {
                    int n6 = n4;
                    nArray[n6] = nArray[n6] + 1;
                }
                this.draw[n4][n3] = f9;
                if (n3 != this.availableLength - 2) continue;
                this.draw[n4][n3 + 1] = f10;
            }
        }
        if (((ChartNumericAxisProperties)this.paper.C.getProperties()).getIsShowPercent()) {
            for (n4 = 0; n4 < this.availableOriginY; ++n4) {
                for (n3 = 0; n3 < this.availableLength; ++n3) {
                    this.draw[n4][n3] = this.draw[n4][n3] / fArray[n3];
                }
            }
        }
        if (this.paper.getProperties().getGraphProperties().isShowThresholdLine() && this.paper.getProperties().getGraphProperties().isShowThresholdLine2()) {
            this.drawArea = 2;
            this.drawAreaSurface = new float[this.drawArea];
            this.fill = new Color[this.drawArea];
            this.drawAreaSurface[0] = (float)this.paper.getProperties().getGraphProperties().getThresholdValue();
            this.drawAreaSurface[1] = (float)this.paper.getProperties().getGraphProperties().getThresholdValue2();
            this.fill[0] = this.paper.getProperties().getGraphProperties().getThresholdLineColor();
            this.fill[1] = this.paper.getProperties().getGraphProperties().getThresholdLineColor2();
        } else if (this.paper.getProperties().getGraphProperties().isShowThresholdLine()) {
            this.drawArea = 1;
            this.drawAreaSurface = new float[this.drawArea];
            this.fill = new Color[this.drawArea];
            this.drawAreaSurface[0] = (float)this.paper.getProperties().getGraphProperties().getThresholdValue();
            this.fill[0] = this.paper.getProperties().getGraphProperties().getThresholdLineColor();
        } else if (this.paper.getProperties().getGraphProperties().isShowThresholdLine2()) {
            this.drawArea = 1;
            this.drawAreaSurface = new float[this.drawArea];
            this.fill = new Color[this.drawArea];
            this.drawAreaSurface[0] = (float)this.paper.getProperties().getGraphProperties().getThresholdValue2();
            this.fill[0] = this.paper.getProperties().getGraphProperties().getThresholdLineColor2();
        } else {
            this.drawArea = 0;
            this.drawAreaSurface = new float[this.drawArea];
            this.fill = new Color[this.drawArea];
        }
        for (n4 = 0; n4 < this.drawArea; ++n4) {
            float f11 = 0.0f;
            for (n2 = n4; n2 < this.drawArea; ++n2) {
                if (!(this.drawAreaSurface[n4] > this.drawAreaSurface[n2])) continue;
                f11 = this.drawAreaSurface[n2];
                this.drawAreaSurface[n2] = this.drawAreaSurface[n4];
                this.drawAreaSurface[n4] = f11;
                Color color = this.fill[n2];
                this.fill[n2] = this.fill[n4];
                this.fill[n4] = color;
            }
        }
        float[] fArray2 = new float[this.drawArea];
        for (n = 0; n < this.drawArea; ++n) {
            fArray2[n] = this.paper.availableLength(this.drawAreaSurface[n] * this.contains[1]);
            if (!(fArray2[n] < 2.0f) || fArray2[n] == 0.0f) continue;
            fArray2[n] = fArray2[n] + 3.0f;
        }
        for (n = 0; n < this.availableOriginY; ++n) {
            int n7 = this.availableLength - 1 + nArray[n];
            this.strip[n] = new Chart3DStrip[n7];
            this.bottom[n] = new Chart3DStrip[n7];
            this.areaSurface[n] = new boolean[n7 + 1];
            this.areas[n] = new Chart3DStrip[n7][this.drawArea][3];
            this.drawSelectedOutLine[n] = new int[n7][this.drawArea][4];
        }
        if (this.paper.getAxisX1().custommerConstant()) {
            this.sideArea = new Chart3DStrip[this.drawArea][2];
            for (n = 0; n < this.drawArea; ++n) {
                this.sideArea[n][0] = new Chart3DStrip(this.pattern[0], this.availableValue, this.bottomCover);
                this.sideArea[n][1] = new Chart3DStrip(this.pattern[0], this.availableValue, this.bottomCover);
                this.sideArea[n][0].setThresholdColor(this.fill[n], this.floatValue);
                this.sideArea[n][1].setThresholdColor(this.fill[n], this.floatValue);
            }
        }
        float f12 = f6;
        float f13 = f7;
        float f14 = 0.0f;
        float f15 = 0.0f;
        float f16 = 0.0f;
        float f17 = 0.0f;
        float f18 = 0.0f;
        ChartCategoryAxis chartCategoryAxis = (ChartCategoryAxis)this.paper.getAxisX1();
        if (this.paper.getAxisX1().custommerConstant()) {
            for (n2 = 0; n2 < this.drawArea; ++n2) {
                Object object = this.getChartDataSet().getChartDataSetModel().getCategoryName(0);
                f2 = chartCategoryAxis.getX(object, this.contains[0]);
                f14 = chartCategoryAxis.getX(object, this.contains[0]);
                this.sideArea[n2][0].setLineVertex1(0.0f, fArray2[n2], 0.0f, 0.0f, this.contains[2] * (float)this.availableOriginY, f2);
                object = this.getChartDataSet().getChartDataSetModel().getCategoryName(this.availableLength - 1);
                f = chartCategoryAxis.getX(object, this.contains[0]);
                this.sideArea[n2][1].setLineVertex1(f, fArray2[n2], 0.0f, 0.0f, this.contains[2] * (float)this.availableOriginY, this.paper.getLength()[0] - f);
            }
        }
        for (n2 = 0; n2 < this.availableOriginY; ++n2) {
            float f19 = f13;
            n = 0;
            for (int i = 0; i < this.availableLength - 1; ++i) {
                int n8;
                Object object;
                if (!this.getAbsoluteValueSumOfCategory) {
                    Object object2;
                    Number number = ((Chart1DDataSet)this.dataset).getValue(n2, i);
                    if (number == null) {
                        if (this.paper.getAxisX1().custommerConstant()) {
                            Object object3 = this.getChartDataSet().getChartDataSetModel().getCategoryName(i);
                            f12 = f = chartCategoryAxis.getX(object3, this.contains[0]);
                        }
                        float[] fArray3 = new float[2];
                        float[] fArray4 = new float[2];
                        object = ((Chart1DDataSet)this.dataset).getNotNullBeforeAndAfterIndex(n2, i);
                        if (object[0] != -1) {
                            if (!this.paper.getAxisX1().custommerConstant()) {
                                fArray3[0] = (float)object[0] * f5;
                            } else {
                                object2 = this.getChartDataSet().getChartDataSetModel().getCategoryName(object[0]);
                                fArray3[0] = chartCategoryAxis.getX(object2, this.contains[0]);
                            }
                            fArray3[1] = this.paper.availableValue(this.draw[n2][object[0]]) * this.contains[1] + f4;
                        }
                        if (object[1] != -1) {
                            if (!this.paper.getAxisX1().custommerConstant()) {
                                fArray4[0] = (float)object[1] * f5;
                            } else {
                                object2 = this.getChartDataSet().getChartDataSetModel().getCategoryName(object[1]);
                                fArray4[0] = chartCategoryAxis.getX(object2, this.contains[0]);
                            }
                            fArray4[1] = this.paper.availableValue(this.draw[n2][object[1]]) * this.contains[1] + f4;
                        }
                        if (object[0] != -1 && object[1] != -1) {
                            f17 = ChartMath.getYforUsedStartAndEndPoint(fArray3, fArray4, f12);
                        } else {
                            f18 = this.paper.availableValue(this.draw[n2][i]);
                            f17 = f18 * this.contains[1] + f4;
                        }
                    } else {
                        f18 = this.paper.availableValue(this.draw[n2][i]);
                        f17 = f18 * this.contains[1] + f4;
                        if (this.paper.getAxisX1().custommerConstant()) {
                            Object object4 = this.getChartDataSet().getChartDataSetModel().getCategoryName(i);
                            f12 = f = chartCategoryAxis.getX(object4, this.contains[0]);
                        }
                    }
                    number = ((Chart1DDataSet)this.dataset).getValue(n2, i + 1);
                    if (number == null) {
                        if (this.paper.getAxisX1().custommerConstant()) {
                            float f20;
                            Object object5 = this.getChartDataSet().getChartDataSetModel().getCategoryName(i + 1);
                            f14 = f20 = chartCategoryAxis.getX(object5, this.contains[0]);
                        } else {
                            f14 = f12 + f5;
                        }
                        float[] fArray5 = new float[2];
                        float[] fArray6 = new float[2];
                        object = ((Chart1DDataSet)this.dataset).getNotNullBeforeAndAfterIndex(n2, i + 1);
                        if (object[0] != -1) {
                            if (!this.paper.getAxisX1().custommerConstant()) {
                                fArray5[0] = (float)object[0] * f5;
                            } else {
                                object2 = this.getChartDataSet().getChartDataSetModel().getCategoryName(object[0]);
                                fArray5[0] = chartCategoryAxis.getX(object2, this.contains[0]);
                            }
                            fArray5[1] = this.paper.availableValue(this.draw[n2][object[0]]) * this.contains[1] + f4;
                        }
                        if (object[1] != -1) {
                            if (!this.paper.getAxisX1().custommerConstant()) {
                                fArray6[0] = (float)object[1] * f5;
                            } else {
                                object2 = this.getChartDataSet().getChartDataSetModel().getCategoryName(object[1]);
                                fArray6[0] = chartCategoryAxis.getX(object2, this.contains[0]);
                            }
                            fArray6[1] = this.paper.availableValue(this.draw[n2][object[1]]) * this.contains[1] + f4;
                        }
                        if (object[0] != -1 && object[1] != -1) {
                            f15 = ChartMath.getYforUsedStartAndEndPoint(fArray5, fArray6, f14);
                        } else {
                            f18 = this.paper.availableValue(this.draw[n2][i + 1]);
                            f15 = f18 * this.contains[1] + f4;
                        }
                    } else {
                        f18 = this.paper.availableValue(this.draw[n2][i + 1]);
                        f15 = f18 * this.contains[1] + f4;
                        if (this.paper.getAxisX1().custommerConstant()) {
                            float f21;
                            Object object6 = this.getChartDataSet().getChartDataSetModel().getCategoryName(i + 1);
                            f14 = f21 = chartCategoryAxis.getX(object6, this.contains[0]);
                        } else {
                            f14 = f12 + f5;
                        }
                    }
                } else {
                    f14 = f12 + f5;
                    if (this.paper.getAxisX1().custommerConstant()) {
                        Object object7 = this.getChartDataSet().getChartDataSetModel().getCategoryName(i);
                        f12 = f = chartCategoryAxis.getX(object7, this.contains[0]);
                        object7 = this.getChartDataSet().getChartDataSetModel().getCategoryName(i + 1);
                        f14 = chartCategoryAxis.getX(object7, this.contains[0]);
                    }
                    f18 = this.draw[n2][i];
                    f16 = this.draw[n2][i + 1];
                    f17 = f18 * this.contains[1];
                    f15 = f16 * this.contains[1];
                    f17 = this.paper.availableLength(f17);
                    f15 = this.paper.availableLength(f15);
                }
                f2 = 0.0f;
                f = 0.0f;
                if (this.paper.getAxisX1().custommerConstant()) {
                    f = f12;
                    object = this.getChartDataSet().getChartDataSetModel().getCategoryName(i + 1);
                    float f22 = chartCategoryAxis.getX(object, this.contains[0]);
                    f2 = f22 - f12;
                    if (i != this.availableLength - 2) {
                        object = this.getChartDataSet().getChartDataSetModel().getCategoryName(i + 1);
                        f22 = chartCategoryAxis.getX(object, this.contains[0]);
                        f2 = f22 - f12;
                    }
                } else {
                    f = this.contains[0] * (float)i;
                    f2 = this.contains[0];
                }
                if (this.draw[n2][i] > 0.0f && this.draw[n2][i + 1] < 0.0f || this.draw[n2][i] < 0.0f && this.draw[n2][i + 1] > 0.0f) {
                    float f23 = ChartMath.isEquals(f15, f17) ? f14 : (f12 * f15 + (f14 - f12) * f4 - f14 * f17) / (f15 - f17);
                    this.strip[n2][i + n] = new Chart3DStrip(this.pattern[n2], this.availableValue, this.bottomCover);
                    this.strip[n2][i + n].setAreaSurfaceVertex(f12, f17, f13, f23, f4, f13, f3);
                    this.strip[n2][i + n].setStartValue(this.draw[n2][i]);
                    this.strip[n2][i + n].setEndValue(0.0f);
                    this.strip[n2][i + n + 1] = new Chart3DStrip(this.pattern[n2], this.availableValue, this.bottomCover);
                    this.strip[n2][i + n + 1].setAreaSurfaceVertex(f23, f4, f13, f14, f15, f13, f3);
                    this.strip[n2][i + n + 1].setStartValue(0.0f);
                    this.strip[n2][i + n + 1].setEndValue(this.draw[n2][i + 1]);
                    this.bottom[n2][i + n] = new Chart3DStrip(this.pattern[n2], this.availableValue, this.bottomCover);
                    this.bottom[n2][i + n].setAreaSurfaceVertex(f12, f4, f13, f23, f4, f19, f3);
                    this.bottom[n2][i + n + 1] = new Chart3DStrip(this.pattern[n2], this.availableValue, this.bottomCover);
                    this.bottom[n2][i + n + 1].setAreaSurfaceVertex(f23, f4, f13, f14, f4, f19, f3);
                    if (this.draw[n2][i] > 0.0f) {
                        this.areaSurface[n2][i + n + 1] = true;
                    } else {
                        this.areaSurface[n2][i + n] = true;
                    }
                    for (n8 = 0; n8 < 2; ++n8) {
                        for (int j = 0; j < this.drawArea; ++j) {
                            this.drawSelectedOutLine[n2][i + n + n8][j][0] = 0;
                            this.drawSelectedOutLine[n2][i + n + n8][j][1] = 0;
                            this.drawSelectedOutLine[n2][i + n + n8][j][2] = 0;
                            this.drawSelectedOutLine[n2][i + n + n8][j][3] = 0;
                            this.areas[n2][i + n + n8][j][0] = new Chart3DStrip(this.pattern[0], this.availableValue, this.bottomCover);
                            this.areas[n2][i + n + n8][j][1] = new Chart3DStrip(this.pattern[0], this.availableValue, this.bottomCover);
                            this.areas[n2][i + n + n8][j][2] = new Chart3DStrip(this.pattern[0], this.availableValue, this.bottomCover);
                            this.areas[n2][i + n + n8][j][0].setThresholdColor(this.fill[j], this.floatValue);
                            this.areas[n2][i + n + n8][j][1].setThresholdColor(this.fill[j], this.floatValue);
                            this.areas[n2][i + n + n8][j][2].setThresholdColor(this.fill[j], this.floatValue);
                        }
                    }
                    for (n8 = 0; n8 < this.drawArea; ++n8) {
                        if (fArray2[n8] < f17 && fArray2[n8] > f15) {
                            if (fArray2[n8] > f4) {
                                this.areas[n2][i + n][n8][2].setLineVertex1(f + (fArray2[n8] - f17) / (f4 - f17) * (f23 - f12), fArray2[n8], (float)n2 * this.contains[2] + this.contains[2] / 2.0f - f3 / 2.0f, 0.0f, f3, f23 - f12 - (fArray2[n8] - f17) / (f4 - f17) * (f23 - f12));
                                int[] nArray2 = this.drawSelectedOutLine[n2][i + n][n8];
                                nArray2[1] = nArray2[1] + 1;
                                continue;
                            }
                            this.areas[n2][i + n + 1][n8][2].setLineVertex1(f23, fArray2[n8], (float)n2 * this.contains[2] + this.contains[2] / 2.0f - f3 / 2.0f, 0.0f, f3, f14 - f23 - (fArray2[n8] - f15) / (f4 - f15) * (f14 - f23));
                            int[] nArray3 = this.drawSelectedOutLine[n2][i + n + 1][n8];
                            nArray3[3] = nArray3[3] + 1;
                            continue;
                        }
                        if (!(fArray2[n8] > f17) || !(fArray2[n8] < f15)) continue;
                        if (fArray2[n8] > f4) {
                            this.areas[n2][i + n + 1][n8][2].setLineVertex1(f23, fArray2[n8], (float)n2 * this.contains[2] + this.contains[2] / 2.0f - f3 / 2.0f, 0.0f, f3, f14 - f23 - (fArray2[n8] - f15) / (f4 - f15) * (f14 - f23));
                            int[] nArray4 = this.drawSelectedOutLine[n2][i + n + 1][n8];
                            nArray4[1] = nArray4[1] + 1;
                            continue;
                        }
                        this.areas[n2][i + n][n8][2].setLineVertex1(f + (fArray2[n8] - f17) / (f4 - f17) * (f23 - f12), fArray2[n8], (float)n2 * this.contains[2] + this.contains[2] / 2.0f - f3 / 2.0f, 0.0f, f3, f23 - f12 - (fArray2[n8] - f17) / (f4 - f17) * (f23 - f12));
                        int[] nArray5 = this.drawSelectedOutLine[n2][i + n][n8];
                        nArray5[3] = nArray5[3] + 1;
                    }
                    for (n8 = 0; n8 < this.drawArea; ++n8) {
                        if (fArray2[n8] > f4) {
                            if (fArray2[n8] > f17) {
                                this.areas[n2][i + n][n8][2].setLineVertex1(f, fArray2[n8], (float)n2 * this.contains[2] + this.contains[2] / 2.0f - f3 / 2.0f, 0.0f, f3, f23 - f12);
                                int[] nArray6 = this.drawSelectedOutLine[n2][i + n][n8];
                                nArray6[0] = nArray6[0] + 1;
                            }
                            if (!(fArray2[n8] > f15)) continue;
                            this.areas[n2][i + n + 1][n8][2].setLineVertex1(f23, fArray2[n8], (float)n2 * this.contains[2] + this.contains[2] / 2.0f - f3 / 2.0f, 0.0f, f3, f14 - f23);
                            int[] nArray7 = this.drawSelectedOutLine[n2][i + n + 1][n8];
                            nArray7[0] = nArray7[0] + 1;
                            continue;
                        }
                        if (!(fArray2[n8] < f4)) continue;
                        if (fArray2[n8] < f17) {
                            this.areas[n2][i + n][n8][2].setLineVertex1(f, fArray2[n8], (float)n2 * this.contains[2] + this.contains[2] / 2.0f - f3 / 2.0f, 0.0f, f3, f23 - f12);
                            int[] nArray8 = this.drawSelectedOutLine[n2][i + n][n8];
                            nArray8[2] = nArray8[2] + 1;
                        }
                        if (!(fArray2[n8] < f15)) continue;
                        this.areas[n2][i + n + 1][n8][2].setLineVertex1(f23, fArray2[n8], (float)n2 * this.contains[2] + this.contains[2] / 2.0f - f3 / 2.0f, 0.0f, f3, f14 - f23);
                        int[] nArray9 = this.drawSelectedOutLine[n2][i + n + 1][n8];
                        nArray9[2] = nArray9[2] + 1;
                    }
                    ++n;
                } else {
                    this.strip[n2][i + n] = new Chart3DStrip(this.pattern[n2], this.availableValue, this.bottomCover);
                    this.strip[n2][i + n].setAreaSurfaceVertex(f12, f17, f13, f14, f15, f19, f3);
                    this.strip[n2][i + n].setStartValue(this.draw[n2][i]);
                    this.strip[n2][i + n].setEndValue(this.draw[n2][i + 1]);
                    this.bottom[n2][i + n] = new Chart3DStrip(this.pattern[n2], this.availableValue, this.bottomCover);
                    this.bottom[n2][i + n].setAreaSurfaceVertex(f12, f4, f13, f14, f4, f19, f3);
                    if (this.draw[n2][i] < 0.0f) {
                        this.areaSurface[n2][i + n] = true;
                    }
                    if (this.draw[n2][i + 1] < 0.0f) {
                        this.areaSurface[n2][i + n + 1] = true;
                    }
                    for (n8 = 0; n8 < this.drawArea; ++n8) {
                        this.drawSelectedOutLine[n2][i + n][n8][0] = 0;
                        this.drawSelectedOutLine[n2][i + n][n8][1] = 0;
                        this.drawSelectedOutLine[n2][i + n][n8][2] = 0;
                        this.drawSelectedOutLine[n2][i + n][n8][3] = 0;
                        this.areas[n2][i + n][n8][0] = new Chart3DStrip(this.pattern[0], this.availableValue, this.bottomCover);
                        this.areas[n2][i + n][n8][1] = new Chart3DStrip(this.pattern[0], this.availableValue, this.bottomCover);
                        this.areas[n2][i + n][n8][2] = new Chart3DStrip(this.pattern[0], this.availableValue, this.bottomCover);
                        this.areas[n2][i + n][n8][0].setThresholdColor(this.fill[n8], this.floatValue);
                        this.areas[n2][i + n][n8][1].setThresholdColor(this.fill[n8], this.floatValue);
                        this.areas[n2][i + n][n8][2].setThresholdColor(this.fill[n8], this.floatValue);
                    }
                    for (n8 = 0; n8 < this.drawArea; ++n8) {
                        if (fArray2[n8] < f17 && fArray2[n8] > f15) {
                            if (fArray2[n8] > f4) {
                                this.areas[n2][i][n8][2].setLineVertex1(f + (fArray2[n8] - f17) / (f15 - f17) * f2, fArray2[n8], (float)n2 * this.contains[2] + this.contains[2] / 2.0f - f3 / 2.0f, 0.0f, f3, f2 - (fArray2[n8] - f17) / (f15 - f17) * f2);
                                int[] nArray10 = this.drawSelectedOutLine[n2][i][n8];
                                nArray10[1] = nArray10[1] + 1;
                                continue;
                            }
                            this.areas[n2][i][n8][2].setLineVertex1(f, fArray2[n8], (float)n2 * this.contains[2] + this.contains[2] / 2.0f - f3 / 2.0f, 0.0f, f3, (fArray2[n8] - f17) / (f15 - f17) * f2);
                            int[] nArray11 = this.drawSelectedOutLine[n2][i][n8];
                            nArray11[3] = nArray11[3] + 1;
                            continue;
                        }
                        if (!(fArray2[n8] > f17) || !(fArray2[n8] < f15)) continue;
                        if (fArray2[n8] > f4) {
                            this.areas[n2][i][n8][2].setLineVertex1(f, fArray2[n8], (float)n2 * this.contains[2] + this.contains[2] / 2.0f - f3 / 2.0f, 0.0f, f3, (fArray2[n8] - f17) / (f15 - f17) * f2);
                            int[] nArray12 = this.drawSelectedOutLine[n2][i][n8];
                            nArray12[1] = nArray12[1] + 1;
                            continue;
                        }
                        this.areas[n2][i][n8][2].setLineVertex1(f + (fArray2[n8] - f17) / (f15 - f17) * f2, fArray2[n8], (float)n2 * this.contains[2] + this.contains[2] / 2.0f - f3 / 2.0f, 0.0f, f3, f2 - (fArray2[n8] - f17) / (f15 - f17) * f2);
                        int[] nArray13 = this.drawSelectedOutLine[n2][i][n8];
                        nArray13[3] = nArray13[3] + 1;
                    }
                    for (n8 = 0; n8 < this.drawArea; ++n8) {
                        if (fArray2[n8] > f17 && fArray2[n8] > f15 && fArray2[n8] > f4) {
                            this.areas[n2][i][n8][2].setLineVertex1(f, fArray2[n8], (float)n2 * this.contains[2] + this.contains[2] / 2.0f - f3 / 2.0f, 0.0f, f3, f2);
                            int[] nArray14 = this.drawSelectedOutLine[n2][i][n8];
                            nArray14[0] = nArray14[0] + 1;
                            continue;
                        }
                        if (!(fArray2[n8] < f17) || !(fArray2[n8] < f15) || !(fArray2[n8] < f4)) continue;
                        this.areas[n2][i][n8][2].setLineVertex1(f, fArray2[n8], (float)n2 * this.contains[2] + this.contains[2] / 2.0f - f3 / 2.0f, 0.0f, f3, f2);
                        int[] nArray15 = this.drawSelectedOutLine[n2][i][n8];
                        nArray15[2] = nArray15[2] + 1;
                    }
                }
                if (!this.paper.getAxisX1().custommerConstant()) {
                    f12 = f14;
                }
                for (n8 = 0; n8 < this.drawArea; ++n8) {
                    this.areas[n2][i][n8][0].setLineVertex1(f, fArray2[n8], this.contains[2] * (float)n2, 0.0f, this.contains[2] / 2.0f - f3 / 2.0f, f2);
                    this.areas[n2][i][n8][1].setLineVertex1(f, fArray2[n8], this.contains[2] * (float)n2 + this.contains[2] / 2.0f + f3 / 2.0f, 0.0f, this.contains[2] / 2.0f - f3 / 2.0f, f2);
                }
            }
            if (!this.paper.getAxisX1().custommerConstant()) {
                f12 = f6;
            }
            f13 += f8;
        }
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        int n;
        int n2;
        if (this.paper.I.getShowValueConditions() != null && this.paper.I.getShowValueConditions().getConditions() != null && this.paper.I.getShowValueConditions().getConditions().size() > 0) {
            this.get = (ChartShowValueCondition)this.paper.I.getShowValueConditions().getConditions().get(0);
        }
        if (this.availableLength < 2) {
            return;
        }
        if (this.paper.getAxisX1().custommerConstant()) {
            n2 = 0;
            if (!this.innerAscending) {
                n2 = 1;
            }
            if (this.toUpAscending) {
                for (n = 0; n < this.drawArea; ++n) {
                    this.sideArea[n][n2].drawArea(graphics2D, 0);
                }
            } else {
                for (n = this.drawArea - 1; n >= 0; --n) {
                    this.sideArea[n][n2].drawArea(graphics2D, 0);
                }
            }
        }
        for (n2 = 0; n2 < this.availableOriginY; ++n2) {
            int n3;
            int n4;
            n = n2;
            if (!this.outerAscending) {
                n = this.availableOriginY - n2 - 1;
            }
            for (n4 = 0; n4 < this.availableLength - 1; ++n4) {
                n3 = n4;
                if (!this.innerAscending) {
                    n3 = this.availableLength - 1 - n4 - 1;
                }
                for (int i = 0; i < this.drawArea; ++i) {
                    if (!this.outerAscending) {
                        this.areas[n][n3][i][1].drawArea(graphics2D, 0);
                        continue;
                    }
                    this.areas[n][n3][i][0].drawArea(graphics2D, 0);
                }
            }
            for (n4 = 0; n4 < this.strip[n].length; ++n4) {
                int n5;
                int n6;
                n3 = n4;
                if (!this.innerAscending) {
                    n3 = this.strip[n].length - n4 - 1;
                }
                float f = this.strip[n][n3].getStartValue();
                float f2 = this.strip[n][n3].getEndValue();
                float f3 = this.paper.getMinAxisValue();
                float f4 = this.paper.getMaxAxisValue();
                float f5 = this.paper.getMaxAxisValue();
                if (f > 0.0f || f2 > 0.0f) {
                    if (f4 > f) {
                        f4 = f;
                    }
                    if (f5 > f2) {
                        f5 = f2;
                    }
                    if (f3 < 0.0f) {
                        f3 = 0.0f;
                    } else {
                        if (f3 > f) {
                            f4 = f3;
                        }
                        if (f3 > f2) {
                            f5 = f3;
                        }
                    }
                } else {
                    if (!(f > f4)) {
                        f4 = f > f3 ? f : f3;
                    }
                    if (!(f2 > this.paper.getMaxAxisValue())) {
                        f5 = f2 > f3 ? f2 : f3;
                    }
                    f3 = this.paper.getMaxAxisValue() < 0.0f ? this.paper.getMaxAxisValue() : 0.0f;
                }
                this.strip[n][n3].setValueScope(f3, f4, f5, f4, f5, this.drawAreaSurface);
                this.strip[n][n3].setConditionalFill(this.get);
                this.bottom[n][n3].setConditionalFill(this.get);
                this.bottom[n][n3].setValueScope(f3, f3, f3, f3, f3, this.drawAreaSurface);
                if ((this.paper.getShownFace() >> 3 & 1) == 1) {
                    if (this.areaSurface[n][n3]) {
                        for (n6 = 0; n6 < this.drawArea; ++n6) {
                            for (n5 = 0; n5 < this.drawSelectedOutLine[n][n3][n6][2]; ++n5) {
                                this.areas[n][n3][n6][2].drawArea(graphics2D, n5 + this.drawSelectedOutLine[n][n3][n6][0] + this.drawSelectedOutLine[n][n3][n6][1] + this.drawSelectedOutLine[n][n3][n6][3]);
                            }
                            for (n5 = 0; n5 < this.drawSelectedOutLine[n][n3][n6][3]; ++n5) {
                                this.areas[n][n3][n6][2].drawArea(graphics2D, n5);
                            }
                        }
                        this.strip[n][n3].drawAreaSurface(graphics2D, this.availableValue);
                        this.bottom[n][n3].drawAreaSurface(graphics2D, this.availableValue);
                        for (n6 = 0; n6 < this.drawArea; ++n6) {
                            for (n5 = 0; n5 < this.drawSelectedOutLine[n][n3][n6][1]; ++n5) {
                                this.areas[n][n3][n6][2].drawArea(graphics2D, n5 + this.drawSelectedOutLine[n][n3][n6][3]);
                            }
                            for (n5 = 0; n5 < this.drawSelectedOutLine[n][n3][n6][0]; ++n5) {
                                this.areas[n][n3][n6][2].drawArea(graphics2D, n5 + this.drawSelectedOutLine[n][n3][n6][1] + this.drawSelectedOutLine[n][n3][n6][3]);
                            }
                        }
                        continue;
                    }
                    for (n6 = 0; n6 < this.drawArea; ++n6) {
                        for (n5 = 0; n5 < this.drawSelectedOutLine[n][n3][n6][2]; ++n5) {
                            this.areas[n][n3][n6][2].drawArea(graphics2D, n5 + this.drawSelectedOutLine[n][n3][n6][0] + this.drawSelectedOutLine[n][n3][n6][1] + this.drawSelectedOutLine[n][n3][n6][3]);
                        }
                        for (n5 = 0; n5 < this.drawSelectedOutLine[n][n3][n6][3]; ++n5) {
                            this.areas[n][n3][n6][2].drawArea(graphics2D, n5);
                        }
                    }
                    this.bottom[n][n3].drawAreaSurface(graphics2D, this.availableValue);
                    this.strip[n][n3].drawAreaSurface(graphics2D, this.availableValue);
                    for (n6 = 0; n6 < this.drawArea; ++n6) {
                        for (n5 = 0; n5 < this.drawSelectedOutLine[n][n3][n6][1]; ++n5) {
                            this.areas[n][n3][n6][2].drawArea(graphics2D, n5 + this.drawSelectedOutLine[n][n3][n6][3]);
                        }
                        for (n5 = 0; n5 < this.drawSelectedOutLine[n][n3][n6][0]; ++n5) {
                            this.areas[n][n3][n6][2].drawArea(graphics2D, n5 + this.drawSelectedOutLine[n][n3][n6][1] + this.drawSelectedOutLine[n][n3][n6][3]);
                        }
                    }
                    continue;
                }
                if (this.areaSurface[n][n3]) {
                    for (n6 = 0; n6 < this.drawArea; ++n6) {
                        for (n5 = 0; n5 < this.drawSelectedOutLine[n][n3][n6][0]; ++n5) {
                            this.areas[n][n3][n6][2].drawArea(graphics2D, n5 + this.drawSelectedOutLine[n][n3][n6][1] + this.drawSelectedOutLine[n][n3][n6][3]);
                        }
                        for (n5 = 0; n5 < this.drawSelectedOutLine[n][n3][n6][1]; ++n5) {
                            this.areas[n][n3][n6][2].drawArea(graphics2D, n5 + this.drawSelectedOutLine[n][n3][n6][3]);
                        }
                    }
                    this.bottom[n][n3].drawAreaSurface(graphics2D, this.availableValue);
                    this.strip[n][n3].drawAreaSurface(graphics2D, this.availableValue);
                    for (n6 = 0; n6 < this.drawArea; ++n6) {
                        for (n5 = 0; n5 < this.drawSelectedOutLine[n][n3][n6][3]; ++n5) {
                            this.areas[n][n3][n6][2].drawArea(graphics2D, n5);
                        }
                        for (n5 = 0; n5 < this.drawSelectedOutLine[n][n3][n6][2]; ++n5) {
                            this.areas[n][n3][n6][2].drawArea(graphics2D, n5 + this.drawSelectedOutLine[n][n3][n6][1] + this.drawSelectedOutLine[n][n3][n6][0] + this.drawSelectedOutLine[n][n3][n6][3]);
                        }
                    }
                    continue;
                }
                for (n6 = 0; n6 < this.drawArea; ++n6) {
                    for (n5 = 0; n5 < this.drawSelectedOutLine[n][n3][n6][0]; ++n5) {
                        this.areas[n][n3][n6][2].drawArea(graphics2D, n5 + this.drawSelectedOutLine[n][n3][n6][1] + this.drawSelectedOutLine[n][n3][n6][3]);
                    }
                    for (n5 = 0; n5 < this.drawSelectedOutLine[n][n3][n6][1]; ++n5) {
                        this.areas[n][n3][n6][2].drawArea(graphics2D, n5 + this.drawSelectedOutLine[n][n3][n6][3]);
                    }
                }
                this.strip[n][n3].drawAreaSurface(graphics2D, this.availableValue);
                this.bottom[n][n3].drawAreaSurface(graphics2D, this.availableValue);
                for (n6 = 0; n6 < this.drawArea; ++n6) {
                    for (n5 = 0; n5 < this.drawSelectedOutLine[n][n3][n6][3]; ++n5) {
                        this.areas[n][n3][n6][2].drawArea(graphics2D, n5);
                    }
                    for (n5 = 0; n5 < this.drawSelectedOutLine[n][n3][n6][2]; ++n5) {
                        this.areas[n][n3][n6][2].drawArea(graphics2D, n5 + this.drawSelectedOutLine[n][n3][n6][3] + this.drawSelectedOutLine[n][n3][n6][0] + this.drawSelectedOutLine[n][n3][n6][1]);
                    }
                }
            }
            this.paintInnerFace(graphics2D, n);
            this.paintOuterFace(graphics2D, n);
            for (n4 = 0; n4 < this.availableLength - 1; ++n4) {
                n3 = n4;
                if (!this.innerAscending) {
                    n3 = this.availableLength - 1 - n4 - 1;
                }
                for (int i = 0; i < this.drawArea; ++i) {
                    if (!this.outerAscending) {
                        this.areas[n][n3][i][0].drawArea(graphics2D, 0);
                        continue;
                    }
                    this.areas[n][n3][i][1].drawArea(graphics2D, 0);
                }
            }
        }
        if (this.paper.getAxisX1().custommerConstant()) {
            n2 = 0;
            if (this.innerAscending) {
                n2 = 1;
            }
            if (this.toUpAscending) {
                for (n = 0; n < this.drawArea; ++n) {
                    this.sideArea[n][n2].drawArea(graphics2D, 0);
                }
            } else {
                for (n = this.drawArea - 1; n >= 0; --n) {
                    this.sideArea[n][n2].drawArea(graphics2D, 0);
                }
            }
        }
        this.areas(graphics2D);
    }

    @Override
    public Shape getShapeBySeries(int n) {
        return null;
    }

    @Override
    public Shape getShapeByItem(int n, int n2) {
        return this.strip[n][n2].toHtml();
    }

    @Override
    public String[] search(int n, int n2) {
        this.drilldown = null;
        String[] stringArray = null;
        if (this.availableLength < 2) {
            this.selectedSeriesIndex = -1;
            return null;
        }
        Area area = new Area();
        for (int i = 0; i < this.availableOriginY; ++i) {
            int n3 = 0;
            for (int j = 0; j < this.availableLength; ++j) {
                if (j != this.availableLength - 1) {
                    this.custommerConstant = new Rectangle((int)this.strip[i][j + n3].tVertex[0][0] - 5, (int)this.strip[i][j + n3].tVertex[0][1] - 5, 10, 10);
                    if (this.draw[i][j] > 0.0f && this.draw[i][j + 1] < 0.0f || this.draw[i][j] < 0.0f && this.draw[i][j + 1] > 0.0f) {
                        ++n3;
                    }
                } else {
                    this.custommerConstant = new Rectangle((int)this.strip[i][j + n3 - 1].tVertex[1][0] - 5, (int)this.strip[i][j + n3 - 1].tVertex[1][1] - 5, 10, 10);
                }
                if (!this.custommerConstant.contains(n, n2)) continue;
                if (area.contains(this.custommerConstant)) {
                    this.selectedSeriesIndex = -1;
                    return null;
                }
                if (this.paper.getProperties().isShowCategoryAndSeries()) {
                    stringArray = new String[3];
                    ChartHintLabel chartHintLabel = new ChartHintLabel((ChartDataObject)this, this.dataset, this.paper, 3);
                    stringArray = chartHintLabel.hintLabelShowCategoryAndSeries(i, j);
                } else {
                    stringArray = new String[]{this.dataset.getFormatedHintValue(((Chart1DDataSet)this.dataset).getValue(i, j))};
                }
                this.selectedSeriesIndex = i;
                this.drilldown = new int[2];
                this.drilldown[0] = i;
                this.drilldown[1] = j;
                return stringArray;
            }
            this.appendCover(area, i);
        }
        this.selectedSeriesIndex = -1;
        return null;
    }

    protected void appendCover(Area area, int n) {
        area.add(this.outerFaceCover(n));
        area.add(this.innerFaceCover(n));
        area.add(this.bottomCover(n));
    }

    protected void paintInnerFace(Graphics2D graphics2D, int n) {
        float f;
        float f2;
        int n2 = this.strip[n].length - 1;
        this.closePath.reset();
        float[][] fArray = new float[4][2];
        if (!this.innerAscending) {
            this.closePath.moveTo(this.bottom[n][0].tVertex[0][0], this.bottom[n][0].tVertex[0][1]);
            this.closePath.lineTo(this.strip[n][0].tVertex[0][0], this.strip[n][0].tVertex[0][1]);
            this.closePath.lineTo(this.strip[n][0].tVertex[3][0], this.strip[n][0].tVertex[3][1]);
            this.closePath.lineTo(this.bottom[n][0].tVertex[3][0], this.bottom[n][0].tVertex[3][1]);
            this.closePath.lineTo(this.bottom[n][0].tVertex[0][0], this.bottom[n][0].tVertex[0][1]);
            fArray[0][0] = this.bottom[n][0].tVertex[0][0];
            fArray[0][1] = this.bottom[n][0].tVertex[0][1];
            fArray[1][0] = this.strip[n][0].tVertex[0][0];
            fArray[1][1] = this.strip[n][0].tVertex[0][1];
            fArray[3][0] = this.strip[n][0].tVertex[3][0];
            fArray[3][1] = this.strip[n][0].tVertex[3][1];
            fArray[2][0] = this.bottom[n][0].tVertex[3][0];
            fArray[2][1] = this.bottom[n][0].tVertex[3][1];
            f2 = this.strip[n][0].getStartValue();
            f = this.strip[n][0].getStartValue();
        } else {
            this.closePath.moveTo(this.bottom[n][n2].tVertex[1][0], this.bottom[n][n2].tVertex[1][1]);
            this.closePath.lineTo(this.strip[n][n2].tVertex[1][0], this.strip[n][n2].tVertex[1][1]);
            this.closePath.lineTo(this.strip[n][n2].tVertex[2][0], this.strip[n][n2].tVertex[2][1]);
            this.closePath.lineTo(this.bottom[n][n2].tVertex[2][0], this.bottom[n][n2].tVertex[2][1]);
            this.closePath.lineTo(this.bottom[n][n2].tVertex[1][0], this.bottom[n][n2].tVertex[1][1]);
            fArray[0][0] = this.bottom[n][n2].tVertex[1][0];
            fArray[0][1] = this.bottom[n][n2].tVertex[1][1];
            fArray[1][0] = this.strip[n][n2].tVertex[1][0];
            fArray[1][1] = this.strip[n][n2].tVertex[1][1];
            fArray[3][0] = this.strip[n][n2].tVertex[2][0];
            fArray[3][1] = this.strip[n][n2].tVertex[2][1];
            fArray[2][0] = this.bottom[n][n2].tVertex[2][0];
            fArray[2][1] = this.bottom[n][n2].tVertex[2][1];
            f2 = this.strip[n][n2].getEndValue();
            f = this.strip[n][n2].getEndValue();
        }
        int n3 = 0;
        if (this.get != null) {
            n3 = this.get.getConditionType();
        }
        if (n3 == 2) {
            float f3 = f2;
            float f4 = f;
            float f5 = this.paper.getMinAxisValue();
            float f6 = this.paper.getMaxAxisValue();
            float f7 = this.paper.getMaxAxisValue();
            if (f3 > 0.0f || f4 > 0.0f) {
                if (f5 < 0.0f) {
                    f5 = 0.0f;
                }
                if (f6 > f3) {
                    f6 = f3;
                }
                if (f7 > f4) {
                    f7 = f4;
                }
            } else {
                if (!(f3 > f6)) {
                    f6 = f3 > f5 ? f3 : f5;
                }
                if (!(f4 > this.paper.getMaxAxisValue())) {
                    f7 = f4 > f5 ? f4 : f5;
                }
                f5 = this.paper.getMaxAxisValue() < 0.0f ? this.paper.getMaxAxisValue() : 0.0f;
            }
            this.availableOriginY(graphics2D, this.get, fArray, f6, f7, f5, this.closePath);
        } else if (this.pattern[n] != null) {
            this.pattern[n].fill(graphics2D, this.closePath);
        }
        if (this.availableValue) {
            this.bottomCover.draw(graphics2D, this.closePath);
        }
    }

    protected void paintOuterFace(Graphics2D graphics2D, int n) {
        int n2;
        int n3 = this.strip[n].length - 1;
        this.closePath.reset();
        float[][] fArray = new float[4][2];
        int n4 = -1;
        int n5 = -1;
        boolean bl = false;
        boolean bl2 = false;
        float f = 0.0f;
        float f2 = 0.0f;
        if (!this.outerAscending) {
            this.closePath.moveTo(this.bottom[n][0].tVertex[0][0], this.bottom[n][0].tVertex[0][1]);
            for (n2 = 0; n2 <= n3; ++n2) {
                this.closePath.lineTo(this.strip[n][n2].tVertex[0][0], this.strip[n][n2].tVertex[0][1]);
                if (this.strip[n][n2].getStartValue() != 0.0f && !bl) {
                    n4 = n2;
                    f = this.strip[n][n4].getStartValue();
                    bl = true;
                }
                if (this.strip[n][n3 - n2].getEndValue() == 0.0f || bl2) continue;
                n5 = n3 - n2;
                f2 = this.strip[n][n5].getEndValue();
                bl2 = true;
            }
            this.closePath.lineTo(this.strip[n][n3].tVertex[1][0], this.strip[n][n3].tVertex[1][1]);
            this.closePath.lineTo(this.bottom[n][n3].tVertex[1][0], this.bottom[n][n3].tVertex[1][1]);
            this.closePath.lineTo(this.bottom[n][0].tVertex[0][0], this.bottom[n][0].tVertex[0][1]);
            if (n4 == -1 || n5 == -1) {
                fArray[0][0] = this.bottom[n][0].tVertex[0][0];
                fArray[0][1] = this.bottom[n][0].tVertex[0][1];
                fArray[2][0] = this.bottom[n][n3].tVertex[1][0];
                fArray[2][1] = this.bottom[n][n3].tVertex[1][1];
                if (n4 == -1) {
                    n4 = n5;
                    f = f2;
                    fArray[1][0] = this.strip[n][n4].tVertex[1][0];
                    fArray[1][1] = this.strip[n][n4].tVertex[1][1];
                } else {
                    fArray[1][0] = this.strip[n][n4].tVertex[0][0];
                    fArray[1][1] = this.strip[n][n4].tVertex[0][1];
                }
                if (n5 == -1) {
                    n5 = n4;
                    f2 = f;
                    fArray[3][0] = this.strip[n][n5].tVertex[0][0];
                    fArray[3][1] = this.strip[n][n5].tVertex[0][1];
                } else {
                    fArray[3][0] = this.strip[n][n5].tVertex[1][0];
                    fArray[3][1] = this.strip[n][n5].tVertex[1][1];
                }
                if (n4 == -1 && n5 == -1) {
                    n4 = 0;
                    n5 = n3;
                    f2 = this.paper.getMinAxisValue();
                    f = this.paper.getMinAxisValue();
                    fArray[1][0] = this.strip[n][n4].tVertex[0][0];
                    fArray[1][1] = this.strip[n][n4].tVertex[0][1];
                    fArray[3][0] = this.strip[n][n5].tVertex[1][0];
                    fArray[3][1] = this.strip[n][n5].tVertex[1][1];
                }
            } else {
                fArray[0][0] = this.bottom[n][0].tVertex[0][0];
                fArray[0][1] = this.bottom[n][0].tVertex[0][1];
                fArray[1][0] = this.strip[n][n4].tVertex[0][0];
                fArray[1][1] = this.strip[n][n4].tVertex[0][1];
                fArray[3][0] = this.strip[n][n5].tVertex[1][0];
                fArray[3][1] = this.strip[n][n5].tVertex[1][1];
                fArray[2][0] = this.bottom[n][n3].tVertex[1][0];
                fArray[2][1] = this.bottom[n][n3].tVertex[1][1];
            }
        } else {
            this.closePath.moveTo(this.bottom[n][0].tVertex[3][0], this.bottom[n][0].tVertex[3][1]);
            for (n2 = 0; n2 <= n3; ++n2) {
                this.closePath.lineTo(this.strip[n][n2].tVertex[3][0], this.strip[n][n2].tVertex[3][1]);
                if (this.strip[n][n2].getStartValue() != 0.0f && !bl) {
                    n4 = n2;
                    f = this.strip[n][n4].getStartValue();
                    bl = true;
                }
                if (this.strip[n][n3 - n2].getEndValue() == 0.0f || bl2) continue;
                n5 = n3 - n2;
                f2 = this.strip[n][n5].getEndValue();
                bl2 = true;
            }
            this.closePath.lineTo(this.strip[n][n3].tVertex[2][0], this.strip[n][n3].tVertex[2][1]);
            this.closePath.lineTo(this.bottom[n][n3].tVertex[2][0], this.bottom[n][n3].tVertex[2][1]);
            this.closePath.lineTo(this.bottom[n][0].tVertex[3][0], this.bottom[n][0].tVertex[3][1]);
            if (n4 == -1 || n5 == -1) {
                fArray[0][0] = this.bottom[n][0].tVertex[3][0];
                fArray[0][1] = this.bottom[n][0].tVertex[3][1];
                fArray[2][0] = this.bottom[n][n3].tVertex[2][0];
                fArray[2][1] = this.bottom[n][n3].tVertex[2][1];
                if (n4 == -1) {
                    n4 = n5;
                    f = f2;
                    fArray[1][0] = this.strip[n][n4].tVertex[2][0];
                    fArray[1][1] = this.strip[n][n4].tVertex[2][1];
                } else {
                    fArray[1][0] = this.strip[n][n4].tVertex[3][0];
                    fArray[1][1] = this.strip[n][n4].tVertex[3][1];
                }
                if (n5 == -1) {
                    n5 = n4;
                    f2 = f;
                    fArray[3][0] = this.strip[n][n5].tVertex[3][0];
                    fArray[3][1] = this.strip[n][n5].tVertex[3][1];
                } else {
                    fArray[3][0] = this.strip[n][n5].tVertex[2][0];
                    fArray[3][1] = this.strip[n][n5].tVertex[2][1];
                }
                if (n4 == -1 && n5 == -1) {
                    n4 = 0;
                    n5 = n3;
                    f2 = this.paper.getMinAxisValue();
                    f = this.paper.getMinAxisValue();
                    fArray[1][0] = this.strip[n][n4].tVertex[3][0];
                    fArray[1][1] = this.strip[n][n4].tVertex[3][1];
                    fArray[3][0] = this.strip[n][n5].tVertex[2][0];
                    fArray[3][1] = this.strip[n][n5].tVertex[2][1];
                }
            } else {
                fArray[0][0] = this.bottom[n][0].tVertex[3][0];
                fArray[0][1] = this.bottom[n][0].tVertex[3][1];
                fArray[1][0] = this.strip[n][n4].tVertex[3][0];
                fArray[1][1] = this.strip[n][n4].tVertex[3][1];
                fArray[3][0] = this.strip[n][n5].tVertex[2][0];
                fArray[3][1] = this.strip[n][n5].tVertex[2][1];
                fArray[2][0] = this.bottom[n][n3].tVertex[2][0];
                fArray[2][1] = this.bottom[n][n3].tVertex[2][1];
            }
        }
        n2 = 0;
        if (this.get != null) {
            n2 = this.get.getConditionType();
        }
        if (n2 == 2) {
            float f3 = this.paper.getMinAxisValue();
            float f4 = this.paper.getMaxAxisValue();
            float f5 = this.paper.getMaxAxisValue();
            if (f > 0.0f || f2 > 0.0f) {
                if (f3 < 0.0f) {
                    f3 = 0.0f;
                }
                if (f4 > f) {
                    f4 = f;
                }
                if (f5 > f2) {
                    f5 = f2;
                }
            } else {
                if (!(f > f4)) {
                    f4 = f > f3 ? f : f3;
                }
                if (!(f2 > this.paper.getMaxAxisValue())) {
                    f5 = f2 > f3 ? f2 : f3;
                }
                f3 = this.paper.getMaxAxisValue() < 0.0f ? this.paper.getMaxAxisValue() : 0.0f;
            }
            if (f4 != f3 && f5 != f3) {
                this.availableOriginY(graphics2D, this.get, fArray, f4, f5, f3, this.closePath);
            }
        } else if (this.pattern[n] != null) {
            this.pattern[n].fill(graphics2D, this.closePath);
        }
        if (this.availableValue) {
            this.bottomCover.draw(graphics2D, this.closePath);
        }
    }

    private void SEDU() {
        this.appendCover();
        this.add();
        this.areaSurface();
    }

    private void add() {
        this.outerAscending = (this.paper.getShownFace() >> 5 & 1) == 1;
    }

    private void appendCover() {
        this.innerAscending = (this.paper.getShownFace() & 1) != 1;
    }

    private void areaSurface() {
        this.toUpAscending = (this.paper.getShownFace() >> 3 & 1) == 1;
    }

    public void setCompass(ChartCompass chartCompass) {
        this.compass = chartCompass;
    }

    protected Area innerFaceCover(int n) {
        int n2 = this.strip[n].length - 1;
        this.closePath.reset();
        if (!this.innerAscending) {
            this.closePath.moveTo(this.bottom[n][0].tVertex[0][0], this.bottom[n][0].tVertex[0][1]);
            this.closePath.lineTo(this.strip[n][0].tVertex[0][0], this.strip[n][0].tVertex[0][1]);
            this.closePath.lineTo(this.strip[n][0].tVertex[3][0], this.strip[n][0].tVertex[3][1]);
            this.closePath.lineTo(this.bottom[n][0].tVertex[3][0], this.bottom[n][0].tVertex[3][1]);
            this.closePath.lineTo(this.bottom[n][0].tVertex[0][0], this.bottom[n][0].tVertex[0][1]);
        } else {
            this.closePath.moveTo(this.bottom[n][n2].tVertex[1][0], this.bottom[n][n2].tVertex[1][1]);
            this.closePath.lineTo(this.strip[n][n2].tVertex[1][0], this.strip[n][n2].tVertex[1][1]);
            this.closePath.lineTo(this.strip[n][n2].tVertex[2][0], this.strip[n][n2].tVertex[2][1]);
            this.closePath.lineTo(this.bottom[n][n2].tVertex[2][0], this.bottom[n][n2].tVertex[2][1]);
            this.closePath.lineTo(this.bottom[n][n2].tVertex[1][0], this.bottom[n][n2].tVertex[1][1]);
        }
        return new Area(this.closePath);
    }

    protected Area outerFaceCover(int n) {
        int n2 = this.strip[n].length - 1;
        this.closePath.reset();
        if (!this.outerAscending) {
            this.closePath.moveTo(this.bottom[n][0].tVertex[0][0], this.bottom[n][0].tVertex[0][1]);
            for (int i = 0; i <= n2; ++i) {
                this.closePath.lineTo(this.strip[n][i].tVertex[0][0], this.strip[n][i].tVertex[0][1]);
            }
            this.closePath.lineTo(this.strip[n][n2].tVertex[1][0], this.strip[n][n2].tVertex[1][1]);
            this.closePath.lineTo(this.bottom[n][n2].tVertex[1][0], this.bottom[n][n2].tVertex[1][1]);
            this.closePath.lineTo(this.bottom[n][0].tVertex[0][0], this.bottom[n][0].tVertex[0][1]);
        } else {
            this.closePath.moveTo(this.bottom[n][0].tVertex[3][0], this.bottom[n][0].tVertex[3][1]);
            for (int i = 0; i <= n2; ++i) {
                this.closePath.lineTo(this.strip[n][i].tVertex[3][0], this.strip[n][i].tVertex[3][1]);
            }
            this.closePath.lineTo(this.strip[n][n2].tVertex[2][0], this.strip[n][n2].tVertex[2][1]);
            this.closePath.lineTo(this.bottom[n][n2].tVertex[2][0], this.bottom[n][n2].tVertex[2][1]);
            this.closePath.lineTo(this.bottom[n][0].tVertex[3][0], this.bottom[n][0].tVertex[3][1]);
        }
        return new Area(this.closePath);
    }

    protected Area bottomCover(int n) {
        Area area = new Area();
        for (int i = 0; i < this.strip[n].length; ++i) {
            int n2 = i;
            if (!this.innerAscending) {
                n2 = this.strip[n].length - i - 1;
            }
            if ((this.paper.getShownFace() >> 3 & 1) == 1) {
                if (this.areaSurface[n][n2]) {
                    area.add(this.strip[n][n2].areaSurface());
                    area.add(this.bottom[n][n2].areaSurface());
                    continue;
                }
                area.add(this.bottom[n][n2].areaSurface());
                area.add(this.strip[n][n2].areaSurface());
                continue;
            }
            if (this.areaSurface[n][n2]) {
                area.add(this.bottom[n][n2].areaSurface());
                area.add(this.strip[n][n2].areaSurface());
                continue;
            }
            area.add(this.strip[n][n2].areaSurface());
            area.add(this.bottom[n][n2].areaSurface());
        }
        return area;
    }

    @Override
    public Shape[][] getItemShapes(int n) {
        if (this.availableLength < 2) {
            return null;
        }
        Area area = new Area();
        Shape[][] shapeArray = new Shape[this.availableOriginY][this.availableLength];
        for (int i = 0; i < this.availableOriginY; ++i) {
            int n2 = 0;
            for (int j = 0; j < this.availableLength; ++j) {
                Rectangle rectangle;
                if (j != this.availableLength - 1) {
                    rectangle = new Rectangle((int)this.strip[i][j + n2].tVertex[0][0] - 5, (int)this.strip[i][j + n2].tVertex[0][1] - 5, 10, 10);
                    if (this.draw[i][j] > 0.0f && this.draw[i][j + 1] < 0.0f || this.draw[i][j] < 0.0f && this.draw[i][j + 1] > 0.0f) {
                        ++n2;
                    }
                } else {
                    rectangle = new Rectangle((int)this.strip[i][j + n2 - 1].tVertex[1][0] - 5, (int)this.strip[i][j + n2 - 1].tVertex[1][1] - 5, 10, 10);
                }
                if (area.contains(rectangle)) {
                    shapeArray[i][j] = null;
                    continue;
                }
                shapeArray[i][j] = new GeneralPath();
                int n3 = (int)rectangle.getX();
                int n4 = (int)rectangle.getY();
                int n5 = n3 + 10;
                int n6 = n4 + 10;
                ((GeneralPath)shapeArray[i][j]).moveTo(n3, n6);
                ((GeneralPath)shapeArray[i][j]).lineTo(n5, n6);
                ((GeneralPath)shapeArray[i][j]).lineTo(n5, n4);
                ((GeneralPath)shapeArray[i][j]).lineTo(n3, n4);
                ((GeneralPath)shapeArray[i][j]).lineTo(n3, n6);
            }
            this.appendCover(area, i);
        }
        return shapeArray;
    }

    public boolean contains(int n, int n2) {
        return false;
    }

    @Override
    public int searchSeries(int n, int n2) {
        return 0;
    }

    private void areas(Graphics2D graphics2D) {
        if (this.availableLength < 2) {
            return;
        }
        for (int i = 0; i < this.availableOriginY; ++i) {
            if (this.strip[i] == null) continue;
            for (int j = 0; j < this.strip[i].length; ++j) {
                if (this.selectedSeriesIndex != i || this.status != 1) continue;
                this.strip[i][j].drawSelectedOutLine(graphics2D);
            }
        }
    }

    private Area availableLength(float[][] fArray, float f, float f2, float f3, float f4, float f5) {
        float[][] fArray2 = new float[4][2];
        GeneralPath generalPath = new GeneralPath();
        float f6 = f4;
        float f7 = f5;
        float f8 = f;
        boolean bl = false;
        if (!bl) {
            fArray2[0][0] = fArray[0][0] + (fArray[1][0] - fArray[0][0]) * (f6 - f8) / (f2 - f8);
            fArray2[0][1] = fArray[0][1] + (fArray[1][1] - fArray[0][1]) * (f6 - f8) / (f2 - f8);
            fArray2[1][0] = fArray[2][0] + (fArray[3][0] - fArray[2][0]) * (f6 - f8) / (f3 - f8);
            fArray2[1][1] = fArray[2][1] + (fArray[3][1] - fArray[2][1]) * (f6 - f8) / (f3 - f8);
        }
        if (!bl) {
            fArray2[2][0] = fArray[2][0] + (fArray[3][0] - fArray[2][0]) * (f7 - f8) / (f3 - f8);
            fArray2[2][1] = fArray[2][1] + (fArray[3][1] - fArray[2][1]) * (f7 - f8) / (f3 - f8);
            fArray2[3][0] = fArray[0][0] + (fArray[1][0] - fArray[0][0]) * (f7 - f8) / (f2 - f8);
            fArray2[3][1] = fArray[0][1] + (fArray[1][1] - fArray[0][1]) * (f7 - f8) / (f2 - f8);
        }
        generalPath.moveTo(fArray2[0][0], fArray2[0][1]);
        generalPath.lineTo(fArray2[1][0], fArray2[1][1]);
        generalPath.lineTo(fArray2[2][0], fArray2[2][1]);
        generalPath.lineTo(fArray2[3][0], fArray2[3][1]);
        generalPath.closePath();
        return new Area(generalPath);
    }

    private void availableOriginY(Graphics2D graphics2D, ChartShowValueCondition chartShowValueCondition, float[][] fArray, float f, float f2, float f3, GeneralPath generalPath) {
        int n = chartShowValueCondition.getSubConditons().size();
        Area area = new Area();
        area.add(new Area(generalPath));
        for (int i = 0; i < n; ++i) {
            Area area2 = this.availableLength(fArray, f3, f, f2, chartShowValueCondition.getCondition(i).getStartValue(), chartShowValueCondition.getCondition(i).getEndValue());
            if (area2 == null) continue;
            area2.intersect(area);
            chartShowValueCondition.getCondition(i).getFillColor().fill(graphics2D, area2);
            area.subtract(new Area(area2));
        }
        if (area != null) {
            chartShowValueCondition.getOtherColor().fill(graphics2D, area);
        }
    }

    @Override
    public int[] searchLinkInfo(int n, int n2) {
        int[] nArray = null;
        if (this.availableLength < 2) {
            return null;
        }
        Area area = new Area();
        for (int i = 0; i < this.availableOriginY; ++i) {
            int n3 = 0;
            for (int j = 0; j < this.availableLength; ++j) {
                if (j != this.availableLength - 1) {
                    this.custommerConstant = new Rectangle((int)this.strip[i][j + n3].tVertex[0][0] - 5, (int)this.strip[i][j + n3].tVertex[0][1] - 5, 10, 10);
                    if (this.draw[i][j] > 0.0f && this.draw[i][j + 1] < 0.0f || this.draw[i][j] < 0.0f && this.draw[i][j + 1] > 0.0f) {
                        ++n3;
                    }
                } else {
                    this.custommerConstant = new Rectangle((int)this.strip[i][j + n3 - 1].tVertex[1][0] - 5, (int)this.strip[i][j + n3 - 1].tVertex[1][1] - 5, 10, 10);
                }
                if (!this.custommerConstant.contains(n, n2)) continue;
                if (area.contains(this.custommerConstant)) {
                    return null;
                }
                ChartShowValueCondition chartShowValueCondition = this.dataset.getCondition(i, j);
                if (chartShowValueCondition != null && chartShowValueCondition.getChartLink() != null) {
                    nArray = ((ChartDataUsedInfo)((List)chartShowValueCondition.getChartLink().get(i)).get(j)).getChartLinkInfo();
                }
                return nArray;
            }
            this.appendCover(area, i);
        }
        return null;
    }
}

