/*
 * Decompiled with CFR 0.152.
 */
package chart.graphics;

import chart.graphics.ChartColorPattern;
import chart.graphics.RoundGradientContext;
import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;

public class RoundGradientPaint
implements Paint {
    protected Point2D mPoint;
    protected Point2D mRadius;
    protected Color mPointColor;
    protected Color mBackgroundColor;

    public RoundGradientPaint(double d, double d2, Color color, Point2D point2D, Color color2) {
        this.mPoint = new Point2D.Double(d, d2);
        this.mPointColor = color;
        this.mRadius = point2D;
        this.mBackgroundColor = color2;
    }

    public RoundGradientPaint(Point2D point2D, Color color, Point2D point2D2, Color color2) {
        this(point2D.getX(), point2D.getY(), color, point2D2, color2);
    }

    public RoundGradientPaint(Point2D.Float float_, Color color, float f, Color color2) {
        this.mPoint = float_;
        this.mPointColor = color;
        this.mRadius = new Point2D.Double(float_.getX() + (double)f, float_.y);
        this.mBackgroundColor = color2;
    }

    @Override
    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        Point2D point2D = affineTransform.transform(this.mPoint, null);
        Point2D point2D2 = affineTransform.deltaTransform(this.mRadius, null);
        return new RoundGradientContext(point2D, this.mPointColor, point2D2, this.mBackgroundColor);
    }

    @Override
    public int getTransparency() {
        int n;
        int n2 = this.mPointColor.getAlpha();
        return (n2 & (n = this.mBackgroundColor.getAlpha())) == 255 ? 1 : 3;
    }

    public ChartColorPattern getPointColor() {
        return new ChartColorPattern(this.mPointColor);
    }

    public ChartColorPattern getBackgroundColor() {
        return new ChartColorPattern(this.mBackgroundColor);
    }
}

