import java.text.DateFormat;
import java.util.*;

import jet.cs.util.*;
import jet.server.api.*;
import jet.server.api.http.HttpUtil;

/**
 * This demo is created to demonstrate the usage of JReport Server API methods to run a report and
 * export it to PDF and HTML and find the result files located in the JReport temp folder.
 * 
 * The sample assumes JReport Server is installed on Windows in the default location
 * SampleReports/SampleReports.cat and SampleReports/CustomerAnalysis.cls are deployed under Public Reports
 * That the C:/JReport/Server/temp directory exists.
 * 
 */ 

public class APIDemoRunAndExportReport
{

    public static void main(String[] args)
	{
    	RptServer server = null;
		try {
			//set report home
			System.getProperties().put("reporthome", "c:\\JReport\\Server");
			
			//creates instance of RptServer (JReport Server must not be already running)
			HttpUtil.initEnv(System.getProperties());
			server = HttpUtil.getHttpRptServer();
			System.out.println("========server="+server);

			String catalog = "/SampleReports/SampleReports.cat";
			String rptName = "/SampleReports/Banded_Link.cls";

			//set report properties
			Properties props = new Properties();
			
			props.put(APIConst.TAG_REPORT_LANGUAGE, "en_US");
			String today = DateFormat.getDateInstance(DateFormat.LONG, new Locale("en", "US")).format(new Date());
			//set value of parameter "p_StartDate" & "p_EndDate".
			props.put(APIConst.TAG_PARAM_PREFIX + "p_StartDate", "January 1, 2006");
			props.put(APIConst.TAG_PARAM_PREFIX + "p_EndDate", today);
			
			//set result type as .rst format.
			props.put(APIConst.TAG_RESULT_TYPE, String.valueOf(APIConst.RST));

			System.out.println("\n========to rst="+props);
			String tempResult = server.runReport("admin", catalog, rptName, props);
			System.out.println("========tempResult="+tempResult);

			//can delete tempResult.* files here.

			//props = new Properties();

			//export to pdf.
			props.put(APIConst.TAG_PDF, "true");
			props.put(APIConst.TAG_PDF_DIR, "c:\\JReport\\Server\\temp\\");			
			props.put(APIConst.TAG_TO_DISK,true);
			//export to html, and specify html result name.
			//(to html and to rtf require you to specify the result filename).
			props.put(APIConst.TAG_HTML, "html_Banded_Link.cls");

			System.out.println("\n========exportResult="+props);
			ExportedFileList fileList = server.exportResult("admin", tempResult, props);

			System.out.println("\n========fileList.getPDFFilename()="+fileList.getPDFFilename());
			System.out.println("\n========fileList.getHTMLFilenameList()="+fileList.getHTMLFilenameList());
			
			//can delete files in file list here or copy them to your client machine (See APIDemoRemoteFileService.java).
			
		
		}catch (Throwable t){
			t.printStackTrace();
		}
		finally{
			// Make sure server is shutdown or there will be a 2 minute wait to start again
			server.shutdown();
			System.out.println("Server "+ server +" shutdown.");
		}
		System.exit(0);
    }
}


