/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.awt.ps;

import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.Serializable;
import java.util.Hashtable;

public class PixelConsumer
implements ImageConsumer,
Serializable {
    public int width;
    public int height;
    public int iwidth;
    public int iheight;
    public int[][] pix;
    private boolean complete = false;
    private boolean region = false;
    private int sx1;
    private int sy1;
    private int sx2;
    private int sy2;
    private Image image;
    private int trycnt = 0;
    private boolean init = false;

    public PixelConsumer(Image image, int n, int n2, int n3, int n4) {
        this.image = image;
        this.region = true;
        this.sx1 = n;
        this.sy1 = n2;
        this.sx2 = n3;
        this.sy2 = n4;
    }

    public PixelConsumer(Image image) {
        this.image = image;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PixelConsumer)) {
            return false;
        }
        PixelConsumer pixelConsumer = (PixelConsumer)object;
        return this.image == pixelConsumer.image && this.sx1 == pixelConsumer.sx1 && this.sy1 == pixelConsumer.sy1 && this.sx2 == pixelConsumer.sx2 && this.sy2 == pixelConsumer.sy2;
    }

    private int SEDU(byte by) {
        return by & 0xFF;
    }

    public Image getImage() {
        return this.image;
    }

    public int hashCode() {
        return this.image.hashCode() + this.sx1 + this.sy1 + this.sx2 + this.sy2;
    }

    @Override
    public synchronized void imageComplete(int n) {
        if (n == 1 || n == 4) {
            if (this.trycnt < 3) {
                ++this.trycnt;
                this.produce(this.image);
            } else {
                n = 3;
            }
        }
        if (n == 3 || n == 2) {
            this.complete = true;
            this.notifyAll();
        }
    }

    public void produce() {
        if (!this.init) {
            this.init = true;
            this.produce(this.image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void produce(Image image) {
        PixelConsumer pixelConsumer;
        ImageProducer imageProducer = image.getSource();
        imageProducer.removeConsumer(this);
        imageProducer.startProduction(this);
        PixelConsumer pixelConsumer2 = pixelConsumer = this;
        synchronized (pixelConsumer2) {
            while (!this.complete) {
                try {
                    this.wait();
                }
                catch (Exception exception) {}
            }
            imageProducer.removeConsumer(this);
        }
    }

    @Override
    public void setColorModel(ColorModel colorModel) {
    }

    @Override
    public void setDimensions(int n, int n2) {
        if (this.region) {
            n = this.sx2 - this.sx1 + 1;
            n2 = this.sy2 - this.sy1 + 1;
        }
        if (this.pix == null || n != this.width || n2 != this.height) {
            this.width = n;
            this.height = n2;
            this.pix = new int[this.width][this.height];
        }
        this.iwidth = this.width;
        this.iheight = this.height;
    }

    @Override
    public void setHints(int n) {
    }

    @Override
    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        int n7 = 0;
        int n8 = 0;
        int n9 = n5;
        int n10 = n5;
        int n11 = n + n3;
        int n12 = n2 + n4;
        for (n8 = n2; n8 < n12; ++n8) {
            n9 = n10;
            for (n7 = n; n7 < n11 && n9 < byArray.length; ++n7) {
                if (this.region) {
                    if (n7 < this.sx1 || n7 > this.sx2 || n8 < this.sy1 || n8 > this.sy2) continue;
                    this.pix[n7 - this.sx1][n8 - this.sy1] = this.SEDU(byArray[n9++]);
                    if (colorModel == null) continue;
                    this.pix[n7 - this.sx1][n8 - this.sy1] = colorModel.getRGB(this.pix[n7 - this.sx1][n8 - this.sy1]);
                    continue;
                }
                this.pix[n7][n8] = this.SEDU(byArray[n9++]);
                if (colorModel == null) continue;
                this.pix[n7][n8] = colorModel.getRGB(this.pix[n7][n8]);
            }
            n10 += n6;
        }
    }

    @Override
    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        int n7 = 0;
        int n8 = 0;
        int n9 = n + n3;
        int n10 = n2 + n4;
        int n11 = n5;
        for (n8 = n2; n8 < n10; ++n8) {
            int n12 = n11;
            for (n7 = n; n7 < n9 && n12 < nArray.length; ++n7) {
                if (this.region) {
                    if (n7 < this.sx1 || n7 > this.sx2 || n8 < this.sy1 || n8 > this.sy2) continue;
                    this.pix[n7 - this.sx1][n8 - this.sy1] = colorModel.getRGB(nArray[n12++]);
                    continue;
                }
                this.pix[n7][n8] = colorModel.getRGB(nArray[n12++]);
            }
            n11 += n6;
        }
    }

    public void setProperties(Hashtable hashtable) {
    }
}

