/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.web.util.json;

import com.jinfonet.web.util.CharArray;
import com.jinfonet.web.util.Converter;
import com.jinfonet.web.util.Parser;
import com.jinfonet.web.util.StringUtil;
import com.jinfonet.web.util.SymbolTable;
import com.jinfonet.web.util.json.JSONArray;
import com.jinfonet.web.util.json.JSONException;
import com.jinfonet.web.util.json.JSONObject;
import java.awt.Color;
import java.lang.reflect.Array;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;

public final class JSON {
    private static final SymbolTable SEDU;
    private static final ConverterMap TYPE;
    public static final Converter NullConverter;
    public static final Converter BoolConverter;
    public static final Converter CharConverter;
    public static final Converter IntrConverter;
    public static final Converter LongConverter;
    public static final Converter DoubConverter;
    public static final Converter FlotConverter;
    public static final Converter MapsConverter;
    public static final Converter CollConverter;
    public static final Converter ArryConverter;
    public static final Converter JsonConverter;
    public static final Converter ObjsConverter;
    public static final Converter StrnConverter;
    public static final Converter TimeZoneConverter;
    public static final Converter ColorConverter;
    private static final Parser[] append;
    public static final Parser MapsParser;
    public static final Parser CollParser;
    public static final Parser StrnParser;
    public static final Parser BoolParser;
    public static final Parser DigtParser;

    public static final Converter getConverter(Class clazz) {
        Converter converter = TYPE.get(clazz);
        if (converter == null) {
            if (Map.class.isAssignableFrom(clazz)) {
                TYPE.put(clazz, MapsConverter);
            } else if (Collection.class.isAssignableFrom(clazz)) {
                TYPE.put(clazz, CollConverter);
            } else if (JSONObject.JSONObjectable.class.isAssignableFrom(clazz)) {
                TYPE.put(clazz, JsonConverter);
            } else if (clazz.isArray()) {
                TYPE.put(clazz, ArryConverter);
            } else {
                TYPE.put(clazz, ObjsConverter);
            }
            converter = TYPE.get(clazz);
        }
        return converter;
    }

    public static final Converter getConverterBy(Object object) {
        if (object == null || object instanceof JSONObject.Null) {
            return NullConverter;
        }
        return JSON.getConverter(object.getClass());
    }

    public static final Object parse(String string) throws JSONException {
        if (string == null) {
            return null;
        }
        return JSON.parse(new CharArray(string));
    }

    public static final Object parse(CharArray charArray) throws JSONException {
        charArray.skip();
        int n = charArray.peek();
        try {
            switch (n) {
                case 123: {
                    return new JSONObject((JSONObject)MapsParser.parse(charArray));
                }
                case 91: {
                    return new JSONArray((JSONArray)CollParser.parse(charArray));
                }
            }
            Parser parser = append[n];
            if (parser == null) {
                throw new ParseException("Unexcept character " + charArray.peek(charArray.tellg() - 1), charArray.tellg() - 1);
            }
            Object object = parser.parse(charArray);
            return object instanceof CharArray ? ((CharArray)object).getString() : object;
        }
        catch (ParseException parseException) {
            throw new JSONException(parseException.getMessage() + " " + parseException.getErrorOffset());
        }
    }

    public static final boolean castBoolean(Object object) throws JSONException {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return Boolean.parseBoolean((String)object);
        }
        throw new JSONException(object == null ? "null" : object.getClass().toString());
    }

    public static final int castInteger(Object object) throws JSONException {
        return object instanceof Number ? ((Number)object).intValue() : (int)JSON.castDouble(object);
    }

    public static final long castLong(Object object) throws JSONException {
        return object instanceof Number ? ((Number)object).longValue() : (long)JSON.castDouble(object);
    }

    public static final float castFloat(Object object) throws JSONException {
        try {
            return object instanceof Number ? ((Number)object).floatValue() : Double.valueOf(object.toString()).floatValue();
        }
        catch (Exception exception) {
            throw new JSONException(object == null ? "null" : object.getClass().toString());
        }
    }

    public static final double castDouble(Object object) throws JSONException {
        try {
            return object instanceof Number ? ((Number)object).doubleValue() : Double.valueOf(object.toString()).doubleValue();
        }
        catch (Exception exception) {
            throw new JSONException(object == null ? "null" : object.getClass().toString());
        }
    }

    public static final String castString(Object object) throws JSONException {
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    public static final JSONObject castJSONObject(Object object) throws JSONException {
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        if (object instanceof Map) {
            return new JSONObject((Map)object);
        }
        throw new JSONException(object == null ? "null" : object.getClass().toString());
    }

    public static final JSONArray castJSONArray(Object object) throws JSONException {
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        if (object instanceof List) {
            return new JSONArray((List)object);
        }
        if (object != null && object.getClass().isArray()) {
            return new JSONArray((Object[])object);
        }
        throw new JSONException(object == null ? "null" : object.getClass().toString());
    }

    static {
        NullConverter = new Converter(){

            @Override
            public final void convert(Object object, CharArray charArray) {
                charArray.put(StringUtil.charsNull, 0, 4);
            }
        };
        BoolConverter = new Converter(){

            @Override
            public final void convert(Object object, CharArray charArray) {
                if (((Boolean)object).booleanValue()) {
                    charArray.put(StringUtil.charsTrue, 0, 4);
                } else {
                    charArray.put(StringUtil.charsFalse, 0, 5);
                }
            }
        };
        CharConverter = new Converter(){

            @Override
            public final void convert(Object object, CharArray charArray) {
                charArray.put(((Character)object).charValue());
            }
        };
        IntrConverter = new Converter(){

            @Override
            public void convert(Object object, CharArray charArray) {
                int n = 0;
                n = object instanceof Byte ? ((Byte)object).intValue() : (object instanceof Short ? ((Short)object).intValue() : ((Integer)object).intValue());
                StringUtil.toCharArray(charArray, n, 10);
            }
        };
        LongConverter = new Converter(){

            @Override
            public final void convert(Object object, CharArray charArray) {
                StringUtil.toCharArray(charArray, (Long)object, 10);
            }
        };
        DoubConverter = new Converter(){

            @Override
            public final void convert(Object object, CharArray charArray) {
                Double d = (Double)object;
                if (d.isNaN() || d.isInfinite()) {
                    charArray.put(StringUtil.charsNull, 0, 4);
                } else {
                    String string = d.toString();
                    int n = string.length();
                    int n2 = charArray.tellp();
                    int n3 = n2 + n;
                    string.getChars(0, n, charArray.expandCapacity(n3), n2);
                    charArray.seekp(n3);
                }
            }
        };
        FlotConverter = new Converter(){

            @Override
            public final void convert(Object object, CharArray charArray) {
                Float f = (Float)object;
                if (f.isNaN() || f.isInfinite()) {
                    charArray.put(StringUtil.charsNull, 0, 4);
                } else {
                    String string = f.toString();
                    int n = string.length();
                    int n2 = charArray.tellp();
                    int n3 = n2 + n;
                    string.getChars(0, n, charArray.expandCapacity(n3), n2);
                    charArray.seekp(n3);
                }
            }
        };
        MapsConverter = new Converter(){

            @Override
            public final void convert(Object object, CharArray charArray) {
                Class<?> clazz = null;
                Converter converter = StrnConverter;
                Converter converter2 = null;
                SymbolTable symbolTable = SEDU;
                charArray.put('{');
                Map map = (Map)object;
                for (Map.Entry entry : map.entrySet()) {
                    converter.convert(symbolTable.addSymbol(entry.getKey().toString()), charArray);
                    charArray.put(':');
                    Object v = entry.getValue();
                    if (v != null && !(v instanceof JSONObject.Null)) {
                        Class<?> clazz2 = v.getClass();
                        if (clazz2 != clazz) {
                            clazz = clazz2;
                            converter2 = JSON.getConverter(clazz2);
                        }
                        converter2.convert(v, charArray);
                    } else {
                        charArray.put(StringUtil.charsNull, 0, 4);
                    }
                    charArray.put(',');
                }
                if (!map.isEmpty()) {
                    charArray.backp();
                }
                charArray.put('}');
            }
        };
        CollConverter = new Converter(){

            @Override
            public final void convert(Object object, CharArray charArray) {
                Class<?> clazz = null;
                Converter converter = null;
                charArray.put('[');
                Collection collection = (Collection)object;
                for (Object e : collection) {
                    if (e != null && !(e instanceof JSONObject.Null)) {
                        Class<?> clazz2 = e.getClass();
                        if (clazz2 != clazz) {
                            clazz = clazz2;
                            converter = JSON.getConverter(clazz2);
                        }
                        converter.convert(e, charArray);
                    } else {
                        charArray.put(StringUtil.charsNull, 0, 4);
                    }
                    charArray.put(',');
                }
                if (!collection.isEmpty()) {
                    charArray.backp();
                }
                charArray.put(']');
            }
        };
        ArryConverter = new Converter(){

            @Override
            public final void convert(Object object, CharArray charArray) {
                Converter converter = JSON.getConverter(object.getClass().getComponentType());
                charArray.put('[');
                int n = Array.getLength(object);
                for (int i = 0; i < n; ++i) {
                    Object object2 = Array.get(object, i);
                    if (object2 != null && !(object2 instanceof JSONObject.Null)) {
                        converter.convert(object2, charArray);
                    } else {
                        charArray.put(StringUtil.charsNull, 0, 4);
                    }
                    charArray.put(',');
                }
                if (n > 0) {
                    charArray.backp();
                }
                charArray.put(']');
            }
        };
        JsonConverter = new Converter(){

            @Override
            public final void convert(Object object, CharArray charArray) {
                Object object2 = null;
                try {
                    object2 = ((JSONObject.JSONObjectable)object).toJSONObject();
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                if (object2 instanceof JSONObject) {
                    MapsConverter.convert((JSONObject)object2, charArray);
                } else if (object2 instanceof JSONArray) {
                    CollConverter.convert((JSONArray)object2, charArray);
                } else {
                    JSON.getConverterBy(object2).convert(object2, charArray);
                }
            }
        };
        ObjsConverter = new Converter(){

            @Override
            public final void convert(Object object, CharArray charArray) {
                StrnConverter.convert(object.toString(), charArray);
            }
        };
        StrnConverter = new Converter(){

            @Override
            public final void convert(Object object, CharArray charArray) {
                int[] nArray = StringUtil.json_encodes;
                String string = (String)object;
                charArray.expandCapacity(charArray.size() + (string.length() << 1) + 2);
                charArray.put('\"');
                int n = string.length();
                for (int i = 0; i < n; ++i) {
                    int n2;
                    char c = string.charAt(i);
                    int n3 = c < '\u0100' ? nArray[c] : (n2 = c >= '\u2000' && c < '\u2100' ? 117 : -1);
                    if (n2 < 0) {
                        charArray.put(c);
                        continue;
                    }
                    charArray.put('\\');
                    charArray.put((char)n2);
                    if (n2 != 117) continue;
                    StringUtil.toCharArray(charArray, c, new int[]{16, 4});
                }
                charArray.put('\"');
            }
        };
        TimeZoneConverter = new Converter(){

            @Override
            public void convert(Object object, CharArray charArray) {
                StrnConverter.convert(((TimeZone)object).getID(), charArray);
            }
        };
        ColorConverter = new Converter(){

            @Override
            public void convert(Object object, CharArray charArray) {
                StrnConverter.convert(StringUtil.formatColor(((Color)object).getRGB()), charArray);
            }
        };
        SEDU = new SymbolTable();
        TYPE = new ConverterMap();
        TYPE.put(Boolean.TYPE, BoolConverter);
        TYPE.put(Boolean.class, BoolConverter);
        TYPE.put(Character.TYPE, CharConverter);
        TYPE.put(Character.class, CharConverter);
        TYPE.put(String.class, StrnConverter);
        TYPE.put(Object.class, ObjsConverter);
        TYPE.put(Byte.TYPE, IntrConverter);
        TYPE.put(Byte.class, IntrConverter);
        TYPE.put(Short.TYPE, IntrConverter);
        TYPE.put(Short.class, IntrConverter);
        TYPE.put(Integer.TYPE, IntrConverter);
        TYPE.put(Integer.class, IntrConverter);
        TYPE.put(Long.TYPE, LongConverter);
        TYPE.put(Long.class, LongConverter);
        TYPE.put(Float.TYPE, FlotConverter);
        TYPE.put(Float.class, FlotConverter);
        TYPE.put(Double.TYPE, DoubConverter);
        TYPE.put(Double.class, DoubConverter);
        TYPE.put(JSONObject.class, MapsConverter);
        TYPE.put(HashMap.class, MapsConverter);
        TYPE.put(Properties.class, MapsConverter);
        TYPE.put(JSONArray.class, CollConverter);
        TYPE.put(ArrayList.class, CollConverter);
        TYPE.put(LinkedList.class, CollConverter);
        TYPE.put(boolean[].class, ArryConverter);
        TYPE.put(byte[].class, ArryConverter);
        TYPE.put(char[].class, ArryConverter);
        TYPE.put(short[].class, ArryConverter);
        TYPE.put(int[].class, ArryConverter);
        TYPE.put(long[].class, ArryConverter);
        TYPE.put(float[].class, ArryConverter);
        TYPE.put(double[].class, ArryConverter);
        TYPE.put(String[].class, ArryConverter);
        TYPE.put(TimeZone.class, TimeZoneConverter);
        TYPE.put(Color.class, ColorConverter);
        append = new Parser[128];
        MapsParser = new Parser(){

            @Override
            public final Object parse(CharArray charArray) throws ParseException {
                charArray.skip();
                if (123 != charArray.get()) {
                    throw new ParseException("Can not found '{' at ", charArray.tellg() - 1);
                }
                Parser parser = StrnParser;
                SymbolTable symbolTable = SEDU;
                JSONObject jSONObject = new JSONObject();
                block4: while (true) {
                    charArray.skip();
                    if (125 == charArray.get()) {
                        return jSONObject;
                    }
                    CharArray charArray2 = (CharArray)parser.parse(charArray.backg());
                    charArray.skip();
                    if (58 != charArray.get()) {
                        throw new ParseException("Can not found ':' at ", charArray.tellg() - 1);
                    }
                    charArray.skip();
                    Parser parser2 = append[charArray.peek()];
                    if (parser2 == null) {
                        throw new ParseException("Unexcept character " + charArray.peek(charArray.tellg() - 1), charArray.tellg() - 1);
                    }
                    Object object = parser2.parse(charArray);
                    if (object instanceof CharArray) {
                        object = ((CharArray)object).getString();
                    }
                    jSONObject.put(symbolTable.addSymbol(charArray2.getChars(), 0, charArray2.size()), object);
                    charArray.skip();
                    switch (charArray.get()) {
                        case 44: {
                            continue block4;
                        }
                        case 125: {
                            return jSONObject;
                        }
                    }
                    break;
                }
                throw new ParseException("Can not found ',' or '}' at ", charArray.tellg() - 1);
            }
        };
        CollParser = new Parser(){

            @Override
            public final Object parse(CharArray charArray) throws ParseException {
                charArray.skip();
                if (91 != charArray.get()) {
                    throw new ParseException("Can not found '[' at ", charArray.tellg() - 1);
                }
                JSONArray jSONArray = new JSONArray();
                block4: while (true) {
                    charArray.skip();
                    int n = charArray.peek();
                    if (93 == n) {
                        charArray.seekg(charArray.tellg() + 1);
                        return jSONArray;
                    }
                    Parser parser = append[n];
                    if (parser == null) {
                        throw new ParseException("Unexcept character " + charArray.peek(charArray.tellg() - 1), charArray.tellg() - 1);
                    }
                    Object object = parser.parse(charArray);
                    if (object instanceof CharArray) {
                        object = ((CharArray)object).getString();
                    }
                    jSONArray.add(object);
                    charArray.skip();
                    switch (charArray.get()) {
                        case 44: {
                            continue block4;
                        }
                        case 93: {
                            return jSONArray;
                        }
                    }
                    break;
                }
                throw new ParseException("Can not found ',' or ']' at ", charArray.tellg() - 1);
            }
        };
        StrnParser = new Parser(){

            @Override
            public final Object parse(CharArray charArray) throws ParseException {
                int[] nArray = StringUtil.json_decodes;
                int[] nArray2 = StringUtil.masks;
                boolean bl = true;
                int n = charArray.get();
                if (34 != n && 39 != n) {
                    bl = false;
                }
                int n2 = 0;
                int n3 = bl ? charArray.get() : n;
                CharArray charArray2 = new CharArray();
                block4: while (true) {
                    int n4 = n2;
                    n2 = n3;
                    n3 = charArray.get();
                    if (n3 == -1) {
                        throw new ParseException("Unexcept EOF at ", charArray.tellg() - 1);
                    }
                    if (bl && n2 == n && n4 != 92 || !bl && (58 == n2 || 128 == nArray2[n2])) {
                        charArray.seekg(charArray.tellg() - (bl ? 1 : 2));
                        return charArray2;
                    }
                    int n5 = n2 == 92 && n3 < 256 ? nArray[n3] : -1;
                    switch (n5) {
                        case -1: {
                            charArray2.put((char)n2);
                            continue block4;
                        }
                        case -2: {
                            if (charArray.tellg() + 3 >= charArray.size()) {
                                throw new ParseException("Unexcept EOF at ", charArray.tellg() + 3);
                            }
                            n5 = StringUtil.parseInt(charArray.getChars(), charArray.tellg(), 4, 16);
                            charArray2.put((char)n5);
                            charArray.seekg(charArray.tellg() + 3);
                            n2 = charArray.get();
                            n3 = charArray.get();
                            continue block4;
                        }
                    }
                    charArray2.put((char)n5);
                    n2 = n3 == 92 ? 0 : n3;
                    n3 = charArray.get();
                }
            }
        };
        BoolParser = new Parser(){

            @Override
            public final Object parse(CharArray charArray) throws ParseException {
                switch (charArray.get()) {
                    case 116: {
                        if (114 == charArray.get() && 117 == charArray.get() && 101 == charArray.get()) {
                            return Boolean.TRUE;
                        }
                        throw new ParseException("Unexcept character for parsing 'true' at ", charArray.tellg() - 1);
                    }
                    case 102: {
                        if (97 == charArray.get() && 108 == charArray.get() && 115 == charArray.get() && 101 == charArray.get()) {
                            return Boolean.FALSE;
                        }
                        throw new ParseException("Unexcept character for parsing 'false' at ", charArray.tellg() - 1);
                    }
                    case 110: {
                        if (117 == charArray.get() && 108 == charArray.get() && 108 == charArray.get()) {
                            return JSONObject.NULL;
                        }
                        throw new ParseException("Unexcept character for parsing 'null' at ", charArray.tellg() - 1);
                    }
                }
                throw new ParseException("Unexcept character for parsing boolean or null at ", charArray.tellg() - 1);
            }
        };
        DigtParser = new Parser(){

            @Override
            public final Object parse(CharArray charArray) throws ParseException {
                int n = charArray.tellg();
                boolean bl = false;
                boolean bl2 = false;
                while (true) {
                    int n2;
                    if ((n2 = charArray.get()) == -1) {
                        throw new ParseException("Unexcept character for parsing number at ", charArray.tellg() - 1);
                    }
                    if (n2 > 128) {
                        throw new ParseException("Unexcept character for parsing number at ", charArray.tellg() - 1);
                    }
                    int n3 = StringUtil.masks[n2];
                    if (n3 >= 128) break;
                    bl |= n3 == 16;
                    bl2 |= n3 == 32;
                }
                charArray.seekg(charArray.tellg() - 1);
                int n4 = charArray.tellg() - n;
                try {
                    if (bl) {
                        return StringUtil.parseNumber(charArray.getChars(), n + 2, n4 - 2, false, 16);
                    }
                    if (bl2) {
                        return StringUtil.parseNumber(charArray.getChars(), n, n4, true, 10);
                    }
                    return StringUtil.parseNumber(charArray.getChars(), n, n4, false, 10);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParseException("Can not parse number string " + new String(charArray.getChars(), n, n4), n);
                }
            }
        };
        block7: for (int i = 0; i < 128; ++i) {
            switch (i) {
                case 123: {
                    JSON.append[i] = MapsParser;
                    continue block7;
                }
                case 91: {
                    JSON.append[i] = CollParser;
                    continue block7;
                }
                case 34: 
                case 39: {
                    JSON.append[i] = StrnParser;
                    continue block7;
                }
                case 102: 
                case 110: 
                case 116: {
                    JSON.append[i] = BoolParser;
                    continue block7;
                }
                case 43: 
                case 45: 
                case 46: {
                    JSON.append[i] = DigtParser;
                    continue block7;
                }
                default: {
                    if (i < 48 || i > 57) continue block7;
                    JSON.append[i] = DigtParser;
                }
            }
        }
    }

    private static final class ConverterMap {
        private final Entry[] SEDU = new Entry[1024];
        private final int identityHashCode = this.SEDU.length - 1;

        public final Converter get(Class clazz) {
            int n = System.identityHashCode(clazz);
            int n2 = n & this.identityHashCode;
            Entry entry = this.SEDU[n2];
            while (entry != null) {
                if (clazz == entry.I) {
                    return entry.Z;
                }
                entry = entry.C;
            }
            return null;
        }

        public final boolean put(Class clazz, Converter converter) {
            int n = System.identityHashCode(clazz);
            int n2 = n & this.identityHashCode;
            Entry entry = this.SEDU[n2];
            while (entry != null) {
                if (clazz == entry.I) {
                    return true;
                }
                entry = entry.C;
            }
            this.SEDU[n2] = entry = new Entry(clazz, converter, this.SEDU[n2]);
            return false;
        }

        static final class Entry {
            Class I;
            Converter Z;
            Entry C;

            Entry(Class clazz, Converter converter, Entry entry) {
                this.I = clazz;
                this.Z = converter;
                this.C = entry;
            }
        }
    }
}

