/*
 * Decompiled with CFR 0.152.
 */
package guitools.toolkit;

import guitools.DisableFilter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import java.io.Serializable;
import java.util.Hashtable;
import jet.log.JRLogger;

public abstract class GifControl
extends Component {
    public static final int ENABLE = 0;
    public static final int DISABLE = 1;
    public static final int IMAGECOUNT = 2;
    protected static Hashtable gifImgs = new Hashtable();
    String addImage;
    Image[] C;
    boolean B;
    boolean D;
    String F;
    private static JRLogger control = JRLogger.getLogger(GifControl.class.getName());

    public GifControl() {
        this("");
    }

    public GifControl(String string) {
        this.setGif(string);
    }

    public GifControl(Image image) {
        this.setImage(image);
    }

    @Override
    public Dimension getPreferredSize() {
        return GifControl.SEDU(this.C, null, null, 0, 3);
    }

    static Dimension SEDU(Image[] imageArray, String string, Font font, int n, int n2) {
        Serializable serializable;
        Dimension dimension = new Dimension();
        if (imageArray != null) {
            serializable = new Component(){};
            dimension.width = imageArray[0].getWidth((ImageObserver)((Object)serializable));
            dimension.height = imageArray[0].getHeight((ImageObserver)((Object)serializable));
        }
        if (font != null && string != null && string.length() > 0) {
            serializable = Toolkit.getDefaultToolkit().getFontMetrics(font);
            dimension.width = dimension.width + ((imageArray != null ? n : 0) + ((FontMetrics)serializable).stringWidth(string));
            dimension.height = Math.max(dimension.height, ((FontMetrics)serializable).getAscent() + ((FontMetrics)serializable).getDescent());
        }
        dimension.width += 2 * n2;
        dimension.height += 2 * n2;
        return dimension;
    }

    @Override
    public void setEnabled(boolean bl) {
        if (!this.isEnabled() || !bl) {
            super.setEnabled(bl);
            this.repaint();
        }
    }

    @Override
    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (dimension.width > 0 && dimension.height > 0) {
            graphics.setColor(SystemColor.control);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            if (this.C != null && this.C[0] != null) {
                this.drawImage(graphics, (dimension.width - this.C[0].getWidth(this)) / 2, (dimension.height - this.C[0].getHeight(this)) / 2);
            }
        }
    }

    protected void drawImage(Graphics graphics, int n, int n2) {
        if (this.C != null) {
            Image image;
            if (!this.isEnabled() && this.C[1] == null && this.C[0] != null) {
                MediaTracker mediaTracker;
                block6: {
                    int n3 = this.C[0].getWidth(this);
                    int n4 = this.C[0].getHeight(this);
                    this.C[1] = this.createImage(new FilteredImageSource(new FilteredImageSource(this.C[0].getSource(), new CropImageFilter(0, 0, n3, n4)), new DisableFilter(n3, n4, this.getBackground())));
                    mediaTracker = new MediaTracker(this);
                    mediaTracker.addImage(this.C[1], 1);
                    try {
                        mediaTracker.waitForID(1);
                    }
                    catch (InterruptedException interruptedException) {
                        if (!control.isErrorEnabled()) break block6;
                        control.error("", interruptedException);
                    }
                }
                if (mediaTracker.isErrorID(1)) {
                    this.C[1] = null;
                }
            }
            if ((image = this.C[this.isEnabled() ? 0 : 1]) != null) {
                graphics.drawImage(this.C[this.isEnabled() ? 0 : 1], n, n2, this);
            }
        }
    }

    public synchronized void setGif(String string) {
        if (string == null || string.equals("")) {
            string = "Default";
        }
        this.addImage = string;
        this.C = (Image[])gifImgs.get(string);
        if (this.C == null && !string.equals("Default")) {
            block6: {
                this.C = new Image[2];
                this.C[0] = this.getToolkit().getImage(string);
                MediaTracker mediaTracker = new MediaTracker(this);
                mediaTracker.addImage(this.C[0], 0);
                try {
                    mediaTracker.waitForID(0);
                }
                catch (InterruptedException interruptedException) {
                    if (!control.isErrorEnabled()) break block6;
                    control.error("", interruptedException);
                }
            }
            int n = this.C[0].getWidth(this);
            int n2 = this.C[0].getHeight(this);
            if (n == -1 || n2 == -1) {
                this.setImage(null);
                return;
            }
        } else {
            this.setImage(null);
            return;
        }
        this.finished();
        this.repaint();
    }

    public void setImage(Image image) {
        if (image != null) {
            this.C = new Image[2];
            this.C[0] = image;
            int n = this.C[0].getWidth(this);
            int n2 = this.C[0].getHeight(this);
            if (n == -1 || n2 == -1) {
                this.C = (Image[])gifImgs.get("Default");
                if (this.C == null) {
                    this.C = new Image[2];
                    this.C[0] = this.getDefaultImage();
                    gifImgs.put("Default", this.C);
                }
            }
        }
        this.finished();
        this.repaint();
    }

    public Image getImage() {
        return this.C == null ? this.getDefaultImage() : this.C[0];
    }

    public void setImages(Image[] imageArray) {
        if (imageArray != null && imageArray.length == 2) {
            this.C = imageArray;
        }
        this.finished();
        this.repaint();
    }

    public String getGif() {
        return this.addImage;
    }

    public boolean isImageOk() {
        return this.C != null;
    }

    public void setActionCommand(String string) {
        this.F = string;
    }

    public String getActionCommand() {
        return this.F;
    }

    protected void finished() {
        this.setSize(this.getPreferredSize());
    }

    protected abstract void pressed(boolean var1);

    protected Image getDefaultImage() {
        Image image = null;
        int[] nArray = new int[256];
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        image = toolkit.createImage(new MemoryImageSource(16, 16, nArray, 0, 16));
        return image;
    }
}

