/*
 * Decompiled with CFR 0.152.
 */
package guitools.toolkit;

import java.util.EmptyStackException;

public class IntStack
implements Cloneable {
    int[] SEDU = new int[8];
    int append = -1;

    public final int push(int n) {
        this.SEDU(false);
        this.SEDU[++this.append] = n;
        return n;
    }

    public final synchronized int pop() {
        if (this.append == -1) {
            throw new EmptyStackException();
        }
        this.SEDU(true);
        return this.append > -1 ? this.SEDU[this.append--] : this.SEDU[0];
    }

    public final synchronized void pop(int n) {
        if (n > this.append + 1) {
            throw new EmptyStackException();
        }
        this.append -= n;
        this.SEDU(true);
    }

    public final synchronized int peek() {
        if (this.append == -1) {
            throw new EmptyStackException();
        }
        return this.SEDU[this.append];
    }

    public final void clear() {
        this.append = -1;
    }

    public final boolean empty() {
        return this.append == -1;
    }

    public final int getSize() {
        return this.append + 1;
    }

    public final synchronized int elementAt(int n) {
        if (n > this.append) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.append);
        }
        try {
            return this.SEDU[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(n + " < 0");
        }
    }

    public final synchronized void setElementAt(int n, int n2) {
        if (n2 > this.append) {
            throw new ArrayIndexOutOfBoundsException(n2 + " >= " + this.append);
        }
        this.SEDU[n2] = n;
    }

    public final synchronized void removeElementAt(int n) {
        if (n > this.append) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.append);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = this.append - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.SEDU, n + 1, this.SEDU, n, n2);
        }
        --this.append;
        this.SEDU[this.append] = 0;
        this.SEDU(true);
    }

    public final synchronized void insertElementAt(int n, int n2) {
        if (n2 > this.append + 1) {
            throw new ArrayIndexOutOfBoundsException(n2 + " > " + this.append);
        }
        this.SEDU(false);
        System.arraycopy(this.SEDU, n2, this.SEDU, n2 + 1, this.append - n2);
        this.SEDU[n2] = n;
        ++this.append;
    }

    public synchronized Object clone() {
        try {
            IntStack intStack = (IntStack)super.clone();
            intStack.SEDU = new int[this.SEDU.length];
            if (this.append >= 0) {
                System.arraycopy(this.SEDU, 0, intStack.SEDU, 0, this.append + 1);
            }
            return intStack;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        boolean bl;
        boolean bl2 = bl = this == object;
        if (!bl && object instanceof IntStack) {
            if (this.append != -1 || ((IntStack)object).append != -1) {
                boolean bl3 = bl = this.append == ((IntStack)object).append;
                if (bl) {
                    for (int i = this.append; i >= 0; --i) {
                        if (this.SEDU[i] == ((IntStack)object).SEDU[i]) continue;
                        bl = false;
                        break;
                    }
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    private void SEDU(boolean bl) {
        if (bl) {
            if (this.append < this.SEDU.length / 2 - 1 && this.SEDU.length > 8) {
                int[] nArray = new int[this.SEDU.length / 2];
                System.arraycopy(this.SEDU, 0, nArray, 0, this.SEDU.length / 2);
            }
        } else if (this.append == this.SEDU.length - 1) {
            int[] nArray = new int[this.SEDU.length * 2];
            System.arraycopy(this.SEDU, 0, nArray, 0, this.SEDU.length);
            this.SEDU = nArray;
        }
    }

    public String toString() {
        String string = "size = " + (this.append + 1) + ", {";
        for (int i = 0; i <= this.append; ++i) {
            string = string + this.SEDU[i] + (i == this.append ? "}" : ",");
        }
        string = string + '\n';
        return string;
    }
}

