/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jet.connect.DbBit;
import jet.connect.DbColDesc;
import jet.connect.DbColumnBuffer;
import jet.connect.DbValue;

public class DbBooleanColumnBuffer
extends DbColumnBuffer {
    boolean[] SEDU;

    public boolean[] getBuffer() {
        return this.SEDU;
    }

    public DbBooleanColumnBuffer(DbColDesc dbColDesc, int n) {
        super(dbColDesc, n);
        this.SEDU = new boolean[n];
    }

    @Override
    public void updateCell(int n, DbValue dbValue) {
        this.SEDU[n] = ((DbBit)dbValue).get();
    }

    @Override
    public void refreshFromCell(int n, DbValue dbValue) {
        ((DbBit)dbValue).set(this.SEDU[n]);
    }

    @Override
    protected void writeValueToFile(DataOutput dataOutput) throws IOException {
        for (int i = 0; i < this.SEDU.length; ++i) {
            dataOutput.writeBoolean(this.SEDU[i]);
        }
    }

    @Override
    protected void readValueFromFile(DataInput dataInput) throws IOException {
        for (int i = 0; i < this.SEDU.length; ++i) {
            this.SEDU[i] = dataInput.readBoolean();
        }
    }

    @Override
    public void clearMem() {
        super.clearMem();
        this.SEDU = null;
    }
}

