/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import com.jinfonet.util.JRLog;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.datastream.DSDataStreamable;
import jet.datastream.DSSubReport;
import jet.util.JRInterruptedException;

public class SubReportBuffer {
    protected int cacheSize = 100;
    private Vector SEDU;
    private int addElement = 0;
    protected Vector pageLengthes = new Vector();
    private DSDataStreamable clear;
    boolean elementAt = false;
    int error = 0;

    public SubReportBuffer() {
    }

    public SubReportBuffer(int n, DSDataStreamable dSDataStreamable) {
        if (n > 0) {
            this.cacheSize = n;
        }
        this.SEDU = new Vector(n);
        this.clear = dSDataStreamable;
    }

    public synchronized DSSubReport nextPage() {
        DSSubReport dSSubReport = null;
        do {
            int n;
            if ((n = this.SEDU.size()) > 0) {
                dSSubReport = (DSSubReport)this.SEDU.elementAt(0);
            }
            if (dSSubReport == null) {
                if (this.elementAt) break;
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    if (!JRLog.isError(2)) continue;
                    JRLog.error(2, interruptedException);
                }
                continue;
            }
            this.SEDU.removeElementAt(0);
        } while (dSSubReport == null);
        this.notifyAll();
        return dSSubReport;
    }

    public synchronized DSSubReport getPage(int n) throws JRStopEngineException {
        DSSubReport dSSubReport = null;
        int n2 = this.SEDU.size();
        int n3 = 0;
        int n4 = 0;
        if (n2 > 0) {
            n3 = ((DSSubReport)this.SEDU.elementAt(n2 - 1)).getPageNum();
            n4 = n3 - n2 + 1;
        }
        if (n >= n4 && n <= n3) {
            dSSubReport = (DSSubReport)this.SEDU.elementAt(n - n4);
        } else {
            do {
                if ((dSSubReport = (DSSubReport)this.SEDU.get(n)) != null) continue;
                if (this.elementAt) break;
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    if (!JRLog.isError(2)) continue;
                    JRLog.error(2, interruptedException);
                }
            } while (dSSubReport == null);
            this.notifyAll();
        }
        return dSSubReport;
    }

    public synchronized void finish() {
        this.elementAt = true;
        this.notifyAll();
    }

    public synchronized void cachePage(DSSubReport dSSubReport) {
        if (this.SEDU.size() >= this.cacheSize) {
            this.error = dSSubReport.getPageNum();
            while (this.SEDU.size() >= this.cacheSize) {
                try {
                    this.wait();
                }
                catch (JRInterruptedException jRInterruptedException) {
                    if (JRLog.isError(2)) {
                        JRLog.error(2, jRInterruptedException);
                    }
                    throw jRInterruptedException;
                }
                catch (Exception exception) {
                    if (!JRLog.isError(2)) continue;
                    JRLog.error(2, exception);
                }
            }
        }
        this.SEDU.addElement(dSSubReport);
        this.notifyAll();
        int n = dSSubReport.length();
        this.addElement += n;
        this.pageLengthes.addElement(n);
    }

    public synchronized int size() {
        return this.error;
    }

    public synchronized void clearMem() {
        if (this.SEDU != null) {
            this.SEDU.clear();
        }
        this.SEDU = null;
    }
}

